from . import objects_pb2 as _objects_pb2
from . import result_status_pb2 as _result_status_pb2
from . import session_status_pb2 as _session_status_pb2
from . import task_status_pb2 as _task_status_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class AvailabilityReply(_message.Message):
    __slots__ = ["error", "not_completed_task", "ok"]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    NOT_COMPLETED_TASK_FIELD_NUMBER: _ClassVar[int]
    OK_FIELD_NUMBER: _ClassVar[int]
    error: _objects_pb2.TaskError
    not_completed_task: str
    ok: _objects_pb2.Empty
    def __init__(self, ok: _Optional[_Union[_objects_pb2.Empty, _Mapping]] = ..., error: _Optional[_Union[_objects_pb2.TaskError, _Mapping]] = ..., not_completed_task: _Optional[str] = ...) -> None: ...

class CreateLargeTaskRequest(_message.Message):
    __slots__ = ["init_request", "init_task", "task_payload"]
    class InitRequest(_message.Message):
        __slots__ = ["session_id", "task_options"]
        SESSION_ID_FIELD_NUMBER: _ClassVar[int]
        TASK_OPTIONS_FIELD_NUMBER: _ClassVar[int]
        session_id: str
        task_options: _objects_pb2.TaskOptions
        def __init__(self, session_id: _Optional[str] = ..., task_options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ...) -> None: ...
    INIT_REQUEST_FIELD_NUMBER: _ClassVar[int]
    INIT_TASK_FIELD_NUMBER: _ClassVar[int]
    TASK_PAYLOAD_FIELD_NUMBER: _ClassVar[int]
    init_request: CreateLargeTaskRequest.InitRequest
    init_task: _objects_pb2.InitTaskRequest
    task_payload: _objects_pb2.DataChunk
    def __init__(self, init_request: _Optional[_Union[CreateLargeTaskRequest.InitRequest, _Mapping]] = ..., init_task: _Optional[_Union[_objects_pb2.InitTaskRequest, _Mapping]] = ..., task_payload: _Optional[_Union[_objects_pb2.DataChunk, _Mapping]] = ...) -> None: ...

class CreateSessionReply(_message.Message):
    __slots__ = ["session_id"]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    session_id: str
    def __init__(self, session_id: _Optional[str] = ...) -> None: ...

class CreateSessionRequest(_message.Message):
    __slots__ = ["default_task_option", "partition_ids"]
    DEFAULT_TASK_OPTION_FIELD_NUMBER: _ClassVar[int]
    PARTITION_IDS_FIELD_NUMBER: _ClassVar[int]
    default_task_option: _objects_pb2.TaskOptions
    partition_ids: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, default_task_option: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ..., partition_ids: _Optional[_Iterable[str]] = ...) -> None: ...

class CreateSmallTaskRequest(_message.Message):
    __slots__ = ["session_id", "task_options", "task_requests"]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    TASK_OPTIONS_FIELD_NUMBER: _ClassVar[int]
    TASK_REQUESTS_FIELD_NUMBER: _ClassVar[int]
    session_id: str
    task_options: _objects_pb2.TaskOptions
    task_requests: _containers.RepeatedCompositeFieldContainer[_objects_pb2.TaskRequest]
    def __init__(self, session_id: _Optional[str] = ..., task_options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ..., task_requests: _Optional[_Iterable[_Union[_objects_pb2.TaskRequest, _Mapping]]] = ...) -> None: ...

class CreateTaskReply(_message.Message):
    __slots__ = ["creation_status_list", "error"]
    class CreationStatus(_message.Message):
        __slots__ = ["error", "task_info"]
        ERROR_FIELD_NUMBER: _ClassVar[int]
        TASK_INFO_FIELD_NUMBER: _ClassVar[int]
        error: str
        task_info: CreateTaskReply.TaskInfo
        def __init__(self, task_info: _Optional[_Union[CreateTaskReply.TaskInfo, _Mapping]] = ..., error: _Optional[str] = ...) -> None: ...
    class CreationStatusList(_message.Message):
        __slots__ = ["creation_statuses"]
        CREATION_STATUSES_FIELD_NUMBER: _ClassVar[int]
        creation_statuses: _containers.RepeatedCompositeFieldContainer[CreateTaskReply.CreationStatus]
        def __init__(self, creation_statuses: _Optional[_Iterable[_Union[CreateTaskReply.CreationStatus, _Mapping]]] = ...) -> None: ...
    class TaskInfo(_message.Message):
        __slots__ = ["data_dependencies", "expected_output_keys", "task_id"]
        DATA_DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
        EXPECTED_OUTPUT_KEYS_FIELD_NUMBER: _ClassVar[int]
        TASK_ID_FIELD_NUMBER: _ClassVar[int]
        data_dependencies: _containers.RepeatedScalarFieldContainer[str]
        expected_output_keys: _containers.RepeatedScalarFieldContainer[str]
        task_id: str
        def __init__(self, task_id: _Optional[str] = ..., expected_output_keys: _Optional[_Iterable[str]] = ..., data_dependencies: _Optional[_Iterable[str]] = ...) -> None: ...
    CREATION_STATUS_LIST_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    creation_status_list: CreateTaskReply.CreationStatusList
    error: str
    def __init__(self, creation_status_list: _Optional[_Union[CreateTaskReply.CreationStatusList, _Mapping]] = ..., error: _Optional[str] = ...) -> None: ...

class GetResultStatusReply(_message.Message):
    __slots__ = ["id_statuses"]
    class IdStatus(_message.Message):
        __slots__ = ["result_id", "status"]
        RESULT_ID_FIELD_NUMBER: _ClassVar[int]
        STATUS_FIELD_NUMBER: _ClassVar[int]
        result_id: str
        status: _result_status_pb2.ResultStatus
        def __init__(self, result_id: _Optional[str] = ..., status: _Optional[_Union[_result_status_pb2.ResultStatus, str]] = ...) -> None: ...
    ID_STATUSES_FIELD_NUMBER: _ClassVar[int]
    id_statuses: _containers.RepeatedCompositeFieldContainer[GetResultStatusReply.IdStatus]
    def __init__(self, id_statuses: _Optional[_Iterable[_Union[GetResultStatusReply.IdStatus, _Mapping]]] = ...) -> None: ...

class GetResultStatusRequest(_message.Message):
    __slots__ = ["result_ids", "session_id"]
    RESULT_IDS_FIELD_NUMBER: _ClassVar[int]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    result_ids: _containers.RepeatedScalarFieldContainer[str]
    session_id: str
    def __init__(self, result_ids: _Optional[_Iterable[str]] = ..., session_id: _Optional[str] = ...) -> None: ...

class GetTaskStatusReply(_message.Message):
    __slots__ = ["id_statuses"]
    class IdStatus(_message.Message):
        __slots__ = ["status", "task_id"]
        STATUS_FIELD_NUMBER: _ClassVar[int]
        TASK_ID_FIELD_NUMBER: _ClassVar[int]
        status: _task_status_pb2.TaskStatus
        task_id: str
        def __init__(self, task_id: _Optional[str] = ..., status: _Optional[_Union[_task_status_pb2.TaskStatus, str]] = ...) -> None: ...
    ID_STATUSES_FIELD_NUMBER: _ClassVar[int]
    id_statuses: _containers.RepeatedCompositeFieldContainer[GetTaskStatusReply.IdStatus]
    def __init__(self, id_statuses: _Optional[_Iterable[_Union[GetTaskStatusReply.IdStatus, _Mapping]]] = ...) -> None: ...

class GetTaskStatusRequest(_message.Message):
    __slots__ = ["task_ids"]
    TASK_IDS_FIELD_NUMBER: _ClassVar[int]
    task_ids: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, task_ids: _Optional[_Iterable[str]] = ...) -> None: ...

class ResultReply(_message.Message):
    __slots__ = ["error", "not_completed_task", "result"]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    NOT_COMPLETED_TASK_FIELD_NUMBER: _ClassVar[int]
    RESULT_FIELD_NUMBER: _ClassVar[int]
    error: _objects_pb2.TaskError
    not_completed_task: str
    result: _objects_pb2.DataChunk
    def __init__(self, result: _Optional[_Union[_objects_pb2.DataChunk, _Mapping]] = ..., error: _Optional[_Union[_objects_pb2.TaskError, _Mapping]] = ..., not_completed_task: _Optional[str] = ...) -> None: ...

class SessionFilter(_message.Message):
    __slots__ = ["excluded", "included", "sessions"]
    class StatusesRequest(_message.Message):
        __slots__ = ["statuses"]
        STATUSES_FIELD_NUMBER: _ClassVar[int]
        statuses: _containers.RepeatedScalarFieldContainer[_session_status_pb2.SessionStatus]
        def __init__(self, statuses: _Optional[_Iterable[_Union[_session_status_pb2.SessionStatus, str]]] = ...) -> None: ...
    EXCLUDED_FIELD_NUMBER: _ClassVar[int]
    INCLUDED_FIELD_NUMBER: _ClassVar[int]
    SESSIONS_FIELD_NUMBER: _ClassVar[int]
    excluded: SessionFilter.StatusesRequest
    included: SessionFilter.StatusesRequest
    sessions: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, sessions: _Optional[_Iterable[str]] = ..., included: _Optional[_Union[SessionFilter.StatusesRequest, _Mapping]] = ..., excluded: _Optional[_Union[SessionFilter.StatusesRequest, _Mapping]] = ...) -> None: ...

class SessionIdList(_message.Message):
    __slots__ = ["session_ids"]
    SESSION_IDS_FIELD_NUMBER: _ClassVar[int]
    session_ids: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, session_ids: _Optional[_Iterable[str]] = ...) -> None: ...

class SessionList(_message.Message):
    __slots__ = ["sessions"]
    SESSIONS_FIELD_NUMBER: _ClassVar[int]
    sessions: _containers.RepeatedCompositeFieldContainer[_objects_pb2.Session]
    def __init__(self, sessions: _Optional[_Iterable[_Union[_objects_pb2.Session, _Mapping]]] = ...) -> None: ...

class TaskFilter(_message.Message):
    __slots__ = ["excluded", "included", "session", "task"]
    class IdsRequest(_message.Message):
        __slots__ = ["ids"]
        IDS_FIELD_NUMBER: _ClassVar[int]
        ids: _containers.RepeatedScalarFieldContainer[str]
        def __init__(self, ids: _Optional[_Iterable[str]] = ...) -> None: ...
    class StatusesRequest(_message.Message):
        __slots__ = ["statuses"]
        STATUSES_FIELD_NUMBER: _ClassVar[int]
        statuses: _containers.RepeatedScalarFieldContainer[_task_status_pb2.TaskStatus]
        def __init__(self, statuses: _Optional[_Iterable[_Union[_task_status_pb2.TaskStatus, str]]] = ...) -> None: ...
    EXCLUDED_FIELD_NUMBER: _ClassVar[int]
    INCLUDED_FIELD_NUMBER: _ClassVar[int]
    SESSION_FIELD_NUMBER: _ClassVar[int]
    TASK_FIELD_NUMBER: _ClassVar[int]
    excluded: TaskFilter.StatusesRequest
    included: TaskFilter.StatusesRequest
    session: TaskFilter.IdsRequest
    task: TaskFilter.IdsRequest
    def __init__(self, session: _Optional[_Union[TaskFilter.IdsRequest, _Mapping]] = ..., task: _Optional[_Union[TaskFilter.IdsRequest, _Mapping]] = ..., included: _Optional[_Union[TaskFilter.StatusesRequest, _Mapping]] = ..., excluded: _Optional[_Union[TaskFilter.StatusesRequest, _Mapping]] = ...) -> None: ...

class WaitRequest(_message.Message):
    __slots__ = ["filter", "stop_on_first_task_cancellation", "stop_on_first_task_error"]
    FILTER_FIELD_NUMBER: _ClassVar[int]
    STOP_ON_FIRST_TASK_CANCELLATION_FIELD_NUMBER: _ClassVar[int]
    STOP_ON_FIRST_TASK_ERROR_FIELD_NUMBER: _ClassVar[int]
    filter: TaskFilter
    stop_on_first_task_cancellation: bool
    stop_on_first_task_error: bool
    def __init__(self, filter: _Optional[_Union[TaskFilter, _Mapping]] = ..., stop_on_first_task_error: bool = ..., stop_on_first_task_cancellation: bool = ...) -> None: ...

class WatchResultRequest(_message.Message):
    __slots__ = ["fetch_statuses", "result_ids", "watch_statuses"]
    FETCH_STATUSES_FIELD_NUMBER: _ClassVar[int]
    RESULT_IDS_FIELD_NUMBER: _ClassVar[int]
    WATCH_STATUSES_FIELD_NUMBER: _ClassVar[int]
    fetch_statuses: _containers.RepeatedScalarFieldContainer[_result_status_pb2.ResultStatus]
    result_ids: _containers.RepeatedScalarFieldContainer[str]
    watch_statuses: _containers.RepeatedScalarFieldContainer[_result_status_pb2.ResultStatus]
    def __init__(self, fetch_statuses: _Optional[_Iterable[_Union[_result_status_pb2.ResultStatus, str]]] = ..., watch_statuses: _Optional[_Iterable[_Union[_result_status_pb2.ResultStatus, str]]] = ..., result_ids: _Optional[_Iterable[str]] = ...) -> None: ...

class WatchResultStream(_message.Message):
    __slots__ = ["result_ids", "status"]
    RESULT_IDS_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    result_ids: _containers.RepeatedScalarFieldContainer[str]
    status: _result_status_pb2.ResultStatus
    def __init__(self, status: _Optional[_Union[_result_status_pb2.ResultStatus, str]] = ..., result_ids: _Optional[_Iterable[str]] = ...) -> None: ...
