# coding: utf-8

"""
    Argo

    Python client for Argo Workflows  # noqa: E501

    OpenAPI spec version: 2.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from argo.workflows.client.api_client import ApiClient

from kubernetes.client.models import V1DeleteOptions

class V1alpha1Api(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_namespaced_archivedworkflow(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_archivedworkflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_archivedworkflow(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_namespaced_archivedworkflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_namespaced_archivedworkflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
            return data

    def create_namespaced_archivedworkflow_with_http_info(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_archivedworkflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_archivedworkflow_with_http_info(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_archivedworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_archivedworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojArchivedworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_namespaced_cronworkflow(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_cronworkflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_cronworkflow(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_namespaced_cronworkflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_namespaced_cronworkflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
            return data

    def create_namespaced_cronworkflow_with_http_info(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_cronworkflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_cronworkflow_with_http_info(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_cronworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_cronworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojCronworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_namespaced_workflow(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_workflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_workflow(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_namespaced_workflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_namespaced_workflow_with_http_info(namespace, body, **kwargs)  # noqa: E501
            return data

    def create_namespaced_workflow_with_http_info(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_workflow  # noqa: E501

        Creates a namespace scoped Workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_workflow_with_http_info(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to create. (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_namespaced_workflowtemplate(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_workflowtemplate  # noqa: E501

        Creates a namespace scoped WorkflowTemplate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_workflowtemplate(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The WorkflowTemplate's namespace (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to create. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_namespaced_workflowtemplate_with_http_info(namespace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_namespaced_workflowtemplate_with_http_info(namespace, body, **kwargs)  # noqa: E501
            return data

    def create_namespaced_workflowtemplate_with_http_info(self, namespace, body, **kwargs):  # noqa: E501
        """create_namespaced_workflowtemplate  # noqa: E501

        Creates a namespace scoped WorkflowTemplate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_namespaced_workflowtemplate_with_http_info(namespace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The WorkflowTemplate's namespace (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to create. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_workflowtemplate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_workflowtemplate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_namespaced_archivedworkflow(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_archivedworkflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_archivedworkflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_namespaced_archivedworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_namespaced_archivedworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def delete_namespaced_archivedworkflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_archivedworkflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_archivedworkflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_archivedworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_archivedworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_namespaced_cronworkflow(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_cronworkflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_cronworkflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_namespaced_cronworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_namespaced_cronworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def delete_namespaced_cronworkflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_cronworkflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_cronworkflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_cronworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_cronworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_namespaced_workflow(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_workflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_workflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_namespaced_workflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_namespaced_workflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def delete_namespaced_workflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_workflow  # noqa: E501

        Deletes the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_workflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_namespaced_workflowtemplate(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_workflowtemplate  # noqa: E501

        Deletes the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_workflowtemplate(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_namespaced_workflowtemplate_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_namespaced_workflowtemplate_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def delete_namespaced_workflowtemplate_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """delete_namespaced_workflowtemplate  # noqa: E501

        Deletes the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_namespaced_workflowtemplate_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1DeleteOptions body: Delete options to be send along in the body of this request.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_workflowtemplate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_workflowtemplate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_namespaced_archivedworkflow(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_archivedworkflow  # noqa: E501

        Get Workflow resource by the archivedworkflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_archivedworkflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_archivedworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespaced_archivedworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def get_namespaced_archivedworkflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_archivedworkflow  # noqa: E501

        Get Workflow resource by the archivedworkflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_archivedworkflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_archivedworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_archivedworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojArchivedworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_namespaced_cronworkflow(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_cronworkflow  # noqa: E501

        Get Workflow resource by the cronworkflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_cronworkflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_cronworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespaced_cronworkflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def get_namespaced_cronworkflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_cronworkflow  # noqa: E501

        Get Workflow resource by the cronworkflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_cronworkflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_cronworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_cronworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojCronworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_namespaced_workflow(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_workflow  # noqa: E501

        Get Workflow resource by the workflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_workflow(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_workflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespaced_workflow_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def get_namespaced_workflow_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_workflow  # noqa: E501

        Get Workflow resource by the workflow name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_workflow_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_namespaced_workflowtemplate(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_workflowtemplate  # noqa: E501

        Get WorkflowTemplate resource by its name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_workflowtemplate(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespaced_workflowtemplate_with_http_info(namespace, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespaced_workflowtemplate_with_http_info(namespace, name, **kwargs)  # noqa: E501
            return data

    def get_namespaced_workflowtemplate_with_http_info(self, namespace, name, **kwargs):  # noqa: E501
        """get_namespaced_workflowtemplate  # noqa: E501

        Get WorkflowTemplate resource by its name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespaced_workflowtemplate_with_http_info(namespace, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_workflowtemplate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_workflowtemplate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_namespaced_archivedworkflows(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_archivedworkflows  # noqa: E501

        List archivedworkflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_archivedworkflows(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: IoArgoprojArchivedworkflowV1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_namespaced_archivedworkflows_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_namespaced_archivedworkflows_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def list_namespaced_archivedworkflows_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_archivedworkflows  # noqa: E501

        List archivedworkflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_archivedworkflows_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: IoArgoprojArchivedworkflowV1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_archivedworkflows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_archivedworkflows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'field_selector' in params:
            query_params.append(('fieldSelector', params['field_selector']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'timeout_seconds' in params:
            query_params.append(('timeoutSeconds', params['timeout_seconds']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojArchivedworkflowV1alpha1WorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_namespaced_cronworkflows(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_cronworkflows  # noqa: E501

        List cronworkflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_cronworkflows(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: IoArgoprojCronworkflowV1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_namespaced_cronworkflows_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_namespaced_cronworkflows_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def list_namespaced_cronworkflows_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_cronworkflows  # noqa: E501

        List cronworkflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_cronworkflows_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: IoArgoprojCronworkflowV1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_cronworkflows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_cronworkflows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'field_selector' in params:
            query_params.append(('fieldSelector', params['field_selector']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'timeout_seconds' in params:
            query_params.append(('timeoutSeconds', params['timeout_seconds']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojCronworkflowV1alpha1WorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_namespaced_workflows(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_workflows  # noqa: E501

        List workflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_workflows(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: V1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_namespaced_workflows_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_namespaced_workflows_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def list_namespaced_workflows_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_workflows  # noqa: E501

        List workflow resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_workflows_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The Workflow's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: V1alpha1WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_workflows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_workflows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'field_selector' in params:
            query_params.append(('fieldSelector', params['field_selector']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'timeout_seconds' in params:
            query_params.append(('timeoutSeconds', params['timeout_seconds']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_namespaced_workflowtemplates(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_workflowtemplates  # noqa: E501

        List WorkflowTemplate resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_workflowtemplates(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The WorkflowTemplate's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: V1alpha1WorkflowTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_namespaced_workflowtemplates_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_namespaced_workflowtemplates_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def list_namespaced_workflowtemplates_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """list_namespaced_workflowtemplates  # noqa: E501

        List WorkflowTemplate resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_namespaced_workflowtemplates_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The WorkflowTemplate's namespace (required)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: V1alpha1WorkflowTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_workflowtemplates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_workflowtemplates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'field_selector' in params:
            query_params.append(('fieldSelector', params['field_selector']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'timeout_seconds' in params:
            query_params.append(('timeoutSeconds', params['timeout_seconds']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowTemplateList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_namespaced_archivedworkflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_archivedworkflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_archivedworkflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_archivedworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_namespaced_archivedworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def patch_namespaced_archivedworkflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_archivedworkflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_archivedworkflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_archivedworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_archivedworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_namespaced_cronworkflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_cronworkflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_cronworkflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_cronworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_namespaced_cronworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def patch_namespaced_cronworkflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_cronworkflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_cronworkflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_cronworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_cronworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_namespaced_workflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_workflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_workflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_workflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_namespaced_workflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def patch_namespaced_workflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_workflow  # noqa: E501

        patch the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_workflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_namespaced_workflowtemplate(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_workflowtemplate  # noqa: E501

        patch the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_workflowtemplate(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to patch. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_namespaced_workflowtemplate_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_namespaced_workflowtemplate_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def patch_namespaced_workflowtemplate_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_workflowtemplate  # noqa: E501

        patch the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_namespaced_workflowtemplate_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to patch. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_workflowtemplate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_workflowtemplate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_namespaced_archivedworkflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_archivedworkflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_archivedworkflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_archivedworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_namespaced_archivedworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def replace_namespaced_archivedworkflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_archivedworkflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_archivedworkflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojArchivedworkflowV1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: IoArgoprojArchivedworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_archivedworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_archivedworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_archivedworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/archivedarchivedworkflows/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojArchivedworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_namespaced_cronworkflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_cronworkflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_cronworkflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_cronworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_namespaced_cronworkflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def replace_namespaced_cronworkflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_cronworkflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_cronworkflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param IoArgoprojCronworkflowV1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: IoArgoprojCronworkflowV1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_cronworkflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_cronworkflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_cronworkflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/croncronworkflows/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoArgoprojCronworkflowV1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_namespaced_workflow(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_workflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_workflow(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_workflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_namespaced_workflow_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def replace_namespaced_workflow_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_workflow  # noqa: E501

        replace the specified namespace scoped Workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_workflow_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique Workflow name (required)
        :param V1alpha1Workflow body: The JSON schema of the Workflow to replace. (required)
        :return: V1alpha1Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_workflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflows/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_namespaced_workflowtemplate(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_workflowtemplate  # noqa: E501

        replace the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_workflowtemplate(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to replace. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_namespaced_workflowtemplate_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_namespaced_workflowtemplate_with_http_info(namespace, name, body, **kwargs)  # noqa: E501
            return data

    def replace_namespaced_workflowtemplate_with_http_info(self, namespace, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_workflowtemplate  # noqa: E501

        replace the specified namespace scoped WorkflowTemplate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_namespaced_workflowtemplate_with_http_info(namespace, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The custom resource's namespace (required)
        :param str name: Unique WorkflowTemplate name (required)
        :param V1alpha1WorkflowTemplate body: The JSON schema of the WorkflowTemplate to replace. (required)
        :return: V1alpha1WorkflowTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_workflowtemplate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_workflowtemplate`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_workflowtemplate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/argoproj.io/v1alpha1/namespaces/{namespace}/workflowtemplates/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1WorkflowTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
