# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._search_client_enums import *


class AnalyzedTokenInfo(msrest.serialization.Model):
    """Information about a token returned by an analyzer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar token: Required. The token returned by the analyzer.
    :vartype token: str
    :ivar start_offset: Required. The index of the first character of the token in the input text.
    :vartype start_offset: int
    :ivar end_offset: Required. The index of the last character of the token in the input text.
    :vartype end_offset: int
    :ivar position: Required. The position of the token in the input text relative to other tokens.
     The first token in the input text has position 0, the next has position 1, and so on. Depending
     on the analyzer used, some tokens might have the same position, for example if they are
     synonyms of each other.
    :vartype position: int
    """

    _validation = {
        'token': {'required': True, 'readonly': True},
        'start_offset': {'required': True, 'readonly': True},
        'end_offset': {'required': True, 'readonly': True},
        'position': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
        'start_offset': {'key': 'startOffset', 'type': 'int'},
        'end_offset': {'key': 'endOffset', 'type': 'int'},
        'position': {'key': 'position', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzedTokenInfo, self).__init__(**kwargs)
        self.token = None
        self.start_offset = None
        self.end_offset = None
        self.position = None


class AnalyzeRequest(msrest.serialization.Model):
    """Specifies some text and analysis components used to break that text into tokens.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The text to break into tokens.
    :type text: str
    :param analyzer: The name of the analyzer to use to break the given text. Possible values
     include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
     "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
     "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
     "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
     "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
     "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
     "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
     "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
     "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
     "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
     "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :type analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :param tokenizer: The name of the tokenizer to use to break the given text. Possible values
     include: "classic", "edgeNGram", "keyword_v2", "letter", "lowercase",
     "microsoft_language_tokenizer", "microsoft_language_stemming_tokenizer", "nGram",
     "path_hierarchy_v2", "pattern", "standard_v2", "uax_url_email", "whitespace".
    :type tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :param normalizer: The name of the normalizer to use to normalize the given text. Possible
     values include: "asciifolding", "elision", "lowercase", "standard", "uppercase".
    :type normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :param token_filters: An optional list of token filters to use when breaking the given text.
    :type token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :param char_filters: An optional list of character filters to use when breaking the given text.
    :type char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'text': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'analyzer': {'key': 'analyzer', 'type': 'str'},
        'tokenizer': {'key': 'tokenizer', 'type': 'str'},
        'normalizer': {'key': 'normalizer', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        text: str,
        analyzer: Optional[Union[str, "LexicalAnalyzerName"]] = None,
        tokenizer: Optional[Union[str, "LexicalTokenizerName"]] = None,
        normalizer: Optional[Union[str, "LexicalNormalizerName"]] = None,
        token_filters: Optional[List[Union[str, "TokenFilterName"]]] = None,
        char_filters: Optional[List[Union[str, "CharFilterName"]]] = None,
        **kwargs
    ):
        super(AnalyzeRequest, self).__init__(**kwargs)
        self.text = text
        self.analyzer = analyzer
        self.tokenizer = tokenizer
        self.normalizer = normalizer
        self.token_filters = token_filters
        self.char_filters = char_filters


class AnalyzeResult(msrest.serialization.Model):
    """The result of testing an analyzer on text.

    All required parameters must be populated in order to send to Azure.

    :param tokens: Required. The list of tokens returned by the analyzer specified in the request.
    :type tokens: list[~azure.search.documents.indexes.models.AnalyzedTokenInfo]
    """

    _validation = {
        'tokens': {'required': True},
    }

    _attribute_map = {
        'tokens': {'key': 'tokens', 'type': '[AnalyzedTokenInfo]'},
    }

    def __init__(
        self,
        *,
        tokens: List["AnalyzedTokenInfo"],
        **kwargs
    ):
        super(AnalyzeResult, self).__init__(**kwargs)
        self.tokens = tokens


class TokenFilter(msrest.serialization.Model):
    """Base type for token filters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AsciiFoldingTokenFilter, CjkBigramTokenFilter, CommonGramTokenFilter, DictionaryDecompounderTokenFilter, EdgeNGramTokenFilter, EdgeNGramTokenFilterV2, ElisionTokenFilter, KeepTokenFilter, KeywordMarkerTokenFilter, LengthTokenFilter, LimitTokenFilter, NGramTokenFilter, NGramTokenFilterV2, PatternCaptureTokenFilter, PatternReplaceTokenFilter, PhoneticTokenFilter, ShingleTokenFilter, SnowballTokenFilter, StemmerOverrideTokenFilter, StemmerTokenFilter, StopwordsTokenFilter, SynonymTokenFilter, TruncateTokenFilter, UniqueTokenFilter, WordDelimiterTokenFilter.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.AsciiFoldingTokenFilter': 'AsciiFoldingTokenFilter', '#Microsoft.Azure.Search.CjkBigramTokenFilter': 'CjkBigramTokenFilter', '#Microsoft.Azure.Search.CommonGramTokenFilter': 'CommonGramTokenFilter', '#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter': 'DictionaryDecompounderTokenFilter', '#Microsoft.Azure.Search.EdgeNGramTokenFilter': 'EdgeNGramTokenFilter', '#Microsoft.Azure.Search.EdgeNGramTokenFilterV2': 'EdgeNGramTokenFilterV2', '#Microsoft.Azure.Search.ElisionTokenFilter': 'ElisionTokenFilter', '#Microsoft.Azure.Search.KeepTokenFilter': 'KeepTokenFilter', '#Microsoft.Azure.Search.KeywordMarkerTokenFilter': 'KeywordMarkerTokenFilter', '#Microsoft.Azure.Search.LengthTokenFilter': 'LengthTokenFilter', '#Microsoft.Azure.Search.LimitTokenFilter': 'LimitTokenFilter', '#Microsoft.Azure.Search.NGramTokenFilter': 'NGramTokenFilter', '#Microsoft.Azure.Search.NGramTokenFilterV2': 'NGramTokenFilterV2', '#Microsoft.Azure.Search.PatternCaptureTokenFilter': 'PatternCaptureTokenFilter', '#Microsoft.Azure.Search.PatternReplaceTokenFilter': 'PatternReplaceTokenFilter', '#Microsoft.Azure.Search.PhoneticTokenFilter': 'PhoneticTokenFilter', '#Microsoft.Azure.Search.ShingleTokenFilter': 'ShingleTokenFilter', '#Microsoft.Azure.Search.SnowballTokenFilter': 'SnowballTokenFilter', '#Microsoft.Azure.Search.StemmerOverrideTokenFilter': 'StemmerOverrideTokenFilter', '#Microsoft.Azure.Search.StemmerTokenFilter': 'StemmerTokenFilter', '#Microsoft.Azure.Search.StopwordsTokenFilter': 'StopwordsTokenFilter', '#Microsoft.Azure.Search.SynonymTokenFilter': 'SynonymTokenFilter', '#Microsoft.Azure.Search.TruncateTokenFilter': 'TruncateTokenFilter', '#Microsoft.Azure.Search.UniqueTokenFilter': 'UniqueTokenFilter', '#Microsoft.Azure.Search.WordDelimiterTokenFilter': 'WordDelimiterTokenFilter'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(TokenFilter, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = name


class AsciiFoldingTokenFilter(TokenFilter):
    """Converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127 ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such equivalents exist. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param preserve_original: A value indicating whether the original token will be kept. Default
     is false.
    :type preserve_original: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        preserve_original: Optional[bool] = False,
        **kwargs
    ):
        super(AsciiFoldingTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.AsciiFoldingTokenFilter'  # type: str
        self.preserve_original = preserve_original


class AzureActiveDirectoryApplicationCredentials(msrest.serialization.Model):
    """Credentials of a registered application created for your search service, used for authenticated access to the encryption keys stored in Azure Key Vault.

    All required parameters must be populated in order to send to Azure.

    :param application_id: Required. An AAD Application ID that was granted the required access
     permissions to the Azure Key Vault that is to be used when encrypting your data at rest. The
     Application ID should not be confused with the Object ID for your AAD Application.
    :type application_id: str
    :param application_secret: The authentication key of the specified AAD application.
    :type application_secret: str
    """

    _validation = {
        'application_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'application_secret': {'key': 'applicationSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        application_id: str,
        application_secret: Optional[str] = None,
        **kwargs
    ):
        super(AzureActiveDirectoryApplicationCredentials, self).__init__(**kwargs)
        self.application_id = application_id
        self.application_secret = application_secret


class Similarity(msrest.serialization.Model):
    """Base type for similarity algorithms. Similarity algorithms are used to calculate scores that tie queries to documents. The higher the score, the more relevant the document is to that specific query. Those scores are used to rank the search results.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BM25Similarity, ClassicSimilarity.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.BM25Similarity': 'BM25Similarity', '#Microsoft.Azure.Search.ClassicSimilarity': 'ClassicSimilarity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Similarity, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class BM25Similarity(Similarity):
    """Ranking function based on the Okapi BM25 similarity algorithm. BM25 is a TF-IDF-like algorithm that includes length normalization (controlled by the 'b' parameter) as well as term frequency saturation (controlled by the 'k1' parameter).

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    :param k1: This property controls the scaling function between the term frequency of each
     matching terms and the final relevance score of a document-query pair. By default, a value of
     1.2 is used. A value of 0.0 means the score does not scale with an increase in term frequency.
    :type k1: float
    :param b: This property controls how the length of a document affects the relevance score. By
     default, a value of 0.75 is used. A value of 0.0 means no length normalization is applied,
     while a value of 1.0 means the score is fully normalized by the length of the document.
    :type b: float
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'k1': {'key': 'k1', 'type': 'float'},
        'b': {'key': 'b', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        k1: Optional[float] = None,
        b: Optional[float] = None,
        **kwargs
    ):
        super(BM25Similarity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.BM25Similarity'  # type: str
        self.k1 = k1
        self.b = b


class CharFilter(msrest.serialization.Model):
    """Base type for character filters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingCharFilter, PatternReplaceCharFilter.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.MappingCharFilter': 'MappingCharFilter', '#Microsoft.Azure.Search.PatternReplaceCharFilter': 'PatternReplaceCharFilter'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CharFilter, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = name


class CjkBigramTokenFilter(TokenFilter):
    """Forms bigrams of CJK terms that are generated from the standard tokenizer. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param ignore_scripts: The scripts to ignore.
    :type ignore_scripts: list[str or
     ~azure.search.documents.indexes.models.CjkBigramTokenFilterScripts]
    :param output_unigrams: A value indicating whether to output both unigrams and bigrams (if
     true), or just bigrams (if false). Default is false.
    :type output_unigrams: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'ignore_scripts': {'key': 'ignoreScripts', 'type': '[str]'},
        'output_unigrams': {'key': 'outputUnigrams', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        ignore_scripts: Optional[List[Union[str, "CjkBigramTokenFilterScripts"]]] = None,
        output_unigrams: Optional[bool] = False,
        **kwargs
    ):
        super(CjkBigramTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CjkBigramTokenFilter'  # type: str
        self.ignore_scripts = ignore_scripts
        self.output_unigrams = output_unigrams


class ClassicSimilarity(Similarity):
    """Legacy similarity algorithm which uses the Lucene TFIDFSimilarity implementation of TF-IDF. This variation of TF-IDF introduces static document length normalization as well as coordinating factors that penalize documents that only partially match the searched queries.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClassicSimilarity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ClassicSimilarity'  # type: str


class LexicalTokenizer(msrest.serialization.Model):
    """Base type for tokenizers.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ClassicTokenizer, EdgeNGramTokenizer, KeywordTokenizer, KeywordTokenizerV2, MicrosoftLanguageStemmingTokenizer, MicrosoftLanguageTokenizer, NGramTokenizer, PathHierarchyTokenizerV2, PatternTokenizer, LuceneStandardTokenizer, LuceneStandardTokenizerV2, UaxUrlEmailTokenizer.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.ClassicTokenizer': 'ClassicTokenizer', '#Microsoft.Azure.Search.EdgeNGramTokenizer': 'EdgeNGramTokenizer', '#Microsoft.Azure.Search.KeywordTokenizer': 'KeywordTokenizer', '#Microsoft.Azure.Search.KeywordTokenizerV2': 'KeywordTokenizerV2', '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer': 'MicrosoftLanguageStemmingTokenizer', '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer': 'MicrosoftLanguageTokenizer', '#Microsoft.Azure.Search.NGramTokenizer': 'NGramTokenizer', '#Microsoft.Azure.Search.PathHierarchyTokenizerV2': 'PathHierarchyTokenizerV2', '#Microsoft.Azure.Search.PatternTokenizer': 'PatternTokenizer', '#Microsoft.Azure.Search.StandardTokenizer': 'LuceneStandardTokenizer', '#Microsoft.Azure.Search.StandardTokenizerV2': 'LuceneStandardTokenizerV2', '#Microsoft.Azure.Search.UaxUrlEmailTokenizer': 'UaxUrlEmailTokenizer'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(LexicalTokenizer, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = name


class ClassicTokenizer(LexicalTokenizer):
    """Grammar-based tokenizer that is suitable for processing most European-language documents. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :type max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        **kwargs
    ):
        super(ClassicTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ClassicTokenizer'  # type: str
        self.max_token_length = max_token_length


class CognitiveServicesAccount(msrest.serialization.Model):
    """Base type for describing any cognitive service resource attached to a skillset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CognitiveServicesAccountKey, DefaultCognitiveServicesAccount.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :type odata_type: str
    :param description: Description of the cognitive service resource attached to a skillset.
    :type description: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.CognitiveServicesByKey': 'CognitiveServicesAccountKey', '#Microsoft.Azure.Search.DefaultCognitiveServices': 'DefaultCognitiveServicesAccount'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CognitiveServicesAccount, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.description = description


class CognitiveServicesAccountKey(CognitiveServicesAccount):
    """A cognitive service resource provisioned with a key that is attached to a skillset.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :type odata_type: str
    :param description: Description of the cognitive service resource attached to a skillset.
    :type description: str
    :param key: Required. The key used to provision the cognitive service resource attached to a
     skillset.
    :type key: str
    """

    _validation = {
        'odata_type': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CognitiveServicesAccountKey, self).__init__(description=description, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CognitiveServicesByKey'  # type: str
        self.key = key


class CommonGramTokenFilter(TokenFilter):
    """Construct bigrams for frequently occurring terms while indexing. Single terms are still indexed too, with bigrams overlaid. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param common_words: Required. The set of common words.
    :type common_words: list[str]
    :param ignore_case: A value indicating whether common words matching will be case insensitive.
     Default is false.
    :type ignore_case: bool
    :param use_query_mode: A value that indicates whether the token filter is in query mode. When
     in query mode, the token filter generates bigrams and then removes common words and single
     terms followed by a common word. Default is false.
    :type use_query_mode: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'common_words': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'common_words': {'key': 'commonWords', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'use_query_mode': {'key': 'queryMode', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        common_words: List[str],
        ignore_case: Optional[bool] = False,
        use_query_mode: Optional[bool] = False,
        **kwargs
    ):
        super(CommonGramTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CommonGramTokenFilter'  # type: str
        self.common_words = common_words
        self.ignore_case = ignore_case
        self.use_query_mode = use_query_mode


class SearchIndexerSkill(msrest.serialization.Model):
    """Base type for skills.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebApiSkill, CustomEntityLookupSkill, EntityRecognitionSkill, KeyPhraseExtractionSkill, LanguageDetectionSkill, MergeSkill, PIIDetectionSkill, SentimentSkill, SplitSkill, TextTranslationSkill, EntityLinkingSkill, EntityRecognitionSkillV3, SentimentSkillV3, ConditionalSkill, DocumentExtractionSkill, ShaperSkill, ImageAnalysisSkill, OcrSkill.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Skills.Custom.WebApiSkill': 'WebApiSkill', '#Microsoft.Skills.Text.CustomEntityLookupSkill': 'CustomEntityLookupSkill', '#Microsoft.Skills.Text.EntityRecognitionSkill': 'EntityRecognitionSkill', '#Microsoft.Skills.Text.KeyPhraseExtractionSkill': 'KeyPhraseExtractionSkill', '#Microsoft.Skills.Text.LanguageDetectionSkill': 'LanguageDetectionSkill', '#Microsoft.Skills.Text.MergeSkill': 'MergeSkill', '#Microsoft.Skills.Text.PIIDetectionSkill': 'PIIDetectionSkill', '#Microsoft.Skills.Text.SentimentSkill': 'SentimentSkill', '#Microsoft.Skills.Text.SplitSkill': 'SplitSkill', '#Microsoft.Skills.Text.TranslationSkill': 'TextTranslationSkill', '#Microsoft.Skills.Text.V3.EntityLinkingSkill': 'EntityLinkingSkill', '#Microsoft.Skills.Text.V3.EntityRecognitionSkill': 'EntityRecognitionSkillV3', '#Microsoft.Skills.Text.V3.SentimentSkill': 'SentimentSkillV3', '#Microsoft.Skills.Util.ConditionalSkill': 'ConditionalSkill', '#Microsoft.Skills.Util.DocumentExtractionSkill': 'DocumentExtractionSkill', '#Microsoft.Skills.Util.ShaperSkill': 'ShaperSkill', '#Microsoft.Skills.Vision.ImageAnalysisSkill': 'ImageAnalysisSkill', '#Microsoft.Skills.Vision.OcrSkill': 'OcrSkill'}
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        **kwargs
    ):
        super(SearchIndexerSkill, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = name
        self.description = description
        self.context = context
        self.inputs = inputs
        self.outputs = outputs


class ConditionalSkill(SearchIndexerSkill):
    """A skill that enables scenarios that require a Boolean operation to determine the data to assign to an output.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        **kwargs
    ):
        super(ConditionalSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Util.ConditionalSkill'  # type: str


class CorsOptions(msrest.serialization.Model):
    """Defines options to control Cross-Origin Resource Sharing (CORS) for an index.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. The list of origins from which JavaScript code will be
     granted access to your index. Can contain a list of hosts of the form
     {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not
     recommended).
    :type allowed_origins: list[str]
    :param max_age_in_seconds: The duration for which browsers should cache CORS preflight
     responses. Defaults to 5 minutes.
    :type max_age_in_seconds: long
    """

    _validation = {
        'allowed_origins': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        allowed_origins: List[str],
        max_age_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(CorsOptions, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.max_age_in_seconds = max_age_in_seconds


class LexicalAnalyzer(msrest.serialization.Model):
    """Base type for analyzers.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomAnalyzer, PatternAnalyzer, LuceneStandardAnalyzer, StopAnalyzer.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.CustomAnalyzer': 'CustomAnalyzer', '#Microsoft.Azure.Search.PatternAnalyzer': 'PatternAnalyzer', '#Microsoft.Azure.Search.StandardAnalyzer': 'LuceneStandardAnalyzer', '#Microsoft.Azure.Search.StopAnalyzer': 'StopAnalyzer'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(LexicalAnalyzer, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = name


class CustomAnalyzer(LexicalAnalyzer):
    """Allows you to take control over the process of converting text into indexable/searchable tokens. It's a user-defined configuration consisting of a single predefined tokenizer and one or more filters. The tokenizer is responsible for breaking text into tokens, and the filters for modifying tokens emitted by the tokenizer.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param tokenizer: Required. The name of the tokenizer to use to divide continuous text into a
     sequence of tokens, such as breaking a sentence into words. Possible values include: "classic",
     "edgeNGram", "keyword_v2", "letter", "lowercase", "microsoft_language_tokenizer",
     "microsoft_language_stemming_tokenizer", "nGram", "path_hierarchy_v2", "pattern",
     "standard_v2", "uax_url_email", "whitespace".
    :type tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :param token_filters: A list of token filters used to filter out or modify the tokens generated
     by a tokenizer. For example, you can specify a lowercase filter that converts all characters to
     lowercase. The filters are run in the order in which they are listed.
    :type token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :param char_filters: A list of character filters used to prepare input text before it is
     processed by the tokenizer. For instance, they can replace certain characters or symbols. The
     filters are run in the order in which they are listed.
    :type char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'tokenizer': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tokenizer': {'key': 'tokenizer', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        tokenizer: Union[str, "LexicalTokenizerName"],
        token_filters: Optional[List[Union[str, "TokenFilterName"]]] = None,
        char_filters: Optional[List[Union[str, "CharFilterName"]]] = None,
        **kwargs
    ):
        super(CustomAnalyzer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CustomAnalyzer'  # type: str
        self.tokenizer = tokenizer
        self.token_filters = token_filters
        self.char_filters = char_filters


class CustomEntity(msrest.serialization.Model):
    """An object that contains information about the matches that were found, and related metadata.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The top-level entity descriptor. Matches in the skill output will be
     grouped by this name, and it should represent the "normalized" form of the text being found.
    :type name: str
    :param description: This field can be used as a passthrough for custom metadata about the
     matched text(s). The value of this field will appear with every match of its entity in the
     skill output.
    :type description: str
    :param type: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :type type: str
    :param subtype: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :type subtype: str
    :param id: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :type id: str
    :param case_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to character casing. Sample case insensitive matches of
     "Microsoft" could be: microsoft, microSoft, MICROSOFT.
    :type case_sensitive: bool
    :param accent_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to accent.
    :type accent_sensitive: bool
    :param fuzzy_edit_distance: Defaults to 0. Maximum value of 5. Denotes the acceptable number of
     divergent characters that would still constitute a match with the entity name. The smallest
     possible fuzziness for any given match is returned. For instance, if the edit distance is set
     to 3, "Windows10" would still match "Windows", "Windows10" and "Windows 7". When case
     sensitivity is set to false, case differences do NOT count towards fuzziness tolerance, but
     otherwise do.
    :type fuzzy_edit_distance: int
    :param default_case_sensitive: Changes the default case sensitivity value for this entity. It
     be used to change the default value of all aliases caseSensitive values.
    :type default_case_sensitive: bool
    :param default_accent_sensitive: Changes the default accent sensitivity value for this entity.
     It be used to change the default value of all aliases accentSensitive values.
    :type default_accent_sensitive: bool
    :param default_fuzzy_edit_distance: Changes the default fuzzy edit distance value for this
     entity. It can be used to change the default value of all aliases fuzzyEditDistance values.
    :type default_fuzzy_edit_distance: int
    :param aliases: An array of complex objects that can be used to specify alternative spellings
     or synonyms to the root entity name.
    :type aliases: list[~azure.search.documents.indexes.models.CustomEntityAlias]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subtype': {'key': 'subtype', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'case_sensitive': {'key': 'caseSensitive', 'type': 'bool'},
        'accent_sensitive': {'key': 'accentSensitive', 'type': 'bool'},
        'fuzzy_edit_distance': {'key': 'fuzzyEditDistance', 'type': 'int'},
        'default_case_sensitive': {'key': 'defaultCaseSensitive', 'type': 'bool'},
        'default_accent_sensitive': {'key': 'defaultAccentSensitive', 'type': 'bool'},
        'default_fuzzy_edit_distance': {'key': 'defaultFuzzyEditDistance', 'type': 'int'},
        'aliases': {'key': 'aliases', 'type': '[CustomEntityAlias]'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        type: Optional[str] = None,
        subtype: Optional[str] = None,
        id: Optional[str] = None,
        case_sensitive: Optional[bool] = None,
        accent_sensitive: Optional[bool] = None,
        fuzzy_edit_distance: Optional[int] = None,
        default_case_sensitive: Optional[bool] = None,
        default_accent_sensitive: Optional[bool] = None,
        default_fuzzy_edit_distance: Optional[int] = None,
        aliases: Optional[List["CustomEntityAlias"]] = None,
        **kwargs
    ):
        super(CustomEntity, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.type = type
        self.subtype = subtype
        self.id = id
        self.case_sensitive = case_sensitive
        self.accent_sensitive = accent_sensitive
        self.fuzzy_edit_distance = fuzzy_edit_distance
        self.default_case_sensitive = default_case_sensitive
        self.default_accent_sensitive = default_accent_sensitive
        self.default_fuzzy_edit_distance = default_fuzzy_edit_distance
        self.aliases = aliases


class CustomEntityAlias(msrest.serialization.Model):
    """A complex object that can be used to specify alternative spellings or synonyms to the root entity name.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The text of the alias.
    :type text: str
    :param case_sensitive: Determine if the alias is case sensitive.
    :type case_sensitive: bool
    :param accent_sensitive: Determine if the alias is accent sensitive.
    :type accent_sensitive: bool
    :param fuzzy_edit_distance: Determine the fuzzy edit distance of the alias.
    :type fuzzy_edit_distance: int
    """

    _validation = {
        'text': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'case_sensitive': {'key': 'caseSensitive', 'type': 'bool'},
        'accent_sensitive': {'key': 'accentSensitive', 'type': 'bool'},
        'fuzzy_edit_distance': {'key': 'fuzzyEditDistance', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        text: str,
        case_sensitive: Optional[bool] = None,
        accent_sensitive: Optional[bool] = None,
        fuzzy_edit_distance: Optional[int] = None,
        **kwargs
    ):
        super(CustomEntityAlias, self).__init__(**kwargs)
        self.text = text
        self.case_sensitive = case_sensitive
        self.accent_sensitive = accent_sensitive
        self.fuzzy_edit_distance = fuzzy_edit_distance


class CustomEntityLookupSkill(SearchIndexerSkill):
    """A skill looks for text from a custom, user-defined list of words and phrases.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
    :type default_language_code: str or
     ~azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage
    :param entities_definition_uri: Path to a JSON or CSV file containing all the target text to
     match against. This entity definition is read at the beginning of an indexer run. Any updates
     to this file during an indexer run will not take effect until subsequent runs. This config must
     be accessible over HTTPS.
    :type entities_definition_uri: str
    :param inline_entities_definition: The inline CustomEntity definition.
    :type inline_entities_definition: list[~azure.search.documents.indexes.models.CustomEntity]
    :param global_default_case_sensitive: A global flag for CaseSensitive. If CaseSensitive is not
     set in CustomEntity, this value will be the default value.
    :type global_default_case_sensitive: bool
    :param global_default_accent_sensitive: A global flag for AccentSensitive. If AccentSensitive
     is not set in CustomEntity, this value will be the default value.
    :type global_default_accent_sensitive: bool
    :param global_default_fuzzy_edit_distance: A global flag for FuzzyEditDistance. If
     FuzzyEditDistance is not set in CustomEntity, this value will be the default value.
    :type global_default_fuzzy_edit_distance: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'entities_definition_uri': {'key': 'entitiesDefinitionUri', 'type': 'str'},
        'inline_entities_definition': {'key': 'inlineEntitiesDefinition', 'type': '[CustomEntity]'},
        'global_default_case_sensitive': {'key': 'globalDefaultCaseSensitive', 'type': 'bool'},
        'global_default_accent_sensitive': {'key': 'globalDefaultAccentSensitive', 'type': 'bool'},
        'global_default_fuzzy_edit_distance': {'key': 'globalDefaultFuzzyEditDistance', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "CustomEntityLookupSkillLanguage"]] = None,
        entities_definition_uri: Optional[str] = None,
        inline_entities_definition: Optional[List["CustomEntity"]] = None,
        global_default_case_sensitive: Optional[bool] = None,
        global_default_accent_sensitive: Optional[bool] = None,
        global_default_fuzzy_edit_distance: Optional[int] = None,
        **kwargs
    ):
        super(CustomEntityLookupSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.CustomEntityLookupSkill'  # type: str
        self.default_language_code = default_language_code
        self.entities_definition_uri = entities_definition_uri
        self.inline_entities_definition = inline_entities_definition
        self.global_default_case_sensitive = global_default_case_sensitive
        self.global_default_accent_sensitive = global_default_accent_sensitive
        self.global_default_fuzzy_edit_distance = global_default_fuzzy_edit_distance


class LexicalNormalizer(msrest.serialization.Model):
    """Base type for normalizers.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the normalizer.
    :type odata_type: str
    :param name: Required. The name of the normalizer. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named
     'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
    :type name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
        **kwargs
    ):
        super(LexicalNormalizer, self).__init__(**kwargs)
        self.odata_type = odata_type
        self.name = name


class CustomNormalizer(LexicalNormalizer):
    """Allows you to configure normalization for filterable, sortable, and facetable fields, which by default operate with strict matching. This is a user-defined configuration consisting of at least one or more filters, which modify the token that is stored.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the normalizer.
    :type odata_type: str
    :param name: Required. The name of the normalizer. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named
     'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
    :type name: str
    :param token_filters: A list of token filters used to filter out or modify the input token. For
     example, you can specify a lowercase filter that converts all characters to lowercase. The
     filters are run in the order in which they are listed.
    :type token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :param char_filters: A list of character filters used to prepare input text before it is
     processed. For instance, they can replace certain characters or symbols. The filters are run in
     the order in which they are listed.
    :type char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
        token_filters: Optional[List[Union[str, "TokenFilterName"]]] = None,
        char_filters: Optional[List[Union[str, "CharFilterName"]]] = None,
        **kwargs
    ):
        super(CustomNormalizer, self).__init__(odata_type=odata_type, name=name, **kwargs)
        self.token_filters = token_filters
        self.char_filters = char_filters


class DataChangeDetectionPolicy(msrest.serialization.Model):
    """Base type for data change detection policies.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HighWaterMarkChangeDetectionPolicy, SqlIntegratedChangeTrackingPolicy.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy': 'HighWaterMarkChangeDetectionPolicy', '#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy': 'SqlIntegratedChangeTrackingPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataChangeDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class DataDeletionDetectionPolicy(msrest.serialization.Model):
    """Base type for data deletion detection policies.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SoftDeleteColumnDeletionDetectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the data deletion detection
     policy.Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy': 'SoftDeleteColumnDeletionDetectionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDeletionDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class DataSourceCredentials(msrest.serialization.Model):
    """Represents credentials that can be used to connect to a datasource.

    :param connection_string: The connection string for the datasource. Set to
     ':code:`<unchanged>`' if you do not want the connection string updated.
    :type connection_string: str
    """

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: Optional[str] = None,
        **kwargs
    ):
        super(DataSourceCredentials, self).__init__(**kwargs)
        self.connection_string = connection_string


class DefaultCognitiveServicesAccount(CognitiveServicesAccount):
    """An empty object that represents the default cognitive service resource for a skillset.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :type odata_type: str
    :param description: Description of the cognitive service resource attached to a skillset.
    :type description: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        super(DefaultCognitiveServicesAccount, self).__init__(description=description, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.DefaultCognitiveServices'  # type: str


class DictionaryDecompounderTokenFilter(TokenFilter):
    """Decomposes compound words found in many Germanic languages. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param word_list: Required. The list of words to match against.
    :type word_list: list[str]
    :param min_word_size: The minimum word size. Only words longer than this get processed. Default
     is 5. Maximum is 300.
    :type min_word_size: int
    :param min_subword_size: The minimum subword size. Only subwords longer than this are
     outputted. Default is 2. Maximum is 300.
    :type min_subword_size: int
    :param max_subword_size: The maximum subword size. Only subwords shorter than this are
     outputted. Default is 15. Maximum is 300.
    :type max_subword_size: int
    :param only_longest_match: A value indicating whether to add only the longest matching subword
     to the output. Default is false.
    :type only_longest_match: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'word_list': {'required': True},
        'min_word_size': {'maximum': 300},
        'min_subword_size': {'maximum': 300},
        'max_subword_size': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'word_list': {'key': 'wordList', 'type': '[str]'},
        'min_word_size': {'key': 'minWordSize', 'type': 'int'},
        'min_subword_size': {'key': 'minSubwordSize', 'type': 'int'},
        'max_subword_size': {'key': 'maxSubwordSize', 'type': 'int'},
        'only_longest_match': {'key': 'onlyLongestMatch', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        word_list: List[str],
        min_word_size: Optional[int] = 5,
        min_subword_size: Optional[int] = 2,
        max_subword_size: Optional[int] = 15,
        only_longest_match: Optional[bool] = False,
        **kwargs
    ):
        super(DictionaryDecompounderTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter'  # type: str
        self.word_list = word_list
        self.min_word_size = min_word_size
        self.min_subword_size = min_subword_size
        self.max_subword_size = max_subword_size
        self.only_longest_match = only_longest_match


class ScoringFunction(msrest.serialization.Model):
    """Base type for functions that can modify document scores during ranking.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DistanceScoringFunction, FreshnessScoringFunction, MagnitudeScoringFunction, TagScoringFunction.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :type type: str
    :param field_name: Required. The name of the field used as input to the scoring function.
    :type field_name: str
    :param boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :type boost: float
    :param interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :type interpolation: str or ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'distance': 'DistanceScoringFunction', 'freshness': 'FreshnessScoringFunction', 'magnitude': 'MagnitudeScoringFunction', 'tag': 'TagScoringFunction'}
    }

    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        interpolation: Optional[Union[str, "ScoringFunctionInterpolation"]] = None,
        **kwargs
    ):
        super(ScoringFunction, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.field_name = field_name
        self.boost = boost
        self.interpolation = interpolation


class DistanceScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on distance from a geographic location.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :type type: str
    :param field_name: Required. The name of the field used as input to the scoring function.
    :type field_name: str
    :param boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :type boost: float
    :param interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :type interpolation: str or ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :param parameters: Required. Parameter values for the distance scoring function.
    :type parameters: ~azure.search.documents.indexes.models.DistanceScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'distance', 'type': 'DistanceScoringParameters'},
    }

    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "DistanceScoringParameters",
        interpolation: Optional[Union[str, "ScoringFunctionInterpolation"]] = None,
        **kwargs
    ):
        super(DistanceScoringFunction, self).__init__(field_name=field_name, boost=boost, interpolation=interpolation, **kwargs)
        self.type = 'distance'  # type: str
        self.parameters = parameters


class DistanceScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a distance scoring function.

    All required parameters must be populated in order to send to Azure.

    :param reference_point_parameter: Required. The name of the parameter passed in search queries
     to specify the reference location.
    :type reference_point_parameter: str
    :param boosting_distance: Required. The distance in kilometers from the reference location
     where the boosting range ends.
    :type boosting_distance: float
    """

    _validation = {
        'reference_point_parameter': {'required': True},
        'boosting_distance': {'required': True},
    }

    _attribute_map = {
        'reference_point_parameter': {'key': 'referencePointParameter', 'type': 'str'},
        'boosting_distance': {'key': 'boostingDistance', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        reference_point_parameter: str,
        boosting_distance: float,
        **kwargs
    ):
        super(DistanceScoringParameters, self).__init__(**kwargs)
        self.reference_point_parameter = reference_point_parameter
        self.boosting_distance = boosting_distance


class DocumentExtractionSkill(SearchIndexerSkill):
    """A skill that extracts content from a file within the enrichment pipeline.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param parsing_mode: The parsingMode for the skill. Will be set to 'default' if not defined.
    :type parsing_mode: str
    :param data_to_extract: The type of data to be extracted for the skill. Will be set to
     'contentAndMetadata' if not defined.
    :type data_to_extract: str
    :param configuration: A dictionary of configurations for the skill.
    :type configuration: dict[str, any]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'parsing_mode': {'key': 'parsingMode', 'type': 'str'},
        'data_to_extract': {'key': 'dataToExtract', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        parsing_mode: Optional[str] = None,
        data_to_extract: Optional[str] = None,
        configuration: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(DocumentExtractionSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Util.DocumentExtractionSkill'  # type: str
        self.parsing_mode = parsing_mode
        self.data_to_extract = data_to_extract
        self.configuration = configuration


class EdgeNGramTokenFilter(TokenFilter):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2.
    :type max_gram: int
    :param side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Possible values include: "front", "back".
    :type side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'side': {'key': 'side', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        side: Optional[Union[str, "EdgeNGramTokenFilterSide"]] = None,
        **kwargs
    ):
        super(EdgeNGramTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenFilter'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram
        self.side = side


class EdgeNGramTokenFilterV2(TokenFilter):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :type max_gram: int
    :param side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Possible values include: "front", "back".
    :type side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'side': {'key': 'side', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        side: Optional[Union[str, "EdgeNGramTokenFilterSide"]] = None,
        **kwargs
    ):
        super(EdgeNGramTokenFilterV2, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenFilterV2'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram
        self.side = side


class EdgeNGramTokenizer(LexicalTokenizer):
    """Tokenizes the input from an edge into n-grams of the given size(s). This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :type max_gram: int
    :param token_chars: Character classes to keep in the tokens.
    :type token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'token_chars': {'key': 'tokenChars', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        token_chars: Optional[List[Union[str, "TokenCharacterKind"]]] = None,
        **kwargs
    ):
        super(EdgeNGramTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenizer'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram
        self.token_chars = token_chars


class ElisionTokenFilter(TokenFilter):
    """Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param articles: The set of articles to remove.
    :type articles: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'articles': {'key': 'articles', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        articles: Optional[List[str]] = None,
        **kwargs
    ):
        super(ElisionTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ElisionTokenFilter'  # type: str
        self.articles = articles


class EntityLinkingSkill(SearchIndexerSkill):
    """Using the Text Analytics API, extracts linked entities from text.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
    :type default_language_code: str
    :param minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :type minimum_precision: float
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        model_version: Optional[str] = None,
        **kwargs
    ):
        super(EntityLinkingSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.EntityLinkingSkill'  # type: str
        self.default_language_code = default_language_code
        self.minimum_precision = minimum_precision
        self.model_version = model_version


class EntityRecognitionSkill(SearchIndexerSkill):
    """Text analytics entity recognition.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param categories: A list of entity categories that should be extracted.
    :type categories: list[str or ~azure.search.documents.indexes.models.EntityCategory]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "ar", "cs", "zh-Hans", "zh-Hant", "da", "nl", "en", "fi", "fr", "de",
     "el", "hu", "it", "ja", "ko", "no", "pl", "pt-PT", "pt-BR", "ru", "es", "sv", "tr".
    :type default_language_code: str or
     ~azure.search.documents.indexes.models.EntityRecognitionSkillLanguage
    :param include_typeless_entities: Determines whether or not to include entities which are well
     known but don't conform to a pre-defined type. If this configuration is not set (default), set
     to null or set to false, entities which don't conform to one of the pre-defined types will not
     be surfaced.
    :type include_typeless_entities: bool
    :param minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :type minimum_precision: float
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'include_typeless_entities': {'key': 'includeTypelessEntities', 'type': 'bool'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        categories: Optional[List[Union[str, "EntityCategory"]]] = None,
        default_language_code: Optional[Union[str, "EntityRecognitionSkillLanguage"]] = None,
        include_typeless_entities: Optional[bool] = None,
        minimum_precision: Optional[float] = None,
        **kwargs
    ):
        super(EntityRecognitionSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.EntityRecognitionSkill'  # type: str
        self.categories = categories
        self.default_language_code = default_language_code
        self.include_typeless_entities = include_typeless_entities
        self.minimum_precision = minimum_precision


class EntityRecognitionSkillV3(SearchIndexerSkill):
    """Using the Text Analytics API, extracts entities of different types from text.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param categories: A list of entity categories that should be extracted.
    :type categories: list[str]
    :param default_language_code: A value indicating which language code to use. Default is en.
    :type default_language_code: str
    :param minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :type minimum_precision: float
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        categories: Optional[List[str]] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        model_version: Optional[str] = None,
        **kwargs
    ):
        super(EntityRecognitionSkillV3, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.EntityRecognitionSkill'  # type: str
        self.categories = categories
        self.default_language_code = default_language_code
        self.minimum_precision = minimum_precision
        self.model_version = model_version


class FieldMapping(msrest.serialization.Model):
    """Defines a mapping between a field in a data source and a target field in an index.

    All required parameters must be populated in order to send to Azure.

    :param source_field_name: Required. The name of the field in the data source.
    :type source_field_name: str
    :param target_field_name: The name of the target field in the index. Same as the source field
     name by default.
    :type target_field_name: str
    :param mapping_function: A function to apply to each source field value before indexing.
    :type mapping_function: ~azure.search.documents.indexes.models.FieldMappingFunction
    """

    _validation = {
        'source_field_name': {'required': True},
    }

    _attribute_map = {
        'source_field_name': {'key': 'sourceFieldName', 'type': 'str'},
        'target_field_name': {'key': 'targetFieldName', 'type': 'str'},
        'mapping_function': {'key': 'mappingFunction', 'type': 'FieldMappingFunction'},
    }

    def __init__(
        self,
        *,
        source_field_name: str,
        target_field_name: Optional[str] = None,
        mapping_function: Optional["FieldMappingFunction"] = None,
        **kwargs
    ):
        super(FieldMapping, self).__init__(**kwargs)
        self.source_field_name = source_field_name
        self.target_field_name = target_field_name
        self.mapping_function = mapping_function


class FieldMappingFunction(msrest.serialization.Model):
    """Represents a function that transforms a value from a data source before indexing.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the field mapping function.
    :type name: str
    :param parameters: A dictionary of parameter name/value pairs to pass to the function. Each
     value must be of a primitive type.
    :type parameters: dict[str, any]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        parameters: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(FieldMappingFunction, self).__init__(**kwargs)
        self.name = name
        self.parameters = parameters


class FreshnessScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on the value of a date-time field.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :type type: str
    :param field_name: Required. The name of the field used as input to the scoring function.
    :type field_name: str
    :param boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :type boost: float
    :param interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :type interpolation: str or ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :param parameters: Required. Parameter values for the freshness scoring function.
    :type parameters: ~azure.search.documents.indexes.models.FreshnessScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'freshness', 'type': 'FreshnessScoringParameters'},
    }

    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "FreshnessScoringParameters",
        interpolation: Optional[Union[str, "ScoringFunctionInterpolation"]] = None,
        **kwargs
    ):
        super(FreshnessScoringFunction, self).__init__(field_name=field_name, boost=boost, interpolation=interpolation, **kwargs)
        self.type = 'freshness'  # type: str
        self.parameters = parameters


class FreshnessScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a freshness scoring function.

    All required parameters must be populated in order to send to Azure.

    :param boosting_duration: Required. The expiration period after which boosting will stop for a
     particular document.
    :type boosting_duration: ~datetime.timedelta
    """

    _validation = {
        'boosting_duration': {'required': True},
    }

    _attribute_map = {
        'boosting_duration': {'key': 'boostingDuration', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        boosting_duration: datetime.timedelta,
        **kwargs
    ):
        super(FreshnessScoringParameters, self).__init__(**kwargs)
        self.boosting_duration = boosting_duration


class GetIndexStatisticsResult(msrest.serialization.Model):
    """Statistics for a given index. Statistics are collected periodically and are not guaranteed to always be up-to-date.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar document_count: Required. The number of documents in the index.
    :vartype document_count: long
    :ivar storage_size: Required. The amount of storage in bytes consumed by the index.
    :vartype storage_size: long
    """

    _validation = {
        'document_count': {'required': True, 'readonly': True},
        'storage_size': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'storage_size': {'key': 'storageSize', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetIndexStatisticsResult, self).__init__(**kwargs)
        self.document_count = None
        self.storage_size = None


class HighWaterMarkChangeDetectionPolicy(DataChangeDetectionPolicy):
    """Defines a data change detection policy that captures changes based on the value of a high water mark column.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :type odata_type: str
    :param high_water_mark_column_name: Required. The name of the high water mark column.
    :type high_water_mark_column_name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'high_water_mark_column_name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'high_water_mark_column_name': {'key': 'highWaterMarkColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        high_water_mark_column_name: str,
        **kwargs
    ):
        super(HighWaterMarkChangeDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy'  # type: str
        self.high_water_mark_column_name = high_water_mark_column_name


class ImageAnalysisSkill(SearchIndexerSkill):
    """A skill that analyzes image files. It extracts a rich set of visual features based on the image content.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "en", "es", "ja", "pt", "zh".
    :type default_language_code: str or
     ~azure.search.documents.indexes.models.ImageAnalysisSkillLanguage
    :param visual_features: A list of visual features.
    :type visual_features: list[str or ~azure.search.documents.indexes.models.VisualFeature]
    :param details: A string indicating which domain-specific details to return.
    :type details: list[str or ~azure.search.documents.indexes.models.ImageDetail]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'visual_features': {'key': 'visualFeatures', 'type': '[str]'},
        'details': {'key': 'details', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "ImageAnalysisSkillLanguage"]] = None,
        visual_features: Optional[List[Union[str, "VisualFeature"]]] = None,
        details: Optional[List[Union[str, "ImageDetail"]]] = None,
        **kwargs
    ):
        super(ImageAnalysisSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Vision.ImageAnalysisSkill'  # type: str
        self.default_language_code = default_language_code
        self.visual_features = visual_features
        self.details = details


class IndexerExecutionResult(msrest.serialization.Model):
    """Represents the result of an individual indexer execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The outcome of this indexer execution. Possible values include:
     "transientFailure", "success", "inProgress", "reset".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerExecutionStatus
    :ivar error_message: The error message indicating the top-level error, if any.
    :vartype error_message: str
    :ivar start_time: The start time of this indexer execution.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of this indexer execution, if the execution has already completed.
    :vartype end_time: ~datetime.datetime
    :ivar errors: Required. The item-level indexing errors.
    :vartype errors: list[~azure.search.documents.indexes.models.SearchIndexerError]
    :ivar warnings: Required. The item-level indexing warnings.
    :vartype warnings: list[~azure.search.documents.indexes.models.SearchIndexerWarning]
    :ivar item_count: Required. The number of items that were processed during this indexer
     execution. This includes both successfully processed items and items where indexing was
     attempted but failed.
    :vartype item_count: int
    :ivar failed_item_count: Required. The number of items that failed to be indexed during this
     indexer execution.
    :vartype failed_item_count: int
    :ivar initial_tracking_state: Change tracking state with which an indexer execution started.
    :vartype initial_tracking_state: str
    :ivar final_tracking_state: Change tracking state with which an indexer execution finished.
    :vartype final_tracking_state: str
    """

    _validation = {
        'status': {'required': True, 'readonly': True},
        'error_message': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'required': True, 'readonly': True},
        'warnings': {'required': True, 'readonly': True},
        'item_count': {'required': True, 'readonly': True},
        'failed_item_count': {'required': True, 'readonly': True},
        'initial_tracking_state': {'readonly': True},
        'final_tracking_state': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[SearchIndexerError]'},
        'warnings': {'key': 'warnings', 'type': '[SearchIndexerWarning]'},
        'item_count': {'key': 'itemsProcessed', 'type': 'int'},
        'failed_item_count': {'key': 'itemsFailed', 'type': 'int'},
        'initial_tracking_state': {'key': 'initialTrackingState', 'type': 'str'},
        'final_tracking_state': {'key': 'finalTrackingState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndexerExecutionResult, self).__init__(**kwargs)
        self.status = None
        self.error_message = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.warnings = None
        self.item_count = None
        self.failed_item_count = None
        self.initial_tracking_state = None
        self.final_tracking_state = None


class IndexingParameters(msrest.serialization.Model):
    """Represents parameters for indexer execution.

    :param batch_size: The number of items that are read from the data source and indexed as a
     single batch in order to improve performance. The default depends on the data source type.
    :type batch_size: int
    :param max_failed_items: The maximum number of items that can fail indexing for indexer
     execution to still be considered successful. -1 means no limit. Default is 0.
    :type max_failed_items: int
    :param max_failed_items_per_batch: The maximum number of items in a single batch that can fail
     indexing for the batch to still be considered successful. -1 means no limit. Default is 0.
    :type max_failed_items_per_batch: int
    :param configuration: A dictionary of indexer-specific configuration properties. Each name is
     the name of a specific property. Each value must be of a primitive type.
    :type configuration: ~azure.search.documents.indexes.models.IndexingParametersConfiguration
    """

    _attribute_map = {
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'max_failed_items': {'key': 'maxFailedItems', 'type': 'int'},
        'max_failed_items_per_batch': {'key': 'maxFailedItemsPerBatch', 'type': 'int'},
        'configuration': {'key': 'configuration', 'type': 'IndexingParametersConfiguration'},
    }

    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        max_failed_items: Optional[int] = 0,
        max_failed_items_per_batch: Optional[int] = 0,
        configuration: Optional["IndexingParametersConfiguration"] = None,
        **kwargs
    ):
        super(IndexingParameters, self).__init__(**kwargs)
        self.batch_size = batch_size
        self.max_failed_items = max_failed_items
        self.max_failed_items_per_batch = max_failed_items_per_batch
        self.configuration = configuration


class IndexingParametersConfiguration(msrest.serialization.Model):
    """A dictionary of indexer-specific configuration properties. Each name is the name of a specific property. Each value must be of a primitive type.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param parsing_mode: Represents the parsing mode for indexing from an Azure blob data source.
     Possible values include: "default", "text", "delimitedText", "json", "jsonArray", "jsonLines".
     Default value: "default".
    :type parsing_mode: str or ~azure.search.documents.indexes.models.BlobIndexerParsingMode
    :param excluded_file_name_extensions: Comma-delimited list of filename extensions to ignore
     when processing from Azure blob storage.  For example, you could exclude ".png, .mp4" to skip
     over those files during indexing.
    :type excluded_file_name_extensions: str
    :param indexed_file_name_extensions: Comma-delimited list of filename extensions to select when
     processing from Azure blob storage.  For example, you could focus indexing on specific
     application files ".docx, .pptx, .msg" to specifically include those file types.
    :type indexed_file_name_extensions: str
    :param fail_on_unsupported_content_type: For Azure blobs, set to false if you want to continue
     indexing when an unsupported content type is encountered, and you don't know all the content
     types (file extensions) in advance.
    :type fail_on_unsupported_content_type: bool
    :param fail_on_unprocessable_document: For Azure blobs, set to false if you want to continue
     indexing if a document fails indexing.
    :type fail_on_unprocessable_document: bool
    :param index_storage_metadata_only_for_oversized_documents: For Azure blobs, set this property
     to true to still index storage metadata for blob content that is too large to process.
     Oversized blobs are treated as errors by default. For limits on blob size, see
     https://docs.microsoft.com/azure/search/search-limits-quotas-capacity.
    :type index_storage_metadata_only_for_oversized_documents: bool
    :param delimited_text_headers: For CSV blobs, specifies a comma-delimited list of column
     headers, useful for mapping source fields to destination fields in an index.
    :type delimited_text_headers: str
    :param delimited_text_delimiter: For CSV blobs, specifies the end-of-line single-character
     delimiter for CSV files where each line starts a new document (for example, "|").
    :type delimited_text_delimiter: str
    :param first_line_contains_headers: For CSV blobs, indicates that the first (non-blank) line of
     each blob contains headers.
    :type first_line_contains_headers: bool
    :param document_root: For JSON arrays, given a structured or semi-structured document, you can
     specify a path to the array using this property.
    :type document_root: str
    :param data_to_extract: Specifies the data to extract from Azure blob storage and tells the
     indexer which data to extract from image content when "imageAction" is set to a value other
     than "none".  This applies to embedded image content in a .PDF or other application, or image
     files such as .jpg and .png, in Azure blobs. Possible values include: "storageMetadata",
     "allMetadata", "contentAndMetadata". Default value: "contentAndMetadata".
    :type data_to_extract: str or ~azure.search.documents.indexes.models.BlobIndexerDataToExtract
    :param image_action: Determines how to process embedded images and image files in Azure blob
     storage.  Setting the "imageAction" configuration to any value other than "none" requires that
     a skillset also be attached to that indexer. Possible values include: "none",
     "generateNormalizedImages", "generateNormalizedImagePerPage". Default value: "none".
    :type image_action: str or ~azure.search.documents.indexes.models.BlobIndexerImageAction
    :param allow_skillset_to_read_file_data: If true, will create a path //document//file_data that
     is an object representing the original file data downloaded from your blob data source.  This
     allows you to pass the original file data to a custom skill for processing within the
     enrichment pipeline, or to the Document Extraction skill.
    :type allow_skillset_to_read_file_data: bool
    :param pdf_text_rotation_algorithm: Determines algorithm for text extraction from PDF files in
     Azure blob storage. Possible values include: "none", "detectAngles". Default value: "none".
    :type pdf_text_rotation_algorithm: str or
     ~azure.search.documents.indexes.models.BlobIndexerPDFTextRotationAlgorithm
    :param execution_environment: Specifies the environment in which the indexer should execute.
     Possible values include: "standard", "private". Default value: "standard".
    :type execution_environment: str or
     ~azure.search.documents.indexes.models.IndexerExecutionEnvironment
    :param query_timeout: Increases the timeout beyond the 5-minute default for Azure SQL database
     data sources, specified in the format "hh:mm:ss".
    :type query_timeout: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'parsing_mode': {'key': 'parsingMode', 'type': 'str'},
        'excluded_file_name_extensions': {'key': 'excludedFileNameExtensions', 'type': 'str'},
        'indexed_file_name_extensions': {'key': 'indexedFileNameExtensions', 'type': 'str'},
        'fail_on_unsupported_content_type': {'key': 'failOnUnsupportedContentType', 'type': 'bool'},
        'fail_on_unprocessable_document': {'key': 'failOnUnprocessableDocument', 'type': 'bool'},
        'index_storage_metadata_only_for_oversized_documents': {'key': 'indexStorageMetadataOnlyForOversizedDocuments', 'type': 'bool'},
        'delimited_text_headers': {'key': 'delimitedTextHeaders', 'type': 'str'},
        'delimited_text_delimiter': {'key': 'delimitedTextDelimiter', 'type': 'str'},
        'first_line_contains_headers': {'key': 'firstLineContainsHeaders', 'type': 'bool'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'data_to_extract': {'key': 'dataToExtract', 'type': 'str'},
        'image_action': {'key': 'imageAction', 'type': 'str'},
        'allow_skillset_to_read_file_data': {'key': 'allowSkillsetToReadFileData', 'type': 'bool'},
        'pdf_text_rotation_algorithm': {'key': 'pdfTextRotationAlgorithm', 'type': 'str'},
        'execution_environment': {'key': 'executionEnvironment', 'type': 'str'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsing_mode: Optional[Union[str, "BlobIndexerParsingMode"]] = "default",
        excluded_file_name_extensions: Optional[str] = "",
        indexed_file_name_extensions: Optional[str] = "",
        fail_on_unsupported_content_type: Optional[bool] = False,
        fail_on_unprocessable_document: Optional[bool] = False,
        index_storage_metadata_only_for_oversized_documents: Optional[bool] = False,
        delimited_text_headers: Optional[str] = None,
        delimited_text_delimiter: Optional[str] = None,
        first_line_contains_headers: Optional[bool] = True,
        document_root: Optional[str] = None,
        data_to_extract: Optional[Union[str, "BlobIndexerDataToExtract"]] = "contentAndMetadata",
        image_action: Optional[Union[str, "BlobIndexerImageAction"]] = "none",
        allow_skillset_to_read_file_data: Optional[bool] = False,
        pdf_text_rotation_algorithm: Optional[Union[str, "BlobIndexerPDFTextRotationAlgorithm"]] = "none",
        execution_environment: Optional[Union[str, "IndexerExecutionEnvironment"]] = "standard",
        query_timeout: Optional[str] = "00:05:00",
        **kwargs
    ):
        super(IndexingParametersConfiguration, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.parsing_mode = parsing_mode
        self.excluded_file_name_extensions = excluded_file_name_extensions
        self.indexed_file_name_extensions = indexed_file_name_extensions
        self.fail_on_unsupported_content_type = fail_on_unsupported_content_type
        self.fail_on_unprocessable_document = fail_on_unprocessable_document
        self.index_storage_metadata_only_for_oversized_documents = index_storage_metadata_only_for_oversized_documents
        self.delimited_text_headers = delimited_text_headers
        self.delimited_text_delimiter = delimited_text_delimiter
        self.first_line_contains_headers = first_line_contains_headers
        self.document_root = document_root
        self.data_to_extract = data_to_extract
        self.image_action = image_action
        self.allow_skillset_to_read_file_data = allow_skillset_to_read_file_data
        self.pdf_text_rotation_algorithm = pdf_text_rotation_algorithm
        self.execution_environment = execution_environment
        self.query_timeout = query_timeout


class IndexingSchedule(msrest.serialization.Model):
    """Represents a schedule for indexer execution.

    All required parameters must be populated in order to send to Azure.

    :param interval: Required. The interval of time between indexer executions.
    :type interval: ~datetime.timedelta
    :param start_time: The time when an indexer should start running.
    :type start_time: ~datetime.datetime
    """

    _validation = {
        'interval': {'required': True},
    }

    _attribute_map = {
        'interval': {'key': 'interval', 'type': 'duration'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        interval: datetime.timedelta,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(IndexingSchedule, self).__init__(**kwargs)
        self.interval = interval
        self.start_time = start_time


class InputFieldMappingEntry(msrest.serialization.Model):
    """Input field mapping for a skill.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the input.
    :type name: str
    :param source: The source of the input.
    :type source: str
    :param source_context: The source context used for selecting recursive inputs.
    :type source_context: str
    :param inputs: The recursive inputs used when creating a complex type.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(InputFieldMappingEntry, self).__init__(**kwargs)
        self.name = name
        self.source = source
        self.source_context = source_context
        self.inputs = inputs


class KeepTokenFilter(TokenFilter):
    """A token filter that only keeps tokens with text contained in a specified list of words. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param keep_words: Required. The list of words to keep.
    :type keep_words: list[str]
    :param lower_case_keep_words: A value indicating whether to lower case all words first. Default
     is false.
    :type lower_case_keep_words: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'keep_words': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'keep_words': {'key': 'keepWords', 'type': '[str]'},
        'lower_case_keep_words': {'key': 'keepWordsCase', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        keep_words: List[str],
        lower_case_keep_words: Optional[bool] = False,
        **kwargs
    ):
        super(KeepTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeepTokenFilter'  # type: str
        self.keep_words = keep_words
        self.lower_case_keep_words = lower_case_keep_words


class KeyPhraseExtractionSkill(SearchIndexerSkill):
    """A skill that uses text analytics for key phrase extraction.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "nl", "en", "fi", "fr", "de", "it", "ja", "ko", "no", "pl",
     "pt-PT", "pt-BR", "ru", "es", "sv".
    :type default_language_code: str or
     ~azure.search.documents.indexes.models.KeyPhraseExtractionSkillLanguage
    :param max_key_phrase_count: A number indicating how many key phrases to return. If absent, all
     identified key phrases will be returned.
    :type max_key_phrase_count: int
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'max_key_phrase_count': {'key': 'maxKeyPhraseCount', 'type': 'int'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "KeyPhraseExtractionSkillLanguage"]] = None,
        max_key_phrase_count: Optional[int] = None,
        model_version: Optional[str] = None,
        **kwargs
    ):
        super(KeyPhraseExtractionSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.KeyPhraseExtractionSkill'  # type: str
        self.default_language_code = default_language_code
        self.max_key_phrase_count = max_key_phrase_count
        self.model_version = model_version


class KeywordMarkerTokenFilter(TokenFilter):
    """Marks terms as keywords. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param keywords: Required. A list of words to mark as keywords.
    :type keywords: list[str]
    :param ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :type ignore_case: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'keywords': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'keywords': {'key': 'keywords', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        keywords: List[str],
        ignore_case: Optional[bool] = False,
        **kwargs
    ):
        super(KeywordMarkerTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordMarkerTokenFilter'  # type: str
        self.keywords = keywords
        self.ignore_case = ignore_case


class KeywordTokenizer(LexicalTokenizer):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param buffer_size: The read buffer size in bytes. Default is 256.
    :type buffer_size: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'buffer_size': {'key': 'bufferSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        buffer_size: Optional[int] = 256,
        **kwargs
    ):
        super(KeywordTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordTokenizer'  # type: str
        self.buffer_size = buffer_size


class KeywordTokenizerV2(LexicalTokenizer):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 256. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :type max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 256,
        **kwargs
    ):
        super(KeywordTokenizerV2, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordTokenizerV2'  # type: str
        self.max_token_length = max_token_length


class LanguageDetectionSkill(SearchIndexerSkill):
    """A skill that detects the language of input text and reports a single language code for every document submitted on the request. The language code is paired with a score indicating the confidence of the analysis.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_country_hint: A country code to use as a hint to the language detection model if
     it cannot disambiguate the language.
    :type default_country_hint: str
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_country_hint': {'key': 'defaultCountryHint', 'type': 'str'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_country_hint: Optional[str] = None,
        model_version: Optional[str] = None,
        **kwargs
    ):
        super(LanguageDetectionSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.LanguageDetectionSkill'  # type: str
        self.default_country_hint = default_country_hint
        self.model_version = model_version


class LengthTokenFilter(TokenFilter):
    """Removes words that are too long or too short. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param min_length: The minimum length in characters. Default is 0. Maximum is 300. Must be less
     than the value of max.
    :type min_length: int
    :param max_length: The maximum length in characters. Default and maximum is 300.
    :type max_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_length': {'maximum': 300},
        'max_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_length': {'key': 'min', 'type': 'int'},
        'max_length': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_length: Optional[int] = 0,
        max_length: Optional[int] = 300,
        **kwargs
    ):
        super(LengthTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.LengthTokenFilter'  # type: str
        self.min_length = min_length
        self.max_length = max_length


class LimitTokenFilter(TokenFilter):
    """Limits the number of tokens while indexing. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param max_token_count: The maximum number of tokens to produce. Default is 1.
    :type max_token_count: int
    :param consume_all_tokens: A value indicating whether all tokens from the input must be
     consumed even if maxTokenCount is reached. Default is false.
    :type consume_all_tokens: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_count': {'key': 'maxTokenCount', 'type': 'int'},
        'consume_all_tokens': {'key': 'consumeAllTokens', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_count: Optional[int] = 1,
        consume_all_tokens: Optional[bool] = False,
        **kwargs
    ):
        super(LimitTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.LimitTokenFilter'  # type: str
        self.max_token_count = max_token_count
        self.consume_all_tokens = consume_all_tokens


class ListDataSourcesResult(msrest.serialization.Model):
    """Response from a List Datasources request. If successful, it includes the full definitions of all datasources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_sources: Required. The datasources in the Search service.
    :vartype data_sources: list[~azure.search.documents.indexes.models.SearchIndexerDataSource]
    """

    _validation = {
        'data_sources': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'data_sources': {'key': 'value', 'type': '[SearchIndexerDataSource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListDataSourcesResult, self).__init__(**kwargs)
        self.data_sources = None


class ListIndexersResult(msrest.serialization.Model):
    """Response from a List Indexers request. If successful, it includes the full definitions of all indexers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar indexers: Required. The indexers in the Search service.
    :vartype indexers: list[~azure.search.documents.indexes.models.SearchIndexer]
    """

    _validation = {
        'indexers': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'indexers': {'key': 'value', 'type': '[SearchIndexer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListIndexersResult, self).__init__(**kwargs)
        self.indexers = None


class ListIndexesResult(msrest.serialization.Model):
    """Response from a List Indexes request. If successful, it includes the full definitions of all indexes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar indexes: Required. The indexes in the Search service.
    :vartype indexes: list[~azure.search.documents.indexes.models.SearchIndex]
    """

    _validation = {
        'indexes': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'indexes': {'key': 'value', 'type': '[SearchIndex]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListIndexesResult, self).__init__(**kwargs)
        self.indexes = None


class ListSkillsetsResult(msrest.serialization.Model):
    """Response from a list skillset request. If successful, it includes the full definitions of all skillsets.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar skillsets: Required. The skillsets defined in the Search service.
    :vartype skillsets: list[~azure.search.documents.indexes.models.SearchIndexerSkillset]
    """

    _validation = {
        'skillsets': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'skillsets': {'key': 'value', 'type': '[SearchIndexerSkillset]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListSkillsetsResult, self).__init__(**kwargs)
        self.skillsets = None


class ListSynonymMapsResult(msrest.serialization.Model):
    """Response from a List SynonymMaps request. If successful, it includes the full definitions of all synonym maps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar synonym_maps: Required. The synonym maps in the Search service.
    :vartype synonym_maps: list[~azure.search.documents.indexes.models.SynonymMap]
    """

    _validation = {
        'synonym_maps': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'synonym_maps': {'key': 'value', 'type': '[SynonymMap]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListSynonymMapsResult, self).__init__(**kwargs)
        self.synonym_maps = None


class LuceneStandardAnalyzer(LexicalAnalyzer):
    """Standard Apache Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop filter.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :type max_token_length: int
    :param stopwords: A list of stopwords.
    :type stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        stopwords: Optional[List[str]] = None,
        **kwargs
    ):
        super(LuceneStandardAnalyzer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardAnalyzer'  # type: str
        self.max_token_length = max_token_length
        self.stopwords = stopwords


class LuceneStandardTokenizer(LexicalTokenizer):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split.
    :type max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        **kwargs
    ):
        super(LuceneStandardTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardTokenizer'  # type: str
        self.max_token_length = max_token_length


class LuceneStandardTokenizerV2(LexicalTokenizer):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :type max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        **kwargs
    ):
        super(LuceneStandardTokenizerV2, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardTokenizerV2'  # type: str
        self.max_token_length = max_token_length


class MagnitudeScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on the magnitude of a numeric field.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :type type: str
    :param field_name: Required. The name of the field used as input to the scoring function.
    :type field_name: str
    :param boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :type boost: float
    :param interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :type interpolation: str or ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :param parameters: Required. Parameter values for the magnitude scoring function.
    :type parameters: ~azure.search.documents.indexes.models.MagnitudeScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'magnitude', 'type': 'MagnitudeScoringParameters'},
    }

    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "MagnitudeScoringParameters",
        interpolation: Optional[Union[str, "ScoringFunctionInterpolation"]] = None,
        **kwargs
    ):
        super(MagnitudeScoringFunction, self).__init__(field_name=field_name, boost=boost, interpolation=interpolation, **kwargs)
        self.type = 'magnitude'  # type: str
        self.parameters = parameters


class MagnitudeScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a magnitude scoring function.

    All required parameters must be populated in order to send to Azure.

    :param boosting_range_start: Required. The field value at which boosting starts.
    :type boosting_range_start: float
    :param boosting_range_end: Required. The field value at which boosting ends.
    :type boosting_range_end: float
    :param should_boost_beyond_range_by_constant: A value indicating whether to apply a constant
     boost for field values beyond the range end value; default is false.
    :type should_boost_beyond_range_by_constant: bool
    """

    _validation = {
        'boosting_range_start': {'required': True},
        'boosting_range_end': {'required': True},
    }

    _attribute_map = {
        'boosting_range_start': {'key': 'boostingRangeStart', 'type': 'float'},
        'boosting_range_end': {'key': 'boostingRangeEnd', 'type': 'float'},
        'should_boost_beyond_range_by_constant': {'key': 'constantBoostBeyondRange', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        boosting_range_start: float,
        boosting_range_end: float,
        should_boost_beyond_range_by_constant: Optional[bool] = None,
        **kwargs
    ):
        super(MagnitudeScoringParameters, self).__init__(**kwargs)
        self.boosting_range_start = boosting_range_start
        self.boosting_range_end = boosting_range_end
        self.should_boost_beyond_range_by_constant = should_boost_beyond_range_by_constant


class MappingCharFilter(CharFilter):
    """A character filter that applies mappings defined with the mappings option. Matching is greedy (longest pattern matching at a given point wins). Replacement is allowed to be the empty string. This character filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param mappings: Required. A list of mappings of the following format: "a=>b" (all occurrences
     of the character "a" will be replaced with character "b").
    :type mappings: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'mappings': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'mappings': {'key': 'mappings', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        mappings: List[str],
        **kwargs
    ):
        super(MappingCharFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MappingCharFilter'  # type: str
        self.mappings = mappings


class MergeSkill(SearchIndexerSkill):
    """A skill for merging two or more strings into a single unified string, with an optional user-defined delimiter separating each component part.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param insert_pre_tag: The tag indicates the start of the merged text. By default, the tag is
     an empty space.
    :type insert_pre_tag: str
    :param insert_post_tag: The tag indicates the end of the merged text. By default, the tag is an
     empty space.
    :type insert_post_tag: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'insert_pre_tag': {'key': 'insertPreTag', 'type': 'str'},
        'insert_post_tag': {'key': 'insertPostTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        insert_pre_tag: Optional[str] = " ",
        insert_post_tag: Optional[str] = " ",
        **kwargs
    ):
        super(MergeSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.MergeSkill'  # type: str
        self.insert_pre_tag = insert_pre_tag
        self.insert_post_tag = insert_post_tag


class MicrosoftLanguageStemmingTokenizer(LexicalTokenizer):
    """Divides text using language-specific rules and reduces words to their base forms.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :type max_token_length: int
    :param is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used
     as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :type is_search_tokenizer: bool
    :param language: The language to use. The default is English. Possible values include:
     "arabic", "bangla", "bulgarian", "catalan", "croatian", "czech", "danish", "dutch", "english",
     "estonian", "finnish", "french", "german", "greek", "gujarati", "hebrew", "hindi", "hungarian",
     "icelandic", "indonesian", "italian", "kannada", "latvian", "lithuanian", "malay", "malayalam",
     "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
     "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovak", "slovenian", "spanish",
     "swedish", "tamil", "telugu", "turkish", "ukrainian", "urdu".
    :type language: str or
     ~azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'is_search_tokenizer': {'key': 'isSearchTokenizer', 'type': 'bool'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        is_search_tokenizer: Optional[bool] = False,
        language: Optional[Union[str, "MicrosoftStemmingTokenizerLanguage"]] = None,
        **kwargs
    ):
        super(MicrosoftLanguageStemmingTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer'  # type: str
        self.max_token_length = max_token_length
        self.is_search_tokenizer = is_search_tokenizer
        self.language = language


class MicrosoftLanguageTokenizer(LexicalTokenizer):
    """Divides text using language-specific rules.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :type max_token_length: int
    :param is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used
     as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :type is_search_tokenizer: bool
    :param language: The language to use. The default is English. Possible values include:
     "bangla", "bulgarian", "catalan", "chineseSimplified", "chineseTraditional", "croatian",
     "czech", "danish", "dutch", "english", "french", "german", "greek", "gujarati", "hindi",
     "icelandic", "indonesian", "italian", "japanese", "kannada", "korean", "malay", "malayalam",
     "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
     "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovenian", "spanish", "swedish",
     "tamil", "telugu", "thai", "ukrainian", "urdu", "vietnamese".
    :type language: str or ~azure.search.documents.indexes.models.MicrosoftTokenizerLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'is_search_tokenizer': {'key': 'isSearchTokenizer', 'type': 'bool'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        is_search_tokenizer: Optional[bool] = False,
        language: Optional[Union[str, "MicrosoftTokenizerLanguage"]] = None,
        **kwargs
    ):
        super(MicrosoftLanguageTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer'  # type: str
        self.max_token_length = max_token_length
        self.is_search_tokenizer = is_search_tokenizer
        self.language = language


class NGramTokenFilter(TokenFilter):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2.
    :type max_gram: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        **kwargs
    ):
        super(NGramTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenFilter'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram


class NGramTokenFilterV2(TokenFilter):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :type max_gram: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        **kwargs
    ):
        super(NGramTokenFilterV2, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenFilterV2'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram


class NGramTokenizer(LexicalTokenizer):
    """Tokenizes the input into n-grams of the given size(s). This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :type min_gram: int
    :param max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :type max_gram: int
    :param token_chars: Character classes to keep in the tokens.
    :type token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'token_chars': {'key': 'tokenChars', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = 1,
        max_gram: Optional[int] = 2,
        token_chars: Optional[List[Union[str, "TokenCharacterKind"]]] = None,
        **kwargs
    ):
        super(NGramTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenizer'  # type: str
        self.min_gram = min_gram
        self.max_gram = max_gram
        self.token_chars = token_chars


class OcrSkill(SearchIndexerSkill):
    """A skill that extracts text from image files.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "zh-Hans", "zh-Hant", "cs", "da", "nl", "en", "fi", "fr", "de", "el",
     "hu", "it", "ja", "ko", "nb", "pl", "pt", "ru", "es", "sv", "tr", "ar", "ro", "sr-Cyrl",
     "sr-Latn", "sk".
    :type default_language_code: str or ~azure.search.documents.indexes.models.OcrSkillLanguage
    :param should_detect_orientation: A value indicating to turn orientation detection on or not.
     Default is false.
    :type should_detect_orientation: bool
    :param line_ending: Defines the sequence of characters to use between the lines of text
     recognized by the OCR skill. The default value is "space". Possible values include: "space",
     "carriageReturn", "lineFeed", "carriageReturnLineFeed".
    :type line_ending: str or ~azure.search.documents.indexes.models.LineEnding
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'should_detect_orientation': {'key': 'detectOrientation', 'type': 'bool'},
        'line_ending': {'key': 'lineEnding', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "OcrSkillLanguage"]] = None,
        should_detect_orientation: Optional[bool] = False,
        line_ending: Optional[Union[str, "LineEnding"]] = None,
        **kwargs
    ):
        super(OcrSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Vision.OcrSkill'  # type: str
        self.default_language_code = default_language_code
        self.should_detect_orientation = should_detect_orientation
        self.line_ending = line_ending


class OutputFieldMappingEntry(msrest.serialization.Model):
    """Output field mapping for a skill.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the output defined by the skill.
    :type name: str
    :param target_name: The target name of the output. It is optional and default to name.
    :type target_name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_name': {'key': 'targetName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        target_name: Optional[str] = None,
        **kwargs
    ):
        super(OutputFieldMappingEntry, self).__init__(**kwargs)
        self.name = name
        self.target_name = target_name


class PathHierarchyTokenizerV2(LexicalTokenizer):
    """Tokenizer for path-like hierarchies. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param delimiter: The delimiter character to use. Default is "/".
    :type delimiter: str
    :param replacement: A value that, if set, replaces the delimiter character. Default is "/".
    :type replacement: str
    :param max_token_length: The maximum token length. Default and maximum is 300.
    :type max_token_length: int
    :param reverse_token_order: A value indicating whether to generate tokens in reverse order.
     Default is false.
    :type reverse_token_order: bool
    :param number_of_tokens_to_skip: The number of initial tokens to skip. Default is 0.
    :type number_of_tokens_to_skip: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'delimiter': {'key': 'delimiter', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'reverse_token_order': {'key': 'reverse', 'type': 'bool'},
        'number_of_tokens_to_skip': {'key': 'skip', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        delimiter: Optional[str] = "/",
        replacement: Optional[str] = "/",
        max_token_length: Optional[int] = 300,
        reverse_token_order: Optional[bool] = False,
        number_of_tokens_to_skip: Optional[int] = 0,
        **kwargs
    ):
        super(PathHierarchyTokenizerV2, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PathHierarchyTokenizerV2'  # type: str
        self.delimiter = delimiter
        self.replacement = replacement
        self.max_token_length = max_token_length
        self.reverse_token_order = reverse_token_order
        self.number_of_tokens_to_skip = number_of_tokens_to_skip


class PatternAnalyzer(LexicalAnalyzer):
    """Flexibly separates text into terms via a regular expression pattern. This analyzer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param lower_case_terms: A value indicating whether terms should be lower-cased. Default is
     true.
    :type lower_case_terms: bool
    :param pattern: A regular expression pattern to match token separators. Default is an
     expression that matches one or more non-word characters.
    :type pattern: str
    :param flags: Regular expression flags. Possible values include: "CANON_EQ",
     "CASE_INSENSITIVE", "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
    :type flags: str or ~azure.search.documents.indexes.models.RegexFlags
    :param stopwords: A list of stopwords.
    :type stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'lower_case_terms': {'key': 'lowercase', 'type': 'bool'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        lower_case_terms: Optional[bool] = True,
        pattern: Optional[str] = "\W+",
        flags: Optional[Union[str, "RegexFlags"]] = None,
        stopwords: Optional[List[str]] = None,
        **kwargs
    ):
        super(PatternAnalyzer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternAnalyzer'  # type: str
        self.lower_case_terms = lower_case_terms
        self.pattern = pattern
        self.flags = flags
        self.stopwords = stopwords


class PatternCaptureTokenFilter(TokenFilter):
    """Uses Java regexes to emit multiple tokens - one for each capture group in one or more patterns. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param patterns: Required. A list of patterns to match against each token.
    :type patterns: list[str]
    :param preserve_original: A value indicating whether to return the original token even if one
     of the patterns matches. Default is true.
    :type preserve_original: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'patterns': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'patterns': {'key': 'patterns', 'type': '[str]'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        patterns: List[str],
        preserve_original: Optional[bool] = True,
        **kwargs
    ):
        super(PatternCaptureTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternCaptureTokenFilter'  # type: str
        self.patterns = patterns
        self.preserve_original = preserve_original


class PatternReplaceCharFilter(CharFilter):
    """A character filter that replaces characters in the input string. It uses a regular expression to identify character sequences to preserve and a replacement pattern to identify characters to replace. For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be "aa#bb aa#bb". This character filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param pattern: Required. A regular expression pattern.
    :type pattern: str
    :param replacement: Required. The replacement text.
    :type replacement: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'pattern': {'required': True},
        'replacement': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        pattern: str,
        replacement: str,
        **kwargs
    ):
        super(PatternReplaceCharFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternReplaceCharFilter'  # type: str
        self.pattern = pattern
        self.replacement = replacement


class PatternReplaceTokenFilter(TokenFilter):
    """A character filter that replaces characters in the input string. It uses a regular expression to identify character sequences to preserve and a replacement pattern to identify characters to replace. For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be "aa#bb aa#bb". This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param pattern: Required. A regular expression pattern.
    :type pattern: str
    :param replacement: Required. The replacement text.
    :type replacement: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'pattern': {'required': True},
        'replacement': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        pattern: str,
        replacement: str,
        **kwargs
    ):
        super(PatternReplaceTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternReplaceTokenFilter'  # type: str
        self.pattern = pattern
        self.replacement = replacement


class PatternTokenizer(LexicalTokenizer):
    """Tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param pattern: A regular expression pattern to match token separators. Default is an
     expression that matches one or more non-word characters.
    :type pattern: str
    :param flags: Regular expression flags. Possible values include: "CANON_EQ",
     "CASE_INSENSITIVE", "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
    :type flags: str or ~azure.search.documents.indexes.models.RegexFlags
    :param group: The zero-based ordinal of the matching group in the regular expression pattern to
     extract into tokens. Use -1 if you want to use the entire pattern to split the input into
     tokens, irrespective of matching groups. Default is -1.
    :type group: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'str'},
        'group': {'key': 'group', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        pattern: Optional[str] = "\W+",
        flags: Optional[Union[str, "RegexFlags"]] = None,
        group: Optional[int] = -1,
        **kwargs
    ):
        super(PatternTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternTokenizer'  # type: str
        self.pattern = pattern
        self.flags = flags
        self.group = group


class PhoneticTokenFilter(TokenFilter):
    """Create tokens for phonetic matches. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param encoder: The phonetic encoder to use. Default is "metaphone". Possible values include:
     "metaphone", "doubleMetaphone", "soundex", "refinedSoundex", "caverphone1", "caverphone2",
     "cologne", "nysiis", "koelnerPhonetik", "haasePhonetik", "beiderMorse".
    :type encoder: str or ~azure.search.documents.indexes.models.PhoneticEncoder
    :param replace_original_tokens: A value indicating whether encoded tokens should replace
     original tokens. If false, encoded tokens are added as synonyms. Default is true.
    :type replace_original_tokens: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'encoder': {'key': 'encoder', 'type': 'str'},
        'replace_original_tokens': {'key': 'replace', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        encoder: Optional[Union[str, "PhoneticEncoder"]] = None,
        replace_original_tokens: Optional[bool] = True,
        **kwargs
    ):
        super(PhoneticTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PhoneticTokenFilter'  # type: str
        self.encoder = encoder
        self.replace_original_tokens = replace_original_tokens


class PIIDetectionSkill(SearchIndexerSkill):
    """Using the Text Analytics API, extracts personal information from an input text and gives you the option of masking it.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
    :type default_language_code: str
    :param minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :type minimum_precision: float
    :param masking_mode: A parameter that provides various ways to mask the personal information
     detected in the input text. Default is 'none'. Possible values include: "none", "replace".
    :type masking_mode: str or ~azure.search.documents.indexes.models.PIIDetectionSkillMaskingMode
    :param masking_character: The character used to mask the text if the maskingMode parameter is
     set to replace. Default is '*'.
    :type masking_character: str
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    :param pii_categories: A list of PII entity categories that should be extracted and masked.
    :type pii_categories: list[str]
    :param domain: If specified, will set the PII domain to include only a subset of the entity
     categories. Possible values include: 'phi', 'none'. Default is 'none'.
    :type domain: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
        'masking_character': {'max_length': 1, 'min_length': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'masking_mode': {'key': 'maskingMode', 'type': 'str'},
        'masking_character': {'key': 'maskingCharacter', 'type': 'str'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'pii_categories': {'key': 'piiCategories', 'type': '[str]'},
        'domain': {'key': 'domain', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        masking_mode: Optional[Union[str, "PIIDetectionSkillMaskingMode"]] = None,
        masking_character: Optional[str] = None,
        model_version: Optional[str] = None,
        pii_categories: Optional[List[str]] = None,
        domain: Optional[str] = None,
        **kwargs
    ):
        super(PIIDetectionSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.PIIDetectionSkill'  # type: str
        self.default_language_code = default_language_code
        self.minimum_precision = minimum_precision
        self.masking_mode = masking_mode
        self.masking_character = masking_character
        self.model_version = model_version
        self.pii_categories = pii_categories
        self.domain = domain


class RequestOptions(msrest.serialization.Model):
    """Parameter group.

    :param x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :type x_ms_client_request_id: str
    """

    _attribute_map = {
        'x_ms_client_request_id': {'key': 'x-ms-client-request-id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        x_ms_client_request_id: Optional[str] = None,
        **kwargs
    ):
        super(RequestOptions, self).__init__(**kwargs)
        self.x_ms_client_request_id = x_ms_client_request_id


class ResourceCounter(msrest.serialization.Model):
    """Represents a resource's usage and quota.

    All required parameters must be populated in order to send to Azure.

    :param usage: Required. The resource usage amount.
    :type usage: long
    :param quota: The resource amount quota.
    :type quota: long
    """

    _validation = {
        'usage': {'required': True},
    }

    _attribute_map = {
        'usage': {'key': 'usage', 'type': 'long'},
        'quota': {'key': 'quota', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        usage: int,
        quota: Optional[int] = None,
        **kwargs
    ):
        super(ResourceCounter, self).__init__(**kwargs)
        self.usage = usage
        self.quota = quota


class ScoringProfile(msrest.serialization.Model):
    """Defines parameters for a search index that influence scoring in search queries.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the scoring profile.
    :type name: str
    :param text_weights: Parameters that boost scoring based on text matches in certain index
     fields.
    :type text_weights: ~azure.search.documents.indexes.models.TextWeights
    :param functions: The collection of functions that influence the scoring of documents.
    :type functions: list[~azure.search.documents.indexes.models.ScoringFunction]
    :param function_aggregation: A value indicating how the results of individual scoring functions
     should be combined. Defaults to "Sum". Ignored if there are no scoring functions. Possible
     values include: "sum", "average", "minimum", "maximum", "firstMatching".
    :type function_aggregation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionAggregation
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'text_weights': {'key': 'text', 'type': 'TextWeights'},
        'functions': {'key': 'functions', 'type': '[ScoringFunction]'},
        'function_aggregation': {'key': 'functionAggregation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        text_weights: Optional["TextWeights"] = None,
        functions: Optional[List["ScoringFunction"]] = None,
        function_aggregation: Optional[Union[str, "ScoringFunctionAggregation"]] = None,
        **kwargs
    ):
        super(ScoringProfile, self).__init__(**kwargs)
        self.name = name
        self.text_weights = text_weights
        self.functions = functions
        self.function_aggregation = function_aggregation


class SearchError(msrest.serialization.Model):
    """Describes an error condition for the Azure Cognitive Search API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.search.documents.indexes.models.SearchError]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'required': True, 'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[SearchError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class SearchField(msrest.serialization.Model):
    """Represents a field in an index definition, which describes the name, data type, and search behavior of a field.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the field, which must be unique within the fields collection
     of the index or parent field.
    :type name: str
    :param type: Required. The data type of the field. Possible values include: "Edm.String",
     "Edm.Int32", "Edm.Int64", "Edm.Double", "Edm.Boolean", "Edm.DateTimeOffset",
     "Edm.GeographyPoint", "Edm.ComplexType".
    :type type: str or ~azure.search.documents.indexes.models.SearchFieldDataType
    :param key: A value indicating whether the field uniquely identifies documents in the index.
     Exactly one top-level field in each index must be chosen as the key field and it must be of
     type Edm.String. Key fields can be used to look up documents directly and update or delete
     specific documents. Default is false for simple fields and null for complex fields.
    :type key: bool
    :param retrievable: A value indicating whether the field can be returned in a search result.
     You can disable this option if you want to use a field (for example, margin) as a filter,
     sorting, or scoring mechanism but do not want the field to be visible to the end user. This
     property must be true for key fields, and it must be null for complex fields. This property can
     be changed on existing fields. Enabling this property does not cause any increase in index
     storage requirements. Default is true for simple fields and null for complex fields.
    :type retrievable: bool
    :param searchable: A value indicating whether the field is full-text searchable. This means it
     will undergo analysis such as word-breaking during indexing. If you set a searchable field to a
     value like "sunny day", internally it will be split into the individual tokens "sunny" and
     "day". This enables full-text searches for these terms. Fields of type Edm.String or
     Collection(Edm.String) are searchable by default. This property must be false for simple fields
     of other non-string data types, and it must be null for complex fields. Note: searchable fields
     consume extra space in your index since Azure Cognitive Search will store an additional
     tokenized version of the field value for full-text searches. If you want to save space in your
     index and you don't need a field to be included in searches, set searchable to false.
    :type searchable: bool
    :param filterable: A value indicating whether to enable the field to be referenced in $filter
     queries. filterable differs from searchable in how strings are handled. Fields of type
     Edm.String or Collection(Edm.String) that are filterable do not undergo word-breaking, so
     comparisons are for exact matches only. For example, if you set such a field f to "sunny day",
     $filter=f eq 'sunny' will find no matches, but $filter=f eq 'sunny day' will. This property
     must be null for complex fields. Default is true for simple fields and null for complex fields.
    :type filterable: bool
    :param sortable: A value indicating whether to enable the field to be referenced in $orderby
     expressions. By default Azure Cognitive Search sorts results by score, but in many experiences
     users will want to sort by fields in the documents. A simple field can be sortable only if it
     is single-valued (it has a single value in the scope of the parent document). Simple collection
     fields cannot be sortable, since they are multi-valued. Simple sub-fields of complex
     collections are also multi-valued, and therefore cannot be sortable. This is true whether it's
     an immediate parent field, or an ancestor field, that's the complex collection. Complex fields
     cannot be sortable and the sortable property must be null for such fields. The default for
     sortable is true for single-valued simple fields, false for multi-valued simple fields, and
     null for complex fields.
    :type sortable: bool
    :param facetable: A value indicating whether to enable the field to be referenced in facet
     queries. Typically used in a presentation of search results that includes hit count by category
     (for example, search for digital cameras and see hits by brand, by megapixels, by price, and so
     on). This property must be null for complex fields. Fields of type Edm.GeographyPoint or
     Collection(Edm.GeographyPoint) cannot be facetable. Default is true for all other simple
     fields.
    :type facetable: bool
    :param analyzer: The name of the analyzer to use for the field. This option can be used only
     with searchable fields and it can't be set together with either searchAnalyzer or
     indexAnalyzer. Once the analyzer is chosen, it cannot be changed for the field. Must be null
     for complex fields. Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene",
     "bn.microsoft", "eu.lucene", "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene",
     "zh-Hans.microsoft", "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft",
     "cs.microsoft", "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene",
     "en.microsoft", "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft",
     "fr.lucene", "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene",
     "gu.microsoft", "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene",
     "is.microsoft", "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene",
     "ja.microsoft", "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft",
     "lv.lucene", "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft",
     "no.lucene", "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene",
     "pt-PT.microsoft", "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft",
     "ru.lucene", "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft",
     "es.microsoft", "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft",
     "th.microsoft", "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft",
     "vi.microsoft", "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern",
     "simple", "stop", "whitespace".
    :type analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :param search_analyzer: The name of the analyzer used at search time for the field. This option
     can be used only with searchable fields. It must be set together with indexAnalyzer and it
     cannot be set together with the analyzer option. This property cannot be set to the name of a
     language analyzer; use the analyzer property instead if you need a language analyzer. This
     analyzer can be updated on an existing field. Must be null for complex fields. Possible values
     include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
     "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
     "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
     "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
     "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
     "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
     "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
     "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
     "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
     "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
     "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :type search_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :param index_analyzer: The name of the analyzer used at indexing time for the field. This
     option can be used only with searchable fields. It must be set together with searchAnalyzer and
     it cannot be set together with the analyzer option.  This property cannot be set to the name of
     a language analyzer; use the analyzer property instead if you need a language analyzer. Once
     the analyzer is chosen, it cannot be changed for the field. Must be null for complex fields.
     Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene",
     "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft",
     "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft",
     "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft",
     "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene",
     "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft",
     "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft",
     "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft",
     "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene",
     "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene",
     "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :type index_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :param normalizer: The name of the normalizer to use for the field. This option can be used
     only with fields with filterable, sortable, or facetable enabled. Once the normalizer is
     chosen, it cannot be changed for the field. Must be null for complex fields. Possible values
     include: "asciifolding", "elision", "lowercase", "standard", "uppercase".
    :type normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :param synonym_maps: A list of the names of synonym maps to associate with this field. This
     option can be used only with searchable fields. Currently only one synonym map per field is
     supported. Assigning a synonym map to a field ensures that query terms targeting that field are
     expanded at query-time using the rules in the synonym map. This attribute can be changed on
     existing fields. Must be null or an empty collection for complex fields.
    :type synonym_maps: list[str]
    :param fields: A list of sub-fields if this is a field of type Edm.ComplexType or
     Collection(Edm.ComplexType). Must be null or empty for simple fields.
    :type fields: list[~azure.search.documents.indexes.models.SearchField]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'key', 'type': 'bool'},
        'retrievable': {'key': 'retrievable', 'type': 'bool'},
        'searchable': {'key': 'searchable', 'type': 'bool'},
        'filterable': {'key': 'filterable', 'type': 'bool'},
        'sortable': {'key': 'sortable', 'type': 'bool'},
        'facetable': {'key': 'facetable', 'type': 'bool'},
        'analyzer': {'key': 'analyzer', 'type': 'str'},
        'search_analyzer': {'key': 'searchAnalyzer', 'type': 'str'},
        'index_analyzer': {'key': 'indexAnalyzer', 'type': 'str'},
        'normalizer': {'key': 'normalizer', 'type': 'str'},
        'synonym_maps': {'key': 'synonymMaps', 'type': '[str]'},
        'fields': {'key': 'fields', 'type': '[SearchField]'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "SearchFieldDataType"],
        key: Optional[bool] = None,
        retrievable: Optional[bool] = None,
        searchable: Optional[bool] = None,
        filterable: Optional[bool] = None,
        sortable: Optional[bool] = None,
        facetable: Optional[bool] = None,
        analyzer: Optional[Union[str, "LexicalAnalyzerName"]] = None,
        search_analyzer: Optional[Union[str, "LexicalAnalyzerName"]] = None,
        index_analyzer: Optional[Union[str, "LexicalAnalyzerName"]] = None,
        normalizer: Optional[Union[str, "LexicalNormalizerName"]] = None,
        synonym_maps: Optional[List[str]] = None,
        fields: Optional[List["SearchField"]] = None,
        **kwargs
    ):
        super(SearchField, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.key = key
        self.retrievable = retrievable
        self.searchable = searchable
        self.filterable = filterable
        self.sortable = sortable
        self.facetable = facetable
        self.analyzer = analyzer
        self.search_analyzer = search_analyzer
        self.index_analyzer = index_analyzer
        self.normalizer = normalizer
        self.synonym_maps = synonym_maps
        self.fields = fields


class SearchIndex(msrest.serialization.Model):
    """Represents a search index definition, which describes the fields and search behavior of an index.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the index.
    :type name: str
    :param fields: Required. The fields of the index.
    :type fields: list[~azure.search.documents.indexes.models.SearchField]
    :param scoring_profiles: The scoring profiles for the index.
    :type scoring_profiles: list[~azure.search.documents.indexes.models.ScoringProfile]
    :param default_scoring_profile: The name of the scoring profile to use if none is specified in
     the query. If this property is not set and no scoring profile is specified in the query, then
     default scoring (tf-idf) will be used.
    :type default_scoring_profile: str
    :param cors_options: Options to control Cross-Origin Resource Sharing (CORS) for the index.
    :type cors_options: ~azure.search.documents.indexes.models.CorsOptions
    :param suggesters: The suggesters for the index.
    :type suggesters: list[~azure.search.documents.indexes.models.Suggester]
    :param analyzers: The analyzers for the index.
    :type analyzers: list[~azure.search.documents.indexes.models.LexicalAnalyzer]
    :param tokenizers: The tokenizers for the index.
    :type tokenizers: list[~azure.search.documents.indexes.models.LexicalTokenizer]
    :param token_filters: The token filters for the index.
    :type token_filters: list[~azure.search.documents.indexes.models.TokenFilter]
    :param char_filters: The character filters for the index.
    :type char_filters: list[~azure.search.documents.indexes.models.CharFilter]
    :param normalizers: The normalizers for the index.
    :type normalizers: list[~azure.search.documents.indexes.models.LexicalNormalizer]
    :param encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
     Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
     Search will ignore attempts to set this property to null. You can change this property as
     needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
     customer-managed keys is not available for free search services, and is only available for paid
     services created on or after January 1, 2019.
    :type encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :param similarity: The type of similarity algorithm to be used when scoring and ranking the
     documents matching a search query. The similarity algorithm can only be defined at index
     creation time and cannot be modified on existing indexes. If null, the ClassicSimilarity
     algorithm is used.
    :type similarity: ~azure.search.documents.indexes.models.Similarity
    :param e_tag: The ETag of the index.
    :type e_tag: str
    """

    _validation = {
        'name': {'required': True},
        'fields': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'fields': {'key': 'fields', 'type': '[SearchField]'},
        'scoring_profiles': {'key': 'scoringProfiles', 'type': '[ScoringProfile]'},
        'default_scoring_profile': {'key': 'defaultScoringProfile', 'type': 'str'},
        'cors_options': {'key': 'corsOptions', 'type': 'CorsOptions'},
        'suggesters': {'key': 'suggesters', 'type': '[Suggester]'},
        'analyzers': {'key': 'analyzers', 'type': '[LexicalAnalyzer]'},
        'tokenizers': {'key': 'tokenizers', 'type': '[LexicalTokenizer]'},
        'token_filters': {'key': 'tokenFilters', 'type': '[TokenFilter]'},
        'char_filters': {'key': 'charFilters', 'type': '[CharFilter]'},
        'normalizers': {'key': 'normalizers', 'type': '[LexicalNormalizer]'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'similarity': {'key': 'similarity', 'type': 'Similarity'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        fields: List["SearchField"],
        scoring_profiles: Optional[List["ScoringProfile"]] = None,
        default_scoring_profile: Optional[str] = None,
        cors_options: Optional["CorsOptions"] = None,
        suggesters: Optional[List["Suggester"]] = None,
        analyzers: Optional[List["LexicalAnalyzer"]] = None,
        tokenizers: Optional[List["LexicalTokenizer"]] = None,
        token_filters: Optional[List["TokenFilter"]] = None,
        char_filters: Optional[List["CharFilter"]] = None,
        normalizers: Optional[List["LexicalNormalizer"]] = None,
        encryption_key: Optional["SearchResourceEncryptionKey"] = None,
        similarity: Optional["Similarity"] = None,
        e_tag: Optional[str] = None,
        **kwargs
    ):
        super(SearchIndex, self).__init__(**kwargs)
        self.name = name
        self.fields = fields
        self.scoring_profiles = scoring_profiles
        self.default_scoring_profile = default_scoring_profile
        self.cors_options = cors_options
        self.suggesters = suggesters
        self.analyzers = analyzers
        self.tokenizers = tokenizers
        self.token_filters = token_filters
        self.char_filters = char_filters
        self.normalizers = normalizers
        self.encryption_key = encryption_key
        self.similarity = similarity
        self.e_tag = e_tag


class SearchIndexer(msrest.serialization.Model):
    """Represents an indexer.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the indexer.
    :type name: str
    :param description: The description of the indexer.
    :type description: str
    :param data_source_name: Required. The name of the datasource from which this indexer reads
     data.
    :type data_source_name: str
    :param skillset_name: The name of the skillset executing with this indexer.
    :type skillset_name: str
    :param target_index_name: Required. The name of the index to which this indexer writes data.
    :type target_index_name: str
    :param schedule: The schedule for this indexer.
    :type schedule: ~azure.search.documents.indexes.models.IndexingSchedule
    :param parameters: Parameters for indexer execution.
    :type parameters: ~azure.search.documents.indexes.models.IndexingParameters
    :param field_mappings: Defines mappings between fields in the data source and corresponding
     target fields in the index.
    :type field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :param output_field_mappings: Output field mappings are applied after enrichment and
     immediately before indexing.
    :type output_field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :param is_disabled: A value indicating whether the indexer is disabled. Default is false.
    :type is_disabled: bool
    :param e_tag: The ETag of the indexer.
    :type e_tag: str
    :param encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your indexer
     definition (as well as indexer execution status) when you want full assurance that no one, not
     even Microsoft, can decrypt them in Azure Cognitive Search. Once you have encrypted your
     indexer definition, it will always remain encrypted. Azure Cognitive Search will ignore
     attempts to set this property to null. You can change this property as needed if you want to
     rotate your encryption key; Your indexer definition (and indexer execution status) will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :type encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :param cache: Adds caching to an enrichment pipeline to allow for incremental modification
     steps without having to rebuild the index every time.
    :type cache: ~azure.search.documents.indexes.models.SearchIndexerCache
    """

    _validation = {
        'name': {'required': True},
        'data_source_name': {'required': True},
        'target_index_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_source_name': {'key': 'dataSourceName', 'type': 'str'},
        'skillset_name': {'key': 'skillsetName', 'type': 'str'},
        'target_index_name': {'key': 'targetIndexName', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'IndexingSchedule'},
        'parameters': {'key': 'parameters', 'type': 'IndexingParameters'},
        'field_mappings': {'key': 'fieldMappings', 'type': '[FieldMapping]'},
        'output_field_mappings': {'key': 'outputFieldMappings', 'type': '[FieldMapping]'},
        'is_disabled': {'key': 'disabled', 'type': 'bool'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'cache': {'key': 'cache', 'type': 'SearchIndexerCache'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_source_name: str,
        target_index_name: str,
        description: Optional[str] = None,
        skillset_name: Optional[str] = None,
        schedule: Optional["IndexingSchedule"] = None,
        parameters: Optional["IndexingParameters"] = None,
        field_mappings: Optional[List["FieldMapping"]] = None,
        output_field_mappings: Optional[List["FieldMapping"]] = None,
        is_disabled: Optional[bool] = False,
        e_tag: Optional[str] = None,
        encryption_key: Optional["SearchResourceEncryptionKey"] = None,
        cache: Optional["SearchIndexerCache"] = None,
        **kwargs
    ):
        super(SearchIndexer, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.data_source_name = data_source_name
        self.skillset_name = skillset_name
        self.target_index_name = target_index_name
        self.schedule = schedule
        self.parameters = parameters
        self.field_mappings = field_mappings
        self.output_field_mappings = output_field_mappings
        self.is_disabled = is_disabled
        self.e_tag = e_tag
        self.encryption_key = encryption_key
        self.cache = cache


class SearchIndexerCache(msrest.serialization.Model):
    """SearchIndexerCache.

    :param storage_connection_string: The connection string to the storage account where the cache
     data will be persisted.
    :type storage_connection_string: str
    :param enable_reprocessing: Specifies whether incremental reprocessing is enabled.
    :type enable_reprocessing: bool
    """

    _attribute_map = {
        'storage_connection_string': {'key': 'storageConnectionString', 'type': 'str'},
        'enable_reprocessing': {'key': 'enableReprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        storage_connection_string: Optional[str] = None,
        enable_reprocessing: Optional[bool] = None,
        **kwargs
    ):
        super(SearchIndexerCache, self).__init__(**kwargs)
        self.storage_connection_string = storage_connection_string
        self.enable_reprocessing = enable_reprocessing


class SearchIndexerDataContainer(msrest.serialization.Model):
    """Represents information about the entity (such as Azure SQL table or CosmosDB collection) that will be indexed.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the table or view (for Azure SQL data source) or collection
     (for CosmosDB data source) that will be indexed.
    :type name: str
    :param query: A query that is applied to this data container. The syntax and meaning of this
     parameter is datasource-specific. Not supported by Azure SQL datasources.
    :type query: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        query: Optional[str] = None,
        **kwargs
    ):
        super(SearchIndexerDataContainer, self).__init__(**kwargs)
        self.name = name
        self.query = query


class SearchIndexerDataIdentity(msrest.serialization.Model):
    """Abstract base type for data identities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchIndexerDataNoneIdentity, SearchIndexerDataUserAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.SearchIndexerDataNoneIdentity': 'SearchIndexerDataNoneIdentity', '#Microsoft.Azure.Search.SearchIndexerDataUserAssignedIdentity': 'SearchIndexerDataUserAssignedIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerDataIdentity, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class SearchIndexerDataNoneIdentity(SearchIndexerDataIdentity):
    """Clears the identity property of a datasource.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerDataNoneIdentity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SearchIndexerDataNoneIdentity'  # type: str


class SearchIndexerDataSource(msrest.serialization.Model):
    """Represents a datasource definition, which can be used to configure an indexer.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the datasource.
    :type name: str
    :param description: The description of the datasource.
    :type description: str
    :param type: Required. The type of the datasource. Possible values include: "azuresql",
     "cosmosdb", "azureblob", "azuretable", "mysql", "adlsgen2".
    :type type: str or ~azure.search.documents.indexes.models.SearchIndexerDataSourceType
    :param credentials: Required. Credentials for the datasource.
    :type credentials: ~azure.search.documents.indexes.models.DataSourceCredentials
    :param container: Required. The data container for the datasource.
    :type container: ~azure.search.documents.indexes.models.SearchIndexerDataContainer
    :param identity: An explicit managed identity to use for this datasource. If not specified and
     the connection string is a managed identity, the system-assigned managed identity is used. If
     not specified, the value remains unchanged. If "none" is specified, the value of this property
     is cleared.
    :type identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :param data_change_detection_policy: The data change detection policy for the datasource.
    :type data_change_detection_policy:
     ~azure.search.documents.indexes.models.DataChangeDetectionPolicy
    :param data_deletion_detection_policy: The data deletion detection policy for the datasource.
    :type data_deletion_detection_policy:
     ~azure.search.documents.indexes.models.DataDeletionDetectionPolicy
    :param e_tag: The ETag of the data source.
    :type e_tag: str
    :param encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your datasource
     definition when you want full assurance that no one, not even Microsoft, can decrypt your data
     source definition in Azure Cognitive Search. Once you have encrypted your data source
     definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
     this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your datasource definition will be unaffected. Encryption with customer-managed
     keys is not available for free search services, and is only available for paid services created
     on or after January 1, 2019.
    :type encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'credentials': {'required': True},
        'container': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'DataSourceCredentials'},
        'container': {'key': 'container', 'type': 'SearchIndexerDataContainer'},
        'identity': {'key': 'identity', 'type': 'SearchIndexerDataIdentity'},
        'data_change_detection_policy': {'key': 'dataChangeDetectionPolicy', 'type': 'DataChangeDetectionPolicy'},
        'data_deletion_detection_policy': {'key': 'dataDeletionDetectionPolicy', 'type': 'DataDeletionDetectionPolicy'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "SearchIndexerDataSourceType"],
        credentials: "DataSourceCredentials",
        container: "SearchIndexerDataContainer",
        description: Optional[str] = None,
        identity: Optional["SearchIndexerDataIdentity"] = None,
        data_change_detection_policy: Optional["DataChangeDetectionPolicy"] = None,
        data_deletion_detection_policy: Optional["DataDeletionDetectionPolicy"] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["SearchResourceEncryptionKey"] = None,
        **kwargs
    ):
        super(SearchIndexerDataSource, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.type = type
        self.credentials = credentials
        self.container = container
        self.identity = identity
        self.data_change_detection_policy = data_change_detection_policy
        self.data_deletion_detection_policy = data_deletion_detection_policy
        self.e_tag = e_tag
        self.encryption_key = encryption_key


class SearchIndexerDataUserAssignedIdentity(SearchIndexerDataIdentity):
    """Specifies the identity for a datasource to use.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :type odata_type: str
    :param user_assigned_identity: Required. The fully qualified Azure resource Id of a user
     assigned managed identity typically in the form
     "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
     that should have been assigned to the search service.
    :type user_assigned_identity: str
    """

    _validation = {
        'odata_type': {'required': True},
        'user_assigned_identity': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: str,
        **kwargs
    ):
        super(SearchIndexerDataUserAssignedIdentity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SearchIndexerDataUserAssignedIdentity'  # type: str
        self.user_assigned_identity = user_assigned_identity


class SearchIndexerError(msrest.serialization.Model):
    """Represents an item- or document-level indexing error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The key of the item for which indexing failed.
    :vartype key: str
    :ivar error_message: Required. The message describing the error that occurred while processing
     the item.
    :vartype error_message: str
    :ivar status_code: Required. The status code indicating why the indexing operation failed.
     Possible values include: 400 for a malformed input document, 404 for document not found, 409
     for a version conflict, 422 when the index is temporarily unavailable, or 503 for when the
     service is too busy.
    :vartype status_code: int
    :ivar name: The name of the source at which the error originated. For example, this could refer
     to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the error to assist in debugging the indexer.
     This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of errors. This
     may not be always available.
    :vartype documentation_link: str
    """

    _validation = {
        'key': {'readonly': True},
        'error_message': {'required': True, 'readonly': True},
        'status_code': {'required': True, 'readonly': True},
        'name': {'readonly': True},
        'details': {'readonly': True},
        'documentation_link': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'documentation_link': {'key': 'documentationLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerError, self).__init__(**kwargs)
        self.key = None
        self.error_message = None
        self.status_code = None
        self.name = None
        self.details = None
        self.documentation_link = None


class SearchIndexerKnowledgeStore(msrest.serialization.Model):
    """Definition of additional projections to azure blob, table, or files, of enriched data.

    All required parameters must be populated in order to send to Azure.

    :param storage_connection_string: Required. The connection string to the storage account
     projections will be stored in.
    :type storage_connection_string: str
    :param projections: Required. A list of additional projections to perform during indexing.
    :type projections:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjection]
    """

    _validation = {
        'storage_connection_string': {'required': True},
        'projections': {'required': True},
    }

    _attribute_map = {
        'storage_connection_string': {'key': 'storageConnectionString', 'type': 'str'},
        'projections': {'key': 'projections', 'type': '[SearchIndexerKnowledgeStoreProjection]'},
    }

    def __init__(
        self,
        *,
        storage_connection_string: str,
        projections: List["SearchIndexerKnowledgeStoreProjection"],
        **kwargs
    ):
        super(SearchIndexerKnowledgeStore, self).__init__(**kwargs)
        self.storage_connection_string = storage_connection_string
        self.projections = projections


class SearchIndexerKnowledgeStoreProjectionSelector(msrest.serialization.Model):
    """Abstract class to share properties between concrete selectors.

    :param reference_key_name: Name of reference key to different projection.
    :type reference_key_name: str
    :param generated_key_name: Name of generated key to store projection under.
    :type generated_key_name: str
    :param source: Source data to project.
    :type source: str
    :param source_context: Source context for complex projections.
    :type source_context: str
    :param inputs: Nested inputs for complex projections.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
    }

    def __init__(
        self,
        *,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreProjectionSelector, self).__init__(**kwargs)
        self.reference_key_name = reference_key_name
        self.generated_key_name = generated_key_name
        self.source = source
        self.source_context = source_context
        self.inputs = inputs


class SearchIndexerKnowledgeStoreBlobProjectionSelector(SearchIndexerKnowledgeStoreProjectionSelector):
    """Abstract class to share properties between concrete selectors.

    All required parameters must be populated in order to send to Azure.

    :param reference_key_name: Name of reference key to different projection.
    :type reference_key_name: str
    :param generated_key_name: Name of generated key to store projection under.
    :type generated_key_name: str
    :param source: Source data to project.
    :type source: str
    :param source_context: Source context for complex projections.
    :type source_context: str
    :param inputs: Nested inputs for complex projections.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param storage_container: Required. Blob container to store projections in.
    :type storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreBlobProjectionSelector, self).__init__(reference_key_name=reference_key_name, generated_key_name=generated_key_name, source=source, source_context=source_context, inputs=inputs, **kwargs)
        self.storage_container = storage_container


class SearchIndexerKnowledgeStoreFileProjectionSelector(SearchIndexerKnowledgeStoreBlobProjectionSelector):
    """Projection definition for what data to store in Azure Files.

    All required parameters must be populated in order to send to Azure.

    :param reference_key_name: Name of reference key to different projection.
    :type reference_key_name: str
    :param generated_key_name: Name of generated key to store projection under.
    :type generated_key_name: str
    :param source: Source data to project.
    :type source: str
    :param source_context: Source context for complex projections.
    :type source_context: str
    :param inputs: Nested inputs for complex projections.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param storage_container: Required. Blob container to store projections in.
    :type storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreFileProjectionSelector, self).__init__(reference_key_name=reference_key_name, generated_key_name=generated_key_name, source=source, source_context=source_context, inputs=inputs, storage_container=storage_container, **kwargs)


class SearchIndexerKnowledgeStoreObjectProjectionSelector(SearchIndexerKnowledgeStoreBlobProjectionSelector):
    """Projection definition for what data to store in Azure Blob.

    All required parameters must be populated in order to send to Azure.

    :param reference_key_name: Name of reference key to different projection.
    :type reference_key_name: str
    :param generated_key_name: Name of generated key to store projection under.
    :type generated_key_name: str
    :param source: Source data to project.
    :type source: str
    :param source_context: Source context for complex projections.
    :type source_context: str
    :param inputs: Nested inputs for complex projections.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param storage_container: Required. Blob container to store projections in.
    :type storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreObjectProjectionSelector, self).__init__(reference_key_name=reference_key_name, generated_key_name=generated_key_name, source=source, source_context=source_context, inputs=inputs, storage_container=storage_container, **kwargs)


class SearchIndexerKnowledgeStoreProjection(msrest.serialization.Model):
    """Container object for various projection selectors.

    :param tables: Projections to Azure Table storage.
    :type tables:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreTableProjectionSelector]
    :param objects: Projections to Azure Blob storage.
    :type objects:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreObjectProjectionSelector]
    :param files: Projections to Azure File storage.
    :type files:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreFileProjectionSelector]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SearchIndexerKnowledgeStoreTableProjectionSelector]'},
        'objects': {'key': 'objects', 'type': '[SearchIndexerKnowledgeStoreObjectProjectionSelector]'},
        'files': {'key': 'files', 'type': '[SearchIndexerKnowledgeStoreFileProjectionSelector]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List["SearchIndexerKnowledgeStoreTableProjectionSelector"]] = None,
        objects: Optional[List["SearchIndexerKnowledgeStoreObjectProjectionSelector"]] = None,
        files: Optional[List["SearchIndexerKnowledgeStoreFileProjectionSelector"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreProjection, self).__init__(**kwargs)
        self.tables = tables
        self.objects = objects
        self.files = files


class SearchIndexerKnowledgeStoreTableProjectionSelector(SearchIndexerKnowledgeStoreProjectionSelector):
    """Description for what data to store in Azure Tables.

    All required parameters must be populated in order to send to Azure.

    :param reference_key_name: Name of reference key to different projection.
    :type reference_key_name: str
    :param generated_key_name: Name of generated key to store projection under.
    :type generated_key_name: str
    :param source: Source data to project.
    :type source: str
    :param source_context: Source context for complex projections.
    :type source_context: str
    :param inputs: Nested inputs for complex projections.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param table_name: Required. Name of the Azure table to store projected data in.
    :type table_name: str
    """

    _validation = {
        'table_name': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'table_name': {'key': 'tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        table_name: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[List["InputFieldMappingEntry"]] = None,
        **kwargs
    ):
        super(SearchIndexerKnowledgeStoreTableProjectionSelector, self).__init__(reference_key_name=reference_key_name, generated_key_name=generated_key_name, source=source, source_context=source_context, inputs=inputs, **kwargs)
        self.table_name = table_name


class SearchIndexerLimits(msrest.serialization.Model):
    """SearchIndexerLimits.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max_run_time: The maximum duration that the indexer is permitted to run for one
     execution.
    :vartype max_run_time: ~datetime.timedelta
    :ivar max_document_extraction_size: The maximum size of a document, in bytes, which will be
     considered valid for indexing.
    :vartype max_document_extraction_size: long
    :ivar max_document_content_characters_to_extract: The maximum number of characters that will be
     extracted from a document picked up for indexing.
    :vartype max_document_content_characters_to_extract: long
    """

    _validation = {
        'max_run_time': {'readonly': True},
        'max_document_extraction_size': {'readonly': True},
        'max_document_content_characters_to_extract': {'readonly': True},
    }

    _attribute_map = {
        'max_run_time': {'key': 'maxRunTime', 'type': 'duration'},
        'max_document_extraction_size': {'key': 'maxDocumentExtractionSize', 'type': 'long'},
        'max_document_content_characters_to_extract': {'key': 'maxDocumentContentCharactersToExtract', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerLimits, self).__init__(**kwargs)
        self.max_run_time = None
        self.max_document_extraction_size = None
        self.max_document_content_characters_to_extract = None


class SearchIndexerSkillset(msrest.serialization.Model):
    """A list of skills.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the skillset.
    :type name: str
    :param description: The description of the skillset.
    :type description: str
    :param skills: Required. A list of skills in the skillset.
    :type skills: list[~azure.search.documents.indexes.models.SearchIndexerSkill]
    :param cognitive_services_account: Details about cognitive services to be used when running
     skills.
    :type cognitive_services_account:
     ~azure.search.documents.indexes.models.CognitiveServicesAccount
    :param knowledge_store: Definition of additional projections to azure blob, table, or files, of
     enriched data.
    :type knowledge_store: ~azure.search.documents.indexes.models.SearchIndexerKnowledgeStore
    :param e_tag: The ETag of the skillset.
    :type e_tag: str
    :param encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your skillset
     definition when you want full assurance that no one, not even Microsoft, can decrypt your
     skillset definition in Azure Cognitive Search. Once you have encrypted your skillset
     definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
     this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your skillset definition will be unaffected. Encryption with customer-managed
     keys is not available for free search services, and is only available for paid services created
     on or after January 1, 2019.
    :type encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    _validation = {
        'name': {'required': True},
        'skills': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'skills': {'key': 'skills', 'type': '[SearchIndexerSkill]'},
        'cognitive_services_account': {'key': 'cognitiveServices', 'type': 'CognitiveServicesAccount'},
        'knowledge_store': {'key': 'knowledgeStore', 'type': 'SearchIndexerKnowledgeStore'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
    }

    def __init__(
        self,
        *,
        name: str,
        skills: List["SearchIndexerSkill"],
        description: Optional[str] = None,
        cognitive_services_account: Optional["CognitiveServicesAccount"] = None,
        knowledge_store: Optional["SearchIndexerKnowledgeStore"] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["SearchResourceEncryptionKey"] = None,
        **kwargs
    ):
        super(SearchIndexerSkillset, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.skills = skills
        self.cognitive_services_account = cognitive_services_account
        self.knowledge_store = knowledge_store
        self.e_tag = e_tag
        self.encryption_key = encryption_key


class SearchIndexerStatus(msrest.serialization.Model):
    """Represents the current status and execution history of an indexer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Overall indexer status. Possible values include: "unknown", "error",
     "running".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerStatus
    :ivar last_result: The result of the most recent or an in-progress indexer execution.
    :vartype last_result: ~azure.search.documents.indexes.models.IndexerExecutionResult
    :ivar execution_history: Required. History of the recent indexer executions, sorted in reverse
     chronological order.
    :vartype execution_history: list[~azure.search.documents.indexes.models.IndexerExecutionResult]
    :ivar limits: Required. The execution limits for the indexer.
    :vartype limits: ~azure.search.documents.indexes.models.SearchIndexerLimits
    """

    _validation = {
        'status': {'required': True, 'readonly': True},
        'last_result': {'readonly': True},
        'execution_history': {'required': True, 'readonly': True},
        'limits': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'last_result': {'key': 'lastResult', 'type': 'IndexerExecutionResult'},
        'execution_history': {'key': 'executionHistory', 'type': '[IndexerExecutionResult]'},
        'limits': {'key': 'limits', 'type': 'SearchIndexerLimits'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerStatus, self).__init__(**kwargs)
        self.status = None
        self.last_result = None
        self.execution_history = None
        self.limits = None


class SearchIndexerWarning(msrest.serialization.Model):
    """Represents an item-level warning.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The key of the item which generated a warning.
    :vartype key: str
    :ivar message: Required. The message describing the warning that occurred while processing the
     item.
    :vartype message: str
    :ivar name: The name of the source at which the warning originated. For example, this could
     refer to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the warning to assist in debugging the
     indexer. This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of warnings. This
     may not be always available.
    :vartype documentation_link: str
    """

    _validation = {
        'key': {'readonly': True},
        'message': {'required': True, 'readonly': True},
        'name': {'readonly': True},
        'details': {'readonly': True},
        'documentation_link': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'documentation_link': {'key': 'documentationLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchIndexerWarning, self).__init__(**kwargs)
        self.key = None
        self.message = None
        self.name = None
        self.details = None
        self.documentation_link = None


class SearchResourceEncryptionKey(msrest.serialization.Model):
    """A customer-managed encryption key in Azure Key Vault. Keys that you create and manage can be used to encrypt or decrypt data-at-rest in Azure Cognitive Search, such as indexes and synonym maps.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of your Azure Key Vault key to be used to encrypt your data
     at rest.
    :type key_name: str
    :param key_version: Required. The version of your Azure Key Vault key to be used to encrypt
     your data at rest.
    :type key_version: str
    :param vault_uri: Required. The URI of your Azure Key Vault, also referred to as DNS name, that
     contains the key to be used to encrypt your data at rest. An example URI might be
     https://my-keyvault-name.vault.azure.net.
    :type vault_uri: str
    :param access_credentials: Optional Azure Active Directory credentials used for accessing your
     Azure Key Vault. Not required if using managed identity instead.
    :type access_credentials:
     ~azure.search.documents.indexes.models.AzureActiveDirectoryApplicationCredentials
    :param identity: An explicit managed identity to use for this encryption key. If not specified
     and the access credentials property is null, the system-assigned managed identity is used. On
     update to the resource, if the explicit identity is unspecified, it remains unchanged. If
     "none" is specified, the value of this property is cleared.
    :type identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    _validation = {
        'key_name': {'required': True},
        'key_version': {'required': True},
        'vault_uri': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyVaultKeyName', 'type': 'str'},
        'key_version': {'key': 'keyVaultKeyVersion', 'type': 'str'},
        'vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'access_credentials': {'key': 'accessCredentials', 'type': 'AzureActiveDirectoryApplicationCredentials'},
        'identity': {'key': 'identity', 'type': 'SearchIndexerDataIdentity'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        key_version: str,
        vault_uri: str,
        access_credentials: Optional["AzureActiveDirectoryApplicationCredentials"] = None,
        identity: Optional["SearchIndexerDataIdentity"] = None,
        **kwargs
    ):
        super(SearchResourceEncryptionKey, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.vault_uri = vault_uri
        self.access_credentials = access_credentials
        self.identity = identity


class SentimentSkill(SearchIndexerSkill):
    """Text analytics positive-negative sentiment analysis, scored as a floating point value in a range of zero to 1.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "nl", "en", "fi", "fr", "de", "el", "it", "no", "pl", "pt-PT",
     "ru", "es", "sv", "tr".
    :type default_language_code: str or
     ~azure.search.documents.indexes.models.SentimentSkillLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "SentimentSkillLanguage"]] = None,
        **kwargs
    ):
        super(SentimentSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.SentimentSkill'  # type: str
        self.default_language_code = default_language_code


class SentimentSkillV3(SearchIndexerSkill):
    """Using the Text Analytics API, evaluates unstructured text and for each record, provides sentiment labels (such as "negative", "neutral" and "positive") based on the highest confidence score found by the service at a sentence and document-level.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
    :type default_language_code: str
    :param include_opinion_mining: If set to true, the skill output will include information from
     Text Analytics for opinion mining, namely targets (nouns or verbs) and their associated
     assessment (adjective) in the text. Default is false.
    :type include_opinion_mining: bool
    :param model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :type model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'include_opinion_mining': {'key': 'includeOpinionMining', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        include_opinion_mining: Optional[bool] = False,
        model_version: Optional[str] = None,
        **kwargs
    ):
        super(SentimentSkillV3, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.SentimentSkill'  # type: str
        self.default_language_code = default_language_code
        self.include_opinion_mining = include_opinion_mining
        self.model_version = model_version


class ServiceCounters(msrest.serialization.Model):
    """Represents service-level resource counters and quotas.

    All required parameters must be populated in order to send to Azure.

    :param document_counter: Required. Total number of documents across all indexes in the service.
    :type document_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param index_counter: Required. Total number of indexes.
    :type index_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param indexer_counter: Required. Total number of indexers.
    :type indexer_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param data_source_counter: Required. Total number of data sources.
    :type data_source_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param storage_size_counter: Required. Total size of used storage in bytes.
    :type storage_size_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param synonym_map_counter: Required. Total number of synonym maps.
    :type synonym_map_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :param skillset_counter: Total number of skillsets.
    :type skillset_counter: ~azure.search.documents.indexes.models.ResourceCounter
    """

    _validation = {
        'document_counter': {'required': True},
        'index_counter': {'required': True},
        'indexer_counter': {'required': True},
        'data_source_counter': {'required': True},
        'storage_size_counter': {'required': True},
        'synonym_map_counter': {'required': True},
    }

    _attribute_map = {
        'document_counter': {'key': 'documentCount', 'type': 'ResourceCounter'},
        'index_counter': {'key': 'indexesCount', 'type': 'ResourceCounter'},
        'indexer_counter': {'key': 'indexersCount', 'type': 'ResourceCounter'},
        'data_source_counter': {'key': 'dataSourcesCount', 'type': 'ResourceCounter'},
        'storage_size_counter': {'key': 'storageSize', 'type': 'ResourceCounter'},
        'synonym_map_counter': {'key': 'synonymMaps', 'type': 'ResourceCounter'},
        'skillset_counter': {'key': 'skillsetCount', 'type': 'ResourceCounter'},
    }

    def __init__(
        self,
        *,
        document_counter: "ResourceCounter",
        index_counter: "ResourceCounter",
        indexer_counter: "ResourceCounter",
        data_source_counter: "ResourceCounter",
        storage_size_counter: "ResourceCounter",
        synonym_map_counter: "ResourceCounter",
        skillset_counter: Optional["ResourceCounter"] = None,
        **kwargs
    ):
        super(ServiceCounters, self).__init__(**kwargs)
        self.document_counter = document_counter
        self.index_counter = index_counter
        self.indexer_counter = indexer_counter
        self.data_source_counter = data_source_counter
        self.storage_size_counter = storage_size_counter
        self.synonym_map_counter = synonym_map_counter
        self.skillset_counter = skillset_counter


class ServiceLimits(msrest.serialization.Model):
    """Represents various service level limits.

    :param max_fields_per_index: The maximum allowed fields per index.
    :type max_fields_per_index: int
    :param max_field_nesting_depth_per_index: The maximum depth which you can nest sub-fields in an
     index, including the top-level complex field. For example, a/b/c has a nesting depth of 3.
    :type max_field_nesting_depth_per_index: int
    :param max_complex_collection_fields_per_index: The maximum number of fields of type
     Collection(Edm.ComplexType) allowed in an index.
    :type max_complex_collection_fields_per_index: int
    :param max_complex_objects_in_collections_per_document: The maximum number of objects in
     complex collections allowed per document.
    :type max_complex_objects_in_collections_per_document: int
    """

    _attribute_map = {
        'max_fields_per_index': {'key': 'maxFieldsPerIndex', 'type': 'int'},
        'max_field_nesting_depth_per_index': {'key': 'maxFieldNestingDepthPerIndex', 'type': 'int'},
        'max_complex_collection_fields_per_index': {'key': 'maxComplexCollectionFieldsPerIndex', 'type': 'int'},
        'max_complex_objects_in_collections_per_document': {'key': 'maxComplexObjectsInCollectionsPerDocument', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_fields_per_index: Optional[int] = None,
        max_field_nesting_depth_per_index: Optional[int] = None,
        max_complex_collection_fields_per_index: Optional[int] = None,
        max_complex_objects_in_collections_per_document: Optional[int] = None,
        **kwargs
    ):
        super(ServiceLimits, self).__init__(**kwargs)
        self.max_fields_per_index = max_fields_per_index
        self.max_field_nesting_depth_per_index = max_field_nesting_depth_per_index
        self.max_complex_collection_fields_per_index = max_complex_collection_fields_per_index
        self.max_complex_objects_in_collections_per_document = max_complex_objects_in_collections_per_document


class ServiceStatistics(msrest.serialization.Model):
    """Response from a get service statistics request. If successful, it includes service level counters and limits.

    All required parameters must be populated in order to send to Azure.

    :param counters: Required. Service level resource counters.
    :type counters: ~azure.search.documents.indexes.models.ServiceCounters
    :param limits: Required. Service level general limits.
    :type limits: ~azure.search.documents.indexes.models.ServiceLimits
    """

    _validation = {
        'counters': {'required': True},
        'limits': {'required': True},
    }

    _attribute_map = {
        'counters': {'key': 'counters', 'type': 'ServiceCounters'},
        'limits': {'key': 'limits', 'type': 'ServiceLimits'},
    }

    def __init__(
        self,
        *,
        counters: "ServiceCounters",
        limits: "ServiceLimits",
        **kwargs
    ):
        super(ServiceStatistics, self).__init__(**kwargs)
        self.counters = counters
        self.limits = limits


class ShaperSkill(SearchIndexerSkill):
    """A skill for reshaping the outputs. It creates a complex type to support composite fields (also known as multipart fields).

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        **kwargs
    ):
        super(ShaperSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Util.ShaperSkill'  # type: str


class ShingleTokenFilter(TokenFilter):
    """Creates combinations of tokens as a single token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param max_shingle_size: The maximum shingle size. Default and minimum value is 2.
    :type max_shingle_size: int
    :param min_shingle_size: The minimum shingle size. Default and minimum value is 2. Must be less
     than the value of maxShingleSize.
    :type min_shingle_size: int
    :param output_unigrams: A value indicating whether the output stream will contain the input
     tokens (unigrams) as well as shingles. Default is true.
    :type output_unigrams: bool
    :param output_unigrams_if_no_shingles: A value indicating whether to output unigrams for those
     times when no shingles are available. This property takes precedence when outputUnigrams is set
     to false. Default is false.
    :type output_unigrams_if_no_shingles: bool
    :param token_separator: The string to use when joining adjacent tokens to form a shingle.
     Default is a single space (" ").
    :type token_separator: str
    :param filter_token: The string to insert for each position at which there is no token. Default
     is an underscore ("_").
    :type filter_token: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_shingle_size': {'minimum': 2},
        'min_shingle_size': {'minimum': 2},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_shingle_size': {'key': 'maxShingleSize', 'type': 'int'},
        'min_shingle_size': {'key': 'minShingleSize', 'type': 'int'},
        'output_unigrams': {'key': 'outputUnigrams', 'type': 'bool'},
        'output_unigrams_if_no_shingles': {'key': 'outputUnigramsIfNoShingles', 'type': 'bool'},
        'token_separator': {'key': 'tokenSeparator', 'type': 'str'},
        'filter_token': {'key': 'filterToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_shingle_size: Optional[int] = 2,
        min_shingle_size: Optional[int] = 2,
        output_unigrams: Optional[bool] = True,
        output_unigrams_if_no_shingles: Optional[bool] = False,
        token_separator: Optional[str] = " ",
        filter_token: Optional[str] = "_",
        **kwargs
    ):
        super(ShingleTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ShingleTokenFilter'  # type: str
        self.max_shingle_size = max_shingle_size
        self.min_shingle_size = min_shingle_size
        self.output_unigrams = output_unigrams
        self.output_unigrams_if_no_shingles = output_unigrams_if_no_shingles
        self.token_separator = token_separator
        self.filter_token = filter_token


class SnowballTokenFilter(TokenFilter):
    """A filter that stems words using a Snowball-generated stemmer. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param language: Required. The language to use. Possible values include: "armenian", "basque",
     "catalan", "danish", "dutch", "english", "finnish", "french", "german", "german2", "hungarian",
     "italian", "kp", "lovins", "norwegian", "porter", "portuguese", "romanian", "russian",
     "spanish", "swedish", "turkish".
    :type language: str or ~azure.search.documents.indexes.models.SnowballTokenFilterLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'language': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        language: Union[str, "SnowballTokenFilterLanguage"],
        **kwargs
    ):
        super(SnowballTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SnowballTokenFilter'  # type: str
        self.language = language


class SoftDeleteColumnDeletionDetectionPolicy(DataDeletionDetectionPolicy):
    """Defines a data deletion detection policy that implements a soft-deletion strategy. It determines whether an item should be deleted based on the value of a designated 'soft delete' column.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the data deletion detection
     policy.Constant filled by server.
    :type odata_type: str
    :param soft_delete_column_name: The name of the column to use for soft-deletion detection.
    :type soft_delete_column_name: str
    :param soft_delete_marker_value: The marker value that identifies an item as deleted.
    :type soft_delete_marker_value: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'soft_delete_column_name': {'key': 'softDeleteColumnName', 'type': 'str'},
        'soft_delete_marker_value': {'key': 'softDeleteMarkerValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        soft_delete_column_name: Optional[str] = None,
        soft_delete_marker_value: Optional[str] = None,
        **kwargs
    ):
        super(SoftDeleteColumnDeletionDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy'  # type: str
        self.soft_delete_column_name = soft_delete_column_name
        self.soft_delete_marker_value = soft_delete_marker_value


class SplitSkill(SearchIndexerSkill):
    """A skill to split a string into chunks of text.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
    :type default_language_code: str or ~azure.search.documents.indexes.models.SplitSkillLanguage
    :param text_split_mode: A value indicating which split mode to perform. Possible values
     include: "pages", "sentences".
    :type text_split_mode: str or ~azure.search.documents.indexes.models.TextSplitMode
    :param maximum_page_length: The desired maximum page length. Default is 10000.
    :type maximum_page_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'text_split_mode': {'key': 'textSplitMode', 'type': 'str'},
        'maximum_page_length': {'key': 'maximumPageLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "SplitSkillLanguage"]] = None,
        text_split_mode: Optional[Union[str, "TextSplitMode"]] = None,
        maximum_page_length: Optional[int] = None,
        **kwargs
    ):
        super(SplitSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.SplitSkill'  # type: str
        self.default_language_code = default_language_code
        self.text_split_mode = text_split_mode
        self.maximum_page_length = maximum_page_length


class SqlIntegratedChangeTrackingPolicy(DataChangeDetectionPolicy):
    """Defines a data change detection policy that captures changes using the Integrated Change Tracking feature of Azure SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlIntegratedChangeTrackingPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy'  # type: str


class StemmerOverrideTokenFilter(TokenFilter):
    """Provides the ability to override other stemming filters with custom dictionary-based stemming. Any dictionary-stemmed terms will be marked as keywords so that they will not be stemmed with stemmers down the chain. Must be placed before any stemming filters. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param rules: Required. A list of stemming rules in the following format: "word => stem", for
     example: "ran => run".
    :type rules: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        rules: List[str],
        **kwargs
    ):
        super(StemmerOverrideTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StemmerOverrideTokenFilter'  # type: str
        self.rules = rules


class StemmerTokenFilter(TokenFilter):
    """Language specific stemming filter. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param language: Required. The language to use. Possible values include: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "dutchKp",
     "english", "lightEnglish", "minimalEnglish", "possessiveEnglish", "porter2", "lovins",
     "finnish", "lightFinnish", "french", "lightFrench", "minimalFrench", "galician",
     "minimalGalician", "german", "german2", "lightGerman", "minimalGerman", "greek", "hindi",
     "hungarian", "lightHungarian", "indonesian", "irish", "italian", "lightItalian", "sorani",
     "latvian", "norwegian", "lightNorwegian", "minimalNorwegian", "lightNynorsk", "minimalNynorsk",
     "portuguese", "lightPortuguese", "minimalPortuguese", "portugueseRslp", "romanian", "russian",
     "lightRussian", "spanish", "lightSpanish", "swedish", "lightSwedish", "turkish".
    :type language: str or ~azure.search.documents.indexes.models.StemmerTokenFilterLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'language': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        language: Union[str, "StemmerTokenFilterLanguage"],
        **kwargs
    ):
        super(StemmerTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StemmerTokenFilter'  # type: str
        self.language = language


class StopAnalyzer(LexicalAnalyzer):
    """Divides text at non-letters; Applies the lowercase and stopword token filters. This analyzer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param stopwords: A list of stopwords.
    :type stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        stopwords: Optional[List[str]] = None,
        **kwargs
    ):
        super(StopAnalyzer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StopAnalyzer'  # type: str
        self.stopwords = stopwords


class StopwordsTokenFilter(TokenFilter):
    """Removes stop words from a token stream. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param stopwords: The list of stopwords. This property and the stopwords list property cannot
     both be set.
    :type stopwords: list[str]
    :param stopwords_list: A predefined list of stopwords to use. This property and the stopwords
     property cannot both be set. Default is English. Possible values include: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "english",
     "finnish", "french", "galician", "german", "greek", "hindi", "hungarian", "indonesian",
     "irish", "italian", "latvian", "norwegian", "persian", "portuguese", "romanian", "russian",
     "sorani", "spanish", "swedish", "thai", "turkish".
    :type stopwords_list: str or ~azure.search.documents.indexes.models.StopwordsList
    :param ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :type ignore_case: bool
    :param remove_trailing_stop_words: A value indicating whether to ignore the last search term if
     it's a stop word. Default is true.
    :type remove_trailing_stop_words: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
        'stopwords_list': {'key': 'stopwordsList', 'type': 'str'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'remove_trailing_stop_words': {'key': 'removeTrailing', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        stopwords: Optional[List[str]] = None,
        stopwords_list: Optional[Union[str, "StopwordsList"]] = None,
        ignore_case: Optional[bool] = False,
        remove_trailing_stop_words: Optional[bool] = True,
        **kwargs
    ):
        super(StopwordsTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StopwordsTokenFilter'  # type: str
        self.stopwords = stopwords
        self.stopwords_list = stopwords_list
        self.ignore_case = ignore_case
        self.remove_trailing_stop_words = remove_trailing_stop_words


class Suggester(msrest.serialization.Model):
    """Defines how the Suggest API should apply to a group of fields in the index.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the suggester.
    :type name: str
    :ivar search_mode: A value indicating the capabilities of the suggester. Has constant value:
     "analyzingInfixMatching".
    :vartype search_mode: str
    :param source_fields: Required. The list of field names to which the suggester applies. Each
     field must be searchable.
    :type source_fields: list[str]
    """

    _validation = {
        'name': {'required': True},
        'search_mode': {'required': True, 'constant': True},
        'source_fields': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'search_mode': {'key': 'searchMode', 'type': 'str'},
        'source_fields': {'key': 'sourceFields', 'type': '[str]'},
    }

    search_mode = "analyzingInfixMatching"

    def __init__(
        self,
        *,
        name: str,
        source_fields: List[str],
        **kwargs
    ):
        super(Suggester, self).__init__(**kwargs)
        self.name = name
        self.source_fields = source_fields


class SynonymMap(msrest.serialization.Model):
    """Represents a synonym map definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the synonym map.
    :type name: str
    :ivar format: The format of the synonym map. Only the 'solr' format is currently supported. Has
     constant value: "solr".
    :vartype format: str
    :param synonyms: Required. A series of synonym rules in the specified synonym map format. The
     rules must be separated by newlines.
    :type synonyms: str
    :param encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
     Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
     Search will ignore attempts to set this property to null. You can change this property as
     needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
     customer-managed keys is not available for free search services, and is only available for paid
     services created on or after January 1, 2019.
    :type encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :param e_tag: The ETag of the synonym map.
    :type e_tag: str
    """

    _validation = {
        'name': {'required': True},
        'format': {'required': True, 'constant': True},
        'synonyms': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'synonyms': {'key': 'synonyms', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
    }

    format = "solr"

    def __init__(
        self,
        *,
        name: str,
        synonyms: str,
        encryption_key: Optional["SearchResourceEncryptionKey"] = None,
        e_tag: Optional[str] = None,
        **kwargs
    ):
        super(SynonymMap, self).__init__(**kwargs)
        self.name = name
        self.synonyms = synonyms
        self.encryption_key = encryption_key
        self.e_tag = e_tag


class SynonymTokenFilter(TokenFilter):
    """Matches single or multi-word synonyms in a token stream. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param synonyms: Required. A list of synonyms in following one of two formats: 1. incredible,
     unbelievable, fabulous => amazing - all terms on the left side of => symbol will be replaced
     with all terms on its right side; 2. incredible, unbelievable, fabulous, amazing - comma
     separated list of equivalent words. Set the expand option to change how this list is
     interpreted.
    :type synonyms: list[str]
    :param ignore_case: A value indicating whether to case-fold input for matching. Default is
     false.
    :type ignore_case: bool
    :param expand: A value indicating whether all words in the list of synonyms (if => notation is
     not used) will map to one another. If true, all words in the list of synonyms (if => notation
     is not used) will map to one another. The following list: incredible, unbelievable, fabulous,
     amazing is equivalent to: incredible, unbelievable, fabulous, amazing => incredible,
     unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable,
     fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing =>
     incredible. Default is true.
    :type expand: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'synonyms': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'synonyms': {'key': 'synonyms', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'expand': {'key': 'expand', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        synonyms: List[str],
        ignore_case: Optional[bool] = False,
        expand: Optional[bool] = True,
        **kwargs
    ):
        super(SynonymTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SynonymTokenFilter'  # type: str
        self.synonyms = synonyms
        self.ignore_case = ignore_case
        self.expand = expand


class TagScoringFunction(ScoringFunction):
    """Defines a function that boosts scores of documents with string values matching a given list of tags.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :type type: str
    :param field_name: Required. The name of the field used as input to the scoring function.
    :type field_name: str
    :param boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :type boost: float
    :param interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :type interpolation: str or ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :param parameters: Required. Parameter values for the tag scoring function.
    :type parameters: ~azure.search.documents.indexes.models.TagScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'tag', 'type': 'TagScoringParameters'},
    }

    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "TagScoringParameters",
        interpolation: Optional[Union[str, "ScoringFunctionInterpolation"]] = None,
        **kwargs
    ):
        super(TagScoringFunction, self).__init__(field_name=field_name, boost=boost, interpolation=interpolation, **kwargs)
        self.type = 'tag'  # type: str
        self.parameters = parameters


class TagScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a tag scoring function.

    All required parameters must be populated in order to send to Azure.

    :param tags_parameter: Required. The name of the parameter passed in search queries to specify
     the list of tags to compare against the target field.
    :type tags_parameter: str
    """

    _validation = {
        'tags_parameter': {'required': True},
    }

    _attribute_map = {
        'tags_parameter': {'key': 'tagsParameter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags_parameter: str,
        **kwargs
    ):
        super(TagScoringParameters, self).__init__(**kwargs)
        self.tags_parameter = tags_parameter


class TextTranslationSkill(SearchIndexerSkill):
    """A skill to translate text from one language to another.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param default_to_language_code: Required. The language code to translate documents into for
     documents that don't specify the to language explicitly. Possible values include: "af", "ar",
     "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj",
     "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw",
     "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt",
     "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty",
     "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
    :type default_to_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :param default_from_language_code: The language code to translate documents from for documents
     that don't specify the from language explicitly. Possible values include: "af", "ar", "bn",
     "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj", "fil",
     "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw", "tlh",
     "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt", "pt-br",
     "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty", "ta",
     "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
    :type default_from_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :param suggested_from: The language code to translate documents from when neither the
     fromLanguageCode input nor the defaultFromLanguageCode parameter are provided, and the
     automatic language detection is unsuccessful. Default is en. Possible values include: "af",
     "ar", "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et",
     "fj", "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja",
     "sw", "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl",
     "pt", "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv",
     "ty", "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml",
     "pa".
    :type suggested_from: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'default_to_language_code': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_to_language_code': {'key': 'defaultToLanguageCode', 'type': 'str'},
        'default_from_language_code': {'key': 'defaultFromLanguageCode', 'type': 'str'},
        'suggested_from': {'key': 'suggestedFrom', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        default_to_language_code: Union[str, "TextTranslationSkillLanguage"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_from_language_code: Optional[Union[str, "TextTranslationSkillLanguage"]] = None,
        suggested_from: Optional[Union[str, "TextTranslationSkillLanguage"]] = None,
        **kwargs
    ):
        super(TextTranslationSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Text.TranslationSkill'  # type: str
        self.default_to_language_code = default_to_language_code
        self.default_from_language_code = default_from_language_code
        self.suggested_from = suggested_from


class TextWeights(msrest.serialization.Model):
    """Defines weights on index fields for which matches should boost scoring in search queries.

    All required parameters must be populated in order to send to Azure.

    :param weights: Required. The dictionary of per-field weights to boost document scoring. The
     keys are field names and the values are the weights for each field.
    :type weights: dict[str, float]
    """

    _validation = {
        'weights': {'required': True},
    }

    _attribute_map = {
        'weights': {'key': 'weights', 'type': '{float}'},
    }

    def __init__(
        self,
        *,
        weights: Dict[str, float],
        **kwargs
    ):
        super(TextWeights, self).__init__(**kwargs)
        self.weights = weights


class TruncateTokenFilter(TokenFilter):
    """Truncates the terms to a specific length. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param length: The length at which terms will be truncated. Default and maximum is 300.
    :type length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        length: Optional[int] = 300,
        **kwargs
    ):
        super(TruncateTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.TruncateTokenFilter'  # type: str
        self.length = length


class UaxUrlEmailTokenizer(LexicalTokenizer):
    """Tokenizes urls and emails as one token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :type odata_type: str
    :param name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :type name: str
    :param max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :type max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = 255,
        **kwargs
    ):
        super(UaxUrlEmailTokenizer, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.UaxUrlEmailTokenizer'  # type: str
        self.max_token_length = max_token_length


class UniqueTokenFilter(TokenFilter):
    """Filters out tokens with same text as the previous token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param only_on_same_position: A value indicating whether to remove duplicates only at the same
     position. Default is false.
    :type only_on_same_position: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'only_on_same_position': {'key': 'onlyOnSamePosition', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        only_on_same_position: Optional[bool] = False,
        **kwargs
    ):
        super(UniqueTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.UniqueTokenFilter'  # type: str
        self.only_on_same_position = only_on_same_position


class WebApiSkill(SearchIndexerSkill):
    """A skill that can call a Web API endpoint, allowing you to extend a skillset by having it call your custom code.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :type odata_type: str
    :param name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :type name: str
    :param description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :type description: str
    :param context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :type context: str
    :param inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :type inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :param outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :type outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :param uri: Required. The url for the Web API.
    :type uri: str
    :param http_headers: The headers required to make the http request.
    :type http_headers: dict[str, str]
    :param http_method: The method for the http request.
    :type http_method: str
    :param timeout: The desired timeout for the request. Default is 30 seconds.
    :type timeout: ~datetime.timedelta
    :param batch_size: The desired batch size which indicates number of documents.
    :type batch_size: int
    :param degree_of_parallelism: If set, the number of parallel calls that can be made to the Web
     API.
    :type degree_of_parallelism: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'uri': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'http_headers': {'key': 'httpHeaders', 'type': '{str}'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'degree_of_parallelism': {'key': 'degreeOfParallelism', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        inputs: List["InputFieldMappingEntry"],
        outputs: List["OutputFieldMappingEntry"],
        uri: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        http_headers: Optional[Dict[str, str]] = None,
        http_method: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        batch_size: Optional[int] = None,
        degree_of_parallelism: Optional[int] = None,
        **kwargs
    ):
        super(WebApiSkill, self).__init__(name=name, description=description, context=context, inputs=inputs, outputs=outputs, **kwargs)
        self.odata_type = '#Microsoft.Skills.Custom.WebApiSkill'  # type: str
        self.uri = uri
        self.http_headers = http_headers
        self.http_method = http_method
        self.timeout = timeout
        self.batch_size = batch_size
        self.degree_of_parallelism = degree_of_parallelism


class WordDelimiterTokenFilter(TokenFilter):
    """Splits words into subwords and performs optional transformations on subword groups. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Identifies the concrete type of the token filter.Constant filled
     by server.
    :type odata_type: str
    :param name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :type name: str
    :param generate_word_parts: A value indicating whether to generate part words. If set, causes
     parts of words to be generated; for example "AzureSearch" becomes "Azure" "Search". Default is
     true.
    :type generate_word_parts: bool
    :param generate_number_parts: A value indicating whether to generate number subwords. Default
     is true.
    :type generate_number_parts: bool
    :param catenate_words: A value indicating whether maximum runs of word parts will be catenated.
     For example, if this is set to true, "Azure-Search" becomes "AzureSearch". Default is false.
    :type catenate_words: bool
    :param catenate_numbers: A value indicating whether maximum runs of number parts will be
     catenated. For example, if this is set to true, "1-2" becomes "12". Default is false.
    :type catenate_numbers: bool
    :param catenate_all: A value indicating whether all subword parts will be catenated. For
     example, if this is set to true, "Azure-Search-1" becomes "AzureSearch1". Default is false.
    :type catenate_all: bool
    :param split_on_case_change: A value indicating whether to split words on caseChange. For
     example, if this is set to true, "AzureSearch" becomes "Azure" "Search". Default is true.
    :type split_on_case_change: bool
    :param preserve_original: A value indicating whether original words will be preserved and added
     to the subword list. Default is false.
    :type preserve_original: bool
    :param split_on_numerics: A value indicating whether to split on numbers. For example, if this
     is set to true, "Azure1Search" becomes "Azure" "1" "Search". Default is true.
    :type split_on_numerics: bool
    :param stem_english_possessive: A value indicating whether to remove trailing "'s" for each
     subword. Default is true.
    :type stem_english_possessive: bool
    :param protected_words: A list of tokens to protect from being delimited.
    :type protected_words: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'generate_word_parts': {'key': 'generateWordParts', 'type': 'bool'},
        'generate_number_parts': {'key': 'generateNumberParts', 'type': 'bool'},
        'catenate_words': {'key': 'catenateWords', 'type': 'bool'},
        'catenate_numbers': {'key': 'catenateNumbers', 'type': 'bool'},
        'catenate_all': {'key': 'catenateAll', 'type': 'bool'},
        'split_on_case_change': {'key': 'splitOnCaseChange', 'type': 'bool'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
        'split_on_numerics': {'key': 'splitOnNumerics', 'type': 'bool'},
        'stem_english_possessive': {'key': 'stemEnglishPossessive', 'type': 'bool'},
        'protected_words': {'key': 'protectedWords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        generate_word_parts: Optional[bool] = True,
        generate_number_parts: Optional[bool] = True,
        catenate_words: Optional[bool] = False,
        catenate_numbers: Optional[bool] = False,
        catenate_all: Optional[bool] = False,
        split_on_case_change: Optional[bool] = True,
        preserve_original: Optional[bool] = False,
        split_on_numerics: Optional[bool] = True,
        stem_english_possessive: Optional[bool] = True,
        protected_words: Optional[List[str]] = None,
        **kwargs
    ):
        super(WordDelimiterTokenFilter, self).__init__(name=name, **kwargs)
        self.odata_type = '#Microsoft.Azure.Search.WordDelimiterTokenFilter'  # type: str
        self.generate_word_parts = generate_word_parts
        self.generate_number_parts = generate_number_parts
        self.catenate_words = catenate_words
        self.catenate_numbers = catenate_numbers
        self.catenate_all = catenate_all
        self.split_on_case_change = split_on_case_change
        self.preserve_original = preserve_original
        self.split_on_numerics = split_on_numerics
        self.stem_english_possessive = stem_english_possessive
        self.protected_words = protected_words
