import { CfnAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
import { BlockDevice, EbsDeviceVolumeType, InstanceProps, LaunchTemplateAttributes, VpcProps, SubnetType } from '@aws-cdk/aws-ec2';
import { NetworkTargetGroupProps } from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface InternalVPC {
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly vpcName: string;
    /**
     * @stability stable
     */
    readonly vpcProps?: VpcProps;
    /**
     * @stability stable
     */
    readonly vpcSubnet?: SubnetType;
}
/**
 * @stability stable
 */
export interface IngressRule {
    /**
     * @stability stable
     */
    readonly sourceSG: string;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly port: number;
}
/**
 * @stability stable
 */
export interface InternalRole {
    /**
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly roleArn?: string;
}
/**
 * @stability stable
 */
export interface InternalSG {
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly sgGroupId?: string;
    /**
     * @stability stable
     */
    readonly ingressRules?: IngressRule[];
    /**
     * @stability stable
     */
    readonly securityGroupName?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly allowAllOutbound?: boolean;
    /**
     * @stability stable
     */
    readonly disableInlineRules?: boolean;
}
/**
 * @stability stable
 */
export interface InstanceStackProps {
    /**
     * @stability stable
     */
    readonly asgName: string;
    /**
     * @stability stable
     */
    readonly securityGroup?: InternalSG;
    /**
     * @stability stable
     */
    readonly vpc?: InternalVPC;
    /**
     * @stability stable
     */
    readonly role?: InternalRole;
    /**
     * @stability stable
     */
    readonly instanceProps: InstanceProps;
    /**
     * @stability stable
     */
    readonly tags?: Record<string, string>;
    /**
     * @stability stable
     */
    readonly instanceVolumeSize?: BlockDevice;
    /**
     * @stability stable
     */
    readonly targetGroupProps?: NetworkTargetGroupProps;
}
/**
 * @stability stable
 */
export interface InternalBD {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly size: number;
    /**
     * @stability stable
     */
    readonly type: EbsDeviceVolumeType;
}
/**
 * @stability stable
 */
export interface InternalLaunchTemplateProps {
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly templateName: string;
    /**
     * @stability stable
     */
    readonly existingAttributes?: LaunchTemplateAttributes;
    /**
     * @stability stable
     */
    readonly vpc: InternalVPC;
    /**
     * @stability stable
     */
    readonly role: InternalRole;
    /**
     * @stability stable
     */
    readonly instanceType: string;
    /**
     * @stability stable
     */
    readonly amiImageId: string;
    /**
     * @stability stable
     */
    readonly detailedMonitoring: boolean;
    /**
     * @stability stable
     */
    readonly instanceVolumeSize?: BlockDevice;
    /**
     * @stability stable
     */
    readonly securityGroup: InternalSG;
    /**
     * @stability stable
     */
    readonly blockDevice: InternalBD;
    /**
     * @stability stable
     */
    readonly sshKey: string;
}
/**
 * @stability stable
 */
export interface TargetGroupProps {
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly port?: number;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * @stability stable
     */
    readonly healthPath?: string;
    /**
     * @stability stable
     */
    readonly thresholdCount?: number;
    /**
     * @stability stable
     */
    readonly tgArn?: string;
}
/**
 * @stability stable
 */
export interface AutoScalerProps {
    /**
     * @stability stable
     */
    readonly asgName: string;
    /**
     * @stability stable
     */
    readonly templateProps: InternalLaunchTemplateProps;
    /**
     * @stability stable
     */
    readonly maxSize: string;
    /**
     * @stability stable
     */
    readonly minSize: string;
    /**
     * @stability stable
     */
    readonly tags?: CfnAutoScalingGroup.TagPropertyProperty[];
    /**
     * @stability stable
     */
    readonly tgProps?: TargetGroupProps;
    /**
     * @stability stable
     */
    readonly subnets: string[];
}
/**
 * @stability stable
 */
export declare class AutoScaler extends cdk.Resource {
    /**
     * @stability stable
     */
    readonly targetGroupArn: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AutoScalerProps);
    private getVPC;
    private getRole;
    private getSG;
    private getBD;
    private getLT;
    private getTG;
}
