"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSns extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SNS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Setup the SNS topic
        [this.snsTopic] = defaults.buildTopic(this, {
            existingTopicObj: props.existingTopicObject,
            topicProps: props.topicProps,
        });
        this.snsTopic.grantPublish(this.service.taskDefinition.taskRole);
        const topicArnEnvironmentVariableName = props.topicArnEnvironmentVariableName || 'SNS_TOPIC_ARN';
        this.container.addEnvironment(topicArnEnvironmentVariableName, this.snsTopic.topicArn);
        const topicNameEnvironmentVariableName = props.topicNameEnvironmentVariableName || 'SNS_TOPIC_NAME';
        this.container.addEnvironment(topicNameEnvironmentVariableName, this.snsTopic.topicName);
    }
}
exports.FargateToSns = FargateToSns;
_a = JSII_RTTI_SYMBOL_1;
FargateToSns[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-sns.FargateToSns", version: "1.143.0" };
//# sourceMappingURL=data:application/json;base64,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