CREATE TABLE build (
  build_id SERIAL NOT NULL,
  branch VARCHAR(100) NOT NULL,
  revision VARCHAR(100) NOT NULL,
  output_tx MEDIUMTEXT DEFAULT NULL,
  exit_status INTEGER DEFAULT NULL,
  exec_sec DECIMAL DEFAULT NULL,
  version VARCHAR(100) NOT NULL,
  build_size DECIMAL DEFAULT NULL,
  deploy_dttm TIMESTAMP DEFAULT NULL,
  revert_dttm TIMESTAMP DEFAULT NULL,
  create_dttm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  update_dttm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  delete_dttm TIMESTAMP DEFAULT NULL
  PRIMARY KEY (build_id),
  UNIQUE (version)
);
CREATE TRIGGER update_dttm BEFORE UPDATE ON build FOR EACH ROW EXECUTE PROCEDURE update_dttm();
