# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.v20_pres_request_by_format import (
    V20PresRequestByFormat,
)


class V20PresCreateRequestRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    V20PresCreateRequestRequest - a model defined in OpenAPI
        presentation_request: The presentation_request of this V20PresCreateRequestRequest.
        auto_verify: Verifier choice to auto-verify proof presentation [Optional].
        comment: The comment of this V20PresCreateRequestRequest [Optional].
        trace: Whether to trace event (default false) [Optional].
    """

    presentation_request: V20PresRequestByFormat
    auto_verify: Optional[bool] = None
    comment: Optional[str] = None
    trace: Optional[bool] = None

    def __init__(
        self,
        *,
        presentation_request: V20PresRequestByFormat = None,
        auto_verify: Optional[bool] = None,
        comment: Optional[str] = None,
        trace: Optional[bool] = None,
        **kwargs,
    ):
        super().__init__(
            auto_verify=auto_verify,
            comment=comment,
            presentation_request=presentation_request,
            trace=trace,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


V20PresCreateRequestRequest.update_forward_refs()
