# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class IndyKeyCorrectnessProof(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyKeyCorrectnessProof - a model defined in OpenAPI
        c: c in key correctness proof.
        xr_cap: xr_cap in key correctness proof.
        xz_cap: xz_cap in key correctness proof.
    """

    c: str
    xr_cap: List[List[str]]
    xz_cap: str

    def __init__(
        self,
        *,
        c: str = None,
        xr_cap: List[List[str]] = None,
        xz_cap: str = None,
        **kwargs,
    ):
        super().__init__(
            c=c,
            xr_cap=xr_cap,
            xz_cap=xz_cap,
            **kwargs,
        )

    @validator("c")
    def c_pattern(cls, value):

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of c does not match regex pattern ('{pattern}')")
        return value

    @validator("xz_cap")
    def xz_cap_pattern(cls, value):

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of xz_cap does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


IndyKeyCorrectnessProof.update_forward_refs()
