# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class Generated(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    Generated - a model defined in OpenAPI
        master_secret: The master_secret of this Generated [Optional].
        number: The number of this Generated [Optional].
        remainder: The remainder of this Generated [Optional].
    """

    master_secret: Optional[str] = None
    number: Optional[str] = None
    remainder: Optional[str] = None

    def __init__(
        self,
        *,
        master_secret: Optional[str] = None,
        number: Optional[str] = None,
        remainder: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            master_secret=master_secret,
            number=number,
            remainder=remainder,
            **kwargs,
        )

    @validator("master_secret")
    def master_secret_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of master_secret does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("number")
    def number_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of number does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("remainder")
    def remainder_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of remainder does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


Generated.update_forward_refs()
