# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class ConnectionStaticRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    ConnectionStaticRequest - a model defined in OpenAPI
        alias: Alias to assign to this connection [Optional].
        my_did: Local DID [Optional].
        my_seed: Seed to use for the local DID [Optional].
        their_did: Remote DID [Optional].
        their_endpoint: URL endpoint for other party [Optional].
        their_label: Other party&#39;s label for this connection [Optional].
        their_seed: Seed to use for the remote DID [Optional].
        their_verkey: Remote verification key [Optional].
    """

    alias: Optional[str] = None
    my_did: Optional[str] = None
    my_seed: Optional[str] = None
    their_did: Optional[str] = None
    their_endpoint: Optional[str] = None
    their_label: Optional[str] = None
    their_seed: Optional[str] = None
    their_verkey: Optional[str] = None

    def __init__(
        self,
        *,
        alias: Optional[str] = None,
        my_did: Optional[str] = None,
        my_seed: Optional[str] = None,
        their_did: Optional[str] = None,
        their_endpoint: Optional[str] = None,
        their_label: Optional[str] = None,
        their_seed: Optional[str] = None,
        their_verkey: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            alias=alias,
            my_did=my_did,
            my_seed=my_seed,
            their_did=their_did,
            their_endpoint=their_endpoint,
            their_label=their_label,
            their_seed=their_seed,
            their_verkey=their_verkey,
            **kwargs,
        )

    @validator("my_did")
    def my_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of my_did does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("their_did")
    def their_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of their_did does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("their_endpoint")
    def their_endpoint_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[A-Za-z0-9\.\-\+]+:\/\/([A-Za-z0-9][.A-Za-z0-9-_]+[A-Za-z0-9])+(:[1-9][0-9]*)?(\/[^?&#]+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of their_endpoint does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


ConnectionStaticRequest.update_forward_refs()
