# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.attach_decorator_data_jws import AttachDecoratorDataJWS


class AttachDecoratorData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    AttachDecoratorData - a model defined in OpenAPI
        base64: Base64-encoded data [Optional].
        json_: JSON-serialized data [Optional].
        jws: Detached Java Web Signature [Optional].
        links: List of hypertext links to data [Optional].
        sha256: SHA256 hash (binhex encoded) of content [Optional].
    """

    base64: Optional[str] = None
    json_: Optional[Dict[str, Any]] = Field(None, alias="json")
    jws: Optional[AttachDecoratorDataJWS] = None
    links: Optional[List[str]] = None
    sha256: Optional[str] = None

    def __init__(
        self,
        *,
        base64: Optional[str] = None,
        json_: Optional[Dict[str, Any]] = None,
        jws: Optional[AttachDecoratorDataJWS] = None,
        links: Optional[List[str]] = None,
        sha256: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            base64=base64,
            json_=json_,
            jws=jws,
            links=links,
            sha256=sha256,
            **kwargs,
        )

    @validator("base64")
    def base64_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[a-zA-Z0-9+\/]*={0,2}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of base64 does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("sha256")
    def sha256_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[a-fA-F0-9+\/]{64}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of sha256 does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


AttachDecoratorData.update_forward_refs()
