"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class S3EventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const bucket = new s3.Bucket(this, 'B', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        fn.addEventSource(new lib_1.S3EventSource(bucket, {
            events: [s3.EventType.OBJECT_CREATED],
            filters: [{ prefix: 'subdir/' }],
        }));
    }
}
const app = new cdk.App();
new S3EventSourceTest(app, 'lambda-event-source-s3');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuczMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5zMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHNDQUFzQztBQUN0QyxxQ0FBcUM7QUFDckMsZ0NBQXVDO0FBQ3ZDLG1EQUErQztBQUUvQyxNQUFNLGlCQUFrQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQ3ZDLFlBQVksS0FBYyxFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsR0FBRyxJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3ZDLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFO1lBQ3RDLGFBQWEsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLE9BQU87U0FDekMsQ0FBQyxDQUFDO1FBRUgsRUFBRSxDQUFDLGNBQWMsQ0FBQyxJQUFJLG1CQUFhLENBQUMsTUFBTSxFQUFFO1lBQzFDLE1BQU0sRUFBRSxDQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFFO1lBQ3ZDLE9BQU8sRUFBRSxDQUFFLEVBQUUsTUFBTSxFQUFFLFNBQVMsRUFBRSxDQUFFO1NBQ25DLENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztBQUNyRCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgUzNFdmVudFNvdXJjZSB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0RnVuY3Rpb24gfSBmcm9tICcuL3Rlc3QtZnVuY3Rpb24nO1xuXG5jbGFzcyBTM0V2ZW50U291cmNlVGVzdCBleHRlbmRzIGNkay5TdGFjayB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQXBwLCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGZuID0gbmV3IFRlc3RGdW5jdGlvbih0aGlzLCAnRicpO1xuICAgIGNvbnN0IGJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQodGhpcywgJ0InLCB7XG4gICAgICByZW1vdmFsUG9saWN5OiBjZGsuUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICAgIH0pO1xuXG4gICAgZm4uYWRkRXZlbnRTb3VyY2UobmV3IFMzRXZlbnRTb3VyY2UoYnVja2V0LCB7XG4gICAgICBldmVudHM6IFsgczMuRXZlbnRUeXBlLk9CSkVDVF9DUkVBVEVEIF0sXG4gICAgICBmaWx0ZXJzOiBbIHsgcHJlZml4OiAnc3ViZGlyLycgfSBdLFxuICAgIH0pKTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IFMzRXZlbnRTb3VyY2VUZXN0KGFwcCwgJ2xhbWJkYS1ldmVudC1zb3VyY2UtczMnKTtcbmFwcC5zeW50aCgpO1xuIl19