import * as lambda from '@aws-cdk/aws-lambda';
import * as sqs from '@aws-cdk/aws-sqs';
export interface SqsEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event
     * source at the time of invoking your function. Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range: Minimum value of 1. Maximum value of 10.
     *
     * @default 10
     */
    readonly batchSize?: number;
}
/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 */
export declare class SqsEventSource implements lambda.IEventSource {
    readonly queue: sqs.IQueue;
    private readonly props;
    private _eventSourceMappingId?;
    constructor(queue: sqs.IQueue, props?: SqsEventSourceProps);
    bind(target: lambda.IFunction): void;
    /**
     * The identifier for this EventSourceMapping
     */
    get eventSourceMappingId(): string;
}
