"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const SecretsManager = require("aws-sdk/clients/secretsmanager");
const util_1 = require("./util");
const secretsManager = new SecretsManager();
async function handler(props, event) {
    const username = props.username;
    const passwordSecretArn = props.passwordSecretArn;
    const clusterProps = props;
    if (event.RequestType === 'Create') {
        await createUser(username, passwordSecretArn, clusterProps);
        return { PhysicalResourceId: util_1.makePhysicalId(username, clusterProps, event.RequestId), Data: { username: username } };
    }
    else if (event.RequestType === 'Delete') {
        await dropUser(username, clusterProps);
        return;
    }
    else if (event.RequestType === 'Update') {
        const { replace } = await updateUser(username, passwordSecretArn, clusterProps, event.OldResourceProperties);
        const physicalId = replace ? util_1.makePhysicalId(username, clusterProps, event.RequestId) : event.PhysicalResourceId;
        return { PhysicalResourceId: physicalId, Data: { username: username } };
    }
    else {
        /* eslint-disable-next-line dot-notation */
        throw new Error(`Unrecognized event type: ${event['RequestType']}`);
    }
}
exports.handler = handler;
async function dropUser(username, clusterProps) {
    await util_1.executeStatement(`DROP USER ${username}`, clusterProps);
}
async function createUser(username, passwordSecretArn, clusterProps) {
    const password = await getPasswordFromSecret(passwordSecretArn);
    await util_1.executeStatement(`CREATE USER ${username} PASSWORD '${password}'`, clusterProps);
}
async function updateUser(username, passwordSecretArn, clusterProps, oldResourceProperties) {
    const oldClusterProps = oldResourceProperties;
    if (clusterProps.clusterName !== oldClusterProps.clusterName || clusterProps.databaseName !== oldClusterProps.databaseName) {
        await createUser(username, passwordSecretArn, clusterProps);
        return { replace: true };
    }
    const oldUsername = oldResourceProperties.username;
    const oldPasswordSecretArn = oldResourceProperties.passwordSecretArn;
    const oldPassword = await getPasswordFromSecret(oldPasswordSecretArn);
    const password = await getPasswordFromSecret(passwordSecretArn);
    if (username !== oldUsername) {
        await createUser(username, passwordSecretArn, clusterProps);
        return { replace: true };
    }
    if (password !== oldPassword) {
        await util_1.executeStatement(`ALTER USER ${username} PASSWORD '${password}'`, clusterProps);
        return { replace: false };
    }
    return { replace: false };
}
async function getPasswordFromSecret(passwordSecretArn) {
    const secretValue = await secretsManager.getSecretValue({
        SecretId: passwordSecretArn,
    }).promise();
    const secretString = secretValue.SecretString;
    if (!secretString) {
        throw new Error(`Secret string for ${passwordSecretArn} was empty`);
    }
    const { password } = JSON.parse(secretString);
    return password;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInVzZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsZ0VBQWdFO0FBQ2hFLGlFQUFpRTtBQUVqRSxpQ0FBd0U7QUFFeEUsTUFBTSxjQUFjLEdBQUcsSUFBSSxjQUFjLEVBQUUsQ0FBQztBQUVyQyxLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXNDLEVBQUUsS0FBa0Q7SUFDdEgsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztJQUNoQyxNQUFNLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztJQUNsRCxNQUFNLFlBQVksR0FBRyxLQUFLLENBQUM7SUFFM0IsSUFBSSxLQUFLLENBQUMsV0FBVyxLQUFLLFFBQVEsRUFBRTtRQUNsQyxNQUFNLFVBQVUsQ0FBQyxRQUFRLEVBQUUsaUJBQWlCLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFDNUQsT0FBTyxFQUFFLGtCQUFrQixFQUFFLHFCQUFjLENBQUMsUUFBUSxFQUFFLFlBQVksRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLFFBQVEsRUFBRSxFQUFFLENBQUM7S0FDdEg7U0FBTSxJQUFJLEtBQUssQ0FBQyxXQUFXLEtBQUssUUFBUSxFQUFFO1FBQ3pDLE1BQU0sUUFBUSxDQUFDLFFBQVEsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUN2QyxPQUFPO0tBQ1I7U0FBTSxJQUFJLEtBQUssQ0FBQyxXQUFXLEtBQUssUUFBUSxFQUFFO1FBQ3pDLE1BQU0sRUFBRSxPQUFPLEVBQUUsR0FBRyxNQUFNLFVBQVUsQ0FBQyxRQUFRLEVBQUUsaUJBQWlCLEVBQUUsWUFBWSxFQUFFLEtBQUssQ0FBQyxxQkFBd0QsQ0FBQyxDQUFDO1FBQ2hKLE1BQU0sVUFBVSxHQUFHLE9BQU8sQ0FBQyxDQUFDLENBQUMscUJBQWMsQ0FBQyxRQUFRLEVBQUUsWUFBWSxFQUFFLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ2hILE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLFFBQVEsRUFBRSxFQUFFLENBQUM7S0FDekU7U0FBTTtRQUNMLDJDQUEyQztRQUMzQyxNQUFNLElBQUksS0FBSyxDQUFDLDRCQUE0QixLQUFLLENBQUMsYUFBYSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0tBQ3JFO0FBQ0gsQ0FBQztBQW5CRCwwQkFtQkM7QUFFRCxLQUFLLFVBQVUsUUFBUSxDQUFDLFFBQWdCLEVBQUUsWUFBMEI7SUFDbEUsTUFBTSx1QkFBZ0IsQ0FBQyxhQUFhLFFBQVEsRUFBRSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ2hFLENBQUM7QUFFRCxLQUFLLFVBQVUsVUFBVSxDQUFDLFFBQWdCLEVBQUUsaUJBQXlCLEVBQUUsWUFBMEI7SUFDL0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxxQkFBcUIsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBRWhFLE1BQU0sdUJBQWdCLENBQUMsZUFBZSxRQUFRLGNBQWMsUUFBUSxHQUFHLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDekYsQ0FBQztBQUVELEtBQUssVUFBVSxVQUFVLENBQ3ZCLFFBQWdCLEVBQ2hCLGlCQUF5QixFQUN6QixZQUEwQixFQUMxQixxQkFBc0Q7SUFFdEQsTUFBTSxlQUFlLEdBQUcscUJBQXFCLENBQUM7SUFDOUMsSUFBSSxZQUFZLENBQUMsV0FBVyxLQUFLLGVBQWUsQ0FBQyxXQUFXLElBQUksWUFBWSxDQUFDLFlBQVksS0FBSyxlQUFlLENBQUMsWUFBWSxFQUFFO1FBQzFILE1BQU0sVUFBVSxDQUFDLFFBQVEsRUFBRSxpQkFBaUIsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUM1RCxPQUFPLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUFDO0tBQzFCO0lBRUQsTUFBTSxXQUFXLEdBQUcscUJBQXFCLENBQUMsUUFBUSxDQUFDO0lBQ25ELE1BQU0sb0JBQW9CLEdBQUcscUJBQXFCLENBQUMsaUJBQWlCLENBQUM7SUFDckUsTUFBTSxXQUFXLEdBQUcsTUFBTSxxQkFBcUIsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3RFLE1BQU0sUUFBUSxHQUFHLE1BQU0scUJBQXFCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUVoRSxJQUFJLFFBQVEsS0FBSyxXQUFXLEVBQUU7UUFDNUIsTUFBTSxVQUFVLENBQUMsUUFBUSxFQUFFLGlCQUFpQixFQUFFLFlBQVksQ0FBQyxDQUFDO1FBQzVELE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQUM7S0FDMUI7SUFFRCxJQUFJLFFBQVEsS0FBSyxXQUFXLEVBQUU7UUFDNUIsTUFBTSx1QkFBZ0IsQ0FBQyxjQUFjLFFBQVEsY0FBYyxRQUFRLEdBQUcsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUN0RixPQUFPLEVBQUUsT0FBTyxFQUFFLEtBQUssRUFBRSxDQUFDO0tBQzNCO0lBRUQsT0FBTyxFQUFFLE9BQU8sRUFBRSxLQUFLLEVBQUUsQ0FBQztBQUM1QixDQUFDO0FBRUQsS0FBSyxVQUFVLHFCQUFxQixDQUFDLGlCQUF5QjtJQUM1RCxNQUFNLFdBQVcsR0FBRyxNQUFNLGNBQWMsQ0FBQyxjQUFjLENBQUM7UUFDdEQsUUFBUSxFQUFFLGlCQUFpQjtLQUM1QixDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDYixNQUFNLFlBQVksR0FBRyxXQUFXLENBQUMsWUFBWSxDQUFDO0lBQzlDLElBQUksQ0FBQyxZQUFZLEVBQUU7UUFDakIsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQkFBcUIsaUJBQWlCLFlBQVksQ0FBQyxDQUFDO0tBQ3JFO0lBQ0QsTUFBTSxFQUFFLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7SUFFOUMsT0FBTyxRQUFRLENBQUM7QUFDbEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvbm8tdW5yZXNvbHZlZCAqL1xuaW1wb3J0ICogYXMgQVdTTGFtYmRhIGZyb20gJ2F3cy1sYW1iZGEnO1xuLyogZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llcyAqL1xuaW1wb3J0ICogYXMgU2VjcmV0c01hbmFnZXIgZnJvbSAnYXdzLXNkay9jbGllbnRzL3NlY3JldHNtYW5hZ2VyJztcbmltcG9ydCB7IFVzZXJIYW5kbGVyUHJvcHMgfSBmcm9tICcuLi9oYW5kbGVyLXByb3BzJztcbmltcG9ydCB7IENsdXN0ZXJQcm9wcywgZXhlY3V0ZVN0YXRlbWVudCwgbWFrZVBoeXNpY2FsSWQgfSBmcm9tICcuL3V0aWwnO1xuXG5jb25zdCBzZWNyZXRzTWFuYWdlciA9IG5ldyBTZWNyZXRzTWFuYWdlcigpO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcihwcm9wczogVXNlckhhbmRsZXJQcm9wcyAmIENsdXN0ZXJQcm9wcywgZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQpIHtcbiAgY29uc3QgdXNlcm5hbWUgPSBwcm9wcy51c2VybmFtZTtcbiAgY29uc3QgcGFzc3dvcmRTZWNyZXRBcm4gPSBwcm9wcy5wYXNzd29yZFNlY3JldEFybjtcbiAgY29uc3QgY2x1c3RlclByb3BzID0gcHJvcHM7XG5cbiAgaWYgKGV2ZW50LlJlcXVlc3RUeXBlID09PSAnQ3JlYXRlJykge1xuICAgIGF3YWl0IGNyZWF0ZVVzZXIodXNlcm5hbWUsIHBhc3N3b3JkU2VjcmV0QXJuLCBjbHVzdGVyUHJvcHMpO1xuICAgIHJldHVybiB7IFBoeXNpY2FsUmVzb3VyY2VJZDogbWFrZVBoeXNpY2FsSWQodXNlcm5hbWUsIGNsdXN0ZXJQcm9wcywgZXZlbnQuUmVxdWVzdElkKSwgRGF0YTogeyB1c2VybmFtZTogdXNlcm5hbWUgfSB9O1xuICB9IGVsc2UgaWYgKGV2ZW50LlJlcXVlc3RUeXBlID09PSAnRGVsZXRlJykge1xuICAgIGF3YWl0IGRyb3BVc2VyKHVzZXJuYW1lLCBjbHVzdGVyUHJvcHMpO1xuICAgIHJldHVybjtcbiAgfSBlbHNlIGlmIChldmVudC5SZXF1ZXN0VHlwZSA9PT0gJ1VwZGF0ZScpIHtcbiAgICBjb25zdCB7IHJlcGxhY2UgfSA9IGF3YWl0IHVwZGF0ZVVzZXIodXNlcm5hbWUsIHBhc3N3b3JkU2VjcmV0QXJuLCBjbHVzdGVyUHJvcHMsIGV2ZW50Lk9sZFJlc291cmNlUHJvcGVydGllcyBhcyBVc2VySGFuZGxlclByb3BzICYgQ2x1c3RlclByb3BzKTtcbiAgICBjb25zdCBwaHlzaWNhbElkID0gcmVwbGFjZSA/IG1ha2VQaHlzaWNhbElkKHVzZXJuYW1lLCBjbHVzdGVyUHJvcHMsIGV2ZW50LlJlcXVlc3RJZCkgOiBldmVudC5QaHlzaWNhbFJlc291cmNlSWQ7XG4gICAgcmV0dXJuIHsgUGh5c2ljYWxSZXNvdXJjZUlkOiBwaHlzaWNhbElkLCBEYXRhOiB7IHVzZXJuYW1lOiB1c2VybmFtZSB9IH07XG4gIH0gZWxzZSB7XG4gICAgLyogZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGRvdC1ub3RhdGlvbiAqL1xuICAgIHRocm93IG5ldyBFcnJvcihgVW5yZWNvZ25pemVkIGV2ZW50IHR5cGU6ICR7ZXZlbnRbJ1JlcXVlc3RUeXBlJ119YCk7XG4gIH1cbn1cblxuYXN5bmMgZnVuY3Rpb24gZHJvcFVzZXIodXNlcm5hbWU6IHN0cmluZywgY2x1c3RlclByb3BzOiBDbHVzdGVyUHJvcHMpIHtcbiAgYXdhaXQgZXhlY3V0ZVN0YXRlbWVudChgRFJPUCBVU0VSICR7dXNlcm5hbWV9YCwgY2x1c3RlclByb3BzKTtcbn1cblxuYXN5bmMgZnVuY3Rpb24gY3JlYXRlVXNlcih1c2VybmFtZTogc3RyaW5nLCBwYXNzd29yZFNlY3JldEFybjogc3RyaW5nLCBjbHVzdGVyUHJvcHM6IENsdXN0ZXJQcm9wcykge1xuICBjb25zdCBwYXNzd29yZCA9IGF3YWl0IGdldFBhc3N3b3JkRnJvbVNlY3JldChwYXNzd29yZFNlY3JldEFybik7XG5cbiAgYXdhaXQgZXhlY3V0ZVN0YXRlbWVudChgQ1JFQVRFIFVTRVIgJHt1c2VybmFtZX0gUEFTU1dPUkQgJyR7cGFzc3dvcmR9J2AsIGNsdXN0ZXJQcm9wcyk7XG59XG5cbmFzeW5jIGZ1bmN0aW9uIHVwZGF0ZVVzZXIoXG4gIHVzZXJuYW1lOiBzdHJpbmcsXG4gIHBhc3N3b3JkU2VjcmV0QXJuOiBzdHJpbmcsXG4gIGNsdXN0ZXJQcm9wczogQ2x1c3RlclByb3BzLFxuICBvbGRSZXNvdXJjZVByb3BlcnRpZXM6IFVzZXJIYW5kbGVyUHJvcHMgJiBDbHVzdGVyUHJvcHMsXG4pOiBQcm9taXNlPHsgcmVwbGFjZTogYm9vbGVhbiB9PiB7XG4gIGNvbnN0IG9sZENsdXN0ZXJQcm9wcyA9IG9sZFJlc291cmNlUHJvcGVydGllcztcbiAgaWYgKGNsdXN0ZXJQcm9wcy5jbHVzdGVyTmFtZSAhPT0gb2xkQ2x1c3RlclByb3BzLmNsdXN0ZXJOYW1lIHx8IGNsdXN0ZXJQcm9wcy5kYXRhYmFzZU5hbWUgIT09IG9sZENsdXN0ZXJQcm9wcy5kYXRhYmFzZU5hbWUpIHtcbiAgICBhd2FpdCBjcmVhdGVVc2VyKHVzZXJuYW1lLCBwYXNzd29yZFNlY3JldEFybiwgY2x1c3RlclByb3BzKTtcbiAgICByZXR1cm4geyByZXBsYWNlOiB0cnVlIH07XG4gIH1cblxuICBjb25zdCBvbGRVc2VybmFtZSA9IG9sZFJlc291cmNlUHJvcGVydGllcy51c2VybmFtZTtcbiAgY29uc3Qgb2xkUGFzc3dvcmRTZWNyZXRBcm4gPSBvbGRSZXNvdXJjZVByb3BlcnRpZXMucGFzc3dvcmRTZWNyZXRBcm47XG4gIGNvbnN0IG9sZFBhc3N3b3JkID0gYXdhaXQgZ2V0UGFzc3dvcmRGcm9tU2VjcmV0KG9sZFBhc3N3b3JkU2VjcmV0QXJuKTtcbiAgY29uc3QgcGFzc3dvcmQgPSBhd2FpdCBnZXRQYXNzd29yZEZyb21TZWNyZXQocGFzc3dvcmRTZWNyZXRBcm4pO1xuXG4gIGlmICh1c2VybmFtZSAhPT0gb2xkVXNlcm5hbWUpIHtcbiAgICBhd2FpdCBjcmVhdGVVc2VyKHVzZXJuYW1lLCBwYXNzd29yZFNlY3JldEFybiwgY2x1c3RlclByb3BzKTtcbiAgICByZXR1cm4geyByZXBsYWNlOiB0cnVlIH07XG4gIH1cblxuICBpZiAocGFzc3dvcmQgIT09IG9sZFBhc3N3b3JkKSB7XG4gICAgYXdhaXQgZXhlY3V0ZVN0YXRlbWVudChgQUxURVIgVVNFUiAke3VzZXJuYW1lfSBQQVNTV09SRCAnJHtwYXNzd29yZH0nYCwgY2x1c3RlclByb3BzKTtcbiAgICByZXR1cm4geyByZXBsYWNlOiBmYWxzZSB9O1xuICB9XG5cbiAgcmV0dXJuIHsgcmVwbGFjZTogZmFsc2UgfTtcbn1cblxuYXN5bmMgZnVuY3Rpb24gZ2V0UGFzc3dvcmRGcm9tU2VjcmV0KHBhc3N3b3JkU2VjcmV0QXJuOiBzdHJpbmcpOiBQcm9taXNlPHN0cmluZz4ge1xuICBjb25zdCBzZWNyZXRWYWx1ZSA9IGF3YWl0IHNlY3JldHNNYW5hZ2VyLmdldFNlY3JldFZhbHVlKHtcbiAgICBTZWNyZXRJZDogcGFzc3dvcmRTZWNyZXRBcm4sXG4gIH0pLnByb21pc2UoKTtcbiAgY29uc3Qgc2VjcmV0U3RyaW5nID0gc2VjcmV0VmFsdWUuU2VjcmV0U3RyaW5nO1xuICBpZiAoIXNlY3JldFN0cmluZykge1xuICAgIHRocm93IG5ldyBFcnJvcihgU2VjcmV0IHN0cmluZyBmb3IgJHtwYXNzd29yZFNlY3JldEFybn0gd2FzIGVtcHR5YCk7XG4gIH1cbiAgY29uc3QgeyBwYXNzd29yZCB9ID0gSlNPTi5wYXJzZShzZWNyZXRTdHJpbmcpO1xuXG4gIHJldHVybiBwYXNzd29yZDtcbn1cbiJdfQ==