"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const redshift_generated_1 = require("./redshift.generated");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
}
/**
 * (experimental) A cluster parameter group.
 *
 * @experimental
 * @resource AWS::Redshift::ClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new redshift_generated_1.CfnClusterParameterGroup(this, 'Resource', {
            description: props.description || 'Cluster parameter group for family redshift-1.0',
            parameterGroupFamily: 'redshift-1.0',
            parameters: Object.entries(props.parameters).map(([name, value]) => {
                return { parameterName: name, parameterValue: value };
            }),
        });
        this.clusterParameterGroupName = resource.ref;
    }
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "@aws-cdk/aws-redshift.ClusterParameterGroup", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,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