#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['asyncapi', 'asyncapi._tests']

package_data = \
{'': ['*']}

install_requires = \
['broadcaster', 'jsondaora']

extras_require = \
{'dev-doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'docs': ['apidaora'],
 'http': ['requests'],
 'kafka': ['aiokafka'],
 'postgres': ['asyncpg'],
 'redis': ['asyncio-redis'],
 'subscriber': ['typer'],
 'test': ['black',
          'isort',
          'ipython',
          'mypy',
          'pytest-asyncio',
          'pytest-cov',
          'pytest-mock',
          'pytest',
          'flake8',
          'bumpversion',
          'jsondaora',
          'asynctest'],
 'yaml': ['pyyaml']}

entry_points = \
{'console_scripts': ['asyncapi-docs = asyncapi:run_docs',
                     'asyncapi-subscriber = asyncapi:run_subscriber']}

setup(name='asyncapi',
      version='0.6.0',
      description='asyncapi',
      author='Diogo Dutra',
      author_email='diogodutradamata@gmail.com',
      url='https://github.com/dutradda/asyncapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
