# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-yandex',
        'name': 'Yandex',
        'description': 'Yandex including `Yandex.Cloud <https://cloud.yandex.com/>`__\n',
        'versions': ['2.0.0', '1.0.1', '1.0.0'],
        'additional-dependencies': ['apache-airflow>=2.1.0'],
        'integrations': [
            {
                'integration-name': 'Yandex.Cloud',
                'external-doc-url': 'https://cloud.yandex.com/',
                'logo': '/integration-logos/yandex/Yandex-Cloud.png',
                'tags': ['service'],
            },
            {
                'integration-name': 'Yandex.Cloud Dataproc',
                'external-doc-url': 'https://cloud.yandex.com/dataproc',
                'how-to-guide': ['/docs/apache-airflow-providers-yandex/operators.rst'],
                'logo': '/integration-logos/yandex/Yandex-Cloud.png',
                'tags': ['service'],
            },
        ],
        'operators': [
            {
                'integration-name': 'Yandex.Cloud Dataproc',
                'python-modules': ['airflow.providers.yandex.operators.yandexcloud_dataproc'],
            }
        ],
        'hooks': [
            {'integration-name': 'Yandex.Cloud', 'python-modules': ['airflow.providers.yandex.hooks.yandex']},
            {
                'integration-name': 'Yandex.Cloud Dataproc',
                'python-modules': ['airflow.providers.yandex.hooks.yandexcloud_dataproc'],
            },
        ],
        'hook-class-names': ['airflow.providers.yandex.hooks.yandex.YandexCloudBaseHook'],
    }
