# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_status_codes.ipynb.

# %% auto 0
__all__ = ['status_codes']

# %% ../nbs/01_status_codes.ipynb 3
from http.client import responses

import pandas as pd
import plotly.express as px

# %% ../nbs/01_status_codes.ipynb 4
_texttemplate = '<b>%{label} </b><br><br>Status code: %{label} %{customdata[0]}<br>Count: %{value:,}<br>%{percentParent:.1%} of %{parent}<br>' #%{percentRoot:.1%} of %{root}'

# %% ../nbs/01_status_codes.ipynb 5
def status_codes(
    status_list,
    height=600,
    width=None,
    theme='none',
    title='Status Codes',
    export_to_html=None):
    """Create a treemap to visualize a list of status codes.

    Parameters
    ----------

    status_list : list, tuple, pandas.Series
        A collection of HTTP status codes
    height: integer
        The desired height of the figure in pixels
    width: integer
        The desired width of the figure in pixels
    theme : str
        Name of theme to use for the chart. Available themes:
            ggplot2, seaborn, simple_white, plotly, plotly_white, plotly_dark,
            presentation, xgridoff, ygridoff, gridon, none
    title: str
        The title of the figure. You can use/include the following HTML tags in
        the title: `<a>`, `<b>`, `<br>`, `<i>`, `<sub>`, `<sup>`
    export_to_html: str, optional
        The path to the HTML file if you want to save it as a shareable file

    Returns
    -------
    status_codes_figure : plotly.graph_objects.Figure
    """
    status_counts = pd.Series(status_list).value_counts().reset_index()
    status_counts.columns = ['status', 'count']
    status_counts = (status_counts
        .assign(status_cat=lambda df: df['status'].astype(int).round(-2))
        .assign(status_desc=lambda df: [responses[int(code)] for code in df['status']])
    )
    status_fig = px.treemap(
        status_counts,
        maxdepth = 2,
        path=[px.Constant('Status codes'), 'status_cat', 'status'],
        hover_name='status_cat',
        height=height,
        width=width,
        custom_data=['status_desc'],
        values='count',
        title=title,
        template=theme
    )
    status_fig.data[0].marker.line.width = 0.01
    status_fig.data[0].marker.pad = dict.fromkeys('lrbt', 0)
    status_fig.data[0]['texttemplate'] = _texttemplate
    status_fig.data[0]['hovertemplate'] = _texttemplate
    if export_to_html:
        status_fig.write_html(export_to_html)
    return status_fig
