"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.TLSSecurityPolicy = exports.ElasticsearchVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const url_1 = require("url");
const acm = require("@aws-cdk/aws-certificatemanager");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const logs = require("@aws-cdk/aws-logs");
const route53 = require("@aws-cdk/aws-route53");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const cdk = require("@aws-cdk/core");
const elasticsearch_access_policy_1 = require("./elasticsearch-access-policy");
const elasticsearch_generated_1 = require("./elasticsearch.generated");
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const perms = require("./perms");
/**
 * Elasticsearch version
 */
class ElasticsearchVersion {
    /**
     *
     * @param version Elasticsearch version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom Elasticsearch version
     * @param version custom version number
     */
    static of(version) { return new ElasticsearchVersion(version); }
}
exports.ElasticsearchVersion = ElasticsearchVersion;
_a = JSII_RTTI_SYMBOL_1;
ElasticsearchVersion[_a] = { fqn: "@aws-cdk/aws-elasticsearch.ElasticsearchVersion", version: "1.156.0" };
/**
 * AWS Elasticsearch 1.5
 */
ElasticsearchVersion.V1_5 = ElasticsearchVersion.of('1.5');
/**
 * AWS Elasticsearch 2.3
 */
ElasticsearchVersion.V2_3 = ElasticsearchVersion.of('2.3');
/**
 * AWS Elasticsearch 5.1
 */
ElasticsearchVersion.V5_1 = ElasticsearchVersion.of('5.1');
/**
 * AWS Elasticsearch 5.3
 */
ElasticsearchVersion.V5_3 = ElasticsearchVersion.of('5.3');
/**
 * AWS Elasticsearch 5.5
 */
ElasticsearchVersion.V5_5 = ElasticsearchVersion.of('5.5');
/**
 * AWS Elasticsearch 5.6
 */
ElasticsearchVersion.V5_6 = ElasticsearchVersion.of('5.6');
/**
 * AWS Elasticsearch 6.0
 */
ElasticsearchVersion.V6_0 = ElasticsearchVersion.of('6.0');
/**
 * AWS Elasticsearch 6.2
 */
ElasticsearchVersion.V6_2 = ElasticsearchVersion.of('6.2');
/**
 * AWS Elasticsearch 6.3
 */
ElasticsearchVersion.V6_3 = ElasticsearchVersion.of('6.3');
/**
 * AWS Elasticsearch 6.4
 */
ElasticsearchVersion.V6_4 = ElasticsearchVersion.of('6.4');
/**
 * AWS Elasticsearch 6.5
 */
ElasticsearchVersion.V6_5 = ElasticsearchVersion.of('6.5');
/**
 * AWS Elasticsearch 6.7
 */
ElasticsearchVersion.V6_7 = ElasticsearchVersion.of('6.7');
/**
 * AWS Elasticsearch 6.8
 */
ElasticsearchVersion.V6_8 = ElasticsearchVersion.of('6.8');
/**
 * AWS Elasticsearch 7.1
 */
ElasticsearchVersion.V7_1 = ElasticsearchVersion.of('7.1');
/**
 * AWS Elasticsearch 7.4
 */
ElasticsearchVersion.V7_4 = ElasticsearchVersion.of('7.4');
/**
 * AWS Elasticsearch 7.7
 */
ElasticsearchVersion.V7_7 = ElasticsearchVersion.of('7.7');
/**
 * AWS Elasticsearch 7.8
 */
ElasticsearchVersion.V7_8 = ElasticsearchVersion.of('7.8');
/**
 * AWS Elasticsearch 7.9
 */
ElasticsearchVersion.V7_9 = ElasticsearchVersion.of('7.9');
/**
 * AWS Elasticsearch 7.10
 */
ElasticsearchVersion.V7_10 = ElasticsearchVersion.of('7.10');
/**
 * The minimum TLS version required for traffic to the domain.
 *
 * @deprecated use opensearchservice module instead
 */
var TLSSecurityPolicy;
(function (TLSSecurityPolicy) {
    /** Cipher suite TLS 1.0 */
    TLSSecurityPolicy["TLS_1_0"] = "Policy-Min-TLS-1-0-2019-07";
    /** Cipher suite TLS 1.2 */
    TLSSecurityPolicy["TLS_1_2"] = "Policy-Min-TLS-1-2-2019-07";
})(TLSSecurityPolicy = exports.TLSSecurityPolicy || (exports.TLSSecurityPolicy = {}));
/**
 * A new or imported domain.
 */
class DomainBase extends cdk.Resource {
    /**
     * Grant read permissions for this domain and its contents to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantRead(identity) {
        return this.grant(identity, perms.ES_READ_ACTIONS, this.domainArn, `${this.domainArn}/*`);
    }
    /**
     * Grant write permissions for this domain and its contents to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantWrite(identity) {
        return this.grant(identity, perms.ES_WRITE_ACTIONS, this.domainArn, `${this.domainArn}/*`);
    }
    /**
     * Grant read/write permissions for this domain and its contents to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantReadWrite(identity) {
        return this.grant(identity, perms.ES_READ_WRITE_ACTIONS, this.domainArn, `${this.domainArn}/*`);
    }
    /**
     * Grant read permissions for an index in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param index The index to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantIndexRead(index, identity) {
        return this.grant(identity, perms.ES_READ_ACTIONS, `${this.domainArn}/${index}`, `${this.domainArn}/${index}/*`);
    }
    /**
     * Grant write permissions for an index in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param index The index to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantIndexWrite(index, identity) {
        return this.grant(identity, perms.ES_WRITE_ACTIONS, `${this.domainArn}/${index}`, `${this.domainArn}/${index}/*`);
    }
    /**
     * Grant read/write permissions for an index in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param index The index to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantIndexReadWrite(index, identity) {
        return this.grant(identity, perms.ES_READ_WRITE_ACTIONS, `${this.domainArn}/${index}`, `${this.domainArn}/${index}/*`);
    }
    /**
     * Grant read permissions for a specific path in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param path The path to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantPathRead(path, identity) {
        return this.grant(identity, perms.ES_READ_ACTIONS, `${this.domainArn}/${path}`);
    }
    /**
     * Grant write permissions for a specific path in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param path The path to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantPathWrite(path, identity) {
        return this.grant(identity, perms.ES_WRITE_ACTIONS, `${this.domainArn}/${path}`);
    }
    /**
     * Grant read/write permissions for a specific path in this domain to an IAM
     * principal (Role/Group/User).
     *
     * @param path The path to grant permissions for
     * @param identity The principal
     * @deprecated use opensearchservice module instead
     */
    grantPathReadWrite(path, identity) {
        return this.grant(identity, perms.ES_READ_WRITE_ACTIONS, `${this.domainArn}/${path}`);
    }
    /**
     * Return the given named metric for this Domain.
     *
     * @deprecated use opensearchservice module instead
     */
    metric(metricName, props) {
        return new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ES',
            metricName,
            dimensionsMap: {
                DomainName: this.domainName,
                ClientId: this.env.account,
            },
            ...props,
        }).attachTo(this);
    }
    /**
     * Metric for the time the cluster status is red.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricClusterStatusRed(props) {
        return this.metric('ClusterStatus.red', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for the time the cluster status is yellow.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricClusterStatusYellow(props) {
        return this.metric('ClusterStatus.yellow', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for the storage space of nodes in the cluster.
     *
     * @default minimum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricFreeStorageSpace(props) {
        return this.metric('FreeStorageSpace', {
            statistic: aws_cloudwatch_1.Statistic.MINIMUM,
            ...props,
        });
    }
    /**
     * Metric for the cluster blocking index writes.
     *
     * @default maximum over 1 minute
     * @deprecated use opensearchservice module instead
     */
    metricClusterIndexWritesBlocked(props) {
        return this.metric('ClusterIndexWritesBlocked', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            period: cdk.Duration.minutes(1),
            ...props,
        });
    }
    /**
     * Metric for the number of nodes.
     *
     * @default minimum over 1 hour
     * @deprecated use opensearchservice module instead
     */
    metricNodes(props) {
        return this.metric('Nodes', {
            statistic: aws_cloudwatch_1.Statistic.MINIMUM,
            period: cdk.Duration.hours(1),
            ...props,
        });
    }
    /**
     * Metric for automated snapshot failures.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricAutomatedSnapshotFailure(props) {
        return this.metric('AutomatedSnapshotFailure', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for CPU utilization.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricCPUUtilization(props) {
        return this.metric('CPUUtilization', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricJVMMemoryPressure(props) {
        return this.metric('JVMMemoryPressure', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for master CPU utilization.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricMasterCPUUtilization(props) {
        return this.metric('MasterCPUUtilization', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for master JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricMasterJVMMemoryPressure(props) {
        return this.metric('MasterJVMMemoryPressure', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for KMS key errors.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricKMSKeyError(props) {
        return this.metric('KMSKeyError', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for KMS key being inaccessible.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricKMSKeyInaccessible(props) {
        return this.metric('KMSKeyInaccessible', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for number of searchable documents.
     *
     * @default maximum over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricSearchableDocuments(props) {
        return this.metric('SearchableDocuments', {
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...props,
        });
    }
    /**
     * Metric for search latency.
     *
     * @default p99 over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricSearchLatency(props) {
        return this.metric('SearchLatency', { statistic: 'p99', ...props });
    }
    /**
     * Metric for indexing latency.
     *
     * @default p99 over 5 minutes
     * @deprecated use opensearchservice module instead
     */
    metricIndexingLatency(props) {
        return this.metric('IndexingLatency', { statistic: 'p99', ...props });
    }
    grant(grantee, domainActions, resourceArn, ...otherResourceArns) {
        const resourceArns = [resourceArn, ...otherResourceArns];
        const grant = iam.Grant.addToPrincipal({
            grantee,
            actions: domainActions,
            resourceArns,
            scope: this,
        });
        return grant;
    }
}
/**
 * Provides an Elasticsearch domain.
 *
 * @deprecated use opensearchservice module instead
 */
class Domain extends DomainBase {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30;
        super(scope, id, {
            physicalName: props.domainName,
        });
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-elasticsearch.Domain", "use opensearchservice module instead");
            jsiiDeprecationWarnings._aws_cdk_aws_elasticsearch_DomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const defaultInstanceType = 'r5.large.elasticsearch';
        const warmDefaultInstanceType = 'ultrawarm1.medium.elasticsearch';
        const dedicatedMasterType = initializeInstanceType(defaultInstanceType, (_c = props.capacity) === null || _c === void 0 ? void 0 : _c.masterNodeInstanceType);
        const dedicatedMasterCount = (_e = (_d = props.capacity) === null || _d === void 0 ? void 0 : _d.masterNodes) !== null && _e !== void 0 ? _e : 0;
        const dedicatedMasterEnabled = cdk.Token.isUnresolved(dedicatedMasterCount) ? true : dedicatedMasterCount > 0;
        const instanceType = initializeInstanceType(defaultInstanceType, (_f = props.capacity) === null || _f === void 0 ? void 0 : _f.dataNodeInstanceType);
        const instanceCount = (_h = (_g = props.capacity) === null || _g === void 0 ? void 0 : _g.dataNodes) !== null && _h !== void 0 ? _h : 1;
        const warmType = initializeInstanceType(warmDefaultInstanceType, (_j = props.capacity) === null || _j === void 0 ? void 0 : _j.warmInstanceType);
        const warmCount = (_l = (_k = props.capacity) === null || _k === void 0 ? void 0 : _k.warmNodes) !== null && _l !== void 0 ? _l : 0;
        const warmEnabled = cdk.Token.isUnresolved(warmCount) ? true : warmCount > 0;
        const availabilityZoneCount = (_o = (_m = props.zoneAwareness) === null || _m === void 0 ? void 0 : _m.availabilityZoneCount) !== null && _o !== void 0 ? _o : 2;
        if (![2, 3].includes(availabilityZoneCount)) {
            throw new Error('Invalid zone awareness configuration; availabilityZoneCount must be 2 or 3');
        }
        const zoneAwarenessEnabled = (_q = (_p = props.zoneAwareness) === null || _p === void 0 ? void 0 : _p.enabled) !== null && _q !== void 0 ? _q : ((_r = props.zoneAwareness) === null || _r === void 0 ? void 0 : _r.availabilityZoneCount) != null;
        let securityGroups;
        let subnets;
        if (props.vpc) {
            subnets = selectSubnets(props.vpc, (_s = props.vpcSubnets) !== null && _s !== void 0 ? _s : [{ subnetType: ec2.SubnetType.PRIVATE }]);
            securityGroups = (_t = props.securityGroups) !== null && _t !== void 0 ? _t : [new ec2.SecurityGroup(this, 'SecurityGroup', {
                    vpc: props.vpc,
                    description: `Security group for domain ${this.node.id}`,
                })];
            this._connections = new ec2.Connections({ securityGroups });
        }
        // If VPC options are supplied ensure that the number of subnets matches the number AZ
        if (subnets && zoneAwarenessEnabled && new Set(subnets.map((subnet) => subnet.availabilityZone)).size < availabilityZoneCount) {
            throw new Error('When providing vpc options you need to provide a subnet for each AZ you are using');
        }
        if ([dedicatedMasterType, instanceType, warmType].some(t => (!cdk.Token.isUnresolved(t) && !t.endsWith('.elasticsearch')))) {
            throw new Error('Master, data and UltraWarm node instance types must end with ".elasticsearch".');
        }
        if (!cdk.Token.isUnresolved(warmType) && !warmType.startsWith('ultrawarm')) {
            throw new Error('UltraWarm node instance type must start with "ultrawarm".');
        }
        const elasticsearchVersion = props.version.version;
        const elasticsearchVersionNum = parseVersion(props.version);
        if (elasticsearchVersionNum <= 7.7 &&
            ![
                1.5, 2.3, 5.1, 5.3, 5.5, 5.6, 6.0,
                6.2, 6.3, 6.4, 6.5, 6.7, 6.8, 7.1, 7.4,
                7.7,
            ].includes(elasticsearchVersionNum)) {
            throw new Error(`Unknown Elasticsearch version: ${elasticsearchVersion}`);
        }
        const unsignedBasicAuthEnabled = (_u = props.useUnsignedBasicAuth) !== null && _u !== void 0 ? _u : false;
        if (unsignedBasicAuthEnabled) {
            if (props.enforceHttps == false) {
                throw new Error('You cannot disable HTTPS and use unsigned basic auth');
            }
            if (props.nodeToNodeEncryption == false) {
                throw new Error('You cannot disable node to node encryption and use unsigned basic auth');
            }
            if (((_v = props.encryptionAtRest) === null || _v === void 0 ? void 0 : _v.enabled) == false) {
                throw new Error('You cannot disable encryption at rest and use unsigned basic auth');
            }
        }
        const unsignedAccessPolicy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['es:ESHttp*'],
            principals: [new iam.AnyPrincipal()],
            resources: [cdk.Lazy.string({ produce: () => `${this.domainArn}/*` })],
        });
        const masterUserArn = (_w = props.fineGrainedAccessControl) === null || _w === void 0 ? void 0 : _w.masterUserArn;
        const masterUserNameProps = (_x = props.fineGrainedAccessControl) === null || _x === void 0 ? void 0 : _x.masterUserName;
        // If basic auth is enabled set the user name to admin if no other user info is supplied.
        const masterUserName = unsignedBasicAuthEnabled
            ? (masterUserArn == null ? (masterUserNameProps !== null && masterUserNameProps !== void 0 ? masterUserNameProps : 'admin') : undefined)
            : masterUserNameProps;
        if (masterUserArn != null && masterUserName != null) {
            throw new Error('Invalid fine grained access control settings. Only provide one of master user ARN or master user name. Not both.');
        }
        const advancedSecurityEnabled = (masterUserArn !== null && masterUserArn !== void 0 ? masterUserArn : masterUserName) != null;
        const internalUserDatabaseEnabled = masterUserName != null;
        const masterUserPasswordProp = (_y = props.fineGrainedAccessControl) === null || _y === void 0 ? void 0 : _y.masterUserPassword;
        const createMasterUserPassword = () => {
            return new secretsmanager.Secret(this, 'MasterUser', {
                generateSecretString: {
                    secretStringTemplate: JSON.stringify({
                        username: masterUserName,
                    }),
                    generateStringKey: 'password',
                    excludeCharacters: "{}'\\*[]()`",
                },
            })
                .secretValueFromJson('password');
        };
        this.masterUserPassword = internalUserDatabaseEnabled ?
            (masterUserPasswordProp !== null && masterUserPasswordProp !== void 0 ? masterUserPasswordProp : createMasterUserPassword())
            : undefined;
        const encryptionAtRestEnabled = (_0 = (_z = props.encryptionAtRest) === null || _z === void 0 ? void 0 : _z.enabled) !== null && _0 !== void 0 ? _0 : (((_1 = props.encryptionAtRest) === null || _1 === void 0 ? void 0 : _1.kmsKey) != null || unsignedBasicAuthEnabled);
        const nodeToNodeEncryptionEnabled = (_2 = props.nodeToNodeEncryption) !== null && _2 !== void 0 ? _2 : unsignedBasicAuthEnabled;
        const volumeSize = (_4 = (_3 = props.ebs) === null || _3 === void 0 ? void 0 : _3.volumeSize) !== null && _4 !== void 0 ? _4 : 10;
        const volumeType = (_6 = (_5 = props.ebs) === null || _5 === void 0 ? void 0 : _5.volumeType) !== null && _6 !== void 0 ? _6 : ec2.EbsDeviceVolumeType.GENERAL_PURPOSE_SSD;
        const ebsEnabled = (_8 = (_7 = props.ebs) === null || _7 === void 0 ? void 0 : _7.enabled) !== null && _8 !== void 0 ? _8 : true;
        const enforceHttps = (_9 = props.enforceHttps) !== null && _9 !== void 0 ? _9 : unsignedBasicAuthEnabled;
        function isInstanceType(t) {
            return dedicatedMasterType.startsWith(t) || instanceType.startsWith(t);
        }
        ;
        function isSomeInstanceType(...instanceTypes) {
            return instanceTypes.some(isInstanceType);
        }
        ;
        function isEveryDatanodeInstanceType(...instanceTypes) {
            return instanceTypes.some(t => instanceType.startsWith(t));
        }
        ;
        // Validate feature support for the given Elasticsearch version, per
        // https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-features-by-version.html
        if (elasticsearchVersionNum < 5.1) {
            if ((_10 = props.logging) === null || _10 === void 0 ? void 0 : _10.appLogEnabled) {
                throw new Error('Error logs publishing requires Elasticsearch version 5.1 or later.');
            }
            if ((_11 = props.encryptionAtRest) === null || _11 === void 0 ? void 0 : _11.enabled) {
                throw new Error('Encryption of data at rest requires Elasticsearch version 5.1 or later.');
            }
            if (props.cognitoKibanaAuth != null) {
                throw new Error('Cognito authentication for Kibana requires Elasticsearch version 5.1 or later.');
            }
            if (isSomeInstanceType('c5', 'i3', 'm5', 'r5')) {
                throw new Error('C5, I3, M5, and R5 instance types require Elasticsearch version 5.1 or later.');
            }
        }
        if (elasticsearchVersionNum < 6.0) {
            if (props.nodeToNodeEncryption) {
                throw new Error('Node-to-node encryption requires Elasticsearch version 6.0 or later.');
            }
        }
        if (elasticsearchVersionNum < 6.7) {
            if (unsignedBasicAuthEnabled) {
                throw new Error('Using unsigned basic auth requires Elasticsearch version 6.7 or later.');
            }
            if (advancedSecurityEnabled) {
                throw new Error('Fine-grained access control requires Elasticsearch version 6.7 or later.');
            }
        }
        if (elasticsearchVersionNum < 6.8 && warmEnabled) {
            throw new Error('UltraWarm requires Elasticsearch 6.8 or later.');
        }
        // Validate against instance type restrictions, per
        // https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html
        if (isSomeInstanceType('i3', 'r6gd') && ebsEnabled) {
            throw new Error('I3 and R6GD instance types do not support EBS storage volumes.');
        }
        if (isSomeInstanceType('m3', 'r3', 't2') && encryptionAtRestEnabled) {
            throw new Error('M3, R3, and T2 instance types do not support encryption of data at rest.');
        }
        if (isInstanceType('t2.micro') && elasticsearchVersionNum > 2.3) {
            throw new Error('The t2.micro.elasticsearch instance type supports only Elasticsearch 1.5 and 2.3.');
        }
        if (isSomeInstanceType('t2', 't3') && warmEnabled) {
            throw new Error('T2 and T3 instance types do not support UltraWarm storage.');
        }
        // Only R3, I3 and r6gd support instance storage, per
        // https://aws.amazon.com/elasticsearch-service/pricing/
        if (!ebsEnabled && !isEveryDatanodeInstanceType('r3', 'i3', 'r6gd')) {
            throw new Error('EBS volumes are required when using instance types other than r3, i3 or r6gd.');
        }
        // Fine-grained access control requires node-to-node encryption, encryption at rest,
        // and enforced HTTPS.
        if (advancedSecurityEnabled) {
            if (!nodeToNodeEncryptionEnabled) {
                throw new Error('Node-to-node encryption is required when fine-grained access control is enabled.');
            }
            if (!encryptionAtRestEnabled) {
                throw new Error('Encryption-at-rest is required when fine-grained access control is enabled.');
            }
            if (!enforceHttps) {
                throw new Error('Enforce HTTPS is required when fine-grained access control is enabled.');
            }
        }
        // Validate fine grained access control enabled for audit logs, per
        // https://aws.amazon.com/about-aws/whats-new/2020/09/elasticsearch-audit-logs-now-available-on-amazon-elasticsearch-service/
        if (((_12 = props.logging) === null || _12 === void 0 ? void 0 : _12.auditLogEnabled) && !advancedSecurityEnabled) {
            throw new Error('Fine-grained access control is required when audit logs publishing is enabled.');
        }
        // Validate UltraWarm requirement for dedicated master nodes, per
        // https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/ultrawarm.html
        if (warmEnabled && !dedicatedMasterEnabled) {
            throw new Error('Dedicated master node is required when UltraWarm storage is enabled.');
        }
        let cfnVpcOptions;
        if (securityGroups && subnets) {
            cfnVpcOptions = {
                securityGroupIds: securityGroups.map((sg) => sg.securityGroupId),
                subnetIds: subnets.map((subnet) => subnet.subnetId),
            };
        }
        // Setup logging
        const logGroups = [];
        if ((_13 = props.logging) === null || _13 === void 0 ? void 0 : _13.slowSearchLogEnabled) {
            this.slowSearchLogGroup = (_14 = props.logging.slowSearchLogGroup) !== null && _14 !== void 0 ? _14 : new logs.LogGroup(this, 'SlowSearchLogs', {
                retention: logs.RetentionDays.ONE_MONTH,
            });
            logGroups.push(this.slowSearchLogGroup);
        }
        ;
        if ((_15 = props.logging) === null || _15 === void 0 ? void 0 : _15.slowIndexLogEnabled) {
            this.slowIndexLogGroup = (_16 = props.logging.slowIndexLogGroup) !== null && _16 !== void 0 ? _16 : new logs.LogGroup(this, 'SlowIndexLogs', {
                retention: logs.RetentionDays.ONE_MONTH,
            });
            logGroups.push(this.slowIndexLogGroup);
        }
        ;
        if ((_17 = props.logging) === null || _17 === void 0 ? void 0 : _17.appLogEnabled) {
            this.appLogGroup = (_18 = props.logging.appLogGroup) !== null && _18 !== void 0 ? _18 : new logs.LogGroup(this, 'AppLogs', {
                retention: logs.RetentionDays.ONE_MONTH,
            });
            logGroups.push(this.appLogGroup);
        }
        ;
        if ((_19 = props.logging) === null || _19 === void 0 ? void 0 : _19.auditLogEnabled) {
            this.auditLogGroup = (_20 = props.logging.auditLogGroup) !== null && _20 !== void 0 ? _20 : new logs.LogGroup(this, 'AuditLogs', {
                retention: logs.RetentionDays.ONE_MONTH,
            });
            logGroups.push(this.auditLogGroup);
        }
        ;
        let logGroupResourcePolicy = null;
        if (logGroups.length > 0) {
            const logPolicyStatement = new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                resources: logGroups.map((lg) => lg.logGroupArn),
                principals: [new iam.ServicePrincipal('es.amazonaws.com')],
            });
            // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
            // https://github.com/aws/aws-cdk/issues/5343
            logGroupResourcePolicy = new log_group_resource_policy_1.LogGroupResourcePolicy(this, `ESLogGroupPolicy${this.node.addr}`, {
                // create a cloudwatch logs resource policy name that is unique to this domain instance
                policyName: `ESLogPolicy${this.node.addr}`,
                policyStatements: [logPolicyStatement],
            });
        }
        const logPublishing = {};
        if (this.appLogGroup) {
            logPublishing.ES_APPLICATION_LOGS = {
                enabled: true,
                cloudWatchLogsLogGroupArn: this.appLogGroup.logGroupArn,
            };
        }
        if (this.slowSearchLogGroup) {
            logPublishing.SEARCH_SLOW_LOGS = {
                enabled: true,
                cloudWatchLogsLogGroupArn: this.slowSearchLogGroup.logGroupArn,
            };
        }
        if (this.slowIndexLogGroup) {
            logPublishing.INDEX_SLOW_LOGS = {
                enabled: true,
                cloudWatchLogsLogGroupArn: this.slowIndexLogGroup.logGroupArn,
            };
        }
        if (this.auditLogGroup) {
            logPublishing.AUDIT_LOGS = {
                enabled: this.auditLogGroup != null,
                cloudWatchLogsLogGroupArn: (_21 = this.auditLogGroup) === null || _21 === void 0 ? void 0 : _21.logGroupArn,
            };
        }
        let customEndpointCertificate;
        if (props.customEndpoint) {
            if (props.customEndpoint.certificate) {
                customEndpointCertificate = props.customEndpoint.certificate;
            }
            else {
                customEndpointCertificate = new acm.Certificate(this, 'CustomEndpointCertificate', {
                    domainName: props.customEndpoint.domainName,
                    validation: props.customEndpoint.hostedZone ? acm.CertificateValidation.fromDns(props.customEndpoint.hostedZone) : undefined,
                });
            }
        }
        // Create the domain
        this.domain = new elasticsearch_generated_1.CfnDomain(this, 'Resource', {
            domainName: this.physicalName,
            elasticsearchVersion,
            elasticsearchClusterConfig: {
                dedicatedMasterEnabled,
                dedicatedMasterCount: dedicatedMasterEnabled
                    ? dedicatedMasterCount
                    : undefined,
                dedicatedMasterType: dedicatedMasterEnabled
                    ? dedicatedMasterType
                    : undefined,
                instanceCount,
                instanceType,
                warmEnabled: warmEnabled
                    ? warmEnabled
                    : undefined,
                warmCount: warmEnabled
                    ? warmCount
                    : undefined,
                warmType: warmEnabled
                    ? warmType
                    : undefined,
                zoneAwarenessEnabled,
                zoneAwarenessConfig: zoneAwarenessEnabled
                    ? { availabilityZoneCount }
                    : undefined,
            },
            ebsOptions: {
                ebsEnabled,
                volumeSize: ebsEnabled ? volumeSize : undefined,
                volumeType: ebsEnabled ? volumeType : undefined,
                iops: ebsEnabled ? (_22 = props.ebs) === null || _22 === void 0 ? void 0 : _22.iops : undefined,
            },
            encryptionAtRestOptions: {
                enabled: encryptionAtRestEnabled,
                kmsKeyId: encryptionAtRestEnabled
                    ? (_24 = (_23 = props.encryptionAtRest) === null || _23 === void 0 ? void 0 : _23.kmsKey) === null || _24 === void 0 ? void 0 : _24.keyId : undefined,
            },
            nodeToNodeEncryptionOptions: { enabled: nodeToNodeEncryptionEnabled },
            logPublishingOptions: logPublishing,
            cognitoOptions: {
                enabled: props.cognitoKibanaAuth != null,
                identityPoolId: (_25 = props.cognitoKibanaAuth) === null || _25 === void 0 ? void 0 : _25.identityPoolId,
                roleArn: (_26 = props.cognitoKibanaAuth) === null || _26 === void 0 ? void 0 : _26.role.roleArn,
                userPoolId: (_27 = props.cognitoKibanaAuth) === null || _27 === void 0 ? void 0 : _27.userPoolId,
            },
            vpcOptions: cfnVpcOptions,
            snapshotOptions: props.automatedSnapshotStartHour
                ? { automatedSnapshotStartHour: props.automatedSnapshotStartHour }
                : undefined,
            domainEndpointOptions: {
                enforceHttps,
                tlsSecurityPolicy: (_28 = props.tlsSecurityPolicy) !== null && _28 !== void 0 ? _28 : TLSSecurityPolicy.TLS_1_0,
                ...props.customEndpoint && {
                    customEndpointEnabled: true,
                    customEndpoint: props.customEndpoint.domainName,
                    customEndpointCertificateArn: customEndpointCertificate.certificateArn,
                },
            },
            advancedSecurityOptions: advancedSecurityEnabled
                ? {
                    enabled: true,
                    internalUserDatabaseEnabled,
                    masterUserOptions: {
                        masterUserArn: masterUserArn,
                        masterUserName: masterUserName,
                        masterUserPassword: (_29 = this.masterUserPassword) === null || _29 === void 0 ? void 0 : _29.unsafeUnwrap(),
                    },
                }
                : undefined,
            advancedOptions: props.advancedOptions,
        });
        this.domain.applyRemovalPolicy(props.removalPolicy);
        if (props.enableVersionUpgrade) {
            this.domain.cfnOptions.updatePolicy = {
                ...this.domain.cfnOptions.updatePolicy,
                enableVersionUpgrade: props.enableVersionUpgrade,
            };
        }
        if (logGroupResourcePolicy) {
            this.domain.node.addDependency(logGroupResourcePolicy);
        }
        if (props.domainName) {
            if (!cdk.Token.isUnresolved(props.domainName)) {
                // https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-datatypes-domainname
                if (!props.domainName.match(/^[a-z0-9\-]+$/)) {
                    throw new Error(`Invalid domainName '${props.domainName}'. Valid characters are a-z (lowercase only), 0-9, and – (hyphen).`);
                }
                if (props.domainName.length < 3 || props.domainName.length > 28) {
                    throw new Error(`Invalid domainName '${props.domainName}'. It must be between 3 and 28 characters`);
                }
                if (props.domainName[0] < 'a' || props.domainName[0] > 'z') {
                    throw new Error(`Invalid domainName '${props.domainName}'. It must start with a lowercase letter`);
                }
            }
            this.node.addMetadata('aws:cdk:hasPhysicalName', props.domainName);
        }
        this.domainName = this.getResourceNameAttribute(this.domain.ref);
        this.domainEndpoint = this.domain.getAtt('DomainEndpoint').toString();
        this.domainArn = this.getResourceArnAttribute(this.domain.attrArn, {
            service: 'es',
            resource: 'domain',
            resourceName: this.physicalName,
        });
        if ((_30 = props.customEndpoint) === null || _30 === void 0 ? void 0 : _30.hostedZone) {
            new route53.CnameRecord(this, 'CnameRecord', {
                recordName: props.customEndpoint.domainName,
                zone: props.customEndpoint.hostedZone,
                domainName: this.domainEndpoint,
            });
        }
        this.encryptionAtRestOptions = props.encryptionAtRest;
        if (props.accessPolicies) {
            this.addAccessPolicies(...props.accessPolicies);
        }
        if (unsignedBasicAuthEnabled) {
            this.addAccessPolicies(unsignedAccessPolicy);
        }
    }
    /**
     * Creates a Domain construct that represents an external domain via domain endpoint.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param domainEndpoint The domain's endpoint.
     * @deprecated use opensearchservice module instead
     */
    static fromDomainEndpoint(scope, id, domainEndpoint) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-elasticsearch.Domain#fromDomainEndpoint", "use opensearchservice module instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDomainEndpoint);
            }
            throw error;
        }
        const stack = cdk.Stack.of(scope);
        const domainName = extractNameFromEndpoint(domainEndpoint);
        const domainArn = stack.formatArn({
            service: 'es',
            resource: 'domain',
            resourceName: domainName,
        });
        return Domain.fromDomainAttributes(scope, id, {
            domainArn,
            domainEndpoint,
        });
    }
    /**
     * Creates a Domain construct that represents an external domain.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `DomainAttributes` object.
     * @deprecated use opensearchservice module instead
     */
    static fromDomainAttributes(scope, id, attrs) {
        var _c;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-elasticsearch.Domain#fromDomainAttributes", "use opensearchservice module instead");
            jsiiDeprecationWarnings._aws_cdk_aws_elasticsearch_DomainAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDomainAttributes);
            }
            throw error;
        }
        const { domainArn, domainEndpoint } = attrs;
        const domainName = (_c = cdk.Stack.of(scope).splitArn(domainArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName) !== null && _c !== void 0 ? _c : extractNameFromEndpoint(domainEndpoint);
        return new class extends DomainBase {
            constructor() {
                super(scope, id);
                this.domainArn = domainArn;
                this.domainName = domainName;
                this.domainEndpoint = domainEndpoint.replace(/^https?:\/\//, '');
            }
        };
    }
    /**
     * Manages network connections to the domain. This will throw an error in case the domain
     * is not placed inside a VPC.
     *
     * @deprecated use opensearchservice module instead
     */
    get connections() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-elasticsearch.Domain#connections", "use opensearchservice module instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "connections").get);
            }
            throw error;
        }
        if (!this._connections) {
            throw new Error("Connections are only available on VPC enabled domains. Use the 'vpc' property to place a domain inside a VPC");
        }
        return this._connections;
    }
    /**
     * Add policy statements to the domain access policy
     *
     * @deprecated use opensearchservice module instead
     */
    addAccessPolicies(...accessPolicyStatements) {
        var _c;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-elasticsearch.Domain#addAccessPolicies", "use opensearchservice module instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAccessPolicies);
            }
            throw error;
        }
        if (accessPolicyStatements.length > 0) {
            if (!this.accessPolicy) {
                // Only create the custom resource after there are statements to set.
                this.accessPolicy = new elasticsearch_access_policy_1.ElasticsearchAccessPolicy(this, 'ESAccessPolicy', {
                    domainName: this.domainName,
                    domainArn: this.domainArn,
                    accessPolicies: accessPolicyStatements,
                });
                if ((_c = this.encryptionAtRestOptions) === null || _c === void 0 ? void 0 : _c.kmsKey) {
                    // https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/encryption-at-rest.html
                    // these permissions are documented as required during domain creation.
                    // while not strictly documented for updates as well, it stands to reason that an update
                    // operation might require these in case the cluster uses a kms key.
                    // empircal evidence shows this is indeed required: https://github.com/aws/aws-cdk/issues/11412
                    this.accessPolicy.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
                        actions: ['kms:List*', 'kms:Describe*', 'kms:CreateGrant'],
                        resources: [this.encryptionAtRestOptions.kmsKey.keyArn],
                        effect: iam.Effect.ALLOW,
                    }));
                }
            }
            else {
                this.accessPolicy.addAccessPolicies(...accessPolicyStatements);
            }
        }
    }
}
exports.Domain = Domain;
_b = JSII_RTTI_SYMBOL_1;
Domain[_b] = { fqn: "@aws-cdk/aws-elasticsearch.Domain", version: "1.156.0" };
/**
 * Given an Elasticsearch domain endpoint, returns a CloudFormation expression that
 * extracts the domain name.
 *
 * Domain endpoints look like this:
 *
 *   https://example-domain-jcjotrt6f7otem4sqcwbch3c4u.us-east-1.es.amazonaws.com
 *   https://<domain-name>-<suffix>.<region>.es.amazonaws.com
 *
 * ..which means that in order to extract the domain name from the endpoint, we can
 * split the endpoint using "-<suffix>" and select the component in index 0.
 *
 * @param domainEndpoint The Elasticsearch domain endpoint
 */
function extractNameFromEndpoint(domainEndpoint) {
    const { hostname } = new url_1.URL(domainEndpoint);
    const domain = hostname.split('.')[0];
    const suffix = '-' + domain.split('-').slice(-1)[0];
    return domain.split(suffix)[0];
}
/**
 * Converts an Elasticsearch version into a into a decimal number with major and minor version i.e x.y.
 *
 * @param version The Elasticsearch version object
 */
function parseVersion(version) {
    const versionStr = version.version;
    const firstDot = versionStr.indexOf('.');
    if (firstDot < 1) {
        throw new Error(`Invalid Elasticsearch version: ${versionStr}. Version string needs to start with major and minor version (x.y).`);
    }
    const secondDot = versionStr.indexOf('.', firstDot + 1);
    try {
        if (secondDot == -1) {
            return parseFloat(versionStr);
        }
        else {
            return parseFloat(versionStr.substring(0, secondDot));
        }
    }
    catch (error) {
        throw new Error(`Invalid Elasticsearch version: ${versionStr}. Version string needs to start with major and minor version (x.y).`);
    }
}
function selectSubnets(vpc, vpcSubnets) {
    const selected = [];
    for (const selection of vpcSubnets) {
        selected.push(...vpc.selectSubnets(selection).subnets);
    }
    return selected;
}
/**
 * Initializes an instance type.
 *
 * @param defaultInstanceType Default instance type which is used if no instance type is provided
 * @param instanceType Instance type
 * @returns Instance type in lowercase (if provided) or default instance type
 */
function initializeInstanceType(defaultInstanceType, instanceType) {
    if (instanceType) {
        return cdk.Token.isUnresolved(instanceType) ? instanceType : instanceType.toLowerCase();
    }
    else {
        return defaultInstanceType;
    }
}
//# sourceMappingURL=data:application/json;base64,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