/* Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --static --use-value-barrier p384 64 '2^384 - 2^128 - 2^96 + 2^32 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp */
/* curve description: p384 */
/* machine_wordsize = 64 (from "64") */
/* requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) */

#include <stdint.h>
typedef unsigned char fiat_p384_uint1;
typedef signed char fiat_p384_int1;
// Pedantic warnings can be disabled by adding prefix __extension__.
__extension__ typedef __int128_t fiat_p384_int128;
__extension__ typedef __uint128_t fiat_p384_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

OPENSSL_UNUSED static void fiat_p384_opp(uint64_t out1[6], const uint64_t arg1[6]);
OPENSSL_UNUSED static void fiat_p384_set_one(uint64_t out1[6]);
OPENSSL_UNUSED static void fiat_p384_msat(uint64_t out1[7]);
OPENSSL_UNUSED static void fiat_p384_divstep(uint64_t* out1, uint64_t out2[7], uint64_t out3[7], uint64_t out4[6], uint64_t out5[6], uint64_t arg1, const uint64_t arg2[7], const uint64_t arg3[7], const uint64_t arg4[6], const uint64_t arg5[6]);
OPENSSL_UNUSED static void fiat_p384_divstep_precomp(uint64_t out1[6]);
OPENSSL_UNUSED static void fiat_p384_add(uint64_t out1[6], const uint64_t arg1[6], const uint64_t arg2[6]);
OPENSSL_UNUSED static void fiat_p384_sub(uint64_t out1[6], const uint64_t arg1[6], const uint64_t arg2[6]);
OPENSSL_UNUSED static void fiat_p384_to_bytes(uint8_t out1[48], const uint64_t arg1[6]);
OPENSSL_UNUSED static void fiat_p384_from_bytes(uint64_t out1[6], const uint8_t arg1[48]);
OPENSSL_UNUSED static void fiat_p384_nonzero(uint64_t* out1, const uint64_t arg1[6]);
OPENSSL_UNUSED static void fiat_p384_selectznz(uint64_t out1[6], fiat_p384_uint1 arg1, const uint64_t arg2[6], const uint64_t arg3[6]);

/*
 * The function fiat_p384_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p384_addcarryx_u64(uint64_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p384_uint128 x1;
  uint64_t x2;
  fiat_p384_uint1 x3;
  x1 = ((arg1 + (fiat_p384_uint128)arg2) + arg3);
  x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  x3 = (fiat_p384_uint1)(x1 >> 64);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p384_subborrowx_u64(uint64_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p384_int128 x1;
  fiat_p384_int1 x2;
  uint64_t x3;
  x1 = ((arg2 - (fiat_p384_int128)arg1) - arg3);
  x2 = (fiat_p384_int1)(x1 >> 64);
  x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p384_uint1)(0x0 - x2);
}

/*
 * The function fiat_p384_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p384_mulx_u64(uint64_t* out1, uint64_t* out2, uint64_t arg1, uint64_t arg2) {
  fiat_p384_uint128 x1;
  uint64_t x2;
  uint64_t x3;
  x1 = ((fiat_p384_uint128)arg1 * arg2);
  x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  x3 = (uint64_t)(x1 >> 64);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p384_cmovznz_u64(uint64_t* out1, fiat_p384_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p384_uint1 x1;
  uint64_t x2;
  uint64_t x3;
  x1 = (!(!arg1));
  x2 = ((fiat_p384_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  // The following line uses the "crypto/internal.h" definition of value_barrier_u64
  x3 = ((value_barrier_u64(x2) & arg3) | (value_barrier_u64((~x2)) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p384_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_mul(uint64_t out1[6], const uint64_t arg1[6], const uint64_t arg2[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint64_t x16;
  uint64_t x17;
  uint64_t x18;
  uint64_t x19;
  fiat_p384_uint1 x20;
  uint64_t x21;
  fiat_p384_uint1 x22;
  uint64_t x23;
  fiat_p384_uint1 x24;
  uint64_t x25;
  fiat_p384_uint1 x26;
  uint64_t x27;
  fiat_p384_uint1 x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint64_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  uint64_t x38;
  uint64_t x39;
  uint64_t x40;
  uint64_t x41;
  uint64_t x42;
  uint64_t x43;
  uint64_t x44;
  fiat_p384_uint1 x45;
  uint64_t x46;
  fiat_p384_uint1 x47;
  uint64_t x48;
  fiat_p384_uint1 x49;
  uint64_t x50;
  fiat_p384_uint1 x51;
  uint64_t x52;
  fiat_p384_uint1 x53;
  uint64_t x54;
  uint64_t x55;
  fiat_p384_uint1 x56;
  uint64_t x57;
  fiat_p384_uint1 x58;
  uint64_t x59;
  fiat_p384_uint1 x60;
  uint64_t x61;
  fiat_p384_uint1 x62;
  uint64_t x63;
  fiat_p384_uint1 x64;
  uint64_t x65;
  fiat_p384_uint1 x66;
  uint64_t x67;
  fiat_p384_uint1 x68;
  uint64_t x69;
  uint64_t x70;
  uint64_t x71;
  uint64_t x72;
  uint64_t x73;
  uint64_t x74;
  uint64_t x75;
  uint64_t x76;
  uint64_t x77;
  uint64_t x78;
  uint64_t x79;
  uint64_t x80;
  uint64_t x81;
  fiat_p384_uint1 x82;
  uint64_t x83;
  fiat_p384_uint1 x84;
  uint64_t x85;
  fiat_p384_uint1 x86;
  uint64_t x87;
  fiat_p384_uint1 x88;
  uint64_t x89;
  fiat_p384_uint1 x90;
  uint64_t x91;
  uint64_t x92;
  fiat_p384_uint1 x93;
  uint64_t x94;
  fiat_p384_uint1 x95;
  uint64_t x96;
  fiat_p384_uint1 x97;
  uint64_t x98;
  fiat_p384_uint1 x99;
  uint64_t x100;
  fiat_p384_uint1 x101;
  uint64_t x102;
  fiat_p384_uint1 x103;
  uint64_t x104;
  fiat_p384_uint1 x105;
  uint64_t x106;
  uint64_t x107;
  uint64_t x108;
  uint64_t x109;
  uint64_t x110;
  uint64_t x111;
  uint64_t x112;
  uint64_t x113;
  uint64_t x114;
  uint64_t x115;
  uint64_t x116;
  uint64_t x117;
  uint64_t x118;
  uint64_t x119;
  uint64_t x120;
  fiat_p384_uint1 x121;
  uint64_t x122;
  fiat_p384_uint1 x123;
  uint64_t x124;
  fiat_p384_uint1 x125;
  uint64_t x126;
  fiat_p384_uint1 x127;
  uint64_t x128;
  fiat_p384_uint1 x129;
  uint64_t x130;
  uint64_t x131;
  fiat_p384_uint1 x132;
  uint64_t x133;
  fiat_p384_uint1 x134;
  uint64_t x135;
  fiat_p384_uint1 x136;
  uint64_t x137;
  fiat_p384_uint1 x138;
  uint64_t x139;
  fiat_p384_uint1 x140;
  uint64_t x141;
  fiat_p384_uint1 x142;
  uint64_t x143;
  fiat_p384_uint1 x144;
  uint64_t x145;
  uint64_t x146;
  uint64_t x147;
  uint64_t x148;
  uint64_t x149;
  uint64_t x150;
  uint64_t x151;
  uint64_t x152;
  uint64_t x153;
  uint64_t x154;
  uint64_t x155;
  uint64_t x156;
  uint64_t x157;
  uint64_t x158;
  fiat_p384_uint1 x159;
  uint64_t x160;
  fiat_p384_uint1 x161;
  uint64_t x162;
  fiat_p384_uint1 x163;
  uint64_t x164;
  fiat_p384_uint1 x165;
  uint64_t x166;
  fiat_p384_uint1 x167;
  uint64_t x168;
  uint64_t x169;
  fiat_p384_uint1 x170;
  uint64_t x171;
  fiat_p384_uint1 x172;
  uint64_t x173;
  fiat_p384_uint1 x174;
  uint64_t x175;
  fiat_p384_uint1 x176;
  uint64_t x177;
  fiat_p384_uint1 x178;
  uint64_t x179;
  fiat_p384_uint1 x180;
  uint64_t x181;
  fiat_p384_uint1 x182;
  uint64_t x183;
  uint64_t x184;
  uint64_t x185;
  uint64_t x186;
  uint64_t x187;
  uint64_t x188;
  uint64_t x189;
  uint64_t x190;
  uint64_t x191;
  uint64_t x192;
  uint64_t x193;
  uint64_t x194;
  uint64_t x195;
  uint64_t x196;
  uint64_t x197;
  fiat_p384_uint1 x198;
  uint64_t x199;
  fiat_p384_uint1 x200;
  uint64_t x201;
  fiat_p384_uint1 x202;
  uint64_t x203;
  fiat_p384_uint1 x204;
  uint64_t x205;
  fiat_p384_uint1 x206;
  uint64_t x207;
  uint64_t x208;
  fiat_p384_uint1 x209;
  uint64_t x210;
  fiat_p384_uint1 x211;
  uint64_t x212;
  fiat_p384_uint1 x213;
  uint64_t x214;
  fiat_p384_uint1 x215;
  uint64_t x216;
  fiat_p384_uint1 x217;
  uint64_t x218;
  fiat_p384_uint1 x219;
  uint64_t x220;
  fiat_p384_uint1 x221;
  uint64_t x222;
  uint64_t x223;
  uint64_t x224;
  uint64_t x225;
  uint64_t x226;
  uint64_t x227;
  uint64_t x228;
  uint64_t x229;
  uint64_t x230;
  uint64_t x231;
  uint64_t x232;
  uint64_t x233;
  uint64_t x234;
  uint64_t x235;
  fiat_p384_uint1 x236;
  uint64_t x237;
  fiat_p384_uint1 x238;
  uint64_t x239;
  fiat_p384_uint1 x240;
  uint64_t x241;
  fiat_p384_uint1 x242;
  uint64_t x243;
  fiat_p384_uint1 x244;
  uint64_t x245;
  uint64_t x246;
  fiat_p384_uint1 x247;
  uint64_t x248;
  fiat_p384_uint1 x249;
  uint64_t x250;
  fiat_p384_uint1 x251;
  uint64_t x252;
  fiat_p384_uint1 x253;
  uint64_t x254;
  fiat_p384_uint1 x255;
  uint64_t x256;
  fiat_p384_uint1 x257;
  uint64_t x258;
  fiat_p384_uint1 x259;
  uint64_t x260;
  uint64_t x261;
  uint64_t x262;
  uint64_t x263;
  uint64_t x264;
  uint64_t x265;
  uint64_t x266;
  uint64_t x267;
  uint64_t x268;
  uint64_t x269;
  uint64_t x270;
  uint64_t x271;
  uint64_t x272;
  uint64_t x273;
  uint64_t x274;
  fiat_p384_uint1 x275;
  uint64_t x276;
  fiat_p384_uint1 x277;
  uint64_t x278;
  fiat_p384_uint1 x279;
  uint64_t x280;
  fiat_p384_uint1 x281;
  uint64_t x282;
  fiat_p384_uint1 x283;
  uint64_t x284;
  uint64_t x285;
  fiat_p384_uint1 x286;
  uint64_t x287;
  fiat_p384_uint1 x288;
  uint64_t x289;
  fiat_p384_uint1 x290;
  uint64_t x291;
  fiat_p384_uint1 x292;
  uint64_t x293;
  fiat_p384_uint1 x294;
  uint64_t x295;
  fiat_p384_uint1 x296;
  uint64_t x297;
  fiat_p384_uint1 x298;
  uint64_t x299;
  uint64_t x300;
  uint64_t x301;
  uint64_t x302;
  uint64_t x303;
  uint64_t x304;
  uint64_t x305;
  uint64_t x306;
  uint64_t x307;
  uint64_t x308;
  uint64_t x309;
  uint64_t x310;
  uint64_t x311;
  uint64_t x312;
  fiat_p384_uint1 x313;
  uint64_t x314;
  fiat_p384_uint1 x315;
  uint64_t x316;
  fiat_p384_uint1 x317;
  uint64_t x318;
  fiat_p384_uint1 x319;
  uint64_t x320;
  fiat_p384_uint1 x321;
  uint64_t x322;
  uint64_t x323;
  fiat_p384_uint1 x324;
  uint64_t x325;
  fiat_p384_uint1 x326;
  uint64_t x327;
  fiat_p384_uint1 x328;
  uint64_t x329;
  fiat_p384_uint1 x330;
  uint64_t x331;
  fiat_p384_uint1 x332;
  uint64_t x333;
  fiat_p384_uint1 x334;
  uint64_t x335;
  fiat_p384_uint1 x336;
  uint64_t x337;
  uint64_t x338;
  uint64_t x339;
  uint64_t x340;
  uint64_t x341;
  uint64_t x342;
  uint64_t x343;
  uint64_t x344;
  uint64_t x345;
  uint64_t x346;
  uint64_t x347;
  uint64_t x348;
  uint64_t x349;
  uint64_t x350;
  uint64_t x351;
  fiat_p384_uint1 x352;
  uint64_t x353;
  fiat_p384_uint1 x354;
  uint64_t x355;
  fiat_p384_uint1 x356;
  uint64_t x357;
  fiat_p384_uint1 x358;
  uint64_t x359;
  fiat_p384_uint1 x360;
  uint64_t x361;
  uint64_t x362;
  fiat_p384_uint1 x363;
  uint64_t x364;
  fiat_p384_uint1 x365;
  uint64_t x366;
  fiat_p384_uint1 x367;
  uint64_t x368;
  fiat_p384_uint1 x369;
  uint64_t x370;
  fiat_p384_uint1 x371;
  uint64_t x372;
  fiat_p384_uint1 x373;
  uint64_t x374;
  fiat_p384_uint1 x375;
  uint64_t x376;
  uint64_t x377;
  uint64_t x378;
  uint64_t x379;
  uint64_t x380;
  uint64_t x381;
  uint64_t x382;
  uint64_t x383;
  uint64_t x384;
  uint64_t x385;
  uint64_t x386;
  uint64_t x387;
  uint64_t x388;
  uint64_t x389;
  fiat_p384_uint1 x390;
  uint64_t x391;
  fiat_p384_uint1 x392;
  uint64_t x393;
  fiat_p384_uint1 x394;
  uint64_t x395;
  fiat_p384_uint1 x396;
  uint64_t x397;
  fiat_p384_uint1 x398;
  uint64_t x399;
  uint64_t x400;
  fiat_p384_uint1 x401;
  uint64_t x402;
  fiat_p384_uint1 x403;
  uint64_t x404;
  fiat_p384_uint1 x405;
  uint64_t x406;
  fiat_p384_uint1 x407;
  uint64_t x408;
  fiat_p384_uint1 x409;
  uint64_t x410;
  fiat_p384_uint1 x411;
  uint64_t x412;
  fiat_p384_uint1 x413;
  uint64_t x414;
  uint64_t x415;
  uint64_t x416;
  uint64_t x417;
  uint64_t x418;
  uint64_t x419;
  uint64_t x420;
  uint64_t x421;
  uint64_t x422;
  uint64_t x423;
  uint64_t x424;
  uint64_t x425;
  uint64_t x426;
  uint64_t x427;
  uint64_t x428;
  fiat_p384_uint1 x429;
  uint64_t x430;
  fiat_p384_uint1 x431;
  uint64_t x432;
  fiat_p384_uint1 x433;
  uint64_t x434;
  fiat_p384_uint1 x435;
  uint64_t x436;
  fiat_p384_uint1 x437;
  uint64_t x438;
  uint64_t x439;
  fiat_p384_uint1 x440;
  uint64_t x441;
  fiat_p384_uint1 x442;
  uint64_t x443;
  fiat_p384_uint1 x444;
  uint64_t x445;
  fiat_p384_uint1 x446;
  uint64_t x447;
  fiat_p384_uint1 x448;
  uint64_t x449;
  fiat_p384_uint1 x450;
  uint64_t x451;
  fiat_p384_uint1 x452;
  uint64_t x453;
  uint64_t x454;
  fiat_p384_uint1 x455;
  uint64_t x456;
  fiat_p384_uint1 x457;
  uint64_t x458;
  fiat_p384_uint1 x459;
  uint64_t x460;
  fiat_p384_uint1 x461;
  uint64_t x462;
  fiat_p384_uint1 x463;
  uint64_t x464;
  fiat_p384_uint1 x465;
  uint64_t x466;
  fiat_p384_uint1 x467;
  uint64_t x468;
  uint64_t x469;
  uint64_t x470;
  uint64_t x471;
  uint64_t x472;
  uint64_t x473;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[0]);
  fiat_p384_mulx_u64(&x7, &x8, x6, (arg2[5]));
  fiat_p384_mulx_u64(&x9, &x10, x6, (arg2[4]));
  fiat_p384_mulx_u64(&x11, &x12, x6, (arg2[3]));
  fiat_p384_mulx_u64(&x13, &x14, x6, (arg2[2]));
  fiat_p384_mulx_u64(&x15, &x16, x6, (arg2[1]));
  fiat_p384_mulx_u64(&x17, &x18, x6, (arg2[0]));
  fiat_p384_addcarryx_u64(&x19, &x20, 0x0, x18, x15);
  fiat_p384_addcarryx_u64(&x21, &x22, x20, x16, x13);
  fiat_p384_addcarryx_u64(&x23, &x24, x22, x14, x11);
  fiat_p384_addcarryx_u64(&x25, &x26, x24, x12, x9);
  fiat_p384_addcarryx_u64(&x27, &x28, x26, x10, x7);
  x29 = (x28 + x8);
  fiat_p384_mulx_u64(&x30, &x31, x17, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x32, &x33, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x34, &x35, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x36, &x37, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x38, &x39, x30, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x40, &x41, x30, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x42, &x43, x30, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x44, &x45, 0x0, x43, x40);
  fiat_p384_addcarryx_u64(&x46, &x47, x45, x41, x38);
  fiat_p384_addcarryx_u64(&x48, &x49, x47, x39, x36);
  fiat_p384_addcarryx_u64(&x50, &x51, x49, x37, x34);
  fiat_p384_addcarryx_u64(&x52, &x53, x51, x35, x32);
  x54 = (x53 + x33);
  fiat_p384_addcarryx_u64(&x55, &x56, 0x0, x17, x42);
  fiat_p384_addcarryx_u64(&x57, &x58, x56, x19, x44);
  fiat_p384_addcarryx_u64(&x59, &x60, x58, x21, x46);
  fiat_p384_addcarryx_u64(&x61, &x62, x60, x23, x48);
  fiat_p384_addcarryx_u64(&x63, &x64, x62, x25, x50);
  fiat_p384_addcarryx_u64(&x65, &x66, x64, x27, x52);
  fiat_p384_addcarryx_u64(&x67, &x68, x66, x29, x54);
  fiat_p384_mulx_u64(&x69, &x70, x1, (arg2[5]));
  fiat_p384_mulx_u64(&x71, &x72, x1, (arg2[4]));
  fiat_p384_mulx_u64(&x73, &x74, x1, (arg2[3]));
  fiat_p384_mulx_u64(&x75, &x76, x1, (arg2[2]));
  fiat_p384_mulx_u64(&x77, &x78, x1, (arg2[1]));
  fiat_p384_mulx_u64(&x79, &x80, x1, (arg2[0]));
  fiat_p384_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
  fiat_p384_addcarryx_u64(&x83, &x84, x82, x78, x75);
  fiat_p384_addcarryx_u64(&x85, &x86, x84, x76, x73);
  fiat_p384_addcarryx_u64(&x87, &x88, x86, x74, x71);
  fiat_p384_addcarryx_u64(&x89, &x90, x88, x72, x69);
  x91 = (x90 + x70);
  fiat_p384_addcarryx_u64(&x92, &x93, 0x0, x57, x79);
  fiat_p384_addcarryx_u64(&x94, &x95, x93, x59, x81);
  fiat_p384_addcarryx_u64(&x96, &x97, x95, x61, x83);
  fiat_p384_addcarryx_u64(&x98, &x99, x97, x63, x85);
  fiat_p384_addcarryx_u64(&x100, &x101, x99, x65, x87);
  fiat_p384_addcarryx_u64(&x102, &x103, x101, x67, x89);
  fiat_p384_addcarryx_u64(&x104, &x105, x103, x68, x91);
  fiat_p384_mulx_u64(&x106, &x107, x92, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x108, &x109, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x110, &x111, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x112, &x113, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x114, &x115, x106, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x116, &x117, x106, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x118, &x119, x106, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x120, &x121, 0x0, x119, x116);
  fiat_p384_addcarryx_u64(&x122, &x123, x121, x117, x114);
  fiat_p384_addcarryx_u64(&x124, &x125, x123, x115, x112);
  fiat_p384_addcarryx_u64(&x126, &x127, x125, x113, x110);
  fiat_p384_addcarryx_u64(&x128, &x129, x127, x111, x108);
  x130 = (x129 + x109);
  fiat_p384_addcarryx_u64(&x131, &x132, 0x0, x92, x118);
  fiat_p384_addcarryx_u64(&x133, &x134, x132, x94, x120);
  fiat_p384_addcarryx_u64(&x135, &x136, x134, x96, x122);
  fiat_p384_addcarryx_u64(&x137, &x138, x136, x98, x124);
  fiat_p384_addcarryx_u64(&x139, &x140, x138, x100, x126);
  fiat_p384_addcarryx_u64(&x141, &x142, x140, x102, x128);
  fiat_p384_addcarryx_u64(&x143, &x144, x142, x104, x130);
  x145 = ((uint64_t)x144 + x105);
  fiat_p384_mulx_u64(&x146, &x147, x2, (arg2[5]));
  fiat_p384_mulx_u64(&x148, &x149, x2, (arg2[4]));
  fiat_p384_mulx_u64(&x150, &x151, x2, (arg2[3]));
  fiat_p384_mulx_u64(&x152, &x153, x2, (arg2[2]));
  fiat_p384_mulx_u64(&x154, &x155, x2, (arg2[1]));
  fiat_p384_mulx_u64(&x156, &x157, x2, (arg2[0]));
  fiat_p384_addcarryx_u64(&x158, &x159, 0x0, x157, x154);
  fiat_p384_addcarryx_u64(&x160, &x161, x159, x155, x152);
  fiat_p384_addcarryx_u64(&x162, &x163, x161, x153, x150);
  fiat_p384_addcarryx_u64(&x164, &x165, x163, x151, x148);
  fiat_p384_addcarryx_u64(&x166, &x167, x165, x149, x146);
  x168 = (x167 + x147);
  fiat_p384_addcarryx_u64(&x169, &x170, 0x0, x133, x156);
  fiat_p384_addcarryx_u64(&x171, &x172, x170, x135, x158);
  fiat_p384_addcarryx_u64(&x173, &x174, x172, x137, x160);
  fiat_p384_addcarryx_u64(&x175, &x176, x174, x139, x162);
  fiat_p384_addcarryx_u64(&x177, &x178, x176, x141, x164);
  fiat_p384_addcarryx_u64(&x179, &x180, x178, x143, x166);
  fiat_p384_addcarryx_u64(&x181, &x182, x180, x145, x168);
  fiat_p384_mulx_u64(&x183, &x184, x169, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x185, &x186, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x187, &x188, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x189, &x190, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x191, &x192, x183, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x193, &x194, x183, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x195, &x196, x183, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x197, &x198, 0x0, x196, x193);
  fiat_p384_addcarryx_u64(&x199, &x200, x198, x194, x191);
  fiat_p384_addcarryx_u64(&x201, &x202, x200, x192, x189);
  fiat_p384_addcarryx_u64(&x203, &x204, x202, x190, x187);
  fiat_p384_addcarryx_u64(&x205, &x206, x204, x188, x185);
  x207 = (x206 + x186);
  fiat_p384_addcarryx_u64(&x208, &x209, 0x0, x169, x195);
  fiat_p384_addcarryx_u64(&x210, &x211, x209, x171, x197);
  fiat_p384_addcarryx_u64(&x212, &x213, x211, x173, x199);
  fiat_p384_addcarryx_u64(&x214, &x215, x213, x175, x201);
  fiat_p384_addcarryx_u64(&x216, &x217, x215, x177, x203);
  fiat_p384_addcarryx_u64(&x218, &x219, x217, x179, x205);
  fiat_p384_addcarryx_u64(&x220, &x221, x219, x181, x207);
  x222 = ((uint64_t)x221 + x182);
  fiat_p384_mulx_u64(&x223, &x224, x3, (arg2[5]));
  fiat_p384_mulx_u64(&x225, &x226, x3, (arg2[4]));
  fiat_p384_mulx_u64(&x227, &x228, x3, (arg2[3]));
  fiat_p384_mulx_u64(&x229, &x230, x3, (arg2[2]));
  fiat_p384_mulx_u64(&x231, &x232, x3, (arg2[1]));
  fiat_p384_mulx_u64(&x233, &x234, x3, (arg2[0]));
  fiat_p384_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
  fiat_p384_addcarryx_u64(&x237, &x238, x236, x232, x229);
  fiat_p384_addcarryx_u64(&x239, &x240, x238, x230, x227);
  fiat_p384_addcarryx_u64(&x241, &x242, x240, x228, x225);
  fiat_p384_addcarryx_u64(&x243, &x244, x242, x226, x223);
  x245 = (x244 + x224);
  fiat_p384_addcarryx_u64(&x246, &x247, 0x0, x210, x233);
  fiat_p384_addcarryx_u64(&x248, &x249, x247, x212, x235);
  fiat_p384_addcarryx_u64(&x250, &x251, x249, x214, x237);
  fiat_p384_addcarryx_u64(&x252, &x253, x251, x216, x239);
  fiat_p384_addcarryx_u64(&x254, &x255, x253, x218, x241);
  fiat_p384_addcarryx_u64(&x256, &x257, x255, x220, x243);
  fiat_p384_addcarryx_u64(&x258, &x259, x257, x222, x245);
  fiat_p384_mulx_u64(&x260, &x261, x246, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x262, &x263, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x264, &x265, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x266, &x267, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x268, &x269, x260, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x270, &x271, x260, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x272, &x273, x260, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x274, &x275, 0x0, x273, x270);
  fiat_p384_addcarryx_u64(&x276, &x277, x275, x271, x268);
  fiat_p384_addcarryx_u64(&x278, &x279, x277, x269, x266);
  fiat_p384_addcarryx_u64(&x280, &x281, x279, x267, x264);
  fiat_p384_addcarryx_u64(&x282, &x283, x281, x265, x262);
  x284 = (x283 + x263);
  fiat_p384_addcarryx_u64(&x285, &x286, 0x0, x246, x272);
  fiat_p384_addcarryx_u64(&x287, &x288, x286, x248, x274);
  fiat_p384_addcarryx_u64(&x289, &x290, x288, x250, x276);
  fiat_p384_addcarryx_u64(&x291, &x292, x290, x252, x278);
  fiat_p384_addcarryx_u64(&x293, &x294, x292, x254, x280);
  fiat_p384_addcarryx_u64(&x295, &x296, x294, x256, x282);
  fiat_p384_addcarryx_u64(&x297, &x298, x296, x258, x284);
  x299 = ((uint64_t)x298 + x259);
  fiat_p384_mulx_u64(&x300, &x301, x4, (arg2[5]));
  fiat_p384_mulx_u64(&x302, &x303, x4, (arg2[4]));
  fiat_p384_mulx_u64(&x304, &x305, x4, (arg2[3]));
  fiat_p384_mulx_u64(&x306, &x307, x4, (arg2[2]));
  fiat_p384_mulx_u64(&x308, &x309, x4, (arg2[1]));
  fiat_p384_mulx_u64(&x310, &x311, x4, (arg2[0]));
  fiat_p384_addcarryx_u64(&x312, &x313, 0x0, x311, x308);
  fiat_p384_addcarryx_u64(&x314, &x315, x313, x309, x306);
  fiat_p384_addcarryx_u64(&x316, &x317, x315, x307, x304);
  fiat_p384_addcarryx_u64(&x318, &x319, x317, x305, x302);
  fiat_p384_addcarryx_u64(&x320, &x321, x319, x303, x300);
  x322 = (x321 + x301);
  fiat_p384_addcarryx_u64(&x323, &x324, 0x0, x287, x310);
  fiat_p384_addcarryx_u64(&x325, &x326, x324, x289, x312);
  fiat_p384_addcarryx_u64(&x327, &x328, x326, x291, x314);
  fiat_p384_addcarryx_u64(&x329, &x330, x328, x293, x316);
  fiat_p384_addcarryx_u64(&x331, &x332, x330, x295, x318);
  fiat_p384_addcarryx_u64(&x333, &x334, x332, x297, x320);
  fiat_p384_addcarryx_u64(&x335, &x336, x334, x299, x322);
  fiat_p384_mulx_u64(&x337, &x338, x323, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x339, &x340, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x341, &x342, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x343, &x344, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x345, &x346, x337, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x347, &x348, x337, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x349, &x350, x337, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x351, &x352, 0x0, x350, x347);
  fiat_p384_addcarryx_u64(&x353, &x354, x352, x348, x345);
  fiat_p384_addcarryx_u64(&x355, &x356, x354, x346, x343);
  fiat_p384_addcarryx_u64(&x357, &x358, x356, x344, x341);
  fiat_p384_addcarryx_u64(&x359, &x360, x358, x342, x339);
  x361 = (x360 + x340);
  fiat_p384_addcarryx_u64(&x362, &x363, 0x0, x323, x349);
  fiat_p384_addcarryx_u64(&x364, &x365, x363, x325, x351);
  fiat_p384_addcarryx_u64(&x366, &x367, x365, x327, x353);
  fiat_p384_addcarryx_u64(&x368, &x369, x367, x329, x355);
  fiat_p384_addcarryx_u64(&x370, &x371, x369, x331, x357);
  fiat_p384_addcarryx_u64(&x372, &x373, x371, x333, x359);
  fiat_p384_addcarryx_u64(&x374, &x375, x373, x335, x361);
  x376 = ((uint64_t)x375 + x336);
  fiat_p384_mulx_u64(&x377, &x378, x5, (arg2[5]));
  fiat_p384_mulx_u64(&x379, &x380, x5, (arg2[4]));
  fiat_p384_mulx_u64(&x381, &x382, x5, (arg2[3]));
  fiat_p384_mulx_u64(&x383, &x384, x5, (arg2[2]));
  fiat_p384_mulx_u64(&x385, &x386, x5, (arg2[1]));
  fiat_p384_mulx_u64(&x387, &x388, x5, (arg2[0]));
  fiat_p384_addcarryx_u64(&x389, &x390, 0x0, x388, x385);
  fiat_p384_addcarryx_u64(&x391, &x392, x390, x386, x383);
  fiat_p384_addcarryx_u64(&x393, &x394, x392, x384, x381);
  fiat_p384_addcarryx_u64(&x395, &x396, x394, x382, x379);
  fiat_p384_addcarryx_u64(&x397, &x398, x396, x380, x377);
  x399 = (x398 + x378);
  fiat_p384_addcarryx_u64(&x400, &x401, 0x0, x364, x387);
  fiat_p384_addcarryx_u64(&x402, &x403, x401, x366, x389);
  fiat_p384_addcarryx_u64(&x404, &x405, x403, x368, x391);
  fiat_p384_addcarryx_u64(&x406, &x407, x405, x370, x393);
  fiat_p384_addcarryx_u64(&x408, &x409, x407, x372, x395);
  fiat_p384_addcarryx_u64(&x410, &x411, x409, x374, x397);
  fiat_p384_addcarryx_u64(&x412, &x413, x411, x376, x399);
  fiat_p384_mulx_u64(&x414, &x415, x400, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x416, &x417, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x418, &x419, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x420, &x421, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x422, &x423, x414, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x424, &x425, x414, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x426, &x427, x414, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x428, &x429, 0x0, x427, x424);
  fiat_p384_addcarryx_u64(&x430, &x431, x429, x425, x422);
  fiat_p384_addcarryx_u64(&x432, &x433, x431, x423, x420);
  fiat_p384_addcarryx_u64(&x434, &x435, x433, x421, x418);
  fiat_p384_addcarryx_u64(&x436, &x437, x435, x419, x416);
  x438 = (x437 + x417);
  fiat_p384_addcarryx_u64(&x439, &x440, 0x0, x400, x426);
  fiat_p384_addcarryx_u64(&x441, &x442, x440, x402, x428);
  fiat_p384_addcarryx_u64(&x443, &x444, x442, x404, x430);
  fiat_p384_addcarryx_u64(&x445, &x446, x444, x406, x432);
  fiat_p384_addcarryx_u64(&x447, &x448, x446, x408, x434);
  fiat_p384_addcarryx_u64(&x449, &x450, x448, x410, x436);
  fiat_p384_addcarryx_u64(&x451, &x452, x450, x412, x438);
  x453 = ((uint64_t)x452 + x413);
  fiat_p384_subborrowx_u64(&x454, &x455, 0x0, x441, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x456, &x457, x455, x443, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x458, &x459, x457, x445, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x460, &x461, x459, x447, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x462, &x463, x461, x449, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x464, &x465, x463, x451, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x466, &x467, x465, x453, 0x0);
  fiat_p384_cmovznz_u64(&x468, x467, x454, x441);
  fiat_p384_cmovznz_u64(&x469, x467, x456, x443);
  fiat_p384_cmovznz_u64(&x470, x467, x458, x445);
  fiat_p384_cmovznz_u64(&x471, x467, x460, x447);
  fiat_p384_cmovznz_u64(&x472, x467, x462, x449);
  fiat_p384_cmovznz_u64(&x473, x467, x464, x451);
  out1[0] = x468;
  out1[1] = x469;
  out1[2] = x470;
  out1[3] = x471;
  out1[4] = x472;
  out1[5] = x473;
}

/*
 * The function fiat_p384_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_square(uint64_t out1[6], const uint64_t arg1[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint64_t x16;
  uint64_t x17;
  uint64_t x18;
  uint64_t x19;
  fiat_p384_uint1 x20;
  uint64_t x21;
  fiat_p384_uint1 x22;
  uint64_t x23;
  fiat_p384_uint1 x24;
  uint64_t x25;
  fiat_p384_uint1 x26;
  uint64_t x27;
  fiat_p384_uint1 x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint64_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  uint64_t x38;
  uint64_t x39;
  uint64_t x40;
  uint64_t x41;
  uint64_t x42;
  uint64_t x43;
  uint64_t x44;
  fiat_p384_uint1 x45;
  uint64_t x46;
  fiat_p384_uint1 x47;
  uint64_t x48;
  fiat_p384_uint1 x49;
  uint64_t x50;
  fiat_p384_uint1 x51;
  uint64_t x52;
  fiat_p384_uint1 x53;
  uint64_t x54;
  uint64_t x55;
  fiat_p384_uint1 x56;
  uint64_t x57;
  fiat_p384_uint1 x58;
  uint64_t x59;
  fiat_p384_uint1 x60;
  uint64_t x61;
  fiat_p384_uint1 x62;
  uint64_t x63;
  fiat_p384_uint1 x64;
  uint64_t x65;
  fiat_p384_uint1 x66;
  uint64_t x67;
  fiat_p384_uint1 x68;
  uint64_t x69;
  uint64_t x70;
  uint64_t x71;
  uint64_t x72;
  uint64_t x73;
  uint64_t x74;
  uint64_t x75;
  uint64_t x76;
  uint64_t x77;
  uint64_t x78;
  uint64_t x79;
  uint64_t x80;
  uint64_t x81;
  fiat_p384_uint1 x82;
  uint64_t x83;
  fiat_p384_uint1 x84;
  uint64_t x85;
  fiat_p384_uint1 x86;
  uint64_t x87;
  fiat_p384_uint1 x88;
  uint64_t x89;
  fiat_p384_uint1 x90;
  uint64_t x91;
  uint64_t x92;
  fiat_p384_uint1 x93;
  uint64_t x94;
  fiat_p384_uint1 x95;
  uint64_t x96;
  fiat_p384_uint1 x97;
  uint64_t x98;
  fiat_p384_uint1 x99;
  uint64_t x100;
  fiat_p384_uint1 x101;
  uint64_t x102;
  fiat_p384_uint1 x103;
  uint64_t x104;
  fiat_p384_uint1 x105;
  uint64_t x106;
  uint64_t x107;
  uint64_t x108;
  uint64_t x109;
  uint64_t x110;
  uint64_t x111;
  uint64_t x112;
  uint64_t x113;
  uint64_t x114;
  uint64_t x115;
  uint64_t x116;
  uint64_t x117;
  uint64_t x118;
  uint64_t x119;
  uint64_t x120;
  fiat_p384_uint1 x121;
  uint64_t x122;
  fiat_p384_uint1 x123;
  uint64_t x124;
  fiat_p384_uint1 x125;
  uint64_t x126;
  fiat_p384_uint1 x127;
  uint64_t x128;
  fiat_p384_uint1 x129;
  uint64_t x130;
  uint64_t x131;
  fiat_p384_uint1 x132;
  uint64_t x133;
  fiat_p384_uint1 x134;
  uint64_t x135;
  fiat_p384_uint1 x136;
  uint64_t x137;
  fiat_p384_uint1 x138;
  uint64_t x139;
  fiat_p384_uint1 x140;
  uint64_t x141;
  fiat_p384_uint1 x142;
  uint64_t x143;
  fiat_p384_uint1 x144;
  uint64_t x145;
  uint64_t x146;
  uint64_t x147;
  uint64_t x148;
  uint64_t x149;
  uint64_t x150;
  uint64_t x151;
  uint64_t x152;
  uint64_t x153;
  uint64_t x154;
  uint64_t x155;
  uint64_t x156;
  uint64_t x157;
  uint64_t x158;
  fiat_p384_uint1 x159;
  uint64_t x160;
  fiat_p384_uint1 x161;
  uint64_t x162;
  fiat_p384_uint1 x163;
  uint64_t x164;
  fiat_p384_uint1 x165;
  uint64_t x166;
  fiat_p384_uint1 x167;
  uint64_t x168;
  uint64_t x169;
  fiat_p384_uint1 x170;
  uint64_t x171;
  fiat_p384_uint1 x172;
  uint64_t x173;
  fiat_p384_uint1 x174;
  uint64_t x175;
  fiat_p384_uint1 x176;
  uint64_t x177;
  fiat_p384_uint1 x178;
  uint64_t x179;
  fiat_p384_uint1 x180;
  uint64_t x181;
  fiat_p384_uint1 x182;
  uint64_t x183;
  uint64_t x184;
  uint64_t x185;
  uint64_t x186;
  uint64_t x187;
  uint64_t x188;
  uint64_t x189;
  uint64_t x190;
  uint64_t x191;
  uint64_t x192;
  uint64_t x193;
  uint64_t x194;
  uint64_t x195;
  uint64_t x196;
  uint64_t x197;
  fiat_p384_uint1 x198;
  uint64_t x199;
  fiat_p384_uint1 x200;
  uint64_t x201;
  fiat_p384_uint1 x202;
  uint64_t x203;
  fiat_p384_uint1 x204;
  uint64_t x205;
  fiat_p384_uint1 x206;
  uint64_t x207;
  uint64_t x208;
  fiat_p384_uint1 x209;
  uint64_t x210;
  fiat_p384_uint1 x211;
  uint64_t x212;
  fiat_p384_uint1 x213;
  uint64_t x214;
  fiat_p384_uint1 x215;
  uint64_t x216;
  fiat_p384_uint1 x217;
  uint64_t x218;
  fiat_p384_uint1 x219;
  uint64_t x220;
  fiat_p384_uint1 x221;
  uint64_t x222;
  uint64_t x223;
  uint64_t x224;
  uint64_t x225;
  uint64_t x226;
  uint64_t x227;
  uint64_t x228;
  uint64_t x229;
  uint64_t x230;
  uint64_t x231;
  uint64_t x232;
  uint64_t x233;
  uint64_t x234;
  uint64_t x235;
  fiat_p384_uint1 x236;
  uint64_t x237;
  fiat_p384_uint1 x238;
  uint64_t x239;
  fiat_p384_uint1 x240;
  uint64_t x241;
  fiat_p384_uint1 x242;
  uint64_t x243;
  fiat_p384_uint1 x244;
  uint64_t x245;
  uint64_t x246;
  fiat_p384_uint1 x247;
  uint64_t x248;
  fiat_p384_uint1 x249;
  uint64_t x250;
  fiat_p384_uint1 x251;
  uint64_t x252;
  fiat_p384_uint1 x253;
  uint64_t x254;
  fiat_p384_uint1 x255;
  uint64_t x256;
  fiat_p384_uint1 x257;
  uint64_t x258;
  fiat_p384_uint1 x259;
  uint64_t x260;
  uint64_t x261;
  uint64_t x262;
  uint64_t x263;
  uint64_t x264;
  uint64_t x265;
  uint64_t x266;
  uint64_t x267;
  uint64_t x268;
  uint64_t x269;
  uint64_t x270;
  uint64_t x271;
  uint64_t x272;
  uint64_t x273;
  uint64_t x274;
  fiat_p384_uint1 x275;
  uint64_t x276;
  fiat_p384_uint1 x277;
  uint64_t x278;
  fiat_p384_uint1 x279;
  uint64_t x280;
  fiat_p384_uint1 x281;
  uint64_t x282;
  fiat_p384_uint1 x283;
  uint64_t x284;
  uint64_t x285;
  fiat_p384_uint1 x286;
  uint64_t x287;
  fiat_p384_uint1 x288;
  uint64_t x289;
  fiat_p384_uint1 x290;
  uint64_t x291;
  fiat_p384_uint1 x292;
  uint64_t x293;
  fiat_p384_uint1 x294;
  uint64_t x295;
  fiat_p384_uint1 x296;
  uint64_t x297;
  fiat_p384_uint1 x298;
  uint64_t x299;
  uint64_t x300;
  uint64_t x301;
  uint64_t x302;
  uint64_t x303;
  uint64_t x304;
  uint64_t x305;
  uint64_t x306;
  uint64_t x307;
  uint64_t x308;
  uint64_t x309;
  uint64_t x310;
  uint64_t x311;
  uint64_t x312;
  fiat_p384_uint1 x313;
  uint64_t x314;
  fiat_p384_uint1 x315;
  uint64_t x316;
  fiat_p384_uint1 x317;
  uint64_t x318;
  fiat_p384_uint1 x319;
  uint64_t x320;
  fiat_p384_uint1 x321;
  uint64_t x322;
  uint64_t x323;
  fiat_p384_uint1 x324;
  uint64_t x325;
  fiat_p384_uint1 x326;
  uint64_t x327;
  fiat_p384_uint1 x328;
  uint64_t x329;
  fiat_p384_uint1 x330;
  uint64_t x331;
  fiat_p384_uint1 x332;
  uint64_t x333;
  fiat_p384_uint1 x334;
  uint64_t x335;
  fiat_p384_uint1 x336;
  uint64_t x337;
  uint64_t x338;
  uint64_t x339;
  uint64_t x340;
  uint64_t x341;
  uint64_t x342;
  uint64_t x343;
  uint64_t x344;
  uint64_t x345;
  uint64_t x346;
  uint64_t x347;
  uint64_t x348;
  uint64_t x349;
  uint64_t x350;
  uint64_t x351;
  fiat_p384_uint1 x352;
  uint64_t x353;
  fiat_p384_uint1 x354;
  uint64_t x355;
  fiat_p384_uint1 x356;
  uint64_t x357;
  fiat_p384_uint1 x358;
  uint64_t x359;
  fiat_p384_uint1 x360;
  uint64_t x361;
  uint64_t x362;
  fiat_p384_uint1 x363;
  uint64_t x364;
  fiat_p384_uint1 x365;
  uint64_t x366;
  fiat_p384_uint1 x367;
  uint64_t x368;
  fiat_p384_uint1 x369;
  uint64_t x370;
  fiat_p384_uint1 x371;
  uint64_t x372;
  fiat_p384_uint1 x373;
  uint64_t x374;
  fiat_p384_uint1 x375;
  uint64_t x376;
  uint64_t x377;
  uint64_t x378;
  uint64_t x379;
  uint64_t x380;
  uint64_t x381;
  uint64_t x382;
  uint64_t x383;
  uint64_t x384;
  uint64_t x385;
  uint64_t x386;
  uint64_t x387;
  uint64_t x388;
  uint64_t x389;
  fiat_p384_uint1 x390;
  uint64_t x391;
  fiat_p384_uint1 x392;
  uint64_t x393;
  fiat_p384_uint1 x394;
  uint64_t x395;
  fiat_p384_uint1 x396;
  uint64_t x397;
  fiat_p384_uint1 x398;
  uint64_t x399;
  uint64_t x400;
  fiat_p384_uint1 x401;
  uint64_t x402;
  fiat_p384_uint1 x403;
  uint64_t x404;
  fiat_p384_uint1 x405;
  uint64_t x406;
  fiat_p384_uint1 x407;
  uint64_t x408;
  fiat_p384_uint1 x409;
  uint64_t x410;
  fiat_p384_uint1 x411;
  uint64_t x412;
  fiat_p384_uint1 x413;
  uint64_t x414;
  uint64_t x415;
  uint64_t x416;
  uint64_t x417;
  uint64_t x418;
  uint64_t x419;
  uint64_t x420;
  uint64_t x421;
  uint64_t x422;
  uint64_t x423;
  uint64_t x424;
  uint64_t x425;
  uint64_t x426;
  uint64_t x427;
  uint64_t x428;
  fiat_p384_uint1 x429;
  uint64_t x430;
  fiat_p384_uint1 x431;
  uint64_t x432;
  fiat_p384_uint1 x433;
  uint64_t x434;
  fiat_p384_uint1 x435;
  uint64_t x436;
  fiat_p384_uint1 x437;
  uint64_t x438;
  uint64_t x439;
  fiat_p384_uint1 x440;
  uint64_t x441;
  fiat_p384_uint1 x442;
  uint64_t x443;
  fiat_p384_uint1 x444;
  uint64_t x445;
  fiat_p384_uint1 x446;
  uint64_t x447;
  fiat_p384_uint1 x448;
  uint64_t x449;
  fiat_p384_uint1 x450;
  uint64_t x451;
  fiat_p384_uint1 x452;
  uint64_t x453;
  uint64_t x454;
  fiat_p384_uint1 x455;
  uint64_t x456;
  fiat_p384_uint1 x457;
  uint64_t x458;
  fiat_p384_uint1 x459;
  uint64_t x460;
  fiat_p384_uint1 x461;
  uint64_t x462;
  fiat_p384_uint1 x463;
  uint64_t x464;
  fiat_p384_uint1 x465;
  uint64_t x466;
  fiat_p384_uint1 x467;
  uint64_t x468;
  uint64_t x469;
  uint64_t x470;
  uint64_t x471;
  uint64_t x472;
  uint64_t x473;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[0]);
  fiat_p384_mulx_u64(&x7, &x8, x6, (arg1[5]));
  fiat_p384_mulx_u64(&x9, &x10, x6, (arg1[4]));
  fiat_p384_mulx_u64(&x11, &x12, x6, (arg1[3]));
  fiat_p384_mulx_u64(&x13, &x14, x6, (arg1[2]));
  fiat_p384_mulx_u64(&x15, &x16, x6, (arg1[1]));
  fiat_p384_mulx_u64(&x17, &x18, x6, (arg1[0]));
  fiat_p384_addcarryx_u64(&x19, &x20, 0x0, x18, x15);
  fiat_p384_addcarryx_u64(&x21, &x22, x20, x16, x13);
  fiat_p384_addcarryx_u64(&x23, &x24, x22, x14, x11);
  fiat_p384_addcarryx_u64(&x25, &x26, x24, x12, x9);
  fiat_p384_addcarryx_u64(&x27, &x28, x26, x10, x7);
  x29 = (x28 + x8);
  fiat_p384_mulx_u64(&x30, &x31, x17, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x32, &x33, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x34, &x35, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x36, &x37, x30, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x38, &x39, x30, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x40, &x41, x30, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x42, &x43, x30, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x44, &x45, 0x0, x43, x40);
  fiat_p384_addcarryx_u64(&x46, &x47, x45, x41, x38);
  fiat_p384_addcarryx_u64(&x48, &x49, x47, x39, x36);
  fiat_p384_addcarryx_u64(&x50, &x51, x49, x37, x34);
  fiat_p384_addcarryx_u64(&x52, &x53, x51, x35, x32);
  x54 = (x53 + x33);
  fiat_p384_addcarryx_u64(&x55, &x56, 0x0, x17, x42);
  fiat_p384_addcarryx_u64(&x57, &x58, x56, x19, x44);
  fiat_p384_addcarryx_u64(&x59, &x60, x58, x21, x46);
  fiat_p384_addcarryx_u64(&x61, &x62, x60, x23, x48);
  fiat_p384_addcarryx_u64(&x63, &x64, x62, x25, x50);
  fiat_p384_addcarryx_u64(&x65, &x66, x64, x27, x52);
  fiat_p384_addcarryx_u64(&x67, &x68, x66, x29, x54);
  fiat_p384_mulx_u64(&x69, &x70, x1, (arg1[5]));
  fiat_p384_mulx_u64(&x71, &x72, x1, (arg1[4]));
  fiat_p384_mulx_u64(&x73, &x74, x1, (arg1[3]));
  fiat_p384_mulx_u64(&x75, &x76, x1, (arg1[2]));
  fiat_p384_mulx_u64(&x77, &x78, x1, (arg1[1]));
  fiat_p384_mulx_u64(&x79, &x80, x1, (arg1[0]));
  fiat_p384_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
  fiat_p384_addcarryx_u64(&x83, &x84, x82, x78, x75);
  fiat_p384_addcarryx_u64(&x85, &x86, x84, x76, x73);
  fiat_p384_addcarryx_u64(&x87, &x88, x86, x74, x71);
  fiat_p384_addcarryx_u64(&x89, &x90, x88, x72, x69);
  x91 = (x90 + x70);
  fiat_p384_addcarryx_u64(&x92, &x93, 0x0, x57, x79);
  fiat_p384_addcarryx_u64(&x94, &x95, x93, x59, x81);
  fiat_p384_addcarryx_u64(&x96, &x97, x95, x61, x83);
  fiat_p384_addcarryx_u64(&x98, &x99, x97, x63, x85);
  fiat_p384_addcarryx_u64(&x100, &x101, x99, x65, x87);
  fiat_p384_addcarryx_u64(&x102, &x103, x101, x67, x89);
  fiat_p384_addcarryx_u64(&x104, &x105, x103, x68, x91);
  fiat_p384_mulx_u64(&x106, &x107, x92, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x108, &x109, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x110, &x111, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x112, &x113, x106, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x114, &x115, x106, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x116, &x117, x106, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x118, &x119, x106, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x120, &x121, 0x0, x119, x116);
  fiat_p384_addcarryx_u64(&x122, &x123, x121, x117, x114);
  fiat_p384_addcarryx_u64(&x124, &x125, x123, x115, x112);
  fiat_p384_addcarryx_u64(&x126, &x127, x125, x113, x110);
  fiat_p384_addcarryx_u64(&x128, &x129, x127, x111, x108);
  x130 = (x129 + x109);
  fiat_p384_addcarryx_u64(&x131, &x132, 0x0, x92, x118);
  fiat_p384_addcarryx_u64(&x133, &x134, x132, x94, x120);
  fiat_p384_addcarryx_u64(&x135, &x136, x134, x96, x122);
  fiat_p384_addcarryx_u64(&x137, &x138, x136, x98, x124);
  fiat_p384_addcarryx_u64(&x139, &x140, x138, x100, x126);
  fiat_p384_addcarryx_u64(&x141, &x142, x140, x102, x128);
  fiat_p384_addcarryx_u64(&x143, &x144, x142, x104, x130);
  x145 = ((uint64_t)x144 + x105);
  fiat_p384_mulx_u64(&x146, &x147, x2, (arg1[5]));
  fiat_p384_mulx_u64(&x148, &x149, x2, (arg1[4]));
  fiat_p384_mulx_u64(&x150, &x151, x2, (arg1[3]));
  fiat_p384_mulx_u64(&x152, &x153, x2, (arg1[2]));
  fiat_p384_mulx_u64(&x154, &x155, x2, (arg1[1]));
  fiat_p384_mulx_u64(&x156, &x157, x2, (arg1[0]));
  fiat_p384_addcarryx_u64(&x158, &x159, 0x0, x157, x154);
  fiat_p384_addcarryx_u64(&x160, &x161, x159, x155, x152);
  fiat_p384_addcarryx_u64(&x162, &x163, x161, x153, x150);
  fiat_p384_addcarryx_u64(&x164, &x165, x163, x151, x148);
  fiat_p384_addcarryx_u64(&x166, &x167, x165, x149, x146);
  x168 = (x167 + x147);
  fiat_p384_addcarryx_u64(&x169, &x170, 0x0, x133, x156);
  fiat_p384_addcarryx_u64(&x171, &x172, x170, x135, x158);
  fiat_p384_addcarryx_u64(&x173, &x174, x172, x137, x160);
  fiat_p384_addcarryx_u64(&x175, &x176, x174, x139, x162);
  fiat_p384_addcarryx_u64(&x177, &x178, x176, x141, x164);
  fiat_p384_addcarryx_u64(&x179, &x180, x178, x143, x166);
  fiat_p384_addcarryx_u64(&x181, &x182, x180, x145, x168);
  fiat_p384_mulx_u64(&x183, &x184, x169, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x185, &x186, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x187, &x188, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x189, &x190, x183, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x191, &x192, x183, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x193, &x194, x183, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x195, &x196, x183, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x197, &x198, 0x0, x196, x193);
  fiat_p384_addcarryx_u64(&x199, &x200, x198, x194, x191);
  fiat_p384_addcarryx_u64(&x201, &x202, x200, x192, x189);
  fiat_p384_addcarryx_u64(&x203, &x204, x202, x190, x187);
  fiat_p384_addcarryx_u64(&x205, &x206, x204, x188, x185);
  x207 = (x206 + x186);
  fiat_p384_addcarryx_u64(&x208, &x209, 0x0, x169, x195);
  fiat_p384_addcarryx_u64(&x210, &x211, x209, x171, x197);
  fiat_p384_addcarryx_u64(&x212, &x213, x211, x173, x199);
  fiat_p384_addcarryx_u64(&x214, &x215, x213, x175, x201);
  fiat_p384_addcarryx_u64(&x216, &x217, x215, x177, x203);
  fiat_p384_addcarryx_u64(&x218, &x219, x217, x179, x205);
  fiat_p384_addcarryx_u64(&x220, &x221, x219, x181, x207);
  x222 = ((uint64_t)x221 + x182);
  fiat_p384_mulx_u64(&x223, &x224, x3, (arg1[5]));
  fiat_p384_mulx_u64(&x225, &x226, x3, (arg1[4]));
  fiat_p384_mulx_u64(&x227, &x228, x3, (arg1[3]));
  fiat_p384_mulx_u64(&x229, &x230, x3, (arg1[2]));
  fiat_p384_mulx_u64(&x231, &x232, x3, (arg1[1]));
  fiat_p384_mulx_u64(&x233, &x234, x3, (arg1[0]));
  fiat_p384_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
  fiat_p384_addcarryx_u64(&x237, &x238, x236, x232, x229);
  fiat_p384_addcarryx_u64(&x239, &x240, x238, x230, x227);
  fiat_p384_addcarryx_u64(&x241, &x242, x240, x228, x225);
  fiat_p384_addcarryx_u64(&x243, &x244, x242, x226, x223);
  x245 = (x244 + x224);
  fiat_p384_addcarryx_u64(&x246, &x247, 0x0, x210, x233);
  fiat_p384_addcarryx_u64(&x248, &x249, x247, x212, x235);
  fiat_p384_addcarryx_u64(&x250, &x251, x249, x214, x237);
  fiat_p384_addcarryx_u64(&x252, &x253, x251, x216, x239);
  fiat_p384_addcarryx_u64(&x254, &x255, x253, x218, x241);
  fiat_p384_addcarryx_u64(&x256, &x257, x255, x220, x243);
  fiat_p384_addcarryx_u64(&x258, &x259, x257, x222, x245);
  fiat_p384_mulx_u64(&x260, &x261, x246, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x262, &x263, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x264, &x265, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x266, &x267, x260, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x268, &x269, x260, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x270, &x271, x260, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x272, &x273, x260, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x274, &x275, 0x0, x273, x270);
  fiat_p384_addcarryx_u64(&x276, &x277, x275, x271, x268);
  fiat_p384_addcarryx_u64(&x278, &x279, x277, x269, x266);
  fiat_p384_addcarryx_u64(&x280, &x281, x279, x267, x264);
  fiat_p384_addcarryx_u64(&x282, &x283, x281, x265, x262);
  x284 = (x283 + x263);
  fiat_p384_addcarryx_u64(&x285, &x286, 0x0, x246, x272);
  fiat_p384_addcarryx_u64(&x287, &x288, x286, x248, x274);
  fiat_p384_addcarryx_u64(&x289, &x290, x288, x250, x276);
  fiat_p384_addcarryx_u64(&x291, &x292, x290, x252, x278);
  fiat_p384_addcarryx_u64(&x293, &x294, x292, x254, x280);
  fiat_p384_addcarryx_u64(&x295, &x296, x294, x256, x282);
  fiat_p384_addcarryx_u64(&x297, &x298, x296, x258, x284);
  x299 = ((uint64_t)x298 + x259);
  fiat_p384_mulx_u64(&x300, &x301, x4, (arg1[5]));
  fiat_p384_mulx_u64(&x302, &x303, x4, (arg1[4]));
  fiat_p384_mulx_u64(&x304, &x305, x4, (arg1[3]));
  fiat_p384_mulx_u64(&x306, &x307, x4, (arg1[2]));
  fiat_p384_mulx_u64(&x308, &x309, x4, (arg1[1]));
  fiat_p384_mulx_u64(&x310, &x311, x4, (arg1[0]));
  fiat_p384_addcarryx_u64(&x312, &x313, 0x0, x311, x308);
  fiat_p384_addcarryx_u64(&x314, &x315, x313, x309, x306);
  fiat_p384_addcarryx_u64(&x316, &x317, x315, x307, x304);
  fiat_p384_addcarryx_u64(&x318, &x319, x317, x305, x302);
  fiat_p384_addcarryx_u64(&x320, &x321, x319, x303, x300);
  x322 = (x321 + x301);
  fiat_p384_addcarryx_u64(&x323, &x324, 0x0, x287, x310);
  fiat_p384_addcarryx_u64(&x325, &x326, x324, x289, x312);
  fiat_p384_addcarryx_u64(&x327, &x328, x326, x291, x314);
  fiat_p384_addcarryx_u64(&x329, &x330, x328, x293, x316);
  fiat_p384_addcarryx_u64(&x331, &x332, x330, x295, x318);
  fiat_p384_addcarryx_u64(&x333, &x334, x332, x297, x320);
  fiat_p384_addcarryx_u64(&x335, &x336, x334, x299, x322);
  fiat_p384_mulx_u64(&x337, &x338, x323, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x339, &x340, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x341, &x342, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x343, &x344, x337, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x345, &x346, x337, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x347, &x348, x337, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x349, &x350, x337, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x351, &x352, 0x0, x350, x347);
  fiat_p384_addcarryx_u64(&x353, &x354, x352, x348, x345);
  fiat_p384_addcarryx_u64(&x355, &x356, x354, x346, x343);
  fiat_p384_addcarryx_u64(&x357, &x358, x356, x344, x341);
  fiat_p384_addcarryx_u64(&x359, &x360, x358, x342, x339);
  x361 = (x360 + x340);
  fiat_p384_addcarryx_u64(&x362, &x363, 0x0, x323, x349);
  fiat_p384_addcarryx_u64(&x364, &x365, x363, x325, x351);
  fiat_p384_addcarryx_u64(&x366, &x367, x365, x327, x353);
  fiat_p384_addcarryx_u64(&x368, &x369, x367, x329, x355);
  fiat_p384_addcarryx_u64(&x370, &x371, x369, x331, x357);
  fiat_p384_addcarryx_u64(&x372, &x373, x371, x333, x359);
  fiat_p384_addcarryx_u64(&x374, &x375, x373, x335, x361);
  x376 = ((uint64_t)x375 + x336);
  fiat_p384_mulx_u64(&x377, &x378, x5, (arg1[5]));
  fiat_p384_mulx_u64(&x379, &x380, x5, (arg1[4]));
  fiat_p384_mulx_u64(&x381, &x382, x5, (arg1[3]));
  fiat_p384_mulx_u64(&x383, &x384, x5, (arg1[2]));
  fiat_p384_mulx_u64(&x385, &x386, x5, (arg1[1]));
  fiat_p384_mulx_u64(&x387, &x388, x5, (arg1[0]));
  fiat_p384_addcarryx_u64(&x389, &x390, 0x0, x388, x385);
  fiat_p384_addcarryx_u64(&x391, &x392, x390, x386, x383);
  fiat_p384_addcarryx_u64(&x393, &x394, x392, x384, x381);
  fiat_p384_addcarryx_u64(&x395, &x396, x394, x382, x379);
  fiat_p384_addcarryx_u64(&x397, &x398, x396, x380, x377);
  x399 = (x398 + x378);
  fiat_p384_addcarryx_u64(&x400, &x401, 0x0, x364, x387);
  fiat_p384_addcarryx_u64(&x402, &x403, x401, x366, x389);
  fiat_p384_addcarryx_u64(&x404, &x405, x403, x368, x391);
  fiat_p384_addcarryx_u64(&x406, &x407, x405, x370, x393);
  fiat_p384_addcarryx_u64(&x408, &x409, x407, x372, x395);
  fiat_p384_addcarryx_u64(&x410, &x411, x409, x374, x397);
  fiat_p384_addcarryx_u64(&x412, &x413, x411, x376, x399);
  fiat_p384_mulx_u64(&x414, &x415, x400, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x416, &x417, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x418, &x419, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x420, &x421, x414, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x422, &x423, x414, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x424, &x425, x414, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x426, &x427, x414, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x428, &x429, 0x0, x427, x424);
  fiat_p384_addcarryx_u64(&x430, &x431, x429, x425, x422);
  fiat_p384_addcarryx_u64(&x432, &x433, x431, x423, x420);
  fiat_p384_addcarryx_u64(&x434, &x435, x433, x421, x418);
  fiat_p384_addcarryx_u64(&x436, &x437, x435, x419, x416);
  x438 = (x437 + x417);
  fiat_p384_addcarryx_u64(&x439, &x440, 0x0, x400, x426);
  fiat_p384_addcarryx_u64(&x441, &x442, x440, x402, x428);
  fiat_p384_addcarryx_u64(&x443, &x444, x442, x404, x430);
  fiat_p384_addcarryx_u64(&x445, &x446, x444, x406, x432);
  fiat_p384_addcarryx_u64(&x447, &x448, x446, x408, x434);
  fiat_p384_addcarryx_u64(&x449, &x450, x448, x410, x436);
  fiat_p384_addcarryx_u64(&x451, &x452, x450, x412, x438);
  x453 = ((uint64_t)x452 + x413);
  fiat_p384_subborrowx_u64(&x454, &x455, 0x0, x441, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x456, &x457, x455, x443, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x458, &x459, x457, x445, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x460, &x461, x459, x447, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x462, &x463, x461, x449, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x464, &x465, x463, x451, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x466, &x467, x465, x453, 0x0);
  fiat_p384_cmovznz_u64(&x468, x467, x454, x441);
  fiat_p384_cmovznz_u64(&x469, x467, x456, x443);
  fiat_p384_cmovznz_u64(&x470, x467, x458, x445);
  fiat_p384_cmovznz_u64(&x471, x467, x460, x447);
  fiat_p384_cmovznz_u64(&x472, x467, x462, x449);
  fiat_p384_cmovznz_u64(&x473, x467, x464, x451);
  out1[0] = x468;
  out1[1] = x469;
  out1[2] = x470;
  out1[3] = x471;
  out1[4] = x472;
  out1[5] = x473;
}

/*
 * The function fiat_p384_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_add(uint64_t out1[6], const uint64_t arg1[6], const uint64_t arg2[6]) {
  uint64_t x1;
  fiat_p384_uint1 x2;
  uint64_t x3;
  fiat_p384_uint1 x4;
  uint64_t x5;
  fiat_p384_uint1 x6;
  uint64_t x7;
  fiat_p384_uint1 x8;
  uint64_t x9;
  fiat_p384_uint1 x10;
  uint64_t x11;
  fiat_p384_uint1 x12;
  uint64_t x13;
  fiat_p384_uint1 x14;
  uint64_t x15;
  fiat_p384_uint1 x16;
  uint64_t x17;
  fiat_p384_uint1 x18;
  uint64_t x19;
  fiat_p384_uint1 x20;
  uint64_t x21;
  fiat_p384_uint1 x22;
  uint64_t x23;
  fiat_p384_uint1 x24;
  uint64_t x25;
  fiat_p384_uint1 x26;
  uint64_t x27;
  uint64_t x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint64_t x32;
  fiat_p384_addcarryx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_p384_addcarryx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_p384_addcarryx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_p384_addcarryx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_p384_addcarryx_u64(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_p384_addcarryx_u64(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_p384_subborrowx_u64(&x13, &x14, 0x0, x1, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x15, &x16, x14, x3, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x17, &x18, x16, x5, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x19, &x20, x18, x7, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x21, &x22, x20, x9, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x23, &x24, x22, x11, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x25, &x26, x24, x12, 0x0);
  fiat_p384_cmovznz_u64(&x27, x26, x13, x1);
  fiat_p384_cmovznz_u64(&x28, x26, x15, x3);
  fiat_p384_cmovznz_u64(&x29, x26, x17, x5);
  fiat_p384_cmovznz_u64(&x30, x26, x19, x7);
  fiat_p384_cmovznz_u64(&x31, x26, x21, x9);
  fiat_p384_cmovznz_u64(&x32, x26, x23, x11);
  out1[0] = x27;
  out1[1] = x28;
  out1[2] = x29;
  out1[3] = x30;
  out1[4] = x31;
  out1[5] = x32;
}

/*
 * The function fiat_p384_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_sub(uint64_t out1[6], const uint64_t arg1[6], const uint64_t arg2[6]) {
  uint64_t x1;
  fiat_p384_uint1 x2;
  uint64_t x3;
  fiat_p384_uint1 x4;
  uint64_t x5;
  fiat_p384_uint1 x6;
  uint64_t x7;
  fiat_p384_uint1 x8;
  uint64_t x9;
  fiat_p384_uint1 x10;
  uint64_t x11;
  fiat_p384_uint1 x12;
  uint64_t x13;
  uint64_t x14;
  fiat_p384_uint1 x15;
  uint64_t x16;
  fiat_p384_uint1 x17;
  uint64_t x18;
  fiat_p384_uint1 x19;
  uint64_t x20;
  fiat_p384_uint1 x21;
  uint64_t x22;
  fiat_p384_uint1 x23;
  uint64_t x24;
  fiat_p384_uint1 x25;
  fiat_p384_subborrowx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_p384_subborrowx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_p384_subborrowx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_p384_subborrowx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_p384_subborrowx_u64(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_p384_subborrowx_u64(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_p384_cmovznz_u64(&x13, x12, 0x0, UINT64_C(0xffffffffffffffff));
  fiat_p384_addcarryx_u64(&x14, &x15, 0x0, x1, (x13 & UINT32_C(0xffffffff)));
  fiat_p384_addcarryx_u64(&x16, &x17, x15, x3, (x13 & UINT64_C(0xffffffff00000000)));
  fiat_p384_addcarryx_u64(&x18, &x19, x17, x5, (x13 & UINT64_C(0xfffffffffffffffe)));
  fiat_p384_addcarryx_u64(&x20, &x21, x19, x7, x13);
  fiat_p384_addcarryx_u64(&x22, &x23, x21, x9, x13);
  fiat_p384_addcarryx_u64(&x24, &x25, x23, x11, x13);
  out1[0] = x14;
  out1[1] = x16;
  out1[2] = x18;
  out1[3] = x20;
  out1[4] = x22;
  out1[5] = x24;
}

/*
 * The function fiat_p384_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_opp(uint64_t out1[6], const uint64_t arg1[6]) {
  uint64_t x1;
  fiat_p384_uint1 x2;
  uint64_t x3;
  fiat_p384_uint1 x4;
  uint64_t x5;
  fiat_p384_uint1 x6;
  uint64_t x7;
  fiat_p384_uint1 x8;
  uint64_t x9;
  fiat_p384_uint1 x10;
  uint64_t x11;
  fiat_p384_uint1 x12;
  uint64_t x13;
  uint64_t x14;
  fiat_p384_uint1 x15;
  uint64_t x16;
  fiat_p384_uint1 x17;
  uint64_t x18;
  fiat_p384_uint1 x19;
  uint64_t x20;
  fiat_p384_uint1 x21;
  uint64_t x22;
  fiat_p384_uint1 x23;
  uint64_t x24;
  fiat_p384_uint1 x25;
  fiat_p384_subborrowx_u64(&x1, &x2, 0x0, 0x0, (arg1[0]));
  fiat_p384_subborrowx_u64(&x3, &x4, x2, 0x0, (arg1[1]));
  fiat_p384_subborrowx_u64(&x5, &x6, x4, 0x0, (arg1[2]));
  fiat_p384_subborrowx_u64(&x7, &x8, x6, 0x0, (arg1[3]));
  fiat_p384_subborrowx_u64(&x9, &x10, x8, 0x0, (arg1[4]));
  fiat_p384_subborrowx_u64(&x11, &x12, x10, 0x0, (arg1[5]));
  fiat_p384_cmovznz_u64(&x13, x12, 0x0, UINT64_C(0xffffffffffffffff));
  fiat_p384_addcarryx_u64(&x14, &x15, 0x0, x1, (x13 & UINT32_C(0xffffffff)));
  fiat_p384_addcarryx_u64(&x16, &x17, x15, x3, (x13 & UINT64_C(0xffffffff00000000)));
  fiat_p384_addcarryx_u64(&x18, &x19, x17, x5, (x13 & UINT64_C(0xfffffffffffffffe)));
  fiat_p384_addcarryx_u64(&x20, &x21, x19, x7, x13);
  fiat_p384_addcarryx_u64(&x22, &x23, x21, x9, x13);
  fiat_p384_addcarryx_u64(&x24, &x25, x23, x11, x13);
  out1[0] = x14;
  out1[1] = x16;
  out1[2] = x18;
  out1[3] = x20;
  out1[4] = x22;
  out1[5] = x24;
}

/*
 * The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_from_montgomery(uint64_t out1[6], const uint64_t arg1[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint64_t x16;
  fiat_p384_uint1 x17;
  uint64_t x18;
  fiat_p384_uint1 x19;
  uint64_t x20;
  fiat_p384_uint1 x21;
  uint64_t x22;
  fiat_p384_uint1 x23;
  uint64_t x24;
  fiat_p384_uint1 x25;
  uint64_t x26;
  fiat_p384_uint1 x27;
  uint64_t x28;
  fiat_p384_uint1 x29;
  uint64_t x30;
  fiat_p384_uint1 x31;
  uint64_t x32;
  fiat_p384_uint1 x33;
  uint64_t x34;
  fiat_p384_uint1 x35;
  uint64_t x36;
  fiat_p384_uint1 x37;
  uint64_t x38;
  fiat_p384_uint1 x39;
  uint64_t x40;
  fiat_p384_uint1 x41;
  uint64_t x42;
  fiat_p384_uint1 x43;
  uint64_t x44;
  fiat_p384_uint1 x45;
  uint64_t x46;
  fiat_p384_uint1 x47;
  uint64_t x48;
  fiat_p384_uint1 x49;
  uint64_t x50;
  fiat_p384_uint1 x51;
  uint64_t x52;
  uint64_t x53;
  uint64_t x54;
  uint64_t x55;
  uint64_t x56;
  uint64_t x57;
  uint64_t x58;
  uint64_t x59;
  uint64_t x60;
  uint64_t x61;
  uint64_t x62;
  uint64_t x63;
  uint64_t x64;
  uint64_t x65;
  uint64_t x66;
  fiat_p384_uint1 x67;
  uint64_t x68;
  fiat_p384_uint1 x69;
  uint64_t x70;
  fiat_p384_uint1 x71;
  uint64_t x72;
  fiat_p384_uint1 x73;
  uint64_t x74;
  fiat_p384_uint1 x75;
  uint64_t x76;
  fiat_p384_uint1 x77;
  uint64_t x78;
  fiat_p384_uint1 x79;
  uint64_t x80;
  fiat_p384_uint1 x81;
  uint64_t x82;
  fiat_p384_uint1 x83;
  uint64_t x84;
  fiat_p384_uint1 x85;
  uint64_t x86;
  fiat_p384_uint1 x87;
  uint64_t x88;
  fiat_p384_uint1 x89;
  uint64_t x90;
  fiat_p384_uint1 x91;
  uint64_t x92;
  fiat_p384_uint1 x93;
  uint64_t x94;
  fiat_p384_uint1 x95;
  uint64_t x96;
  fiat_p384_uint1 x97;
  uint64_t x98;
  fiat_p384_uint1 x99;
  uint64_t x100;
  fiat_p384_uint1 x101;
  uint64_t x102;
  uint64_t x103;
  uint64_t x104;
  uint64_t x105;
  uint64_t x106;
  uint64_t x107;
  uint64_t x108;
  uint64_t x109;
  uint64_t x110;
  uint64_t x111;
  uint64_t x112;
  uint64_t x113;
  uint64_t x114;
  uint64_t x115;
  uint64_t x116;
  fiat_p384_uint1 x117;
  uint64_t x118;
  fiat_p384_uint1 x119;
  uint64_t x120;
  fiat_p384_uint1 x121;
  uint64_t x122;
  fiat_p384_uint1 x123;
  uint64_t x124;
  fiat_p384_uint1 x125;
  uint64_t x126;
  fiat_p384_uint1 x127;
  uint64_t x128;
  fiat_p384_uint1 x129;
  uint64_t x130;
  fiat_p384_uint1 x131;
  uint64_t x132;
  fiat_p384_uint1 x133;
  uint64_t x134;
  fiat_p384_uint1 x135;
  uint64_t x136;
  fiat_p384_uint1 x137;
  uint64_t x138;
  fiat_p384_uint1 x139;
  uint64_t x140;
  fiat_p384_uint1 x141;
  uint64_t x142;
  fiat_p384_uint1 x143;
  uint64_t x144;
  fiat_p384_uint1 x145;
  uint64_t x146;
  fiat_p384_uint1 x147;
  uint64_t x148;
  fiat_p384_uint1 x149;
  uint64_t x150;
  fiat_p384_uint1 x151;
  uint64_t x152;
  uint64_t x153;
  uint64_t x154;
  uint64_t x155;
  uint64_t x156;
  uint64_t x157;
  uint64_t x158;
  uint64_t x159;
  uint64_t x160;
  uint64_t x161;
  uint64_t x162;
  uint64_t x163;
  uint64_t x164;
  uint64_t x165;
  uint64_t x166;
  fiat_p384_uint1 x167;
  uint64_t x168;
  fiat_p384_uint1 x169;
  uint64_t x170;
  fiat_p384_uint1 x171;
  uint64_t x172;
  fiat_p384_uint1 x173;
  uint64_t x174;
  fiat_p384_uint1 x175;
  uint64_t x176;
  fiat_p384_uint1 x177;
  uint64_t x178;
  fiat_p384_uint1 x179;
  uint64_t x180;
  fiat_p384_uint1 x181;
  uint64_t x182;
  fiat_p384_uint1 x183;
  uint64_t x184;
  fiat_p384_uint1 x185;
  uint64_t x186;
  fiat_p384_uint1 x187;
  uint64_t x188;
  fiat_p384_uint1 x189;
  uint64_t x190;
  fiat_p384_uint1 x191;
  uint64_t x192;
  fiat_p384_uint1 x193;
  uint64_t x194;
  fiat_p384_uint1 x195;
  uint64_t x196;
  fiat_p384_uint1 x197;
  uint64_t x198;
  fiat_p384_uint1 x199;
  uint64_t x200;
  fiat_p384_uint1 x201;
  uint64_t x202;
  uint64_t x203;
  uint64_t x204;
  uint64_t x205;
  uint64_t x206;
  uint64_t x207;
  uint64_t x208;
  uint64_t x209;
  uint64_t x210;
  uint64_t x211;
  uint64_t x212;
  uint64_t x213;
  uint64_t x214;
  uint64_t x215;
  uint64_t x216;
  fiat_p384_uint1 x217;
  uint64_t x218;
  fiat_p384_uint1 x219;
  uint64_t x220;
  fiat_p384_uint1 x221;
  uint64_t x222;
  fiat_p384_uint1 x223;
  uint64_t x224;
  fiat_p384_uint1 x225;
  uint64_t x226;
  fiat_p384_uint1 x227;
  uint64_t x228;
  fiat_p384_uint1 x229;
  uint64_t x230;
  fiat_p384_uint1 x231;
  uint64_t x232;
  fiat_p384_uint1 x233;
  uint64_t x234;
  fiat_p384_uint1 x235;
  uint64_t x236;
  fiat_p384_uint1 x237;
  uint64_t x238;
  fiat_p384_uint1 x239;
  uint64_t x240;
  fiat_p384_uint1 x241;
  uint64_t x242;
  fiat_p384_uint1 x243;
  uint64_t x244;
  fiat_p384_uint1 x245;
  uint64_t x246;
  fiat_p384_uint1 x247;
  uint64_t x248;
  fiat_p384_uint1 x249;
  uint64_t x250;
  fiat_p384_uint1 x251;
  uint64_t x252;
  uint64_t x253;
  uint64_t x254;
  uint64_t x255;
  uint64_t x256;
  uint64_t x257;
  uint64_t x258;
  uint64_t x259;
  uint64_t x260;
  uint64_t x261;
  uint64_t x262;
  uint64_t x263;
  uint64_t x264;
  uint64_t x265;
  uint64_t x266;
  fiat_p384_uint1 x267;
  uint64_t x268;
  fiat_p384_uint1 x269;
  uint64_t x270;
  fiat_p384_uint1 x271;
  uint64_t x272;
  fiat_p384_uint1 x273;
  uint64_t x274;
  fiat_p384_uint1 x275;
  uint64_t x276;
  fiat_p384_uint1 x277;
  uint64_t x278;
  fiat_p384_uint1 x279;
  uint64_t x280;
  fiat_p384_uint1 x281;
  uint64_t x282;
  fiat_p384_uint1 x283;
  uint64_t x284;
  fiat_p384_uint1 x285;
  uint64_t x286;
  fiat_p384_uint1 x287;
  uint64_t x288;
  fiat_p384_uint1 x289;
  uint64_t x290;
  fiat_p384_uint1 x291;
  uint64_t x292;
  fiat_p384_uint1 x293;
  uint64_t x294;
  fiat_p384_uint1 x295;
  uint64_t x296;
  fiat_p384_uint1 x297;
  uint64_t x298;
  fiat_p384_uint1 x299;
  uint64_t x300;
  fiat_p384_uint1 x301;
  uint64_t x302;
  fiat_p384_uint1 x303;
  uint64_t x304;
  uint64_t x305;
  uint64_t x306;
  uint64_t x307;
  uint64_t x308;
  uint64_t x309;
  x1 = (arg1[0]);
  fiat_p384_mulx_u64(&x2, &x3, x1, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x4, &x5, x2, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x6, &x7, x2, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x8, &x9, x2, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x10, &x11, x2, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x12, &x13, x2, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x14, &x15, x2, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x16, &x17, 0x0, x15, x12);
  fiat_p384_addcarryx_u64(&x18, &x19, x17, x13, x10);
  fiat_p384_addcarryx_u64(&x20, &x21, x19, x11, x8);
  fiat_p384_addcarryx_u64(&x22, &x23, x21, x9, x6);
  fiat_p384_addcarryx_u64(&x24, &x25, x23, x7, x4);
  fiat_p384_addcarryx_u64(&x26, &x27, 0x0, x1, x14);
  fiat_p384_addcarryx_u64(&x28, &x29, x27, 0x0, x16);
  fiat_p384_addcarryx_u64(&x30, &x31, x29, 0x0, x18);
  fiat_p384_addcarryx_u64(&x32, &x33, x31, 0x0, x20);
  fiat_p384_addcarryx_u64(&x34, &x35, x33, 0x0, x22);
  fiat_p384_addcarryx_u64(&x36, &x37, x35, 0x0, x24);
  fiat_p384_addcarryx_u64(&x38, &x39, x37, 0x0, (x25 + x5));
  fiat_p384_addcarryx_u64(&x40, &x41, 0x0, x28, (arg1[1]));
  fiat_p384_addcarryx_u64(&x42, &x43, x41, x30, 0x0);
  fiat_p384_addcarryx_u64(&x44, &x45, x43, x32, 0x0);
  fiat_p384_addcarryx_u64(&x46, &x47, x45, x34, 0x0);
  fiat_p384_addcarryx_u64(&x48, &x49, x47, x36, 0x0);
  fiat_p384_addcarryx_u64(&x50, &x51, x49, x38, 0x0);
  fiat_p384_mulx_u64(&x52, &x53, x40, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x54, &x55, x52, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x56, &x57, x52, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x58, &x59, x52, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x60, &x61, x52, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x62, &x63, x52, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x64, &x65, x52, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x66, &x67, 0x0, x65, x62);
  fiat_p384_addcarryx_u64(&x68, &x69, x67, x63, x60);
  fiat_p384_addcarryx_u64(&x70, &x71, x69, x61, x58);
  fiat_p384_addcarryx_u64(&x72, &x73, x71, x59, x56);
  fiat_p384_addcarryx_u64(&x74, &x75, x73, x57, x54);
  fiat_p384_addcarryx_u64(&x76, &x77, 0x0, x40, x64);
  fiat_p384_addcarryx_u64(&x78, &x79, x77, x42, x66);
  fiat_p384_addcarryx_u64(&x80, &x81, x79, x44, x68);
  fiat_p384_addcarryx_u64(&x82, &x83, x81, x46, x70);
  fiat_p384_addcarryx_u64(&x84, &x85, x83, x48, x72);
  fiat_p384_addcarryx_u64(&x86, &x87, x85, x50, x74);
  fiat_p384_addcarryx_u64(&x88, &x89, x87, ((uint64_t)x51 + x39), (x75 + x55));
  fiat_p384_addcarryx_u64(&x90, &x91, 0x0, x78, (arg1[2]));
  fiat_p384_addcarryx_u64(&x92, &x93, x91, x80, 0x0);
  fiat_p384_addcarryx_u64(&x94, &x95, x93, x82, 0x0);
  fiat_p384_addcarryx_u64(&x96, &x97, x95, x84, 0x0);
  fiat_p384_addcarryx_u64(&x98, &x99, x97, x86, 0x0);
  fiat_p384_addcarryx_u64(&x100, &x101, x99, x88, 0x0);
  fiat_p384_mulx_u64(&x102, &x103, x90, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x104, &x105, x102, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x106, &x107, x102, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x108, &x109, x102, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x110, &x111, x102, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x112, &x113, x102, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x114, &x115, x102, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x116, &x117, 0x0, x115, x112);
  fiat_p384_addcarryx_u64(&x118, &x119, x117, x113, x110);
  fiat_p384_addcarryx_u64(&x120, &x121, x119, x111, x108);
  fiat_p384_addcarryx_u64(&x122, &x123, x121, x109, x106);
  fiat_p384_addcarryx_u64(&x124, &x125, x123, x107, x104);
  fiat_p384_addcarryx_u64(&x126, &x127, 0x0, x90, x114);
  fiat_p384_addcarryx_u64(&x128, &x129, x127, x92, x116);
  fiat_p384_addcarryx_u64(&x130, &x131, x129, x94, x118);
  fiat_p384_addcarryx_u64(&x132, &x133, x131, x96, x120);
  fiat_p384_addcarryx_u64(&x134, &x135, x133, x98, x122);
  fiat_p384_addcarryx_u64(&x136, &x137, x135, x100, x124);
  fiat_p384_addcarryx_u64(&x138, &x139, x137, ((uint64_t)x101 + x89), (x125 + x105));
  fiat_p384_addcarryx_u64(&x140, &x141, 0x0, x128, (arg1[3]));
  fiat_p384_addcarryx_u64(&x142, &x143, x141, x130, 0x0);
  fiat_p384_addcarryx_u64(&x144, &x145, x143, x132, 0x0);
  fiat_p384_addcarryx_u64(&x146, &x147, x145, x134, 0x0);
  fiat_p384_addcarryx_u64(&x148, &x149, x147, x136, 0x0);
  fiat_p384_addcarryx_u64(&x150, &x151, x149, x138, 0x0);
  fiat_p384_mulx_u64(&x152, &x153, x140, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x154, &x155, x152, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x156, &x157, x152, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x158, &x159, x152, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x160, &x161, x152, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x162, &x163, x152, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x164, &x165, x152, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x166, &x167, 0x0, x165, x162);
  fiat_p384_addcarryx_u64(&x168, &x169, x167, x163, x160);
  fiat_p384_addcarryx_u64(&x170, &x171, x169, x161, x158);
  fiat_p384_addcarryx_u64(&x172, &x173, x171, x159, x156);
  fiat_p384_addcarryx_u64(&x174, &x175, x173, x157, x154);
  fiat_p384_addcarryx_u64(&x176, &x177, 0x0, x140, x164);
  fiat_p384_addcarryx_u64(&x178, &x179, x177, x142, x166);
  fiat_p384_addcarryx_u64(&x180, &x181, x179, x144, x168);
  fiat_p384_addcarryx_u64(&x182, &x183, x181, x146, x170);
  fiat_p384_addcarryx_u64(&x184, &x185, x183, x148, x172);
  fiat_p384_addcarryx_u64(&x186, &x187, x185, x150, x174);
  fiat_p384_addcarryx_u64(&x188, &x189, x187, ((uint64_t)x151 + x139), (x175 + x155));
  fiat_p384_addcarryx_u64(&x190, &x191, 0x0, x178, (arg1[4]));
  fiat_p384_addcarryx_u64(&x192, &x193, x191, x180, 0x0);
  fiat_p384_addcarryx_u64(&x194, &x195, x193, x182, 0x0);
  fiat_p384_addcarryx_u64(&x196, &x197, x195, x184, 0x0);
  fiat_p384_addcarryx_u64(&x198, &x199, x197, x186, 0x0);
  fiat_p384_addcarryx_u64(&x200, &x201, x199, x188, 0x0);
  fiat_p384_mulx_u64(&x202, &x203, x190, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x204, &x205, x202, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x206, &x207, x202, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x208, &x209, x202, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x210, &x211, x202, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x212, &x213, x202, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x214, &x215, x202, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x216, &x217, 0x0, x215, x212);
  fiat_p384_addcarryx_u64(&x218, &x219, x217, x213, x210);
  fiat_p384_addcarryx_u64(&x220, &x221, x219, x211, x208);
  fiat_p384_addcarryx_u64(&x222, &x223, x221, x209, x206);
  fiat_p384_addcarryx_u64(&x224, &x225, x223, x207, x204);
  fiat_p384_addcarryx_u64(&x226, &x227, 0x0, x190, x214);
  fiat_p384_addcarryx_u64(&x228, &x229, x227, x192, x216);
  fiat_p384_addcarryx_u64(&x230, &x231, x229, x194, x218);
  fiat_p384_addcarryx_u64(&x232, &x233, x231, x196, x220);
  fiat_p384_addcarryx_u64(&x234, &x235, x233, x198, x222);
  fiat_p384_addcarryx_u64(&x236, &x237, x235, x200, x224);
  fiat_p384_addcarryx_u64(&x238, &x239, x237, ((uint64_t)x201 + x189), (x225 + x205));
  fiat_p384_addcarryx_u64(&x240, &x241, 0x0, x228, (arg1[5]));
  fiat_p384_addcarryx_u64(&x242, &x243, x241, x230, 0x0);
  fiat_p384_addcarryx_u64(&x244, &x245, x243, x232, 0x0);
  fiat_p384_addcarryx_u64(&x246, &x247, x245, x234, 0x0);
  fiat_p384_addcarryx_u64(&x248, &x249, x247, x236, 0x0);
  fiat_p384_addcarryx_u64(&x250, &x251, x249, x238, 0x0);
  fiat_p384_mulx_u64(&x252, &x253, x240, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x254, &x255, x252, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x256, &x257, x252, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x258, &x259, x252, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x260, &x261, x252, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x262, &x263, x252, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x264, &x265, x252, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x266, &x267, 0x0, x265, x262);
  fiat_p384_addcarryx_u64(&x268, &x269, x267, x263, x260);
  fiat_p384_addcarryx_u64(&x270, &x271, x269, x261, x258);
  fiat_p384_addcarryx_u64(&x272, &x273, x271, x259, x256);
  fiat_p384_addcarryx_u64(&x274, &x275, x273, x257, x254);
  fiat_p384_addcarryx_u64(&x276, &x277, 0x0, x240, x264);
  fiat_p384_addcarryx_u64(&x278, &x279, x277, x242, x266);
  fiat_p384_addcarryx_u64(&x280, &x281, x279, x244, x268);
  fiat_p384_addcarryx_u64(&x282, &x283, x281, x246, x270);
  fiat_p384_addcarryx_u64(&x284, &x285, x283, x248, x272);
  fiat_p384_addcarryx_u64(&x286, &x287, x285, x250, x274);
  fiat_p384_addcarryx_u64(&x288, &x289, x287, ((uint64_t)x251 + x239), (x275 + x255));
  fiat_p384_subborrowx_u64(&x290, &x291, 0x0, x278, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x292, &x293, x291, x280, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x294, &x295, x293, x282, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x296, &x297, x295, x284, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x298, &x299, x297, x286, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x300, &x301, x299, x288, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x302, &x303, x301, x289, 0x0);
  fiat_p384_cmovznz_u64(&x304, x303, x290, x278);
  fiat_p384_cmovznz_u64(&x305, x303, x292, x280);
  fiat_p384_cmovznz_u64(&x306, x303, x294, x282);
  fiat_p384_cmovznz_u64(&x307, x303, x296, x284);
  fiat_p384_cmovznz_u64(&x308, x303, x298, x286);
  fiat_p384_cmovznz_u64(&x309, x303, x300, x288);
  out1[0] = x304;
  out1[1] = x305;
  out1[2] = x306;
  out1[3] = x307;
  out1[4] = x308;
  out1[5] = x309;
}

/*
 * The function fiat_p384_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_to_montgomery(uint64_t out1[6], const uint64_t arg1[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  fiat_p384_uint1 x16;
  uint64_t x17;
  fiat_p384_uint1 x18;
  uint64_t x19;
  fiat_p384_uint1 x20;
  uint64_t x21;
  fiat_p384_uint1 x22;
  uint64_t x23;
  uint64_t x24;
  uint64_t x25;
  uint64_t x26;
  uint64_t x27;
  uint64_t x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint64_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  fiat_p384_uint1 x38;
  uint64_t x39;
  fiat_p384_uint1 x40;
  uint64_t x41;
  fiat_p384_uint1 x42;
  uint64_t x43;
  fiat_p384_uint1 x44;
  uint64_t x45;
  fiat_p384_uint1 x46;
  uint64_t x47;
  fiat_p384_uint1 x48;
  uint64_t x49;
  fiat_p384_uint1 x50;
  uint64_t x51;
  fiat_p384_uint1 x52;
  uint64_t x53;
  fiat_p384_uint1 x54;
  uint64_t x55;
  fiat_p384_uint1 x56;
  uint64_t x57;
  fiat_p384_uint1 x58;
  uint64_t x59;
  fiat_p384_uint1 x60;
  uint64_t x61;
  uint64_t x62;
  uint64_t x63;
  uint64_t x64;
  uint64_t x65;
  uint64_t x66;
  uint64_t x67;
  uint64_t x68;
  uint64_t x69;
  fiat_p384_uint1 x70;
  uint64_t x71;
  fiat_p384_uint1 x72;
  uint64_t x73;
  fiat_p384_uint1 x74;
  uint64_t x75;
  fiat_p384_uint1 x76;
  uint64_t x77;
  fiat_p384_uint1 x78;
  uint64_t x79;
  fiat_p384_uint1 x80;
  uint64_t x81;
  fiat_p384_uint1 x82;
  uint64_t x83;
  fiat_p384_uint1 x84;
  uint64_t x85;
  fiat_p384_uint1 x86;
  uint64_t x87;
  fiat_p384_uint1 x88;
  uint64_t x89;
  uint64_t x90;
  uint64_t x91;
  uint64_t x92;
  uint64_t x93;
  uint64_t x94;
  uint64_t x95;
  uint64_t x96;
  uint64_t x97;
  uint64_t x98;
  uint64_t x99;
  uint64_t x100;
  uint64_t x101;
  uint64_t x102;
  uint64_t x103;
  fiat_p384_uint1 x104;
  uint64_t x105;
  fiat_p384_uint1 x106;
  uint64_t x107;
  fiat_p384_uint1 x108;
  uint64_t x109;
  fiat_p384_uint1 x110;
  uint64_t x111;
  fiat_p384_uint1 x112;
  uint64_t x113;
  fiat_p384_uint1 x114;
  uint64_t x115;
  fiat_p384_uint1 x116;
  uint64_t x117;
  fiat_p384_uint1 x118;
  uint64_t x119;
  fiat_p384_uint1 x120;
  uint64_t x121;
  fiat_p384_uint1 x122;
  uint64_t x123;
  fiat_p384_uint1 x124;
  uint64_t x125;
  fiat_p384_uint1 x126;
  uint64_t x127;
  uint64_t x128;
  uint64_t x129;
  uint64_t x130;
  uint64_t x131;
  uint64_t x132;
  uint64_t x133;
  uint64_t x134;
  uint64_t x135;
  fiat_p384_uint1 x136;
  uint64_t x137;
  fiat_p384_uint1 x138;
  uint64_t x139;
  fiat_p384_uint1 x140;
  uint64_t x141;
  fiat_p384_uint1 x142;
  uint64_t x143;
  fiat_p384_uint1 x144;
  uint64_t x145;
  fiat_p384_uint1 x146;
  uint64_t x147;
  fiat_p384_uint1 x148;
  uint64_t x149;
  fiat_p384_uint1 x150;
  uint64_t x151;
  fiat_p384_uint1 x152;
  uint64_t x153;
  fiat_p384_uint1 x154;
  uint64_t x155;
  uint64_t x156;
  uint64_t x157;
  uint64_t x158;
  uint64_t x159;
  uint64_t x160;
  uint64_t x161;
  uint64_t x162;
  uint64_t x163;
  uint64_t x164;
  uint64_t x165;
  uint64_t x166;
  uint64_t x167;
  uint64_t x168;
  uint64_t x169;
  fiat_p384_uint1 x170;
  uint64_t x171;
  fiat_p384_uint1 x172;
  uint64_t x173;
  fiat_p384_uint1 x174;
  uint64_t x175;
  fiat_p384_uint1 x176;
  uint64_t x177;
  fiat_p384_uint1 x178;
  uint64_t x179;
  fiat_p384_uint1 x180;
  uint64_t x181;
  fiat_p384_uint1 x182;
  uint64_t x183;
  fiat_p384_uint1 x184;
  uint64_t x185;
  fiat_p384_uint1 x186;
  uint64_t x187;
  fiat_p384_uint1 x188;
  uint64_t x189;
  fiat_p384_uint1 x190;
  uint64_t x191;
  fiat_p384_uint1 x192;
  uint64_t x193;
  uint64_t x194;
  uint64_t x195;
  uint64_t x196;
  uint64_t x197;
  uint64_t x198;
  uint64_t x199;
  uint64_t x200;
  uint64_t x201;
  fiat_p384_uint1 x202;
  uint64_t x203;
  fiat_p384_uint1 x204;
  uint64_t x205;
  fiat_p384_uint1 x206;
  uint64_t x207;
  fiat_p384_uint1 x208;
  uint64_t x209;
  fiat_p384_uint1 x210;
  uint64_t x211;
  fiat_p384_uint1 x212;
  uint64_t x213;
  fiat_p384_uint1 x214;
  uint64_t x215;
  fiat_p384_uint1 x216;
  uint64_t x217;
  fiat_p384_uint1 x218;
  uint64_t x219;
  fiat_p384_uint1 x220;
  uint64_t x221;
  uint64_t x222;
  uint64_t x223;
  uint64_t x224;
  uint64_t x225;
  uint64_t x226;
  uint64_t x227;
  uint64_t x228;
  uint64_t x229;
  uint64_t x230;
  uint64_t x231;
  uint64_t x232;
  uint64_t x233;
  uint64_t x234;
  uint64_t x235;
  fiat_p384_uint1 x236;
  uint64_t x237;
  fiat_p384_uint1 x238;
  uint64_t x239;
  fiat_p384_uint1 x240;
  uint64_t x241;
  fiat_p384_uint1 x242;
  uint64_t x243;
  fiat_p384_uint1 x244;
  uint64_t x245;
  fiat_p384_uint1 x246;
  uint64_t x247;
  fiat_p384_uint1 x248;
  uint64_t x249;
  fiat_p384_uint1 x250;
  uint64_t x251;
  fiat_p384_uint1 x252;
  uint64_t x253;
  fiat_p384_uint1 x254;
  uint64_t x255;
  fiat_p384_uint1 x256;
  uint64_t x257;
  fiat_p384_uint1 x258;
  uint64_t x259;
  uint64_t x260;
  uint64_t x261;
  uint64_t x262;
  uint64_t x263;
  uint64_t x264;
  uint64_t x265;
  uint64_t x266;
  uint64_t x267;
  fiat_p384_uint1 x268;
  uint64_t x269;
  fiat_p384_uint1 x270;
  uint64_t x271;
  fiat_p384_uint1 x272;
  uint64_t x273;
  fiat_p384_uint1 x274;
  uint64_t x275;
  fiat_p384_uint1 x276;
  uint64_t x277;
  fiat_p384_uint1 x278;
  uint64_t x279;
  fiat_p384_uint1 x280;
  uint64_t x281;
  fiat_p384_uint1 x282;
  uint64_t x283;
  fiat_p384_uint1 x284;
  uint64_t x285;
  fiat_p384_uint1 x286;
  uint64_t x287;
  uint64_t x288;
  uint64_t x289;
  uint64_t x290;
  uint64_t x291;
  uint64_t x292;
  uint64_t x293;
  uint64_t x294;
  uint64_t x295;
  uint64_t x296;
  uint64_t x297;
  uint64_t x298;
  uint64_t x299;
  uint64_t x300;
  uint64_t x301;
  fiat_p384_uint1 x302;
  uint64_t x303;
  fiat_p384_uint1 x304;
  uint64_t x305;
  fiat_p384_uint1 x306;
  uint64_t x307;
  fiat_p384_uint1 x308;
  uint64_t x309;
  fiat_p384_uint1 x310;
  uint64_t x311;
  fiat_p384_uint1 x312;
  uint64_t x313;
  fiat_p384_uint1 x314;
  uint64_t x315;
  fiat_p384_uint1 x316;
  uint64_t x317;
  fiat_p384_uint1 x318;
  uint64_t x319;
  fiat_p384_uint1 x320;
  uint64_t x321;
  fiat_p384_uint1 x322;
  uint64_t x323;
  fiat_p384_uint1 x324;
  uint64_t x325;
  uint64_t x326;
  uint64_t x327;
  uint64_t x328;
  uint64_t x329;
  uint64_t x330;
  uint64_t x331;
  uint64_t x332;
  uint64_t x333;
  fiat_p384_uint1 x334;
  uint64_t x335;
  fiat_p384_uint1 x336;
  uint64_t x337;
  fiat_p384_uint1 x338;
  uint64_t x339;
  fiat_p384_uint1 x340;
  uint64_t x341;
  fiat_p384_uint1 x342;
  uint64_t x343;
  fiat_p384_uint1 x344;
  uint64_t x345;
  fiat_p384_uint1 x346;
  uint64_t x347;
  fiat_p384_uint1 x348;
  uint64_t x349;
  fiat_p384_uint1 x350;
  uint64_t x351;
  fiat_p384_uint1 x352;
  uint64_t x353;
  uint64_t x354;
  uint64_t x355;
  uint64_t x356;
  uint64_t x357;
  uint64_t x358;
  uint64_t x359;
  uint64_t x360;
  uint64_t x361;
  uint64_t x362;
  uint64_t x363;
  uint64_t x364;
  uint64_t x365;
  uint64_t x366;
  uint64_t x367;
  fiat_p384_uint1 x368;
  uint64_t x369;
  fiat_p384_uint1 x370;
  uint64_t x371;
  fiat_p384_uint1 x372;
  uint64_t x373;
  fiat_p384_uint1 x374;
  uint64_t x375;
  fiat_p384_uint1 x376;
  uint64_t x377;
  fiat_p384_uint1 x378;
  uint64_t x379;
  fiat_p384_uint1 x380;
  uint64_t x381;
  fiat_p384_uint1 x382;
  uint64_t x383;
  fiat_p384_uint1 x384;
  uint64_t x385;
  fiat_p384_uint1 x386;
  uint64_t x387;
  fiat_p384_uint1 x388;
  uint64_t x389;
  fiat_p384_uint1 x390;
  uint64_t x391;
  fiat_p384_uint1 x392;
  uint64_t x393;
  fiat_p384_uint1 x394;
  uint64_t x395;
  fiat_p384_uint1 x396;
  uint64_t x397;
  fiat_p384_uint1 x398;
  uint64_t x399;
  fiat_p384_uint1 x400;
  uint64_t x401;
  fiat_p384_uint1 x402;
  uint64_t x403;
  fiat_p384_uint1 x404;
  uint64_t x405;
  uint64_t x406;
  uint64_t x407;
  uint64_t x408;
  uint64_t x409;
  uint64_t x410;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[0]);
  fiat_p384_mulx_u64(&x7, &x8, x6, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x9, &x10, x6, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x11, &x12, x6, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x13, &x14, x6, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x15, &x16, 0x0, x14, x11);
  fiat_p384_addcarryx_u64(&x17, &x18, x16, x12, x9);
  fiat_p384_addcarryx_u64(&x19, &x20, x18, x10, x7);
  fiat_p384_addcarryx_u64(&x21, &x22, x20, x8, x6);
  fiat_p384_mulx_u64(&x23, &x24, x13, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x25, &x26, x23, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x27, &x28, x23, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x29, &x30, x23, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x31, &x32, x23, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x33, &x34, x23, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x35, &x36, x23, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x37, &x38, 0x0, x36, x33);
  fiat_p384_addcarryx_u64(&x39, &x40, x38, x34, x31);
  fiat_p384_addcarryx_u64(&x41, &x42, x40, x32, x29);
  fiat_p384_addcarryx_u64(&x43, &x44, x42, x30, x27);
  fiat_p384_addcarryx_u64(&x45, &x46, x44, x28, x25);
  fiat_p384_addcarryx_u64(&x47, &x48, 0x0, x13, x35);
  fiat_p384_addcarryx_u64(&x49, &x50, x48, x15, x37);
  fiat_p384_addcarryx_u64(&x51, &x52, x50, x17, x39);
  fiat_p384_addcarryx_u64(&x53, &x54, x52, x19, x41);
  fiat_p384_addcarryx_u64(&x55, &x56, x54, x21, x43);
  fiat_p384_addcarryx_u64(&x57, &x58, x56, x22, x45);
  fiat_p384_addcarryx_u64(&x59, &x60, x58, 0x0, (x46 + x26));
  fiat_p384_mulx_u64(&x61, &x62, x1, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x63, &x64, x1, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x65, &x66, x1, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x67, &x68, x1, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x69, &x70, 0x0, x68, x65);
  fiat_p384_addcarryx_u64(&x71, &x72, x70, x66, x63);
  fiat_p384_addcarryx_u64(&x73, &x74, x72, x64, x61);
  fiat_p384_addcarryx_u64(&x75, &x76, x74, x62, x1);
  fiat_p384_addcarryx_u64(&x77, &x78, 0x0, x49, x67);
  fiat_p384_addcarryx_u64(&x79, &x80, x78, x51, x69);
  fiat_p384_addcarryx_u64(&x81, &x82, x80, x53, x71);
  fiat_p384_addcarryx_u64(&x83, &x84, x82, x55, x73);
  fiat_p384_addcarryx_u64(&x85, &x86, x84, x57, x75);
  fiat_p384_addcarryx_u64(&x87, &x88, x86, x59, x76);
  fiat_p384_mulx_u64(&x89, &x90, x77, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x91, &x92, x89, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x93, &x94, x89, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x95, &x96, x89, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x97, &x98, x89, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x99, &x100, x89, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x101, &x102, x89, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x103, &x104, 0x0, x102, x99);
  fiat_p384_addcarryx_u64(&x105, &x106, x104, x100, x97);
  fiat_p384_addcarryx_u64(&x107, &x108, x106, x98, x95);
  fiat_p384_addcarryx_u64(&x109, &x110, x108, x96, x93);
  fiat_p384_addcarryx_u64(&x111, &x112, x110, x94, x91);
  fiat_p384_addcarryx_u64(&x113, &x114, 0x0, x77, x101);
  fiat_p384_addcarryx_u64(&x115, &x116, x114, x79, x103);
  fiat_p384_addcarryx_u64(&x117, &x118, x116, x81, x105);
  fiat_p384_addcarryx_u64(&x119, &x120, x118, x83, x107);
  fiat_p384_addcarryx_u64(&x121, &x122, x120, x85, x109);
  fiat_p384_addcarryx_u64(&x123, &x124, x122, x87, x111);
  fiat_p384_addcarryx_u64(&x125, &x126, x124, ((uint64_t)x88 + x60), (x112 + x92));
  fiat_p384_mulx_u64(&x127, &x128, x2, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x129, &x130, x2, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x131, &x132, x2, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x133, &x134, x2, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x135, &x136, 0x0, x134, x131);
  fiat_p384_addcarryx_u64(&x137, &x138, x136, x132, x129);
  fiat_p384_addcarryx_u64(&x139, &x140, x138, x130, x127);
  fiat_p384_addcarryx_u64(&x141, &x142, x140, x128, x2);
  fiat_p384_addcarryx_u64(&x143, &x144, 0x0, x115, x133);
  fiat_p384_addcarryx_u64(&x145, &x146, x144, x117, x135);
  fiat_p384_addcarryx_u64(&x147, &x148, x146, x119, x137);
  fiat_p384_addcarryx_u64(&x149, &x150, x148, x121, x139);
  fiat_p384_addcarryx_u64(&x151, &x152, x150, x123, x141);
  fiat_p384_addcarryx_u64(&x153, &x154, x152, x125, x142);
  fiat_p384_mulx_u64(&x155, &x156, x143, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x157, &x158, x155, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x159, &x160, x155, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x161, &x162, x155, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x163, &x164, x155, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x165, &x166, x155, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x167, &x168, x155, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x169, &x170, 0x0, x168, x165);
  fiat_p384_addcarryx_u64(&x171, &x172, x170, x166, x163);
  fiat_p384_addcarryx_u64(&x173, &x174, x172, x164, x161);
  fiat_p384_addcarryx_u64(&x175, &x176, x174, x162, x159);
  fiat_p384_addcarryx_u64(&x177, &x178, x176, x160, x157);
  fiat_p384_addcarryx_u64(&x179, &x180, 0x0, x143, x167);
  fiat_p384_addcarryx_u64(&x181, &x182, x180, x145, x169);
  fiat_p384_addcarryx_u64(&x183, &x184, x182, x147, x171);
  fiat_p384_addcarryx_u64(&x185, &x186, x184, x149, x173);
  fiat_p384_addcarryx_u64(&x187, &x188, x186, x151, x175);
  fiat_p384_addcarryx_u64(&x189, &x190, x188, x153, x177);
  fiat_p384_addcarryx_u64(&x191, &x192, x190, ((uint64_t)x154 + x126), (x178 + x158));
  fiat_p384_mulx_u64(&x193, &x194, x3, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x195, &x196, x3, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x197, &x198, x3, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x199, &x200, x3, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x201, &x202, 0x0, x200, x197);
  fiat_p384_addcarryx_u64(&x203, &x204, x202, x198, x195);
  fiat_p384_addcarryx_u64(&x205, &x206, x204, x196, x193);
  fiat_p384_addcarryx_u64(&x207, &x208, x206, x194, x3);
  fiat_p384_addcarryx_u64(&x209, &x210, 0x0, x181, x199);
  fiat_p384_addcarryx_u64(&x211, &x212, x210, x183, x201);
  fiat_p384_addcarryx_u64(&x213, &x214, x212, x185, x203);
  fiat_p384_addcarryx_u64(&x215, &x216, x214, x187, x205);
  fiat_p384_addcarryx_u64(&x217, &x218, x216, x189, x207);
  fiat_p384_addcarryx_u64(&x219, &x220, x218, x191, x208);
  fiat_p384_mulx_u64(&x221, &x222, x209, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x223, &x224, x221, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x225, &x226, x221, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x227, &x228, x221, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x229, &x230, x221, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x231, &x232, x221, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x233, &x234, x221, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
  fiat_p384_addcarryx_u64(&x237, &x238, x236, x232, x229);
  fiat_p384_addcarryx_u64(&x239, &x240, x238, x230, x227);
  fiat_p384_addcarryx_u64(&x241, &x242, x240, x228, x225);
  fiat_p384_addcarryx_u64(&x243, &x244, x242, x226, x223);
  fiat_p384_addcarryx_u64(&x245, &x246, 0x0, x209, x233);
  fiat_p384_addcarryx_u64(&x247, &x248, x246, x211, x235);
  fiat_p384_addcarryx_u64(&x249, &x250, x248, x213, x237);
  fiat_p384_addcarryx_u64(&x251, &x252, x250, x215, x239);
  fiat_p384_addcarryx_u64(&x253, &x254, x252, x217, x241);
  fiat_p384_addcarryx_u64(&x255, &x256, x254, x219, x243);
  fiat_p384_addcarryx_u64(&x257, &x258, x256, ((uint64_t)x220 + x192), (x244 + x224));
  fiat_p384_mulx_u64(&x259, &x260, x4, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x261, &x262, x4, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x263, &x264, x4, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x265, &x266, x4, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x267, &x268, 0x0, x266, x263);
  fiat_p384_addcarryx_u64(&x269, &x270, x268, x264, x261);
  fiat_p384_addcarryx_u64(&x271, &x272, x270, x262, x259);
  fiat_p384_addcarryx_u64(&x273, &x274, x272, x260, x4);
  fiat_p384_addcarryx_u64(&x275, &x276, 0x0, x247, x265);
  fiat_p384_addcarryx_u64(&x277, &x278, x276, x249, x267);
  fiat_p384_addcarryx_u64(&x279, &x280, x278, x251, x269);
  fiat_p384_addcarryx_u64(&x281, &x282, x280, x253, x271);
  fiat_p384_addcarryx_u64(&x283, &x284, x282, x255, x273);
  fiat_p384_addcarryx_u64(&x285, &x286, x284, x257, x274);
  fiat_p384_mulx_u64(&x287, &x288, x275, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x289, &x290, x287, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x291, &x292, x287, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x293, &x294, x287, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x295, &x296, x287, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x297, &x298, x287, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x299, &x300, x287, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x301, &x302, 0x0, x300, x297);
  fiat_p384_addcarryx_u64(&x303, &x304, x302, x298, x295);
  fiat_p384_addcarryx_u64(&x305, &x306, x304, x296, x293);
  fiat_p384_addcarryx_u64(&x307, &x308, x306, x294, x291);
  fiat_p384_addcarryx_u64(&x309, &x310, x308, x292, x289);
  fiat_p384_addcarryx_u64(&x311, &x312, 0x0, x275, x299);
  fiat_p384_addcarryx_u64(&x313, &x314, x312, x277, x301);
  fiat_p384_addcarryx_u64(&x315, &x316, x314, x279, x303);
  fiat_p384_addcarryx_u64(&x317, &x318, x316, x281, x305);
  fiat_p384_addcarryx_u64(&x319, &x320, x318, x283, x307);
  fiat_p384_addcarryx_u64(&x321, &x322, x320, x285, x309);
  fiat_p384_addcarryx_u64(&x323, &x324, x322, ((uint64_t)x286 + x258), (x310 + x290));
  fiat_p384_mulx_u64(&x325, &x326, x5, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x327, &x328, x5, UINT64_C(0xfffffffe00000000));
  fiat_p384_mulx_u64(&x329, &x330, x5, UINT64_C(0x200000000));
  fiat_p384_mulx_u64(&x331, &x332, x5, UINT64_C(0xfffffffe00000001));
  fiat_p384_addcarryx_u64(&x333, &x334, 0x0, x332, x329);
  fiat_p384_addcarryx_u64(&x335, &x336, x334, x330, x327);
  fiat_p384_addcarryx_u64(&x337, &x338, x336, x328, x325);
  fiat_p384_addcarryx_u64(&x339, &x340, x338, x326, x5);
  fiat_p384_addcarryx_u64(&x341, &x342, 0x0, x313, x331);
  fiat_p384_addcarryx_u64(&x343, &x344, x342, x315, x333);
  fiat_p384_addcarryx_u64(&x345, &x346, x344, x317, x335);
  fiat_p384_addcarryx_u64(&x347, &x348, x346, x319, x337);
  fiat_p384_addcarryx_u64(&x349, &x350, x348, x321, x339);
  fiat_p384_addcarryx_u64(&x351, &x352, x350, x323, x340);
  fiat_p384_mulx_u64(&x353, &x354, x341, UINT64_C(0x100000001));
  fiat_p384_mulx_u64(&x355, &x356, x353, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x357, &x358, x353, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x359, &x360, x353, UINT64_C(0xffffffffffffffff));
  fiat_p384_mulx_u64(&x361, &x362, x353, UINT64_C(0xfffffffffffffffe));
  fiat_p384_mulx_u64(&x363, &x364, x353, UINT64_C(0xffffffff00000000));
  fiat_p384_mulx_u64(&x365, &x366, x353, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u64(&x367, &x368, 0x0, x366, x363);
  fiat_p384_addcarryx_u64(&x369, &x370, x368, x364, x361);
  fiat_p384_addcarryx_u64(&x371, &x372, x370, x362, x359);
  fiat_p384_addcarryx_u64(&x373, &x374, x372, x360, x357);
  fiat_p384_addcarryx_u64(&x375, &x376, x374, x358, x355);
  fiat_p384_addcarryx_u64(&x377, &x378, 0x0, x341, x365);
  fiat_p384_addcarryx_u64(&x379, &x380, x378, x343, x367);
  fiat_p384_addcarryx_u64(&x381, &x382, x380, x345, x369);
  fiat_p384_addcarryx_u64(&x383, &x384, x382, x347, x371);
  fiat_p384_addcarryx_u64(&x385, &x386, x384, x349, x373);
  fiat_p384_addcarryx_u64(&x387, &x388, x386, x351, x375);
  fiat_p384_addcarryx_u64(&x389, &x390, x388, ((uint64_t)x352 + x324), (x376 + x356));
  fiat_p384_subborrowx_u64(&x391, &x392, 0x0, x379, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x393, &x394, x392, x381, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x395, &x396, x394, x383, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x397, &x398, x396, x385, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x399, &x400, x398, x387, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x401, &x402, x400, x389, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x403, &x404, x402, x390, 0x0);
  fiat_p384_cmovznz_u64(&x405, x404, x391, x379);
  fiat_p384_cmovznz_u64(&x406, x404, x393, x381);
  fiat_p384_cmovznz_u64(&x407, x404, x395, x383);
  fiat_p384_cmovznz_u64(&x408, x404, x397, x385);
  fiat_p384_cmovznz_u64(&x409, x404, x399, x387);
  fiat_p384_cmovznz_u64(&x410, x404, x401, x389);
  out1[0] = x405;
  out1[1] = x406;
  out1[2] = x407;
  out1[3] = x408;
  out1[4] = x409;
  out1[5] = x410;
}

/*
 * The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p384_nonzero(uint64_t* out1, const uint64_t arg1[6]) {
  uint64_t x1;
  x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | (arg1[5]))))));
  *out1 = x1;
}

/*
 * The function fiat_p384_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_selectznz(uint64_t out1[6], fiat_p384_uint1 arg1, const uint64_t arg2[6], const uint64_t arg3[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  fiat_p384_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  fiat_p384_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  fiat_p384_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  fiat_p384_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  fiat_p384_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
  fiat_p384_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/*
 * The function fiat_p384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p384_to_bytes(uint8_t out1[48], const uint64_t arg1[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint8_t x7;
  uint64_t x8;
  uint8_t x9;
  uint64_t x10;
  uint8_t x11;
  uint64_t x12;
  uint8_t x13;
  uint64_t x14;
  uint8_t x15;
  uint64_t x16;
  uint8_t x17;
  uint64_t x18;
  uint8_t x19;
  uint8_t x20;
  uint8_t x21;
  uint64_t x22;
  uint8_t x23;
  uint64_t x24;
  uint8_t x25;
  uint64_t x26;
  uint8_t x27;
  uint64_t x28;
  uint8_t x29;
  uint64_t x30;
  uint8_t x31;
  uint64_t x32;
  uint8_t x33;
  uint8_t x34;
  uint8_t x35;
  uint64_t x36;
  uint8_t x37;
  uint64_t x38;
  uint8_t x39;
  uint64_t x40;
  uint8_t x41;
  uint64_t x42;
  uint8_t x43;
  uint64_t x44;
  uint8_t x45;
  uint64_t x46;
  uint8_t x47;
  uint8_t x48;
  uint8_t x49;
  uint64_t x50;
  uint8_t x51;
  uint64_t x52;
  uint8_t x53;
  uint64_t x54;
  uint8_t x55;
  uint64_t x56;
  uint8_t x57;
  uint64_t x58;
  uint8_t x59;
  uint64_t x60;
  uint8_t x61;
  uint8_t x62;
  uint8_t x63;
  uint64_t x64;
  uint8_t x65;
  uint64_t x66;
  uint8_t x67;
  uint64_t x68;
  uint8_t x69;
  uint64_t x70;
  uint8_t x71;
  uint64_t x72;
  uint8_t x73;
  uint64_t x74;
  uint8_t x75;
  uint8_t x76;
  uint8_t x77;
  uint64_t x78;
  uint8_t x79;
  uint64_t x80;
  uint8_t x81;
  uint64_t x82;
  uint8_t x83;
  uint64_t x84;
  uint8_t x85;
  uint64_t x86;
  uint8_t x87;
  uint64_t x88;
  uint8_t x89;
  uint8_t x90;
  x1 = (arg1[5]);
  x2 = (arg1[4]);
  x3 = (arg1[3]);
  x4 = (arg1[2]);
  x5 = (arg1[1]);
  x6 = (arg1[0]);
  x7 = (uint8_t)(x6 & UINT8_C(0xff));
  x8 = (x6 >> 8);
  x9 = (uint8_t)(x8 & UINT8_C(0xff));
  x10 = (x8 >> 8);
  x11 = (uint8_t)(x10 & UINT8_C(0xff));
  x12 = (x10 >> 8);
  x13 = (uint8_t)(x12 & UINT8_C(0xff));
  x14 = (x12 >> 8);
  x15 = (uint8_t)(x14 & UINT8_C(0xff));
  x16 = (x14 >> 8);
  x17 = (uint8_t)(x16 & UINT8_C(0xff));
  x18 = (x16 >> 8);
  x19 = (uint8_t)(x18 & UINT8_C(0xff));
  x20 = (uint8_t)(x18 >> 8);
  x21 = (uint8_t)(x5 & UINT8_C(0xff));
  x22 = (x5 >> 8);
  x23 = (uint8_t)(x22 & UINT8_C(0xff));
  x24 = (x22 >> 8);
  x25 = (uint8_t)(x24 & UINT8_C(0xff));
  x26 = (x24 >> 8);
  x27 = (uint8_t)(x26 & UINT8_C(0xff));
  x28 = (x26 >> 8);
  x29 = (uint8_t)(x28 & UINT8_C(0xff));
  x30 = (x28 >> 8);
  x31 = (uint8_t)(x30 & UINT8_C(0xff));
  x32 = (x30 >> 8);
  x33 = (uint8_t)(x32 & UINT8_C(0xff));
  x34 = (uint8_t)(x32 >> 8);
  x35 = (uint8_t)(x4 & UINT8_C(0xff));
  x36 = (x4 >> 8);
  x37 = (uint8_t)(x36 & UINT8_C(0xff));
  x38 = (x36 >> 8);
  x39 = (uint8_t)(x38 & UINT8_C(0xff));
  x40 = (x38 >> 8);
  x41 = (uint8_t)(x40 & UINT8_C(0xff));
  x42 = (x40 >> 8);
  x43 = (uint8_t)(x42 & UINT8_C(0xff));
  x44 = (x42 >> 8);
  x45 = (uint8_t)(x44 & UINT8_C(0xff));
  x46 = (x44 >> 8);
  x47 = (uint8_t)(x46 & UINT8_C(0xff));
  x48 = (uint8_t)(x46 >> 8);
  x49 = (uint8_t)(x3 & UINT8_C(0xff));
  x50 = (x3 >> 8);
  x51 = (uint8_t)(x50 & UINT8_C(0xff));
  x52 = (x50 >> 8);
  x53 = (uint8_t)(x52 & UINT8_C(0xff));
  x54 = (x52 >> 8);
  x55 = (uint8_t)(x54 & UINT8_C(0xff));
  x56 = (x54 >> 8);
  x57 = (uint8_t)(x56 & UINT8_C(0xff));
  x58 = (x56 >> 8);
  x59 = (uint8_t)(x58 & UINT8_C(0xff));
  x60 = (x58 >> 8);
  x61 = (uint8_t)(x60 & UINT8_C(0xff));
  x62 = (uint8_t)(x60 >> 8);
  x63 = (uint8_t)(x2 & UINT8_C(0xff));
  x64 = (x2 >> 8);
  x65 = (uint8_t)(x64 & UINT8_C(0xff));
  x66 = (x64 >> 8);
  x67 = (uint8_t)(x66 & UINT8_C(0xff));
  x68 = (x66 >> 8);
  x69 = (uint8_t)(x68 & UINT8_C(0xff));
  x70 = (x68 >> 8);
  x71 = (uint8_t)(x70 & UINT8_C(0xff));
  x72 = (x70 >> 8);
  x73 = (uint8_t)(x72 & UINT8_C(0xff));
  x74 = (x72 >> 8);
  x75 = (uint8_t)(x74 & UINT8_C(0xff));
  x76 = (uint8_t)(x74 >> 8);
  x77 = (uint8_t)(x1 & UINT8_C(0xff));
  x78 = (x1 >> 8);
  x79 = (uint8_t)(x78 & UINT8_C(0xff));
  x80 = (x78 >> 8);
  x81 = (uint8_t)(x80 & UINT8_C(0xff));
  x82 = (x80 >> 8);
  x83 = (uint8_t)(x82 & UINT8_C(0xff));
  x84 = (x82 >> 8);
  x85 = (uint8_t)(x84 & UINT8_C(0xff));
  x86 = (x84 >> 8);
  x87 = (uint8_t)(x86 & UINT8_C(0xff));
  x88 = (x86 >> 8);
  x89 = (uint8_t)(x88 & UINT8_C(0xff));
  x90 = (uint8_t)(x88 >> 8);
  out1[0] = x7;
  out1[1] = x9;
  out1[2] = x11;
  out1[3] = x13;
  out1[4] = x15;
  out1[5] = x17;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x27;
  out1[12] = x29;
  out1[13] = x31;
  out1[14] = x33;
  out1[15] = x34;
  out1[16] = x35;
  out1[17] = x37;
  out1[18] = x39;
  out1[19] = x41;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x55;
  out1[28] = x57;
  out1[29] = x59;
  out1[30] = x61;
  out1[31] = x62;
  out1[32] = x63;
  out1[33] = x65;
  out1[34] = x67;
  out1[35] = x69;
  out1[36] = x71;
  out1[37] = x73;
  out1[38] = x75;
  out1[39] = x76;
  out1[40] = x77;
  out1[41] = x79;
  out1[42] = x81;
  out1[43] = x83;
  out1[44] = x85;
  out1[45] = x87;
  out1[46] = x89;
  out1[47] = x90;
}

/*
 * The function fiat_p384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_from_bytes(uint64_t out1[6], const uint8_t arg1[48]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint8_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint8_t x16;
  uint64_t x17;
  uint64_t x18;
  uint64_t x19;
  uint64_t x20;
  uint64_t x21;
  uint64_t x22;
  uint64_t x23;
  uint8_t x24;
  uint64_t x25;
  uint64_t x26;
  uint64_t x27;
  uint64_t x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint8_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  uint64_t x38;
  uint64_t x39;
  uint8_t x40;
  uint64_t x41;
  uint64_t x42;
  uint64_t x43;
  uint64_t x44;
  uint64_t x45;
  uint64_t x46;
  uint64_t x47;
  uint8_t x48;
  uint64_t x49;
  uint64_t x50;
  uint64_t x51;
  uint64_t x52;
  uint64_t x53;
  uint64_t x54;
  uint64_t x55;
  uint64_t x56;
  uint64_t x57;
  uint64_t x58;
  uint64_t x59;
  uint64_t x60;
  uint64_t x61;
  uint64_t x62;
  uint64_t x63;
  uint64_t x64;
  uint64_t x65;
  uint64_t x66;
  uint64_t x67;
  uint64_t x68;
  uint64_t x69;
  uint64_t x70;
  uint64_t x71;
  uint64_t x72;
  uint64_t x73;
  uint64_t x74;
  uint64_t x75;
  uint64_t x76;
  uint64_t x77;
  uint64_t x78;
  uint64_t x79;
  uint64_t x80;
  uint64_t x81;
  uint64_t x82;
  uint64_t x83;
  uint64_t x84;
  uint64_t x85;
  uint64_t x86;
  uint64_t x87;
  uint64_t x88;
  uint64_t x89;
  uint64_t x90;
  x1 = ((uint64_t)(arg1[47]) << 56);
  x2 = ((uint64_t)(arg1[46]) << 48);
  x3 = ((uint64_t)(arg1[45]) << 40);
  x4 = ((uint64_t)(arg1[44]) << 32);
  x5 = ((uint64_t)(arg1[43]) << 24);
  x6 = ((uint64_t)(arg1[42]) << 16);
  x7 = ((uint64_t)(arg1[41]) << 8);
  x8 = (arg1[40]);
  x9 = ((uint64_t)(arg1[39]) << 56);
  x10 = ((uint64_t)(arg1[38]) << 48);
  x11 = ((uint64_t)(arg1[37]) << 40);
  x12 = ((uint64_t)(arg1[36]) << 32);
  x13 = ((uint64_t)(arg1[35]) << 24);
  x14 = ((uint64_t)(arg1[34]) << 16);
  x15 = ((uint64_t)(arg1[33]) << 8);
  x16 = (arg1[32]);
  x17 = ((uint64_t)(arg1[31]) << 56);
  x18 = ((uint64_t)(arg1[30]) << 48);
  x19 = ((uint64_t)(arg1[29]) << 40);
  x20 = ((uint64_t)(arg1[28]) << 32);
  x21 = ((uint64_t)(arg1[27]) << 24);
  x22 = ((uint64_t)(arg1[26]) << 16);
  x23 = ((uint64_t)(arg1[25]) << 8);
  x24 = (arg1[24]);
  x25 = ((uint64_t)(arg1[23]) << 56);
  x26 = ((uint64_t)(arg1[22]) << 48);
  x27 = ((uint64_t)(arg1[21]) << 40);
  x28 = ((uint64_t)(arg1[20]) << 32);
  x29 = ((uint64_t)(arg1[19]) << 24);
  x30 = ((uint64_t)(arg1[18]) << 16);
  x31 = ((uint64_t)(arg1[17]) << 8);
  x32 = (arg1[16]);
  x33 = ((uint64_t)(arg1[15]) << 56);
  x34 = ((uint64_t)(arg1[14]) << 48);
  x35 = ((uint64_t)(arg1[13]) << 40);
  x36 = ((uint64_t)(arg1[12]) << 32);
  x37 = ((uint64_t)(arg1[11]) << 24);
  x38 = ((uint64_t)(arg1[10]) << 16);
  x39 = ((uint64_t)(arg1[9]) << 8);
  x40 = (arg1[8]);
  x41 = ((uint64_t)(arg1[7]) << 56);
  x42 = ((uint64_t)(arg1[6]) << 48);
  x43 = ((uint64_t)(arg1[5]) << 40);
  x44 = ((uint64_t)(arg1[4]) << 32);
  x45 = ((uint64_t)(arg1[3]) << 24);
  x46 = ((uint64_t)(arg1[2]) << 16);
  x47 = ((uint64_t)(arg1[1]) << 8);
  x48 = (arg1[0]);
  x49 = (x47 + (uint64_t)x48);
  x50 = (x46 + x49);
  x51 = (x45 + x50);
  x52 = (x44 + x51);
  x53 = (x43 + x52);
  x54 = (x42 + x53);
  x55 = (x41 + x54);
  x56 = (x39 + (uint64_t)x40);
  x57 = (x38 + x56);
  x58 = (x37 + x57);
  x59 = (x36 + x58);
  x60 = (x35 + x59);
  x61 = (x34 + x60);
  x62 = (x33 + x61);
  x63 = (x31 + (uint64_t)x32);
  x64 = (x30 + x63);
  x65 = (x29 + x64);
  x66 = (x28 + x65);
  x67 = (x27 + x66);
  x68 = (x26 + x67);
  x69 = (x25 + x68);
  x70 = (x23 + (uint64_t)x24);
  x71 = (x22 + x70);
  x72 = (x21 + x71);
  x73 = (x20 + x72);
  x74 = (x19 + x73);
  x75 = (x18 + x74);
  x76 = (x17 + x75);
  x77 = (x15 + (uint64_t)x16);
  x78 = (x14 + x77);
  x79 = (x13 + x78);
  x80 = (x12 + x79);
  x81 = (x11 + x80);
  x82 = (x10 + x81);
  x83 = (x9 + x82);
  x84 = (x7 + (uint64_t)x8);
  x85 = (x6 + x84);
  x86 = (x5 + x85);
  x87 = (x4 + x86);
  x88 = (x3 + x87);
  x89 = (x2 + x88);
  x90 = (x1 + x89);
  out1[0] = x55;
  out1[1] = x62;
  out1[2] = x69;
  out1[3] = x76;
  out1[4] = x83;
  out1[5] = x90;
}

/*
 * The function fiat_p384_set_one returns the field element one in the Montgomery domain.
 * Postconditions:
 *   eval (from_montgomery out1) mod m = 1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_set_one(uint64_t out1[6]) {
  out1[0] = UINT64_C(0xffffffff00000001);
  out1[1] = UINT32_C(0xffffffff);
  out1[2] = 0x1;
  out1[3] = 0x0;
  out1[4] = 0x0;
  out1[5] = 0x0;
}

/*
 * The function fiat_p384_msat returns the saturated represtation of the prime modulus.
 * Postconditions:
 *   twos_complement_eval out1 = m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_msat(uint64_t out1[7]) {
  out1[0] = UINT32_C(0xffffffff);
  out1[1] = UINT64_C(0xffffffff00000000);
  out1[2] = UINT64_C(0xfffffffffffffffe);
  out1[3] = UINT64_C(0xffffffffffffffff);
  out1[4] = UINT64_C(0xffffffffffffffff);
  out1[5] = UINT64_C(0xffffffffffffffff);
  out1[6] = 0x0;
}

/*
 * The function fiat_p384_divstep computes a divstep.
 * Preconditions:
 *   0 ≤ eval arg4 < m
 *   0 ≤ eval arg5 < m
 * Postconditions:
 *   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
 *   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
 *   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
 *   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
 *   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out2 < m
 *   0 ≤ eval out3 < m
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_divstep(uint64_t* out1, uint64_t out2[7], uint64_t out3[7], uint64_t out4[6], uint64_t out5[6], uint64_t arg1, const uint64_t arg2[7], const uint64_t arg3[7], const uint64_t arg4[6], const uint64_t arg5[6]) {
  uint64_t x1;
  fiat_p384_uint1 x2;
  fiat_p384_uint1 x3;
  uint64_t x4;
  fiat_p384_uint1 x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  fiat_p384_uint1 x15;
  uint64_t x16;
  fiat_p384_uint1 x17;
  uint64_t x18;
  fiat_p384_uint1 x19;
  uint64_t x20;
  fiat_p384_uint1 x21;
  uint64_t x22;
  fiat_p384_uint1 x23;
  uint64_t x24;
  fiat_p384_uint1 x25;
  uint64_t x26;
  fiat_p384_uint1 x27;
  uint64_t x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint64_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  uint64_t x38;
  uint64_t x39;
  uint64_t x40;
  uint64_t x41;
  fiat_p384_uint1 x42;
  uint64_t x43;
  fiat_p384_uint1 x44;
  uint64_t x45;
  fiat_p384_uint1 x46;
  uint64_t x47;
  fiat_p384_uint1 x48;
  uint64_t x49;
  fiat_p384_uint1 x50;
  uint64_t x51;
  fiat_p384_uint1 x52;
  uint64_t x53;
  fiat_p384_uint1 x54;
  uint64_t x55;
  fiat_p384_uint1 x56;
  uint64_t x57;
  fiat_p384_uint1 x58;
  uint64_t x59;
  fiat_p384_uint1 x60;
  uint64_t x61;
  fiat_p384_uint1 x62;
  uint64_t x63;
  fiat_p384_uint1 x64;
  uint64_t x65;
  fiat_p384_uint1 x66;
  uint64_t x67;
  uint64_t x68;
  uint64_t x69;
  uint64_t x70;
  uint64_t x71;
  uint64_t x72;
  uint64_t x73;
  fiat_p384_uint1 x74;
  uint64_t x75;
  fiat_p384_uint1 x76;
  uint64_t x77;
  fiat_p384_uint1 x78;
  uint64_t x79;
  fiat_p384_uint1 x80;
  uint64_t x81;
  fiat_p384_uint1 x82;
  uint64_t x83;
  fiat_p384_uint1 x84;
  uint64_t x85;
  uint64_t x86;
  fiat_p384_uint1 x87;
  uint64_t x88;
  fiat_p384_uint1 x89;
  uint64_t x90;
  fiat_p384_uint1 x91;
  uint64_t x92;
  fiat_p384_uint1 x93;
  uint64_t x94;
  fiat_p384_uint1 x95;
  uint64_t x96;
  fiat_p384_uint1 x97;
  uint64_t x98;
  uint64_t x99;
  uint64_t x100;
  uint64_t x101;
  uint64_t x102;
  uint64_t x103;
  fiat_p384_uint1 x104;
  uint64_t x105;
  uint64_t x106;
  uint64_t x107;
  uint64_t x108;
  uint64_t x109;
  uint64_t x110;
  uint64_t x111;
  uint64_t x112;
  fiat_p384_uint1 x113;
  uint64_t x114;
  fiat_p384_uint1 x115;
  uint64_t x116;
  fiat_p384_uint1 x117;
  uint64_t x118;
  fiat_p384_uint1 x119;
  uint64_t x120;
  fiat_p384_uint1 x121;
  uint64_t x122;
  fiat_p384_uint1 x123;
  uint64_t x124;
  fiat_p384_uint1 x125;
  uint64_t x126;
  uint64_t x127;
  uint64_t x128;
  uint64_t x129;
  uint64_t x130;
  uint64_t x131;
  uint64_t x132;
  fiat_p384_uint1 x133;
  uint64_t x134;
  fiat_p384_uint1 x135;
  uint64_t x136;
  fiat_p384_uint1 x137;
  uint64_t x138;
  fiat_p384_uint1 x139;
  uint64_t x140;
  fiat_p384_uint1 x141;
  uint64_t x142;
  fiat_p384_uint1 x143;
  uint64_t x144;
  fiat_p384_uint1 x145;
  uint64_t x146;
  fiat_p384_uint1 x147;
  uint64_t x148;
  fiat_p384_uint1 x149;
  uint64_t x150;
  fiat_p384_uint1 x151;
  uint64_t x152;
  fiat_p384_uint1 x153;
  uint64_t x154;
  fiat_p384_uint1 x155;
  uint64_t x156;
  fiat_p384_uint1 x157;
  uint64_t x158;
  fiat_p384_uint1 x159;
  uint64_t x160;
  uint64_t x161;
  uint64_t x162;
  uint64_t x163;
  uint64_t x164;
  uint64_t x165;
  uint64_t x166;
  uint64_t x167;
  uint64_t x168;
  uint64_t x169;
  uint64_t x170;
  uint64_t x171;
  uint64_t x172;
  uint64_t x173;
  uint64_t x174;
  uint64_t x175;
  uint64_t x176;
  uint64_t x177;
  uint64_t x178;
  fiat_p384_addcarryx_u64(&x1, &x2, 0x0, (~arg1), 0x1);
  x3 = (fiat_p384_uint1)((fiat_p384_uint1)(x1 >> 63) & (fiat_p384_uint1)((arg3[0]) & 0x1));
  fiat_p384_addcarryx_u64(&x4, &x5, 0x0, (~arg1), 0x1);
  fiat_p384_cmovznz_u64(&x6, x3, arg1, x4);
  fiat_p384_cmovznz_u64(&x7, x3, (arg2[0]), (arg3[0]));
  fiat_p384_cmovznz_u64(&x8, x3, (arg2[1]), (arg3[1]));
  fiat_p384_cmovznz_u64(&x9, x3, (arg2[2]), (arg3[2]));
  fiat_p384_cmovznz_u64(&x10, x3, (arg2[3]), (arg3[3]));
  fiat_p384_cmovznz_u64(&x11, x3, (arg2[4]), (arg3[4]));
  fiat_p384_cmovznz_u64(&x12, x3, (arg2[5]), (arg3[5]));
  fiat_p384_cmovznz_u64(&x13, x3, (arg2[6]), (arg3[6]));
  fiat_p384_addcarryx_u64(&x14, &x15, 0x0, 0x1, (~(arg2[0])));
  fiat_p384_addcarryx_u64(&x16, &x17, x15, 0x0, (~(arg2[1])));
  fiat_p384_addcarryx_u64(&x18, &x19, x17, 0x0, (~(arg2[2])));
  fiat_p384_addcarryx_u64(&x20, &x21, x19, 0x0, (~(arg2[3])));
  fiat_p384_addcarryx_u64(&x22, &x23, x21, 0x0, (~(arg2[4])));
  fiat_p384_addcarryx_u64(&x24, &x25, x23, 0x0, (~(arg2[5])));
  fiat_p384_addcarryx_u64(&x26, &x27, x25, 0x0, (~(arg2[6])));
  fiat_p384_cmovznz_u64(&x28, x3, (arg3[0]), x14);
  fiat_p384_cmovznz_u64(&x29, x3, (arg3[1]), x16);
  fiat_p384_cmovznz_u64(&x30, x3, (arg3[2]), x18);
  fiat_p384_cmovznz_u64(&x31, x3, (arg3[3]), x20);
  fiat_p384_cmovznz_u64(&x32, x3, (arg3[4]), x22);
  fiat_p384_cmovznz_u64(&x33, x3, (arg3[5]), x24);
  fiat_p384_cmovznz_u64(&x34, x3, (arg3[6]), x26);
  fiat_p384_cmovznz_u64(&x35, x3, (arg4[0]), (arg5[0]));
  fiat_p384_cmovznz_u64(&x36, x3, (arg4[1]), (arg5[1]));
  fiat_p384_cmovznz_u64(&x37, x3, (arg4[2]), (arg5[2]));
  fiat_p384_cmovznz_u64(&x38, x3, (arg4[3]), (arg5[3]));
  fiat_p384_cmovznz_u64(&x39, x3, (arg4[4]), (arg5[4]));
  fiat_p384_cmovznz_u64(&x40, x3, (arg4[5]), (arg5[5]));
  fiat_p384_addcarryx_u64(&x41, &x42, 0x0, x35, x35);
  fiat_p384_addcarryx_u64(&x43, &x44, x42, x36, x36);
  fiat_p384_addcarryx_u64(&x45, &x46, x44, x37, x37);
  fiat_p384_addcarryx_u64(&x47, &x48, x46, x38, x38);
  fiat_p384_addcarryx_u64(&x49, &x50, x48, x39, x39);
  fiat_p384_addcarryx_u64(&x51, &x52, x50, x40, x40);
  fiat_p384_subborrowx_u64(&x53, &x54, 0x0, x41, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x55, &x56, x54, x43, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x57, &x58, x56, x45, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x59, &x60, x58, x47, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x61, &x62, x60, x49, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x63, &x64, x62, x51, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x65, &x66, x64, x52, 0x0);
  x67 = (arg4[5]);
  x68 = (arg4[4]);
  x69 = (arg4[3]);
  x70 = (arg4[2]);
  x71 = (arg4[1]);
  x72 = (arg4[0]);
  fiat_p384_subborrowx_u64(&x73, &x74, 0x0, 0x0, x72);
  fiat_p384_subborrowx_u64(&x75, &x76, x74, 0x0, x71);
  fiat_p384_subborrowx_u64(&x77, &x78, x76, 0x0, x70);
  fiat_p384_subborrowx_u64(&x79, &x80, x78, 0x0, x69);
  fiat_p384_subborrowx_u64(&x81, &x82, x80, 0x0, x68);
  fiat_p384_subborrowx_u64(&x83, &x84, x82, 0x0, x67);
  fiat_p384_cmovznz_u64(&x85, x84, 0x0, UINT64_C(0xffffffffffffffff));
  fiat_p384_addcarryx_u64(&x86, &x87, 0x0, x73, (x85 & UINT32_C(0xffffffff)));
  fiat_p384_addcarryx_u64(&x88, &x89, x87, x75, (x85 & UINT64_C(0xffffffff00000000)));
  fiat_p384_addcarryx_u64(&x90, &x91, x89, x77, (x85 & UINT64_C(0xfffffffffffffffe)));
  fiat_p384_addcarryx_u64(&x92, &x93, x91, x79, x85);
  fiat_p384_addcarryx_u64(&x94, &x95, x93, x81, x85);
  fiat_p384_addcarryx_u64(&x96, &x97, x95, x83, x85);
  fiat_p384_cmovznz_u64(&x98, x3, (arg5[0]), x86);
  fiat_p384_cmovznz_u64(&x99, x3, (arg5[1]), x88);
  fiat_p384_cmovznz_u64(&x100, x3, (arg5[2]), x90);
  fiat_p384_cmovznz_u64(&x101, x3, (arg5[3]), x92);
  fiat_p384_cmovznz_u64(&x102, x3, (arg5[4]), x94);
  fiat_p384_cmovznz_u64(&x103, x3, (arg5[5]), x96);
  x104 = (fiat_p384_uint1)(x28 & 0x1);
  fiat_p384_cmovznz_u64(&x105, x104, 0x0, x7);
  fiat_p384_cmovznz_u64(&x106, x104, 0x0, x8);
  fiat_p384_cmovznz_u64(&x107, x104, 0x0, x9);
  fiat_p384_cmovznz_u64(&x108, x104, 0x0, x10);
  fiat_p384_cmovznz_u64(&x109, x104, 0x0, x11);
  fiat_p384_cmovznz_u64(&x110, x104, 0x0, x12);
  fiat_p384_cmovznz_u64(&x111, x104, 0x0, x13);
  fiat_p384_addcarryx_u64(&x112, &x113, 0x0, x28, x105);
  fiat_p384_addcarryx_u64(&x114, &x115, x113, x29, x106);
  fiat_p384_addcarryx_u64(&x116, &x117, x115, x30, x107);
  fiat_p384_addcarryx_u64(&x118, &x119, x117, x31, x108);
  fiat_p384_addcarryx_u64(&x120, &x121, x119, x32, x109);
  fiat_p384_addcarryx_u64(&x122, &x123, x121, x33, x110);
  fiat_p384_addcarryx_u64(&x124, &x125, x123, x34, x111);
  fiat_p384_cmovznz_u64(&x126, x104, 0x0, x35);
  fiat_p384_cmovznz_u64(&x127, x104, 0x0, x36);
  fiat_p384_cmovznz_u64(&x128, x104, 0x0, x37);
  fiat_p384_cmovznz_u64(&x129, x104, 0x0, x38);
  fiat_p384_cmovznz_u64(&x130, x104, 0x0, x39);
  fiat_p384_cmovznz_u64(&x131, x104, 0x0, x40);
  fiat_p384_addcarryx_u64(&x132, &x133, 0x0, x98, x126);
  fiat_p384_addcarryx_u64(&x134, &x135, x133, x99, x127);
  fiat_p384_addcarryx_u64(&x136, &x137, x135, x100, x128);
  fiat_p384_addcarryx_u64(&x138, &x139, x137, x101, x129);
  fiat_p384_addcarryx_u64(&x140, &x141, x139, x102, x130);
  fiat_p384_addcarryx_u64(&x142, &x143, x141, x103, x131);
  fiat_p384_subborrowx_u64(&x144, &x145, 0x0, x132, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u64(&x146, &x147, x145, x134, UINT64_C(0xffffffff00000000));
  fiat_p384_subborrowx_u64(&x148, &x149, x147, x136, UINT64_C(0xfffffffffffffffe));
  fiat_p384_subborrowx_u64(&x150, &x151, x149, x138, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x152, &x153, x151, x140, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x154, &x155, x153, x142, UINT64_C(0xffffffffffffffff));
  fiat_p384_subborrowx_u64(&x156, &x157, x155, x143, 0x0);
  fiat_p384_addcarryx_u64(&x158, &x159, 0x0, x6, 0x1);
  x160 = ((x112 >> 1) | ((x114 << 63) & UINT64_C(0xffffffffffffffff)));
  x161 = ((x114 >> 1) | ((x116 << 63) & UINT64_C(0xffffffffffffffff)));
  x162 = ((x116 >> 1) | ((x118 << 63) & UINT64_C(0xffffffffffffffff)));
  x163 = ((x118 >> 1) | ((x120 << 63) & UINT64_C(0xffffffffffffffff)));
  x164 = ((x120 >> 1) | ((x122 << 63) & UINT64_C(0xffffffffffffffff)));
  x165 = ((x122 >> 1) | ((x124 << 63) & UINT64_C(0xffffffffffffffff)));
  x166 = ((x124 & UINT64_C(0x8000000000000000)) | (x124 >> 1));
  fiat_p384_cmovznz_u64(&x167, x66, x53, x41);
  fiat_p384_cmovznz_u64(&x168, x66, x55, x43);
  fiat_p384_cmovznz_u64(&x169, x66, x57, x45);
  fiat_p384_cmovznz_u64(&x170, x66, x59, x47);
  fiat_p384_cmovznz_u64(&x171, x66, x61, x49);
  fiat_p384_cmovznz_u64(&x172, x66, x63, x51);
  fiat_p384_cmovznz_u64(&x173, x157, x144, x132);
  fiat_p384_cmovznz_u64(&x174, x157, x146, x134);
  fiat_p384_cmovznz_u64(&x175, x157, x148, x136);
  fiat_p384_cmovznz_u64(&x176, x157, x150, x138);
  fiat_p384_cmovznz_u64(&x177, x157, x152, x140);
  fiat_p384_cmovznz_u64(&x178, x157, x154, x142);
  *out1 = x158;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out3[0] = x160;
  out3[1] = x161;
  out3[2] = x162;
  out3[3] = x163;
  out3[4] = x164;
  out3[5] = x165;
  out3[6] = x166;
  out4[0] = x167;
  out4[1] = x168;
  out4[2] = x169;
  out4[3] = x170;
  out4[4] = x171;
  out4[5] = x172;
  out5[0] = x173;
  out5[1] = x174;
  out5[2] = x175;
  out5[3] = x176;
  out5[4] = x177;
  out5[5] = x178;
}

/*
 * The function fiat_p384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
 * Postconditions:
 *   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if (log2 m) + 1 < 46 then ⌊(49 * ((log2 m) + 1) + 80) / 17⌋ else ⌊(49 * ((log2 m) + 1) + 57) / 17⌋)
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p384_divstep_precomp(uint64_t out1[6]) {
  out1[0] = UINT64_C(0xfff69400fff18fff);
  out1[1] = UINT64_C(0x2b7feffffd3ff);
  out1[2] = UINT64_C(0xfffedbfffffe97ff);
  out1[3] = UINT64_C(0x2840000002fff);
  out1[4] = UINT64_C(0x6040000050400);
  out1[5] = UINT64_C(0xfffc480000038000);
}
