"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.GlobalVariables = exports.ActionCategory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
var ActionCategory;
(function (ActionCategory) {
    ActionCategory["SOURCE"] = "Source";
    ActionCategory["BUILD"] = "Build";
    ActionCategory["TEST"] = "Test";
    ActionCategory["APPROVAL"] = "Approval";
    ActionCategory["DEPLOY"] = "Deploy";
    ActionCategory["INVOKE"] = "Invoke";
})(ActionCategory = exports.ActionCategory || (exports.ActionCategory = {}));
/**
 * The CodePipeline variables that are global, not bound to a specific action.
 *
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 *
 * @stability stable
 */
class GlobalVariables {
}
exports.GlobalVariables = GlobalVariables;
_a = JSII_RTTI_SYMBOL_1;
GlobalVariables[_a] = { fqn: "@aws-cdk/aws-codepipeline.GlobalVariables", version: "1.108.1" };
/**
 * The identifier of the current pipeline execution.
 *
 * @stability stable
 */
GlobalVariables.executionId = '#{codepipeline.PipelineExecutionId}';
/**
 * Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 *
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 *
 * @stability stable
 */
class Action {
    /**
     * @stability stable
     */
    constructor() {
        this._variableReferenced = false;
        this._namespaceToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this._actualNamespace === undefined) {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
                else {
                    return this._customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this._customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this._variableReferenced ? this._actualNamespace : undefined);
                }
            },
        });
    }
    /**
     * The simple properties of the Action, like its Owner, name, etc.
     *
     * Note that this accessor will be called before the {@link bind} callback.
     *
     * @stability stable
     */
    get actionProperties() {
        if (this.__actionProperties === undefined) {
            const actionProperties = this.providedActionProperties;
            this._customerProvidedNamespace = actionProperties.variablesNamespace;
            this.__actionProperties = {
                ...actionProperties,
                variablesNamespace: this._customerProvidedNamespace === undefined
                    ? this._namespaceToken
                    : this._customerProvidedNamespace,
            };
        }
        return this.__actionProperties;
    }
    /**
     * The callback invoked when this Action is added to a Pipeline.
     *
     * @stability stable
     */
    bind(scope, stage, options) {
        this.__pipeline = stage.pipeline;
        this.__stage = stage;
        this.__scope = scope;
        this._actualNamespace = this._customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this._customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    /**
     * Creates an Event that will be triggered whenever the state of this Action changes.
     *
     * @stability stable
     */
    onStateChange(name, target, options) {
        const rule = new events.Rule(this._scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this._pipeline.pipelineArn],
            detail: {
                stage: [this._stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    /**
     * @stability stable
     */
    variableExpression(variableName) {
        this._variableReferenced = true;
        return `#{${this._namespaceToken}.${variableName}}`;
    }
    get _pipeline() {
        if (this.__pipeline) {
            return this.__pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get _stage() {
        if (this.__stage) {
            return this.__stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get _scope() {
        if (this.__scope) {
            return this.__scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_b = JSII_RTTI_SYMBOL_1;
Action[_b] = { fqn: "@aws-cdk/aws-codepipeline.Action", version: "1.108.1" };
//# sourceMappingURL=data:application/json;base64,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