"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCliAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
/**
 * A CDK Asset construct that contains the AWS CLI.
 */
class AwsCliAsset extends s3_assets.Asset {
    constructor(scope, id, options = {}) {
        super(scope, id, {
            path: path.join(__dirname, 'layer.zip'),
            // we hash the layer directory (it contains the tools versions and Dockerfile) because hashing the zip is non-deterministic
            assetHash: aws_cdk_lib_1.FileSystem.fingerprint(path.join(__dirname, '../layer')),
            ...options,
        });
    }
}
exports.AwsCliAsset = AwsCliAsset;
_a = JSII_RTTI_SYMBOL_1;
AwsCliAsset[_a] = { fqn: "@aws-cdk/asset-awscli-v1.AwsCliAsset", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2xpLWFzc2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2F3c2NsaS1hc3NldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3Qiw2Q0FBeUM7QUFDekMsdURBQXVEO0FBR3ZEOztHQUVHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsU0FBUyxDQUFDLEtBQUs7SUFDOUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxVQUFrQyxFQUFFO1FBQzVFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFdBQVcsQ0FBQztZQUN2QywySEFBMkg7WUFDM0gsU0FBUyxFQUFFLHdCQUFVLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1lBQ25FLEdBQUcsT0FBTztTQUNYLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBUkgsa0NBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIHMzX2Fzc2V0cyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMtYXNzZXRzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIEEgQ0RLIEFzc2V0IGNvbnN0cnVjdCB0aGF0IGNvbnRhaW5zIHRoZSBBV1MgQ0xJLlxuICovXG5leHBvcnQgY2xhc3MgQXdzQ2xpQXNzZXQgZXh0ZW5kcyBzM19hc3NldHMuQXNzZXQge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBvcHRpb25zOiBzM19hc3NldHMuQXNzZXRPcHRpb25zID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBhdGg6IHBhdGguam9pbihfX2Rpcm5hbWUsICdsYXllci56aXAnKSxcbiAgICAgIC8vIHdlIGhhc2ggdGhlIGxheWVyIGRpcmVjdG9yeSAoaXQgY29udGFpbnMgdGhlIHRvb2xzIHZlcnNpb25zIGFuZCBEb2NrZXJmaWxlKSBiZWNhdXNlIGhhc2hpbmcgdGhlIHppcCBpcyBub24tZGV0ZXJtaW5pc3RpY1xuICAgICAgYXNzZXRIYXNoOiBGaWxlU3lzdGVtLmZpbmdlcnByaW50KHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9sYXllcicpKSxcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==