# Generated by Django 3.2.11 on 2022-03-04 08:02

from django.db import migrations, models


def fill_search_text(apps, schema_editor):
    # Fills in search_text field
    Incident = apps.get_model('argus_incident', 'Incident')
    for incident in Incident.objects.all():
        search_fields = []
        for event in incident.events.all():
            search_fields.append(event.description)
        incident.search_text = " ".join(search_fields)
        incident.save()

def clear_search_text(apps, schema_editor):
    # clears search_text field
    Incident = apps.get_model('argus_incident', 'Incident')
    for incident in Incident.objects.all():
        incident.search_text = ""
        incident.save()


class Migration(migrations.Migration):

    dependencies = [
        ('argus_incident', '0005_alter_event_type'),
    ]

    operations = [
        migrations.AddField(
            model_name='incident',
            name='search_text',
            field=models.TextField(blank=True, default='', verbose_name='Search Text'),
        ),
        migrations.RunPython(fill_search_text, clear_search_text),
    ]
