"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-firehose-s3-and-analytics-stack');
// Definitions
const props = {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    }
};
new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-firehose-s3-and-analytics-stack', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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