"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseToAnalyticsAndS3 = void 0;
const aws_kinesisfirehose_s3_1 = require("@aws-solutions-constructs/aws-kinesisfirehose-s3");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
/**
 * @summary The KinesisFirehoseToAnalyticsAndS3 class.
 */
class KinesisFirehoseToAnalyticsAndS3 extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the KinesisFirehoseToAnalyticsAndS3 class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Setup the kinesisfirehose-s3 pattern
        const kinesisFirehoseToS3Props = {
            kinesisFirehoseProps: props.kinesisFirehoseProps,
            existingBucketObj: props.existingBucketObj,
            bucketProps: props.bucketProps
        };
        // Add the kinesisfirehose-s3 pattern
        const kfs = new aws_kinesisfirehose_s3_1.KinesisFirehoseToS3(this, 'KinesisFirehoseToS3', kinesisFirehoseToS3Props);
        // Add the Kinesis Analytics application
        this.kinesisAnalytics = defaults.buildKinesisAnalyticsApp(this, {
            kinesisFirehose: kfs.kinesisFirehose,
            kinesisAnalyticsProps: props.kinesisAnalyticsProps
        });
        this.kinesisFirehose = kfs.kinesisFirehose;
        this.kinesisFirehoseLogGroup = kfs.kinesisFirehoseLogGroup;
        this.kinesisFirehoseRole = kfs.kinesisFirehoseRole;
        this.s3Bucket = kfs.s3Bucket;
        this.s3LoggingBucket = kfs.s3LoggingBucket;
    }
}
exports.KinesisFirehoseToAnalyticsAndS3 = KinesisFirehoseToAnalyticsAndS3;
//# sourceMappingURL=data:application/json;base64,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