"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
// Definitions
const props = {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    }
};
new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-firehose-s3-and-analytics-stack', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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