"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const app = new aws_cdk_lib_1.App();
// Empty arguments
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-kinesisfirehose-analytics-s3', {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    },
    loggingBucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        bucketName: 'custom-logging-bucket',
        encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
        versioned: true
    }
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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