from __future__ import annotations

import curses

from babi.margin import Margin
from babi.prompt import PromptResult


class Status:
    def __init__(self) -> None:
        self._status = ''
        self._action_counter = -1

    def update(self, status: str) -> None:
        self._status = status
        self._action_counter = 25

    def clear(self) -> None:
        self._status = ''

    def draw(self, stdscr: curses._CursesWindow, margin: Margin) -> None:
        if margin.footer or self._status:
            stdscr.insstr(margin.lines - 1, 0, ' ' * margin.cols)
            if self._status:
                status = f' {self._status} '
                x = (margin.cols - len(status)) // 2
                if x < 0:
                    x = 0
                    status = status.strip()
                stdscr.insstr(margin.lines - 1, x, status, curses.A_REVERSE)

    def tick(self, margin: Margin) -> None:
        # when the window is only 1-tall, hide the status quicker
        if margin.footer:
            self._action_counter -= 1
        else:
            self._action_counter -= 24
        if self._action_counter < 0:
            self.clear()

    def cancelled(self) -> PromptResult:
        self.update('cancelled')
        return PromptResult.CANCELLED
