import * as constructs from 'constructs';
/**
 * Information about the Codebuild or CodePipeline associated with a notification source.
 *
 * @stability stable
 */
export interface NotificationRuleSourceConfig {
    /**
     * The Amazon Resource Name (ARN) of the notification source.
     *
     * @stability stable
     */
    readonly sourceArn: string;
}
/**
 * Represents a notification source The source that allows CodeBuild and CodePipeline to associate with this rule.
 *
 * @stability stable
 */
export interface INotificationRuleSource {
    /**
     * Returns a source configuration for notification rule.
     *
     * @stability stable
     */
    bindAsNotificationRuleSource(scope: constructs.Construct): NotificationRuleSourceConfig;
}
