# Prerequisites

* Python 3.7
* AWS Credentials

# AWS Container Launcher (aws-container-launcher)

AWS Container Launcher makes it easy to programmatically run a Docker container in AWS using the Python package.

| WARNING: After processing a job, you are in charge of destroying the infrastructure. Do not forget to call the "destroy" method; otherwise, the instance will continue to operate and you will be charged by Amazon. |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|


# Instance type determination

You can specify the instance type explicitly or set the CPU and memory, and the package will automatically select the optimal instance type for you.

# Usage

To better understand, familiarize yourself with the available methods and the [start_container](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/START_CONTAINER.MD) method in particular.

# Client

* [Client configuration](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/client/CONFIGURATION.MD)

# Methods

* [start_container](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/START_CONTAINER.MD)
* [get_container_status](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/GET_CONTAINER_STATUS.MD)
* [get_container_record](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/GET_CONTAINER_RECORD.MD)
* [destroy](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/DESTROY.MD)
* [delete_monitoring_table](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/method/DELETE_MONITORING_TABLE.MD)

# Storage

* [SSD instance store](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/storage/SSD.MD)
* [EBS](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/storage/EBS.MD)
* [Amazon FSx for Lustre](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/storage/FSX.MD)
* [EFS](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/storage/EFS.MD)

# Spot instance

* [Using spot instances](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/SPOT_INSTANCE.MD)

# Scaling options

* [Scaling in](https://github.com/kankou-aliaksei/aws-container-launcher/blob/main/doc/scaling/SCALING_IN.MD)
