"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const lib_1 = require("../lib");
const stepfunctions = require("@aws-cdk/aws-stepfunctions");
const core_2 = require("@aws-solutions-constructs/core");
const app = new core_1.App();
// Empty arguments
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
const startState = new stepfunctions.Pass(stack, 'StartState');
new lib_1.S3ToStepfunctions(stack, 'test-s3-stepfunctions', {
    stateMachineProps: {
        definition: startState
    },
    bucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
    },
    loggingBucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
        bucketName: 'custom-logging-bucket',
        encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
        versioned: true
    },
    logGroupProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY
    }
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY3VzdG9tTG9nZ2luZ0J1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmN1c3RvbUxvZ2dpbmdCdWNrZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILGdCQUFnQjtBQUNoQix3Q0FBMEQ7QUFDMUQsNENBQW1EO0FBQ25ELGdDQUEyQztBQUMzQyw0REFBNEQ7QUFDNUQseURBQXdFO0FBRXhFLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFFdEIsa0JBQWtCO0FBQ2xCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSw2QkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0FBRWpFLE1BQU0sVUFBVSxHQUFHLElBQUksYUFBYSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFFL0QsSUFBSSx1QkFBaUIsQ0FBQyxLQUFLLEVBQUUsdUJBQXVCLEVBQUU7SUFDcEQsaUJBQWlCLEVBQUU7UUFDakIsVUFBVSxFQUFFLFVBQVU7S0FDdkI7SUFDRCxXQUFXLEVBQUU7UUFDWCxhQUFhLEVBQUUsb0JBQWEsQ0FBQyxPQUFPO0tBQ3JDO0lBQ0Qsa0JBQWtCLEVBQUU7UUFDbEIsYUFBYSxFQUFFLG9CQUFhLENBQUMsT0FBTztRQUNwQyxVQUFVLEVBQUUsdUJBQXVCO1FBQ25DLFVBQVUsRUFBRSx5QkFBZ0IsQ0FBQyxVQUFVO1FBQ3ZDLFNBQVMsRUFBRSxJQUFJO0tBQ2hCO0lBQ0QsYUFBYSxFQUFFO1FBQ2IsYUFBYSxFQUFFLG9CQUFhLENBQUMsT0FBTztLQUNyQztDQUNGLENBQUMsQ0FBQztBQUNILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuLy8vICFjZGstaW50ZWcgKlxuaW1wb3J0IHsgQXBwLCBTdGFjaywgUmVtb3ZhbFBvbGljeSB9IGZyb20gXCJAYXdzLWNkay9jb3JlXCI7XG5pbXBvcnQgeyBCdWNrZXRFbmNyeXB0aW9uIH0gZnJvbSBcIkBhd3MtY2RrL2F3cy1zM1wiO1xuaW1wb3J0IHsgUzNUb1N0ZXBmdW5jdGlvbnMgfSBmcm9tIFwiLi4vbGliXCI7XG5pbXBvcnQgKiBhcyBzdGVwZnVuY3Rpb25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCB7IGdlbmVyYXRlSW50ZWdTdGFja05hbWUgfSBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmUnO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbi8vIEVtcHR5IGFyZ3VtZW50c1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBnZW5lcmF0ZUludGVnU3RhY2tOYW1lKF9fZmlsZW5hbWUpKTtcblxuY29uc3Qgc3RhcnRTdGF0ZSA9IG5ldyBzdGVwZnVuY3Rpb25zLlBhc3Moc3RhY2ssICdTdGFydFN0YXRlJyk7XG5cbm5ldyBTM1RvU3RlcGZ1bmN0aW9ucyhzdGFjaywgJ3Rlc3QtczMtc3RlcGZ1bmN0aW9ucycsIHtcbiAgc3RhdGVNYWNoaW5lUHJvcHM6IHtcbiAgICBkZWZpbml0aW9uOiBzdGFydFN0YXRlXG4gIH0sXG4gIGJ1Y2tldFByb3BzOiB7XG4gICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICB9LFxuICBsb2dnaW5nQnVja2V0UHJvcHM6IHtcbiAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgYnVja2V0TmFtZTogJ2N1c3RvbS1sb2dnaW5nLWJ1Y2tldCcsXG4gICAgZW5jcnlwdGlvbjogQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELFxuICAgIHZlcnNpb25lZDogdHJ1ZVxuICB9LFxuICBsb2dHcm91cFByb3BzOiB7XG4gICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZXG4gIH1cbn0pO1xuYXBwLnN5bnRoKCk7XG4iXX0=