/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gciatto.kt.math.BitSieve;
import org.gciatto.kt.math.MutableBigInteger;
import org.gciatto.kt.math.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\bF\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0007\u0018\u0000 \u00a7\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u00a7\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u0017\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010B\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0013B\u0017\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017B\u001f\b\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0005\u0012\u0006\u0010\u0019\u001a\u00020\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001aB\u0017\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001bB\u0017\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001cB\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u00108\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\u0010\u00109\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\b\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0007J\u0015\u0010>\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b?J\u0015\u0010>\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b?J\u0011\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0087\u0002J\u001b\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00000D2\u0006\u0010\u0002\u001a\u00020\u0000H\u0007\u00a2\u0006\u0002\u0010EJ\u001b\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00000D2\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\u001b\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000D2\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\u0010\u0010H\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0010\u0010I\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0013\u0010J\u001a\u00020K2\b\u0010A\u001a\u0004\u0018\u00010LH\u0096\u0002J\b\u0010M\u001a\u00020\u0000H\u0002J\b\u0010N\u001a\u00020\u0005H\u0002J\u0010\u0010O\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0007J\u0010\u0010P\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\u0011\u0010Q\u001a\u00020K2\u0006\u0010=\u001a\u00020\u0005H\u0087\u0002J\u0010\u0010R\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0010\u0010S\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0002J(\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u0005H\u0002J\u0010\u0010Y\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0002J\b\u0010Z\u001a\u00020\u0005H\u0016J\u0010\u0010[\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0010\u0010\\\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\bH\u0002J\b\u0010]\u001a\u00020\u0003H\u0002J\u0010\u0010^\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\u0010\u0010_\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\u0011\u0010`\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0087\u0002J\u0010\u0010a\u001a\u00020\u00002\u0006\u0010b\u001a\u00020\u0005H\u0002J\u0010\u0010c\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0000H\u0007J\u0018\u0010e\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0000H\u0007J\u0018\u0010g\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010b\u001a\u00020\u0005H\u0002J\b\u0010h\u001a\u00020\u0000H\u0007J\t\u0010i\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010j\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0000H\u0002J\u0010\u0010m\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J \u0010n\u001a\u00020\u00052\u0006\u0010o\u001a\u00020\u00112\u0006\u0010p\u001a\u00020\u00052\u0006\u0010q\u001a\u00020\u0005H\u0002J\b\u0010r\u001a\u00020KH\u0002J\u001a\u0010s\u001a\u00020K2\u0006\u0010t\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0011\u0010u\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0087\u0002J\u0015\u0010v\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bwJ\u0011\u0010x\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u0005H\u0087\u0004J\u001f\u0010y\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010z\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b{J\u0011\u0010|\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0000H\u0087\u0002J\u0010\u0010}\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\u0010\u0010~\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0010\u0010\u007f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u001b\u0010\u0080\u0001\u001a\u00020;2\u0006\u0010=\u001a\u00020\u00052\u0007\u0010\u0081\u0001\u001a\u00020KH\u0087\u0002J\u0011\u0010\u0082\u0001\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0007J\u0011\u0010\u0083\u0001\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0012\u0010\u0084\u0001\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0087\u0004J\u0012\u0010\u0085\u0001\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005H\u0087\u0004J\u0011\u0010\u0086\u0001\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\t\u0010\u0087\u0001\u001a\u00020\u0000H\u0007J\u0015\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000DH\u0007\u00a2\u0006\u0003\u0010\u0089\u0001J\t\u0010\u008a\u0001\u001a\u00020\u0000H\u0002J\t\u0010\u008b\u0001\u001a\u00020\u0000H\u0002J\t\u0010\u008c\u0001\u001a\u00020\u0000H\u0002J\u0011\u0010\u008d\u0001\u001a\u00020K2\u0006\u0010=\u001a\u00020\u0005H\u0007J\u0012\u0010\u008e\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010\u008f\u0001\u001a\u00020\u00002\u0007\u0010\u0090\u0001\u001a\u00020\u001dH\u0000\u00a2\u0006\u0003\b\u0091\u0001J\n\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0007J\t\u0010\u0094\u0001\u001a\u00020\u0003H\u0007J\n\u0010\u0095\u0001\u001a\u00030\u0093\u0001H\u0007J\n\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0007J\n\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0007J\n\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0007J\t\u0010\u009c\u0001\u001a\u00020\u0005H\u0007J\t\u0010\u009d\u0001\u001a\u00020\u0005H\u0007J\t\u0010\u009e\u0001\u001a\u00020\u001dH\u0007J\u0007\u0010\u009f\u0001\u001a\u00020\u001dJ\n\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001H\u0007J\n\u0010\u00a2\u0001\u001a\u00030\u00a1\u0001H\u0007J\t\u0010\u00a3\u0001\u001a\u00020\u000eH\u0016J\u0011\u0010\u00a3\u0001\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\n\u0010\u00a4\u0001\u001a\u00020\u0000H\u0087\u0002J\n\u0010\u00a5\u0001\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010\u00a6\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0007R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010(R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010(R\u0014\u0010/\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010(R\u0014\u00101\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010(R\u0014\u00103\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010(R\u0014\u00105\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010(R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b7\u0010(\u00a8\u0006\u00a8\u0001"}, d2={"Lorg/gciatto/kt/math/BigInteger;", "", "val", "", "off", "", "len", "([BII)V", "", "([I)V", "signum", "magnitude", "(I[BII)V", "(I[I)V", "", "radix", "(Ljava/lang/String;I)V", "", "sign", "([CII)V", "numBits", "rnd", "Lkotlin/random/Random;", "(ILkotlin/random/Random;)V", "bitLength", "certainty", "(IILkotlin/random/Random;)V", "([II)V", "([BI)V", "", "(J)V", "_bitCountPlusOne", "_bitLengthPlusOne", "_firstNonzeroIntNumPlusTwo", "_lowestSetBitPlusTwo", "_mag", "get_mag$kt_math", "()[I", "_signum", "get_signum$kt_math", "()I", "absoluteValue", "getAbsoluteValue", "()Lorg/gciatto/kt/math/BigInteger;", "bitCount", "getBitCount", "getBitLength", "intLength", "getIntLength", "lowestSetBit", "getLowestSetBit", "signBit", "getSignBit", "signInt", "getSignInt", "getSignum", "and", "andNot", "checkRange", "", "clearBit", "n", "compareMagnitude", "compareMagnitude$kt_math", "compareTo", "other", "div", "divideAndRemainder", "", "(Lorg/gciatto/kt/math/BigInteger;)[Lorg/gciatto/kt/math/BigInteger;", "divideAndRemainderBurnikelZiegler", "divideAndRemainderKnuth", "divideBurnikelZiegler", "divideKnuth", "equals", "", "", "exactDivideBy3", "firstNonzeroIntNum", "flipBit", "gcd", "get", "getInt", "getLower", "getToomSlice", "lowerSize", "upperSize", "slice", "fullsize", "getUpper", "hashCode", "isProbablePrime", "javaIncrement", "magSerializedForm", "max", "min", "minus", "mod2", "p", "modInverse", "m", "modPow", "exponent", "modPow2", "nextProbablePrime", "not", "oddModPow", "y", "z", "or", "parseInt", "source", "start", "end", "passesLucasLehmer", "passesMillerRabin", "iterations", "plus", "plusLong", "plusLong$kt_math", "pow", "primeToCertainty", "random", "primeToCertainty$kt_math", "rem", "remainder", "remainderBurnikelZiegler", "remainderKnuth", "set", "b", "setBit", "shiftRightImpl", "shl", "shr", "smallToString", "sqrt", "sqrtAndRemainder", "()[Lorg/gciatto/kt/math/BigInteger;", "square", "squareKaratsuba", "squareToomCook3", "testBit", "times", "timesLong", "v", "timesLong$kt_math", "toByte", "", "toByteArray", "toByteExact", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toIntExact", "toLong", "toLongExact", "toShort", "", "toShortExact", "toString", "unaryMinus", "unaryPlus", "xor", "Companion", "kt-math"})
public final class BigInteger
implements Comparable<BigInteger> {
    @NotNull
    public static final Companion Companion;
    private final int _signum;
    @NotNull
    private final int[] _mag;
    private int _bitCountPlusOne;
    private int _bitLengthPlusOne;
    private int _lowestSetBitPlusTwo;
    private int _firstNonzeroIntNumPlusTwo;
    public static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int PRIME_SEARCH_BIT_LENGTH_LIMIT = 500000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    public static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    public static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int SCHOENHAGE_BASE_CONVERSION_THRESHOLD = 20;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    private static final int MONTGOMERY_INTRINSIC_THRESHOLD = 512;
    @NotNull
    private static final long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    @NotNull
    private static final BigInteger SMALL_PRIME_PRODUCT;
    private static final int MAX_CONSTANT;
    @NotNull
    private static final BigInteger[] posConst;
    @NotNull
    private static final BigInteger[] negConst;
    @NotNull
    private static BigInteger[][] powerCache;
    @NotNull
    private static final double[] logCache;
    private static final double LOG_TWO;
    @NotNull
    private static final BigInteger ZERO;
    @NotNull
    private static final BigInteger ONE;
    @NotNull
    private static final BigInteger TWO;
    @NotNull
    private static final BigInteger NEGATIVE_ONE;
    @NotNull
    private static final BigInteger TEN;
    @NotNull
    private static int[] bnExpModThreshTable;
    @NotNull
    private static final String[] zeros;
    @NotNull
    private static final int[] digitsPerLong;
    @NotNull
    private static final BigInteger[] longRadix;
    @NotNull
    private static final int[] digitsPerInt;
    @NotNull
    private static final int[] intRadix;

    public final int get_signum$kt_math() {
        return this._signum;
    }

    @NotNull
    public final int[] get_mag$kt_math() {
        return this._mag;
    }

    private final int getLowestSetBit() {
        int lsb = this._lowestSetBitPlusTwo - 2;
        if (lsb == -2) {
            lsb = 0;
            if (this._signum == 0) {
                --lsb;
            } else {
                int i = 0;
                int b = 0;
                i = 0;
                b = this.getInt(i);
                while (b == 0) {
                    int n = i;
                    i = n + 1;
                    b = this.getInt(i);
                }
                lsb += (i << 5) + UtilsKt.numberOfTrailingZeros(b);
            }
            this._lowestSetBitPlusTwo = lsb + 2;
        }
        return lsb;
    }

    public BigInteger(@NotNull byte[] val, int off, int len) {
        Intrinsics.checkNotNullParameter(val, "val");
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (off < 0 || off >= val.length || len < 0 || len > val.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (val[off] < 0) {
            this._mag = BigInteger.Companion.makePositive(val, off, len);
            this._signum = -1;
        } else {
            this._mag = BigInteger.Companion.stripLeadingZeroBytes(val, off, len);
            int n = this._signum = this._mag.length == 0 ? 0 : 1;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ BigInteger(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    private BigInteger(int[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this._mag = BigInteger.Companion.makePositive(val);
            this._signum = -1;
        } else {
            this._mag = BigInteger.Companion.trustedStripLeadingZeroInts(val);
            int n = this._signum = this._mag.length == 0 ? 0 : 1;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public BigInteger(int signum, @NotNull byte[] magnitude, int off, int len) {
        Intrinsics.checkNotNullParameter(magnitude, "magnitude");
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid _signum value");
        }
        if (off < 0 || len < 0 || len > 0 && (off >= magnitude.length || len > magnitude.length - off)) {
            throw new IndexOutOfBoundsException();
        }
        this._mag = BigInteger.Companion.stripLeadingZeroBytes(magnitude, off, len);
        if (this._mag.length == 0) {
            this._signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("_signum-magnitude mismatch");
            }
            this._signum = signum;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ BigInteger(int n, byte[] byArray, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byArray.length;
        }
        this(n, byArray, n2, n3);
    }

    private BigInteger(int signum, int[] magnitude) {
        this._mag = BigInteger.Companion.stripLeadingZeroInts(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid _signum value");
        }
        if (this._mag.length == 0) {
            this._signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("_signum-magnitude mismatch");
            }
            this._signum = signum;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public BigInteger(@NotNull String val, int radix) {
        Intrinsics.checkNotNullParameter(val, "val");
        int cursor = 0;
        int numDigits = 0;
        int len = val.length();
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (len == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        int sign = 1;
        int index1 = StringsKt.lastIndexOf$default((CharSequence)val, '-', 0, false, 6, null);
        int index2 = StringsKt.lastIndexOf$default((CharSequence)val, '+', 0, false, 6, null);
        if (index1 >= 0) {
            if (index1 != 0 || index2 >= 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            sign = -1;
            cursor = 1;
        } else if (index2 >= 0) {
            if (index2 != 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            cursor = 1;
        }
        if (cursor == len) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        while (cursor < len && UtilsKt.toDigit(val.charAt(cursor), radix) == 0) {
            int n = cursor;
            cursor = n + 1;
        }
        if (cursor == len) {
            this._signum = 0;
            this._mag = BigInteger.ZERO._mag;
            return;
        }
        numDigits = len - cursor;
        this._signum = sign;
        long numBits = ((long)numDigits * bitsPerDigit[radix] >>> 10) + 1L;
        if (numBits + (long)31 >= 0x100000000L) {
            BigInteger.Companion.reportOverflow();
        }
        int numWords = (int)(numBits + (long)31) >>> 5;
        int[] magnitude = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[radix];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[radix];
        }
        String string2 = val;
        int n = cursor + firstGroupLen;
        boolean bl = false;
        String string3 = string2.substring(cursor, n);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String group = string3;
        cursor += firstGroupLen;
        string2 = group;
        n = 0;
        magnitude[numWords - 1] = Integer.parseInt(string2, CharsKt.checkRadix(radix));
        if (magnitude[numWords - 1] < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        int superRadix = intRadix[radix];
        int groupVal = 0;
        while (cursor < len) {
            String string4 = val;
            int n2 = cursor + digitsPerInt[radix];
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(string4.substring(cursor, n2), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            cursor += digitsPerInt[radix];
            string4 = group;
            n2 = 0;
            groupVal = Integer.parseInt(string4, CharsKt.checkRadix(radix));
            if (groupVal < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            BigInteger.Companion.destructiveMulAdd(magnitude, superRadix, groupVal);
        }
        this._mag = BigInteger.Companion.trustedStripLeadingZeroInts(magnitude);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ BigInteger(String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(string2, n);
    }

    public BigInteger(@NotNull char[] val, int sign, int len) {
        Intrinsics.checkNotNullParameter(val, "val");
        int cursor = 0;
        int numDigits = 0;
        while (cursor < len && UtilsKt.toDigit(val[cursor], 10) == 0) {
            int n = cursor;
            cursor = n + 1;
        }
        if (cursor == len) {
            this._signum = 0;
            this._mag = BigInteger.ZERO._mag;
            return;
        }
        numDigits = len - cursor;
        this._signum = sign;
        int numWords = 0;
        if (len < 10) {
            numWords = 1;
        } else {
            long numBits = ((long)numDigits * bitsPerDigit[10] >>> 10) + 1L;
            if (numBits + (long)31 >= 0x100000000L) {
                BigInteger.Companion.reportOverflow();
            }
            numWords = (int)(numBits + (long)31) >>> 5;
        }
        int[] magnitude = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[10];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[10];
        }
        magnitude[numWords - 1] = this.parseInt(val, cursor, cursor + firstGroupLen);
        cursor += firstGroupLen;
        while (cursor < len) {
            int groupVal = this.parseInt(val, cursor, cursor + digitsPerInt[10]);
            cursor += digitsPerInt[10];
            BigInteger.Companion.destructiveMulAdd(magnitude, BigInteger.intRadix[10], groupVal);
        }
        this._mag = BigInteger.Companion.trustedStripLeadingZeroInts(magnitude);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private final int parseInt(char[] source, int start, int end) {
        int result2 = UtilsKt.toDigit(source[start], 10);
        if (result2 == -1) {
            throw new NumberFormatException(StringsKt.concatToString(source));
        }
        int n = start + 1;
        if (n < end) {
            do {
                int index;
                int nextVal;
                if ((nextVal = UtilsKt.toDigit(source[index = n++], 10)) == -1) {
                    throw new NumberFormatException(StringsKt.concatToString(source));
                }
                result2 = 10 * result2 + nextVal;
            } while (n < end);
        }
        return result2;
    }

    public BigInteger(int numBits, @NotNull Random rnd) {
        Intrinsics.checkNotNullParameter(rnd, "rnd");
        this(1, BigInteger.Companion.randomBits(numBits, rnd), 0, 0, 12, null);
    }

    public BigInteger(int bitLength, int certainty, @NotNull Random rnd) {
        Intrinsics.checkNotNullParameter(rnd, "rnd");
        BigInteger prime = null;
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        prime = bitLength < 95 ? BigInteger.Companion.smallPrime(bitLength, certainty, rnd) : BigInteger.Companion.largePrime(bitLength, certainty, rnd);
        this._signum = 1;
        this._mag = prime._mag;
    }

    @NotNull
    public final BigInteger nextProbablePrime() {
        if (this._signum < 0) {
            throw new ArithmeticException(Intrinsics.stringPlus("start < 0: ", this));
        }
        if (this._signum == 0 || Intrinsics.areEqual(this, ONE)) {
            return TWO;
        }
        BigInteger result2 = this.plus(ONE);
        if (result2.getBitLength() < 95) {
            if (!result2.testBit(0)) {
                result2 = result2.plus(ONE);
            }
            while (true) {
                long r;
                if (result2.getBitLength() > 6 && ((r = result2.remainder(SMALL_PRIME_PRODUCT).toLong()) % (long)3 == 0L || r % (long)5 == 0L || r % (long)7 == 0L || r % (long)11 == 0L || r % (long)13 == 0L || r % (long)17 == 0L || r % (long)19 == 0L || r % (long)23 == 0L || r % (long)29 == 0L || r % (long)31 == 0L || r % (long)37 == 0L || r % (long)41 == 0L)) {
                    result2 = result2.plus(TWO);
                    continue;
                }
                if (result2.getBitLength() < 4) {
                    return result2;
                }
                if (result2.primeToCertainty$kt_math(100, null)) {
                    return result2;
                }
                result2 = result2.plus(TWO);
            }
        }
        if (result2.testBit(0)) {
            result2 = result2.minus(ONE);
        }
        int searchLen = BigInteger.Companion.getPrimeSearchLen(result2.getBitLength());
        while (true) {
            BitSieve searchSieve = new BitSieve(result2, searchLen);
            Intrinsics.checkNotNull(null);
            BigInteger candidate = searchSieve.retrieve(result2, 100, null);
            if (candidate != null) {
                return candidate;
            }
            result2 = result2.plus(Companion.of((long)(2 * searchLen)));
        }
    }

    public final boolean primeToCertainty$kt_math(int certainty, @Nullable Random random) {
        int rounds = 0;
        int n = 0x7FFFFFFE;
        boolean bl = false;
        int n2 = (Math.max(certainty, n) + 1) / 2;
        int sizeInBits = this.getBitLength();
        if (sizeInBits < 100) {
            rounds = 50;
            rounds = n2 < rounds ? n2 : rounds;
            return this.passesMillerRabin(rounds, random);
        }
        rounds = sizeInBits < 256 ? 27 : (sizeInBits < 512 ? 15 : (sizeInBits < 768 ? 8 : (sizeInBits < 1024 ? 4 : 2)));
        rounds = n2 < rounds ? n2 : rounds;
        return this.passesMillerRabin(rounds, random) && this.passesLucasLehmer();
    }

    private final boolean passesLucasLehmer() {
        BigInteger thisPlusOne = this.plus(ONE);
        int d = 5;
        while (BigInteger.Companion.jacobiSymbol(d, this) != -1) {
            int n;
            if (d < 0) {
                int n2 = d;
                boolean bl = false;
                n = Math.abs(n2) + 2;
            } else {
                n = -(d + 2);
            }
            d = n;
        }
        BigInteger u = BigInteger.Companion.lucasLehmerSequence(d, thisPlusOne, this);
        return Intrinsics.areEqual(u.rem(this), ZERO);
    }

    private final boolean passesMillerRabin(int iterations, Random rnd) {
        int n;
        BigInteger thisMinusOne;
        Random rnd2 = rnd;
        BigInteger m = thisMinusOne = this.minus(ONE);
        int a = m.getLowestSetBit();
        m = m.shr(a);
        if (rnd2 == null) {
            rnd2 = Random.Default;
        }
        if ((n = 0) < iterations) {
            do {
                int i = n++;
                BigInteger b = null;
                while ((b = new BigInteger(this.getBitLength(), rnd2)).compareTo(ONE) <= 0 || b.compareTo(this) >= 0) {
                }
                int j = 0;
                BigInteger z = b.modPow(m, this);
                while (!(j == 0 && Intrinsics.areEqual(z, ONE) || Intrinsics.areEqual(z, thisMinusOne))) {
                    if (j > 0 && Intrinsics.areEqual(z, ONE) || ++j == a) {
                        return false;
                    }
                    z = z.modPow(TWO, this);
                }
            } while (n < iterations);
        }
        return true;
    }

    public BigInteger(@NotNull int[] magnitude, int signum) {
        Intrinsics.checkNotNullParameter(magnitude, "magnitude");
        this._signum = magnitude.length == 0 ? 0 : signum;
        this._mag = magnitude;
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private BigInteger(byte[] magnitude, int signum) {
        this._signum = magnitude.length == 0 ? 0 : signum;
        this._mag = BigInteger.Companion.stripLeadingZeroBytes(magnitude, 0, magnitude.length);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private final void checkRange() {
        if (this._mag.length > 0x4000000 || this._mag.length == 0x4000000 && this._mag[0] < 0) {
            BigInteger.Companion.reportOverflow();
        }
    }

    private BigInteger(long val) {
        long val2 = val;
        if (val2 < 0L) {
            val2 = -val2;
            this._signum = -1;
        } else {
            this._signum = 1;
        }
        int highWord = (int)(val2 >>> 32);
        if (highWord == 0) {
            this._mag = new int[1];
            this._mag[0] = (int)val2;
        } else {
            this._mag = new int[2];
            this._mag[0] = highWord;
            this._mag[1] = (int)val2;
        }
    }

    @NotNull
    public final BigInteger plus(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        if (val._signum == 0) {
            return this;
        }
        if (this._signum == 0) {
            return val;
        }
        if (val._signum == this._signum) {
            return new BigInteger(BigInteger.Companion.sum(this._mag, val._mag), this._signum);
        }
        int cmp = this.compareMagnitude$kt_math(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.Companion.subtract(this._mag, val._mag) : BigInteger.Companion.subtract(val._mag, this._mag);
        resultMag = BigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @NotNull
    public final BigInteger plusLong$kt_math(long val) {
        int[] nArray;
        boolean bl;
        long l;
        if (val == 0L) {
            return this;
        }
        if (this._signum == 0) {
            return Companion.of(val);
        }
        if (MathKt.getSign(val) == this._signum) {
            long l2 = val;
            boolean bl2 = false;
            return new BigInteger(BigInteger.Companion.sum(this._mag, Math.abs(l2)), this._signum);
        }
        int cmp = this.compareMagnitude$kt_math(val);
        if (cmp == 0) {
            return ZERO;
        }
        if (cmp > 0) {
            l = val;
            bl = false;
            nArray = BigInteger.Companion.subtract(this._mag, Math.abs(l));
        } else {
            l = val;
            bl = false;
            nArray = BigInteger.Companion.subtract(Math.abs(l), this._mag);
        }
        int[] resultMag = nArray;
        resultMag = BigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @NotNull
    public final BigInteger minus(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        if (val._signum == 0) {
            return this;
        }
        if (this._signum == 0) {
            return val.unaryMinus();
        }
        if (val._signum != this._signum) {
            return new BigInteger(BigInteger.Companion.sum(this._mag, val._mag), this._signum);
        }
        int cmp = this.compareMagnitude$kt_math(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.Companion.subtract(this._mag, val._mag) : BigInteger.Companion.subtract(val._mag, this._mag);
        resultMag = BigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @NotNull
    public final BigInteger times(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        if (val._signum == 0 || this._signum == 0) {
            return ZERO;
        }
        int xlen = this._mag.length;
        if (val == this && xlen > 20) {
            return this.square();
        }
        int ylen = val._mag.length;
        if (xlen < 80 || ylen < 80) {
            int resultSign;
            int n = resultSign = this._signum == val._signum ? 1 : -1;
            if (val._mag.length == 1) {
                return BigInteger.Companion.multiplyByInt(this._mag, val._mag[0], resultSign);
            }
            if (this._mag.length == 1) {
                return BigInteger.Companion.multiplyByInt(val._mag, this._mag[0], resultSign);
            }
            int[] result2 = BigInteger.Companion.multiplyToLen(this._mag, xlen, val._mag, ylen, null);
            result2 = BigInteger.Companion.trustedStripLeadingZeroInts(result2);
            return new BigInteger(result2, resultSign);
        }
        return xlen < 240 && ylen < 240 ? BigInteger.Companion.multiplyKaratsuba(this, val) : BigInteger.Companion.multiplyToomCook3(this, val);
    }

    @NotNull
    public final BigInteger timesLong$kt_math(long v) {
        int n;
        long product2;
        int i;
        int rsign;
        long v2 = v;
        if (v2 == 0L || this._signum == 0) {
            return ZERO;
        }
        if (v2 == Long.MIN_VALUE) {
            return this.times(Companion.of(v2));
        }
        int n2 = rsign = v2 > 0L ? this._signum : -this._signum;
        if (v2 < 0L) {
            v2 = -v2;
        }
        long dh = v2 >>> 32;
        long dl = v2 & 0xFFFFFFFFL;
        int xlen = this._mag.length;
        int[] value = this._mag;
        int[] rmag = dh == 0L ? new int[xlen + 1] : new int[xlen + 2];
        long carry = 0L;
        int rstart = rmag.length - 1;
        int n3 = xlen - 1;
        if (0 <= n3) {
            do {
                i = n3--;
                product2 = ((long)value[i] & 0xFFFFFFFFL) * dl + carry;
                n = rstart;
                rstart = n + -1;
                rmag[n] = (int)product2;
                carry = product2 >>> 32;
            } while (0 <= n3);
        }
        rmag[rstart] = (int)carry;
        if (dh != 0L) {
            carry = 0L;
            rstart = rmag.length - 2;
            n3 = xlen - 1;
            if (0 <= n3) {
                do {
                    i = n3--;
                    product2 = ((long)value[i] & 0xFFFFFFFFL) * dh + ((long)rmag[rstart] & 0xFFFFFFFFL) + carry;
                    n = rstart;
                    rstart = n + -1;
                    rmag[n] = (int)product2;
                    carry = product2 >>> 32;
                } while (0 <= n3);
            }
            rmag[0] = (int)carry;
        }
        if (carry == 0L) {
            int[] nArray = rmag;
            int n4 = 1;
            int n5 = rmag.length;
            boolean bl = false;
            rmag = ArraysKt.copyOfRange(nArray, n4, n5);
        }
        return new BigInteger(rmag, rsign);
    }

    private final BigInteger getToomSlice(int lowerSize, int upperSize, int slice, int fullsize) {
        int start = 0;
        int end = 0;
        int sliceSize = 0;
        int len = 0;
        int offset = 0;
        len = this._mag.length;
        offset = fullsize - len;
        if (slice == 0) {
            start = 0 - offset;
            end = upperSize - 1 - offset;
        } else {
            start = upperSize + (slice - 1) * lowerSize - offset;
            end = start + lowerSize - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            return ZERO;
        }
        sliceSize = end - start + 1;
        if (sliceSize <= 0) {
            return ZERO;
        }
        if (start == 0 && sliceSize >= len) {
            return this.getAbsoluteValue();
        }
        int[] intSlice = new int[sliceSize];
        UtilsKt.arrayCopy(this._mag, start, intSlice, 0, sliceSize);
        return new BigInteger(BigInteger.Companion.trustedStripLeadingZeroInts(intSlice), 1);
    }

    private final BigInteger exactDivideBy3() {
        int len = this._mag.length;
        int[] result2 = new int[len];
        long x = 0L;
        long w = 0L;
        long q = 0L;
        long borrow = 0L;
        borrow = 0L;
        int n = len - 1;
        if (0 <= n) {
            do {
                int i = n--;
                x = (long)this._mag[i] & 0xFFFFFFFFL;
                w = x - borrow;
                borrow = borrow > x ? 1L : 0L;
                q = w * 0xAAAAAAABL & 0xFFFFFFFFL;
                result2[i] = (int)q;
                if (q < 0x55555556L) continue;
                long l = borrow;
                borrow = l + 1L;
                if (q < 0xAAAAAAABL) continue;
                l = borrow;
                borrow = l + 1L;
            } while (0 <= n);
        }
        result2 = BigInteger.Companion.trustedStripLeadingZeroInts(result2);
        return new BigInteger(result2, this._signum);
    }

    private final BigInteger getLower(int n) {
        int len = this._mag.length;
        if (len <= n) {
            return this.getAbsoluteValue();
        }
        int[] lowerInts = new int[n];
        UtilsKt.arrayCopy(this._mag, len - n, lowerInts, 0, n);
        return new BigInteger(BigInteger.Companion.trustedStripLeadingZeroInts(lowerInts), 1);
    }

    private final BigInteger getUpper(int n) {
        int len = this._mag.length;
        if (len <= n) {
            return ZERO;
        }
        int upperLen = len - n;
        int[] upperInts = new int[upperLen];
        UtilsKt.arrayCopy(this._mag, 0, upperInts, 0, upperLen);
        return new BigInteger(BigInteger.Companion.trustedStripLeadingZeroInts(upperInts), 1);
    }

    private final BigInteger square() {
        if (this._signum == 0) {
            return ZERO;
        }
        int len = this._mag.length;
        if (len < 128) {
            int[] z = BigInteger.Companion.squareToLen(this._mag, len, null);
            return new BigInteger(BigInteger.Companion.trustedStripLeadingZeroInts(z), 1);
        }
        return len < 216 ? this.squareKaratsuba() : this.squareToomCook3();
    }

    private final BigInteger squareKaratsuba() {
        int half = (this._mag.length + 1) / 2;
        BigInteger xl = this.getLower(half);
        BigInteger xh = this.getUpper(half);
        BigInteger xhs = xh.square();
        BigInteger xls = xl.square();
        return xhs.shl(half * 32).plus(xl.plus(xh).square().minus(xhs.plus(xls))).shl(half * 32).plus(xls);
    }

    private final BigInteger squareToomCook3() {
        int len = this._mag.length;
        int k = (len + 2) / 3;
        int r = len - 2 * k;
        BigInteger a0 = null;
        BigInteger a1 = null;
        BigInteger a2 = null;
        a2 = this.getToomSlice(k, r, 0, len);
        a1 = this.getToomSlice(k, r, 1, len);
        a0 = this.getToomSlice(k, r, 2, len);
        BigInteger v0 = null;
        BigInteger v1 = null;
        BigInteger v2 = null;
        BigInteger vm1 = null;
        BigInteger vinf = null;
        BigInteger t1 = null;
        BigInteger t2 = null;
        BigInteger tm1 = null;
        BigInteger da1 = null;
        v0 = a0.square();
        da1 = a2.plus(a0);
        vm1 = da1.minus(a1).square();
        da1 = da1.plus(a1);
        v1 = da1.square();
        vinf = a2.square();
        v2 = da1.plus(a2).shl(1).minus(a0).square();
        t2 = v2.minus(vm1).exactDivideBy3();
        tm1 = v1.minus(vm1).shr(1);
        t1 = v1.minus(v0);
        t2 = t2.minus(t1).shr(1);
        t1 = t1.minus(tm1).minus(vinf);
        t2 = t2.minus(vinf.shl(1));
        tm1 = tm1.minus(t2);
        int ss = k * 32;
        return vinf.shl(ss).plus(t2).shl(ss).plus(t1).shl(ss).plus(tm1).shl(ss).plus(v0);
    }

    @NotNull
    public final BigInteger div(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val._mag.length < 80 || this._mag.length - val._mag.length < 40 ? this.divideKnuth(val) : this.divideBurnikelZiegler(val);
    }

    private final BigInteger divideKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(val._mag);
        a.divideKnuth(b, q, false);
        return q.toBigInteger(this._signum * val._signum);
    }

    @NotNull
    public final BigInteger[] divideAndRemainder(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val._mag.length < 80 || this._mag.length - val._mag.length < 40 ? this.divideAndRemainderKnuth(val) : this.divideAndRemainderBurnikelZiegler(val);
    }

    private final BigInteger[] divideAndRemainderKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(val._mag);
        MutableBigInteger r = MutableBigInteger.divideKnuth$default(a, b, q, false, 4, null);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        bigIntegerArray[0] = q.toBigInteger(this._signum == val._signum ? 1 : -1);
        Intrinsics.checkNotNull(r);
        bigIntegerArray[1] = r.toBigInteger(this._signum);
        return bigIntegerArray;
    }

    @NotNull
    public final BigInteger remainder(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val._mag.length < 80 || this._mag.length - val._mag.length < 40 ? this.remainderKnuth(val) : this.remainderBurnikelZiegler(val);
    }

    private final BigInteger remainderKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(val._mag);
        MutableBigInteger mutableBigInteger = MutableBigInteger.divideKnuth$default(a, b, q, false, 4, null);
        Intrinsics.checkNotNull(mutableBigInteger);
        return mutableBigInteger.toBigInteger(this._signum);
    }

    private final BigInteger divideBurnikelZiegler(BigInteger val) {
        return this.divideAndRemainderBurnikelZiegler(val)[0];
    }

    private final BigInteger remainderBurnikelZiegler(BigInteger val) {
        return this.divideAndRemainderBurnikelZiegler(val)[1];
    }

    private final BigInteger[] divideAndRemainderBurnikelZiegler(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger(this).divideAndRemainderBurnikelZiegler(new MutableBigInteger(val), q);
        BigInteger qBigInt = q.isZero() ? ZERO : q.toBigInteger(this._signum * val._signum);
        BigInteger rBigInt = r.isZero() ? ZERO : r.toBigInteger(this._signum);
        BigInteger[] bigIntegerArray = new BigInteger[]{qBigInt, rBigInt};
        return bigIntegerArray;
    }

    @NotNull
    public final BigInteger pow(int exponent) {
        if (exponent < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this._signum == 0) {
            return exponent == 0 ? ONE : this;
        }
        BigInteger partToSquare = this.getAbsoluteValue();
        int powersOfTwo = partToSquare.getLowestSetBit();
        long bitsToShift = (long)powersOfTwo * (long)exponent;
        if (bitsToShift > Integer.MAX_VALUE) {
            BigInteger.Companion.reportOverflow();
        }
        int remainingBits = 0;
        if (powersOfTwo > 0) {
            remainingBits = (partToSquare = partToSquare.shr(powersOfTwo)).getBitLength();
            if (remainingBits == 1) {
                return this._signum < 0 && (exponent & 1) == 1 ? NEGATIVE_ONE.shl(powersOfTwo * exponent) : ONE.shl(powersOfTwo * exponent);
            }
        } else {
            remainingBits = partToSquare.getBitLength();
            if (remainingBits == 1) {
                return this._signum < 0 && (exponent & 1) == 1 ? NEGATIVE_ONE : ONE;
            }
        }
        long scaleFactor = (long)remainingBits * (long)exponent;
        if (partToSquare._mag.length == 1 && scaleFactor <= 62L) {
            int newSign = this._signum < 0 && (exponent & 1) == 1 ? -1 : 1;
            long result2 = 1L;
            long baseToPow2 = (long)partToSquare._mag[0] & 0xFFFFFFFFL;
            int workingExponent = exponent;
            while (workingExponent != 0) {
                if ((workingExponent & 1) == 1) {
                    result2 *= baseToPow2;
                }
                if ((workingExponent >>>= 1) == 0) continue;
                baseToPow2 *= baseToPow2;
            }
            return powersOfTwo > 0 ? (bitsToShift + scaleFactor <= 62L ? Companion.of((result2 << (int)bitsToShift) * (long)newSign) : Companion.of(result2 * (long)newSign).shl((int)bitsToShift)) : Companion.of(result2 * (long)newSign);
        }
        BigInteger answer = ONE;
        int workingExponent = exponent;
        while (workingExponent != 0) {
            if ((workingExponent & 1) == 1) {
                answer = answer.times(partToSquare);
            }
            if ((workingExponent >>>= 1) == 0) continue;
            partToSquare = partToSquare.square();
        }
        if (powersOfTwo > 0) {
            answer = answer.shl(powersOfTwo * exponent);
        }
        return this._signum < 0 && (exponent & 1) == 1 ? answer.unaryMinus() : answer;
    }

    @NotNull
    public final BigInteger sqrt() {
        if (this._signum < 0) {
            throw new ArithmeticException("Negative BigInteger");
        }
        return new MutableBigInteger(this._mag).sqrt().toBigInteger();
    }

    @NotNull
    public final BigInteger[] sqrtAndRemainder() {
        BigInteger s = this.sqrt();
        BigInteger r = this.minus(s.square());
        boolean bl = r.compareTo(ZERO) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{s, r};
        return bigIntegerArray;
    }

    @NotNull
    public final BigInteger gcd(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        if (val._signum == 0) {
            return this.getAbsoluteValue();
        }
        if (this._signum == 0) {
            return val.getAbsoluteValue();
        }
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger b = new MutableBigInteger(val);
        MutableBigInteger result2 = a.hybridGCD(b);
        return result2.toBigInteger(1);
    }

    @NotNull
    public final BigInteger getAbsoluteValue() {
        return this._signum >= 0 ? this : this.unaryMinus();
    }

    @NotNull
    public final BigInteger unaryMinus() {
        return new BigInteger(this._mag, -this._signum);
    }

    @NotNull
    public final BigInteger unaryPlus() {
        return this;
    }

    public final int getSignum() {
        return this._signum;
    }

    @NotNull
    public final BigInteger rem(@NotNull BigInteger m) {
        Intrinsics.checkNotNullParameter(m, "m");
        if (m._signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger result2 = this.remainder(m);
        return result2._signum >= 0 ? result2 : result2.plus(m);
    }

    @NotNull
    public final BigInteger modPow(@NotNull BigInteger exponent, @NotNull BigInteger m) {
        boolean invertResult;
        Intrinsics.checkNotNullParameter(exponent, "exponent");
        Intrinsics.checkNotNullParameter(m, "m");
        BigInteger exponent2 = exponent;
        if (m._signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (exponent2._signum == 0) {
            return Intrinsics.areEqual(m, ONE) ? ZERO : ONE;
        }
        if (Intrinsics.areEqual(this, ONE)) {
            return Intrinsics.areEqual(m, ONE) ? ZERO : ONE;
        }
        if (Intrinsics.areEqual(this, ZERO) && exponent2._signum >= 0) {
            return ZERO;
        }
        if (Intrinsics.areEqual(this, negConst[1]) && !exponent2.testBit(0)) {
            return Intrinsics.areEqual(m, ONE) ? ZERO : ONE;
        }
        boolean bl = invertResult = exponent2._signum < 0;
        if (invertResult) {
            exponent2 = exponent2.unaryMinus();
        }
        BigInteger base2 = this._signum < 0 || this.compareTo(m) >= 0 ? this.rem(m) : this;
        BigInteger result2 = null;
        if (m.testBit(0)) {
            result2 = base2.oddModPow(exponent2, m);
        } else {
            int p = m.getLowestSetBit();
            BigInteger m1 = m.shr(p);
            BigInteger m2 = ONE.shl(p);
            BigInteger base22 = this._signum < 0 || this.compareTo(m1) >= 0 ? this.rem(m1) : this;
            BigInteger a1 = Intrinsics.areEqual(m1, ONE) ? ZERO : base22.oddModPow(exponent2, m1);
            BigInteger a2 = base2.modPow2(exponent2, p);
            BigInteger y1 = m2.modInverse(m1);
            BigInteger y2 = m1.modInverse(m2);
            if (m._mag.length < 0x2000000) {
                result2 = a1.times(m2).times(y1).plus(a2.times(m1).times(y2)).rem(m);
            } else {
                MutableBigInteger t1 = new MutableBigInteger();
                new MutableBigInteger(a1.times(m2)).multiply(new MutableBigInteger(y1), t1);
                MutableBigInteger t2 = new MutableBigInteger();
                new MutableBigInteger(a2.times(m1)).multiply(new MutableBigInteger(y2), t2);
                t1.add(t2);
                MutableBigInteger q = new MutableBigInteger();
                MutableBigInteger mutableBigInteger = MutableBigInteger.divide$default(t1, new MutableBigInteger(m), q, false, 4, null);
                Intrinsics.checkNotNull(mutableBigInteger);
                result2 = mutableBigInteger.toBigInteger();
            }
        }
        return invertResult ? result2.modInverse(m) : result2;
    }

    /*
     * WARNING - void declaration
     */
    private final BigInteger oddModPow(BigInteger y, BigInteger z) {
        int n;
        int i;
        int[] b;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(y, ONE)) {
            return this;
        }
        if (this._signum == 0) {
            return ZERO;
        }
        int[] base2 = UtilsKt.cloneArray(this._mag);
        int[] exp = y._mag;
        int[] mod = z._mag;
        int modLen = 0;
        modLen = mod.length;
        if ((modLen & 1) != 0) {
            int[] x = new int[modLen + 1];
            UtilsKt.arrayCopy(mod, 0, x, 1, modLen);
            mod = x;
            int n2 = modLen;
            modLen = n2 + 1;
        }
        int wbits = 0;
        int ebits = BigInteger.Companion.bitLength(exp, exp.length);
        if (ebits != 17 || exp[0] != 65537) {
            while (ebits > bnExpModThreshTable[wbits]) {
                int n3 = wbits;
                wbits = n3 + 1;
            }
        }
        int tblmask = 1 << wbits;
        Iterable $this$map$iv = RangesKt.until(0, tblmask);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n4 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int[] nArray = new int[modLen];
            collection.add(nArray);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new int[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        int[][] table = (int[][])TArray;
        long n0 = ((long)mod[modLen - 1] & 0xFFFFFFFFL) + (((long)mod[modLen - 2] & 0xFFFFFFFFL) << 32);
        long inv = -MutableBigInteger.Companion.inverseMod64(n0);
        int[] a = BigInteger.Companion.leftShift(base2, base2.length, modLen << 5);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a2 = new MutableBigInteger(a);
        MutableBigInteger b2 = new MutableBigInteger(mod);
        b2.normalize();
        MutableBigInteger r = MutableBigInteger.divide$default(a2, b2, q, false, 4, null);
        Intrinsics.checkNotNull(r);
        table[0] = r.toIntArray();
        if (table[0].length < modLen) {
            int offset = modLen - table[0].length;
            int[] t2 = new int[modLen];
            UtilsKt.arrayCopy(table[0], 0, t2, offset, table[0].length);
            table[0] = t2;
        }
        int[] nArray = b = BigInteger.Companion.montgomerySquare(table[0], mod, modLen, inv, null);
        int n5 = modLen;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n5);
        Intrinsics.checkNotNullExpressionValue(nArray2, "java.util.Arrays.copyOf(this, newSize)");
        int[] t = nArray2;
        int n6 = 1;
        if (n6 < tblmask) {
            do {
                int i2 = n6++;
                table[i2] = BigInteger.Companion.montgomeryMultiply(t, table[i2 - 1], mod, modLen, inv, null);
            } while (n6 < tblmask);
        }
        int bitpos = 1 << (ebits - 1 & 0x1F);
        int buf = 0;
        int elen = exp.length;
        int eIndex = 0;
        int n7 = 0;
        if (n7 <= wbits) {
            do {
                i = n7++;
                buf = buf << 1 | ((exp[eIndex] & bitpos) != 0 ? 1 : 0);
                if ((bitpos >>>= 1) != 0) continue;
                n = eIndex;
                eIndex = n + 1;
                bitpos = Integer.MIN_VALUE;
                n = elen;
                elen = n + -1;
            } while (i != wbits);
        }
        int multpos = ebits;
        i = ebits;
        ebits = i + -1;
        boolean isone = true;
        multpos = ebits - wbits;
        while ((buf & 1) == 0) {
            buf >>>= 1;
            n = multpos;
            multpos = n + 1;
        }
        int[] mult = table[buf >>> 1];
        buf = 0;
        if (multpos == ebits) {
            isone = false;
        }
        while (true) {
            int n8 = ebits;
            ebits = n8 + -1;
            buf <<= 1;
            if (elen != 0) {
                buf |= (exp[eIndex] & bitpos) != 0 ? 1 : 0;
                if ((bitpos >>>= 1) == 0) {
                    n8 = eIndex;
                    eIndex = n8 + 1;
                    bitpos = Integer.MIN_VALUE;
                    n8 = elen;
                    elen = n8 + -1;
                }
            }
            if ((buf & tblmask) != 0) {
                multpos = ebits - wbits;
                while ((buf & 1) == 0) {
                    buf >>>= 1;
                    n8 = multpos;
                    multpos = n8 + 1;
                }
                mult = table[buf >>> 1];
                buf = 0;
            }
            if (ebits == multpos) {
                if (isone) {
                    b = UtilsKt.cloneArray(mult);
                    isone = false;
                } else {
                    t = b;
                    a = BigInteger.Companion.montgomeryMultiply(t, mult, mod, modLen, inv, a);
                    t = a;
                    a = b;
                    b = t;
                }
            }
            if (ebits == 0) break;
            if (isone) continue;
            t = b;
            a = BigInteger.Companion.montgomerySquare(t, mod, modLen, inv, a);
            t = a;
            a = b;
            b = t;
        }
        int[] t2 = new int[2 * modLen];
        UtilsKt.arrayCopy(b, 0, t2, modLen, modLen);
        int[] nArray3 = b = BigInteger.Companion.montReduce(t2, mod, modLen, (int)inv);
        int n9 = modLen;
        boolean bl2 = false;
        int[] nArray4 = Arrays.copyOf(nArray3, n9);
        Intrinsics.checkNotNullExpressionValue(nArray4, "java.util.Arrays.copyOf(this, newSize)");
        t2 = nArray4;
        return new BigInteger(1, t2);
    }

    private final BigInteger modPow2(BigInteger exponent, int p) {
        BigInteger result2 = ONE;
        BigInteger baseToPow2 = this.mod2(p);
        int expOffset = 0;
        int limit2 = exponent.getBitLength();
        if (this.testBit(0)) {
            int n = limit2 = p - 1 < limit2 ? p - 1 : limit2;
        }
        while (expOffset < limit2) {
            int n;
            if (exponent.testBit(expOffset)) {
                result2 = result2.times(baseToPow2).mod2(p);
            }
            if ((expOffset = (n = expOffset) + 1) >= limit2) continue;
            baseToPow2 = baseToPow2.square().mod2(p);
        }
        return result2;
    }

    private final BigInteger mod2(int p) {
        if (this.getBitLength() <= p) {
            return this;
        }
        int numInts = p + 31 >>> 5;
        int[] mag = new int[numInts];
        UtilsKt.arrayCopy(this._mag, this._mag.length - numInts, mag, 0, numInts);
        int excessBits = (numInts << 5) - p;
        mag[0] = mag[0] & (int)((1L << 32 - excessBits) - 1L);
        return mag[0] == 0 ? new BigInteger(1, mag) : new BigInteger(mag, 1);
    }

    @NotNull
    public final BigInteger modInverse(@NotNull BigInteger m) {
        Intrinsics.checkNotNullParameter(m, "m");
        if (m._signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (Intrinsics.areEqual(m, ONE)) {
            return ZERO;
        }
        BigInteger modVal = this;
        if (this._signum < 0 || this.compareMagnitude$kt_math(m) >= 0) {
            modVal = this.rem(m);
        }
        if (Intrinsics.areEqual(modVal, ONE)) {
            return ONE;
        }
        MutableBigInteger a = new MutableBigInteger(modVal);
        MutableBigInteger b = new MutableBigInteger(m);
        MutableBigInteger result2 = a.mutableModInverse(b);
        Intrinsics.checkNotNull(result2);
        return result2.toBigInteger(1);
    }

    @NotNull
    public final BigInteger shl(int n) {
        if (this._signum == 0) {
            return ZERO;
        }
        return n > 0 ? new BigInteger(BigInteger.Companion.shl(this._mag, n), this._signum) : (n == 0 ? this : this.shiftRightImpl(-n));
    }

    @NotNull
    public final BigInteger shr(int n) {
        if (this._signum == 0) {
            return ZERO;
        }
        return n > 0 ? this.shiftRightImpl(n) : (n == 0 ? this : new BigInteger(BigInteger.Companion.shl(this._mag, -n), this._signum));
    }

    private final BigInteger shiftRightImpl(int n) {
        int n2;
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this._mag.length;
        int[] newMag = null;
        if (nInts >= magLen) {
            BigInteger bigInteger;
            if (this._signum >= 0) {
                bigInteger = ZERO;
            } else {
                BigInteger bigInteger2 = negConst[1];
                if (bigInteger2 == null) {
                    throw new IllegalStateException();
                }
                bigInteger = bigInteger2;
            }
            return bigInteger;
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            int[] nArray = this._mag;
            n2 = 0;
            int[] nArray2 = Arrays.copyOf(nArray, newMagLen);
            Intrinsics.checkNotNullExpressionValue(nArray2, "java.util.Arrays.copyOf(this, newSize)");
            newMag = nArray2;
        } else {
            int i = 0;
            int highBits = this._mag[0] >>> nBits;
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                n2 = i;
                i = n2 + 1;
                newMag[n2] = highBits;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            int j = 0;
            while (j < magLen - nInts - 1) {
                int n3 = i;
                i = n3 + 1;
                int n4 = n3;
                n3 = j;
                j = n3 + 1;
                newMag[n4] = this._mag[n3] << nBits2 | this._mag[j] >>> nBits;
            }
        }
        if (this._signum < 0) {
            boolean onesLost = false;
            int i = magLen - 1;
            int j = magLen - nInts;
            while (i >= j && !onesLost) {
                onesLost = this._mag[i] != 0;
                int n5 = i;
                i = n5 + -1;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this._mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new BigInteger(newMag, this._signum);
    }

    private final int[] javaIncrement(int[] val) {
        int[] result2 = val;
        int lastSum = 0;
        int i = result2.length - 1;
        while (i >= 0 && lastSum == 0) {
            int[] nArray = result2;
            int n = i;
            int n2 = nArray[n];
            nArray[n] = n2 + 1;
            lastSum = n2;
            int n3 = i;
            i = n3 + -1;
        }
        if (lastSum == 0) {
            result2 = new int[result2.length + 1];
            result2[0] = 1;
        }
        return result2;
    }

    @NotNull
    public final BigInteger and(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int n = this.getIntLength();
        int n2 = val.getIntLength();
        boolean bl = false;
        int[] result2 = new int[Math.max(n, n2)];
        n = 0;
        n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2[i] = this.getInt(result2.length - i - 1) & val.getInt(result2.length - i - 1);
            } while (n <= n2);
        }
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger or(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int n = this.getIntLength();
        int n2 = val.getIntLength();
        boolean bl = false;
        int[] result2 = new int[Math.max(n, n2)];
        n = 0;
        n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2[i] = this.getInt(result2.length - i - 1) | val.getInt(result2.length - i - 1);
            } while (n <= n2);
        }
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger xor(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int n = this.getIntLength();
        int n2 = val.getIntLength();
        boolean bl = false;
        int[] result2 = new int[Math.max(n, n2)];
        n = 0;
        n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2[i] = this.getInt(result2.length - i - 1) ^ val.getInt(result2.length - i - 1);
            } while (n <= n2);
        }
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger not() {
        int n = 0;
        int[] result2 = new int[this.getIntLength()];
        int n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2[i] = ~this.getInt(result2.length - i - 1);
            } while (n <= n2);
        }
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger andNot(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int n = this.getIntLength();
        int n2 = val.getIntLength();
        boolean bl = false;
        int[] result2 = new int[Math.max(n, n2)];
        n = 0;
        n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2[i] = this.getInt(result2.length - i - 1) & ~val.getInt(result2.length - i - 1);
            } while (n <= n2);
        }
        return BigInteger.Companion.of(result2);
    }

    public final boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getInt(n >>> 5) & 1 << (n & 0x1F)) != 0;
    }

    public final boolean get(int n) {
        return this.testBit(n);
    }

    public final void set(int n, boolean b) {
        if (b) {
            this.setBit(n);
        } else {
            this.clearBit(n);
        }
    }

    @NotNull
    public final BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int n2 = this.getIntLength();
        int n3 = intNum + 2;
        boolean bl = false;
        n2 = 0;
        int[] result2 = new int[Math.max(n2, n3)];
        if (n2 <= (n3 = result2.length + -1)) {
            do {
                int i = n2++;
                result2[result2.length - i - 1] = this.getInt(i);
            } while (n2 <= n3);
        }
        result2[result2.length - intNum - 1] = result2[result2.length - intNum - 1] | 1 << (n & 0x1F);
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int n2 = this.getIntLength();
        int n3 = (n + 1 >>> 5) + 1;
        boolean bl = false;
        n2 = 0;
        int[] result2 = new int[Math.max(n2, n3)];
        if (n2 <= (n3 = result2.length + -1)) {
            do {
                int i = n2++;
                result2[result2.length - i - 1] = this.getInt(i);
            } while (n2 <= n3);
        }
        result2[result2.length - intNum - 1] = result2[result2.length - intNum - 1] & ~(1 << (n & 0x1F));
        return BigInteger.Companion.of(result2);
    }

    @NotNull
    public final BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int n2 = this.getIntLength();
        int n3 = intNum + 2;
        boolean bl = false;
        n2 = 0;
        int[] result2 = new int[Math.max(n2, n3)];
        if (n2 <= (n3 = result2.length + -1)) {
            do {
                int i = n2++;
                result2[result2.length - i - 1] = this.getInt(i);
            } while (n2 <= n3);
        }
        result2[result2.length - intNum - 1] = result2[result2.length - intNum - 1] ^ 1 << (n & 0x1F);
        return BigInteger.Companion.of(result2);
    }

    public final int getBitLength() {
        int n = this._bitLengthPlusOne - 1;
        if (n == -1) {
            int[] m = this._mag;
            int len = m.length;
            if (len == 0) {
                n = 0;
            } else {
                int magBitLength = (len - 1 << 5) + Companion.bitLengthForInt$kt_math(this._mag[0]);
                if (this._signum < 0) {
                    boolean pow2 = UtilsKt.bitCount(this._mag[0]) == 1;
                    int i = 1;
                    while (i < len && pow2) {
                        pow2 = this._mag[i] == 0;
                        int n2 = i;
                        i = n2 + 1;
                    }
                    n = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    n = magBitLength;
                }
            }
            this._bitLengthPlusOne = n + 1;
        }
        return n;
    }

    public final int getBitCount() {
        int bc = this._bitCountPlusOne - 1;
        if (bc == -1) {
            bc = 0;
            int n = 0;
            int n2 = this._mag.length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    bc += UtilsKt.bitCount(this._mag[i]);
                } while (n <= n2);
            }
            if (this._signum < 0) {
                int magTrailingZeroCount = 0;
                int j = 0;
                j = this._mag.length - 1;
                while (this._mag[j] == 0) {
                    magTrailingZeroCount += 32;
                    int n3 = j;
                    j = n3 + -1;
                }
                bc += (magTrailingZeroCount += UtilsKt.numberOfTrailingZeros(this._mag[j])) - 1;
            }
            this._bitCountPlusOne = bc + 1;
        }
        return bc;
    }

    public final boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        BigInteger w = this.getAbsoluteValue();
        if (Intrinsics.areEqual(w, TWO)) {
            return true;
        }
        return !w.testBit(0) || Intrinsics.areEqual(w, ONE) ? false : w.primeToCertainty$kt_math(certainty, null);
    }

    @Override
    public int compareTo(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (this._signum == other._signum) {
            int n = this._signum;
            switch (n) {
                case 1: {
                    return this.compareMagnitude$kt_math(other);
                }
                case -1: {
                    return other.compareMagnitude$kt_math(this);
                }
            }
            return 0;
        }
        return this._signum > other._signum ? 1 : -1;
    }

    public final int compareMagnitude$kt_math(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int[] m1 = this._mag;
        int len1 = m1.length;
        int[] m2 = val._mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        int n = 0;
        if (n < len1) {
            do {
                int b;
                int i;
                int a;
                if ((a = m1[i = n++]) == (b = m2[i])) continue;
                return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
            } while (n < len1);
        }
        return 0;
    }

    public final int compareMagnitude$kt_math(long val) {
        int a;
        int highWord;
        long val2 = val;
        boolean bl = val2 != Long.MIN_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        int[] m1 = this._mag;
        int len = m1.length;
        if (len > 2) {
            return 1;
        }
        if (val2 < 0L) {
            val2 = -val2;
        }
        if ((highWord = (int)(val2 >>> 32)) == 0) {
            if (len < 1) {
                return -1;
            }
            if (len > 1) {
                return 1;
            }
            a = m1[0];
            int b = (int)val2;
            return a != b ? (((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1) : 0;
        }
        if (len < 2) {
            return -1;
        }
        a = m1[0];
        int b = highWord;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        a = m1[1];
        b = (int)val2;
        return a != b ? (((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1) : 0;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)other;
        if (xInt._signum != this._signum) {
            return false;
        }
        int[] m = this._mag;
        int len = m.length;
        int[] xm = xInt._mag;
        if (len != xm.length) {
            return false;
        }
        int n = 0;
        if (n < len) {
            do {
                int i;
                if (xm[i = n++] == m[i]) continue;
                return false;
            } while (n < len);
        }
        return true;
    }

    @NotNull
    public final BigInteger min(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return this.compareTo(val) < 0 ? this : val;
    }

    @NotNull
    public final BigInteger max(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return this.compareTo(val) > 0 ? this : val;
    }

    public int hashCode() {
        int hashCode2 = 0;
        int n = 0;
        int n2 = this._mag.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                hashCode2 = 31 * hashCode2 + (int)((long)this._mag[i] & 0xFFFFFFFFL);
            } while (n <= n2);
        }
        return hashCode2 * this._signum;
    }

    @NotNull
    public final String toString(int radix) {
        int radix2 = radix;
        if (this._signum == 0) {
            return "0";
        }
        if (radix2 < 2 || radix2 > 36) {
            radix2 = 10;
        }
        if (this._mag.length <= 20) {
            return this.smallToString(radix2);
        }
        StringBuilder sb = new StringBuilder();
        if (this._signum < 0) {
            BigInteger.Companion.toString(this.unaryMinus(), sb, radix2, 0);
            sb = UtilsKt.insertChar(sb, 0, '-');
        } else {
            BigInteger.Companion.toString(this, sb, radix2, 0);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    private final String smallToString(int radix) {
        if (this._signum == 0) {
            return "0";
        }
        int maxNumDigitGroups = (4 * this._mag.length + 6) / 7;
        String[] digitGroup = new String[maxNumDigitGroups];
        BigInteger tmp = this.getAbsoluteValue();
        int numGroups = 0;
        while (tmp._signum != 0) {
            BigInteger d = longRadix[radix];
            MutableBigInteger q = new MutableBigInteger();
            MutableBigInteger a = new MutableBigInteger(tmp._mag);
            Intrinsics.checkNotNull(d);
            MutableBigInteger b = new MutableBigInteger(d._mag);
            MutableBigInteger r = MutableBigInteger.divide$default(a, b, q, false, 4, null);
            BigInteger q2 = q.toBigInteger(tmp._signum * d._signum);
            Intrinsics.checkNotNull(r);
            BigInteger r2 = r.toBigInteger(tmp._signum * d._signum);
            int n = numGroups;
            numGroups = n + 1;
            long l = r2.toLong();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(Long.toString(l, CharsKt.checkRadix(radix)), "java.lang.Long.toString(this, checkRadix(radix))");
            tmp = q2;
        }
        StringBuilder buf = new StringBuilder(numGroups * digitsPerLong[radix] + 1);
        if (this._signum < 0) {
            buf.append('-');
        }
        buf.append(digitGroup[numGroups - 1]);
        int n = numGroups - 2;
        if (0 <= n) {
            do {
                int i = n--;
                int n2 = digitsPerLong[radix];
                String string2 = digitGroup[i];
                Intrinsics.checkNotNull(string2);
                int numLeadingZeros = n2 - string2.length();
                if (numLeadingZeros != 0) {
                    buf.append(zeros[numLeadingZeros]);
                }
                buf.append(digitGroup[i]);
            } while (0 <= n);
        }
        String string3 = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "buf.toString()");
        return string3;
    }

    @NotNull
    public String toString() {
        return this.toString(10);
    }

    @NotNull
    public final byte[] toByteArray() {
        int byteLen = this.getBitLength() / 8 + 1;
        byte[] byteArray = new byte[byteLen];
        int i = byteLen - 1;
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        while (i >= 0) {
            int n;
            if (bytesCopied == 4) {
                n = intIndex;
                intIndex = n + 1;
                nextInt = this.getInt(n);
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                n = bytesCopied;
                bytesCopied = n + 1;
            }
            byteArray[i] = (byte)nextInt;
            n = i;
            i = n + -1;
        }
        return byteArray;
    }

    public final int toInt() {
        int result2 = 0;
        result2 = this.getInt(0);
        return result2;
    }

    public final long toLong() {
        long result2 = 0L;
        int n = 1;
        do {
            int i = n--;
            result2 = (result2 << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
        } while (0 <= n);
        return result2;
    }

    public final byte toByte() {
        return (byte)this.toInt();
    }

    public final char toChar() {
        return (char)this.toInt();
    }

    public final short toShort() {
        return (short)this.toInt();
    }

    public final float toFloat() {
        return this.toInt();
    }

    public final double toDouble() {
        return this.toLong();
    }

    private final int getIntLength() {
        return (this.getBitLength() >>> 5) + 1;
    }

    private final int getSignBit() {
        return this._signum < 0 ? 1 : 0;
    }

    private final int getSignInt() {
        return this._signum < 0 ? -1 : 0;
    }

    private final int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this._mag.length) {
            return this.getSignInt();
        }
        int magInt = this._mag[this._mag.length - n - 1];
        return this._signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private final int firstNonzeroIntNum() {
        int fn = this._firstNonzeroIntNumPlusTwo - 2;
        if (fn == -2) {
            int i = 0;
            int mlen = this._mag.length;
            i = mlen - 1;
            while (i >= 0 && this._mag[i] == 0) {
                int n = i;
                i = n + -1;
            }
            fn = mlen - i - 1;
            this._firstNonzeroIntNumPlusTwo = fn + 2;
        }
        return fn;
    }

    private final byte[] magSerializedForm() {
        int len = this._mag.length;
        int bitLen = len == 0 ? 0 : (len - 1 << 5) + Companion.bitLengthForInt$kt_math(this._mag[0]);
        int byteLen = bitLen + 7 >>> 3;
        byte[] result2 = new byte[byteLen];
        int i = byteLen - 1;
        int bytesCopied = 4;
        int intIndex = len - 1;
        int nextInt = 0;
        while (i >= 0) {
            int n;
            if (bytesCopied == 4) {
                n = intIndex;
                intIndex = n + -1;
                nextInt = this._mag[n];
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                n = bytesCopied;
                bytesCopied = n + 1;
            }
            result2[i] = (byte)nextInt;
            n = i;
            i = n + -1;
        }
        return result2;
    }

    public final long toLongExact() {
        if (this._mag.length > 2 || this.getBitLength() > 63) {
            throw new ArithmeticException("BigInteger out of long range");
        }
        return this.toLong();
    }

    public final int toIntExact() {
        if (this._mag.length > 1 || this.getBitLength() > 31) {
            throw new ArithmeticException("BigInteger out of int range");
        }
        return this.toInt();
    }

    public final short toShortExact() {
        int value;
        if (this._mag.length <= 1 && this.getBitLength() <= 31 && (value = this.toInt()) >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return this.toShort();
        }
        throw new ArithmeticException("BigInteger out of short range");
    }

    public final byte toByteExact() {
        int value;
        if (this._mag.length <= 1 && this.getBitLength() <= 31 && (value = this.toInt()) >= -128 && value <= 127) {
            return this.toByte();
        }
        throw new ArithmeticException("BigInteger out of byte range");
    }

    public /* synthetic */ BigInteger(long val, DefaultConstructorMarker $constructor_marker) {
        this(val);
    }

    public /* synthetic */ BigInteger(int[] val, DefaultConstructorMarker $constructor_marker) {
        this(val);
    }

    static {
        boolean bl;
        int i;
        Companion = new Companion(null);
        long[] lArray = new long[]{0L, 0L, 1024L, 1624L, 2048L, 2378L, 2648L, 2875L, 3072L, 3247L, 3402L, 3543L, 3672L, 3790L, 3899L, 4001L, 4096L, 4186L, 4271L, 4350L, 4426L, 4498L, 4567L, 4633L, 4696L, 4756L, 4814L, 4870L, 4923L, 4975L, 5025L, 5074L, 5120L, 5166L, 5210L, 5253L, 5295L};
        bitsPerDigit = lArray;
        SMALL_PRIME_PRODUCT = Companion.of(152125131763605L);
        MAX_CONSTANT = 16;
        posConst = new BigInteger[MAX_CONSTANT + 1];
        negConst = new BigInteger[MAX_CONSTANT + 1];
        powerCache = new BigInteger[0][];
        double d = 2.0;
        boolean bl2 = false;
        LOG_TWO = Math.log(d);
        int n = 1;
        int n2 = MAX_CONSTANT;
        if (n <= n2) {
            int i2;
            do {
                i2 = n++;
                int[] magnitude = new int[]{i2};
                BigInteger.posConst[i2] = new BigInteger(magnitude, 1);
                BigInteger.negConst[i2] = new BigInteger(magnitude, -1);
            } while (i2 != n2);
        }
        powerCache = new BigInteger[37][];
        logCache = new double[37];
        n = 2;
        do {
            i = n++;
            BigInteger[] bigIntegerArray = new BigInteger[]{Companion.of((long)i)};
            BigInteger.powerCache[i] = bigIntegerArray;
            double d2 = i;
            bl = false;
            BigInteger.logCache[i] = Math.log(d2);
        } while (n <= 36);
        ZERO = new BigInteger(new int[0], 0);
        ONE = Companion.of(1);
        TWO = Companion.of(2);
        NEGATIVE_ONE = Companion.of(-1);
        TEN = Companion.of(10);
        int[] nArray = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        bnExpModThreshTable = nArray;
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        int n3 = 0;
        do {
            i = n3++;
            String string2 = zeros[63];
            Intrinsics.checkNotNull(string2);
            int n4 = 0;
            bl = false;
            Intrinsics.checkNotNullExpressionValue(string2.substring(n4, i), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } while (n3 <= 62);
        Object[] objectArray = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        digitsPerLong = objectArray;
        objectArray = new BigInteger[37];
        objectArray[0] = (int)null;
        objectArray[1] = (int)null;
        objectArray[2] = (int)Companion.of(0x4000000000000000L);
        objectArray[3] = (int)Companion.of(4052555153018976267L);
        objectArray[4] = (int)Companion.of(0x4000000000000000L);
        objectArray[5] = (int)Companion.of(7450580596923828125L);
        objectArray[6] = (int)Companion.of(4738381338321616896L);
        objectArray[7] = (int)Companion.of(3909821048582988049L);
        objectArray[8] = (int)Companion.of(0x1000000000000000L);
        objectArray[9] = (int)Companion.of(1350851717672992089L);
        objectArray[10] = (int)Companion.of(1000000000000000000L);
        objectArray[11] = (int)Companion.of(5559917313492231481L);
        objectArray[12] = (int)Companion.of(2218611106740436992L);
        objectArray[13] = (int)Companion.of(8650415919381337933L);
        objectArray[14] = (int)Companion.of(2177953337809371136L);
        objectArray[15] = (int)Companion.of(6568408355712890625L);
        objectArray[16] = (int)Companion.of(0x1000000000000000L);
        objectArray[17] = (int)Companion.of(2862423051509815793L);
        objectArray[18] = (int)Companion.of(6746640616477458432L);
        objectArray[19] = (int)Companion.of(799006685782884121L);
        objectArray[20] = (int)Companion.of(1638400000000000000L);
        objectArray[21] = (int)Companion.of(3243919932521508681L);
        objectArray[22] = (int)Companion.of(6221821273427820544L);
        objectArray[23] = (int)Companion.of(504036361936467383L);
        objectArray[24] = (int)Companion.of(876488338465357824L);
        objectArray[25] = (int)Companion.of(1490116119384765625L);
        objectArray[26] = (int)Companion.of(2481152873203736576L);
        objectArray[27] = (int)Companion.of(4052555153018976267L);
        objectArray[28] = (int)Companion.of(6502111422497947648L);
        objectArray[29] = (int)Companion.of(353814783205469041L);
        objectArray[30] = (int)Companion.of(531441000000000000L);
        objectArray[31] = (int)Companion.of(787662783788549761L);
        objectArray[32] = (int)Companion.of(0x1000000000000000L);
        objectArray[33] = (int)Companion.of(1667889514952984961L);
        objectArray[34] = (int)Companion.of(2386420683693101056L);
        objectArray[35] = (int)Companion.of(3379220508056640625L);
        objectArray[36] = (int)Companion.of(4738381338321616896L);
        longRadix = (BigInteger[])objectArray;
        objectArray = new int[]{0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        digitsPerInt = objectArray;
        objectArray = new int[]{0, 0, 0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
        intRadix = objectArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0004H\u0002J\u0015\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bDJ \u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u0004H\u0002J\u0010\u0010J\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u0004H\u0002J\u0018\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u0004H\u0002J8\u0010N\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010O\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020%H\u0002J2\u0010R\u001a\u00020F2\u0006\u0010:\u001a\u00020%2\u0006\u0010O\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\b\u0010Q\u001a\u0004\u0018\u00010%H\u0002J0\u0010S\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020%H\u0002J0\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0004H\u0002J0\u0010X\u001a\u00020F2\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0004H\u0002J2\u0010Y\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010H\u001a\u00020%2\u0006\u0010[\u001a\u00020\u00042\b\u0010I\u001a\u0004\u0018\u00010%H\u0002J(\u0010\\\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010I\u001a\u00020%2\u0006\u0010]\u001a\u00020\u0004H\u0002J(\u0010^\u001a\u00020F2\u0006\u0010G\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010I\u001a\u00020%2\u0006\u0010]\u001a\u00020\u0004H\u0002J \u0010_\u001a\u00020\u00042\u0006\u0010`\u001a\u00020%2\u0006\u0010a\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0004H\u0002J\u0018\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0012H\u0002J \u0010d\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020gH\u0002J \u0010h\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0004H\u0002J \u0010i\u001a\u00020\u00122\u0006\u0010I\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00122\u0006\u0010C\u001a\u00020\u0012H\u0002J \u0010j\u001a\u00020%2\u0006\u0010:\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004H\u0002J\u0010\u0010j\u001a\u00020%2\u0006\u0010:\u001a\u00020%H\u0002J\u001a\u0010m\u001a\u00020%2\b\u0010I\u001a\u0004\u0018\u00010%2\u0006\u0010A\u001a\u00020\u0004H\u0002J(\u0010n\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010o\u001a\u00020%2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0004H\u0002J:\u0010p\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010O\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010%H\u0002J2\u0010q\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010C\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010%H\u0002J5\u0010r\u001a\u00020\u00042\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bsJ \u0010t\u001a\u00020\u00122\u0006\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020\u00042\u0006\u0010u\u001a\u00020\u0004H\u0002J\u0018\u0010v\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u0012H\u0002J2\u0010w\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010H\u001a\u00020%2\u0006\u0010[\u001a\u00020\u00042\b\u0010I\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010x\u001a\u00020F2\u0006\u0010y\u001a\u00020%2\u0006\u0010z\u001a\u00020\u0004H\u0002J\u0018\u0010{\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u0012H\u0002J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010}\u001a\u00020\u0004H\u0007J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010@\u001a\u00020%H\u0003J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\fH\u0007J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010}\u001a\u000207H\u0007J\u0018\u0010|\u001a\u00020\u00122\u0006\u0010}\u001a\u0002072\u0006\u0010L\u001a\u00020\u0004H\u0007J%\u0010~\u001a\u00020F2\u0006\u0010:\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u007fJ'\u0010\u0080\u0001\u001a\u00020F2\u0006\u0010:\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u0081\u0001J\u0017\u0010\u0082\u0001\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00042\u0006\u0010f\u001a\u00020gJ\u001a\u0010\u0083\u0001\u001a\u00020k2\u0007\u0010\u0084\u0001\u001a\u00020\u00042\u0006\u0010f\u001a\u00020gH\u0002J\t\u0010\u0085\u0001\u001a\u00020FH\u0002J\u001a\u0010\u0086\u0001\u001a\u00020%2\u0007\u0010\u0087\u0001\u001a\u00020%2\u0006\u0010C\u001a\u00020\u0004H\u0002J!\u0010\u0088\u0001\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020gH\u0002J#\u0010\u0089\u0001\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010A\u001a\u00020\u00042\b\u0010I\u001a\u0004\u0018\u00010%H\u0002J!\u0010\u008a\u0001\u001a\u00020%2\u0006\u0010:\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004H\u0002J\u0011\u0010\u008b\u0001\u001a\u00020%2\u0006\u0010@\u001a\u00020%H\u0002J!\u0010\u008c\u0001\u001a\u00020\u00042\u0006\u0010:\u001a\u00020%2\u0006\u0010O\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0004H\u0002J\u001b\u0010\u008d\u0001\u001a\u00020%2\u0007\u0010\u008e\u0001\u001a\u00020%2\u0007\u0010\u008f\u0001\u001a\u00020%H\u0002J\u001a\u0010\u008d\u0001\u001a\u00020%2\u0007\u0010\u008e\u0001\u001a\u00020%2\u0006\u0010@\u001a\u00020\fH\u0002J\u001a\u0010\u008d\u0001\u001a\u00020%2\u0006\u0010@\u001a\u00020\f2\u0007\u0010\u008f\u0001\u001a\u00020%H\u0002J\u0019\u0010\u0090\u0001\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020%H\u0002J\u0019\u0010\u0090\u0001\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010@\u001a\u00020\fH\u0002J2\u0010\u0091\u0001\u001a\u00020F2\u0007\u0010\u0092\u0001\u001a\u00020\u00122\r\u0010\u0093\u0001\u001a\b0\u0094\u0001j\u0003`\u0095\u00012\u0006\u0010L\u001a\u00020\u00042\u0007\u0010\u0096\u0001\u001a\u00020\u0004H\u0002J\u0011\u0010\u0097\u0001\u001a\u00020%2\u0006\u0010@\u001a\u00020%H\u0002J\u001a\u0010\u0098\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002070\u0099\u0001*\u000207H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0018\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0018\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u001e\u00104\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00105R\u0018\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010700X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00108\u00a8\u0006\u009a\u0001"}, d2={"Lorg/gciatto/kt/math/BigInteger$Companion;", "", "()V", "BURNIKEL_ZIEGLER_OFFSET", "", "BURNIKEL_ZIEGLER_THRESHOLD", "DEFAULT_PRIME_CERTAINTY", "KARATSUBA_SQUARE_THRESHOLD", "KARATSUBA_THRESHOLD", "LOG_TWO", "", "LONG_MASK", "", "MAX_CONSTANT", "MAX_MAG_LENGTH", "MONTGOMERY_INTRINSIC_THRESHOLD", "MULTIPLY_SQUARE_THRESHOLD", "NEGATIVE_ONE", "Lorg/gciatto/kt/math/BigInteger;", "ONE", "getONE", "()Lorg/gciatto/kt/math/BigInteger;", "PRIME_SEARCH_BIT_LENGTH_LIMIT", "SCHOENHAGE_BASE_CONVERSION_THRESHOLD", "SMALL_PRIME_PRODUCT", "SMALL_PRIME_THRESHOLD", "TEN", "getTEN", "TOOM_COOK_SQUARE_THRESHOLD", "TOOM_COOK_THRESHOLD", "TWO", "getTWO", "ZERO", "getZERO", "bitsPerDigit", "", "bnExpModThreshTable", "", "getBnExpModThreshTable$kt_math", "()[I", "setBnExpModThreshTable$kt_math", "([I)V", "digitsPerInt", "digitsPerLong", "intRadix", "logCache", "", "longRadix", "", "[Lorg/gciatto/kt/math/BigInteger;", "negConst", "posConst", "powerCache", "[[Lorg/gciatto/kt/math/BigInteger;", "zeros", "", "[Ljava/lang/String;", "addOne", "a", "offset", "mlen", "carry", "addOne$kt_math", "bitLength", "val", "len", "bitLengthForInt", "n", "bitLengthForInt$kt_math", "destructiveMulAdd", "", "x", "y", "z", "getPrimeSearchLen", "getRadixConversionCache", "radix", "exponent", "implMontgomeryMultiply", "b", "inv", "product", "implMontgomeryMultiplyChecks", "implMontgomerySquare", "implMulAdd", "out", "in", "k", "implMulAddCheck", "implMultiplyToLen", "xlen", "ylen", "implSquareToLen", "zlen", "implSquareToLenChecks", "intArrayCmpToLen", "arg1", "arg2", "jacobiSymbol", "p", "largePrime", "certainty", "rnd", "Lkotlin/random/Random;", "leftShift", "lucasLehmerSequence", "makePositive", "", "off", "materialize", "montReduce", "mod", "montgomeryMultiply", "montgomerySquare", "mulAdd", "mulAdd$kt_math", "multiplyByInt", "sign", "multiplyKaratsuba", "multiplyToLen", "multiplyToLenCheck", "array", "length", "multiplyToomCook3", "of", "value", "primitiveLeftShift", "primitiveLeftShift$kt_math", "primitiveRightShift", "primitiveRightShift$kt_math", "probablePrime", "randomBits", "numBits", "reportOverflow", "shl", "mag", "smallPrime", "squareToLen", "stripLeadingZeroBytes", "stripLeadingZeroInts", "subN", "subtract", "big", "little", "sum", "toString", "u", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "digits", "trustedStripLeadingZeroInts", "getRadix", "Lkotlin/Pair;", "kt-math"})
    public static final class Companion {
        private Companion() {
        }

        private final void destructiveMulAdd(int[] x, int y, int z) {
            long ylong = (long)y & 0xFFFFFFFFL;
            long zlong = (long)z & 0xFFFFFFFFL;
            int len = x.length;
            long product2 = 0L;
            long carry = 0L;
            int n = len - 1;
            if (0 <= n) {
                do {
                    int i = n--;
                    product2 = ylong * ((long)x[i] & 0xFFFFFFFFL) + carry;
                    x[i] = (int)product2;
                    carry = product2 >>> 32;
                } while (0 <= n);
            }
            long sum = ((long)x[len - 1] & 0xFFFFFFFFL) + zlong;
            x[len - 1] = (int)sum;
            carry = sum >>> 32;
            int n2 = len - 2;
            if (0 <= n2) {
                do {
                    int i = n2--;
                    sum = ((long)x[i] & 0xFFFFFFFFL) + carry;
                    x[i] = (int)sum;
                    carry = sum >>> 32;
                } while (0 <= n2);
            }
        }

        private final byte[] randomBits(int numBits, Random rnd) {
            if (numBits < 0) {
                throw new IllegalArgumentException("numBits must be non-negative");
            }
            int numBytes = (int)(((long)numBits + (long)7) / (long)8);
            byte[] randomBits = new byte[numBytes];
            if (numBytes > 0) {
                rnd.nextBytes(randomBits);
                int excessBits = 8 * numBytes - numBits;
                byte by = randomBits[0];
                byte by2 = (byte)((1 << 8 - excessBits) - 1);
                boolean bl = false;
                randomBits[0] = (byte)(by & by2);
            }
            return randomBits;
        }

        @NotNull
        public final BigInteger probablePrime(int bitLength, @NotNull Random rnd) {
            Intrinsics.checkNotNullParameter(rnd, "rnd");
            if (bitLength < 2) {
                throw new ArithmeticException("bitLength < 2");
            }
            return bitLength < 95 ? this.smallPrime(bitLength, 100, rnd) : this.largePrime(bitLength, 100, rnd);
        }

        private final BigInteger smallPrime(int bitLength, int certainty, Random rnd) {
            BigInteger p;
            int magLen = bitLength + 31 >>> 5;
            int[] temp = new int[magLen];
            int highBit = 1 << (bitLength + 31 & 0x1F);
            int highMask = (highBit << 1) - 1;
            while (true) {
                long r;
                int n;
                if ((n = 0) < magLen) {
                    do {
                        int i = n++;
                        temp[i] = rnd.nextInt();
                    } while (n < magLen);
                }
                temp[0] = temp[0] & highMask | highBit;
                if (bitLength > 2) {
                    temp[magLen - 1] = temp[magLen - 1] | 1;
                }
                p = new BigInteger(temp, 1);
                if (bitLength > 6 && ((r = p.remainder(SMALL_PRIME_PRODUCT).toLong()) % (long)3 == 0L || r % (long)5 == 0L || r % (long)7 == 0L || r % (long)11 == 0L || r % (long)13 == 0L || r % (long)17 == 0L || r % (long)19 == 0L || r % (long)23 == 0L || r % (long)29 == 0L || r % (long)31 == 0L || r % (long)37 == 0L || r % (long)41 == 0L)) continue;
                if (bitLength < 4) {
                    return p;
                }
                if (p.primeToCertainty$kt_math(certainty, rnd)) break;
            }
            return p;
        }

        private final BigInteger largePrime(int bitLength, int certainty, Random rnd) {
            BigInteger p = null;
            p = new BigInteger(bitLength, rnd).setBit(bitLength - 1);
            p.get_mag$kt_math()[p.get_mag$kt_math().length - 1] = p.get_mag$kt_math()[p.get_mag$kt_math().length - 1] & 0xFFFFFFFE;
            int searchLen = this.getPrimeSearchLen(bitLength);
            BitSieve searchSieve = new BitSieve(p, searchLen);
            BigInteger candidate = searchSieve.retrieve(p, certainty, rnd);
            while (candidate == null || candidate.getBitLength() != bitLength) {
                if ((p = p.plus(this.of((long)(2 * searchLen)))).getBitLength() != bitLength) {
                    p = new BigInteger(bitLength, rnd).setBit(bitLength - 1);
                }
                p.get_mag$kt_math()[p.get_mag$kt_math().length - 1] = p.get_mag$kt_math()[p.get_mag$kt_math().length - 1] & 0xFFFFFFFE;
                searchSieve = new BitSieve(p, searchLen);
                candidate = searchSieve.retrieve(p, certainty, rnd);
            }
            return candidate;
        }

        private final int getPrimeSearchLen(int bitLength) {
            if (bitLength > 500000001) {
                throw new ArithmeticException("Prime search implementation restriction on bitLength");
            }
            return bitLength / 20 * 64;
        }

        private final int jacobiSymbol(int p, BigInteger n) {
            int n8;
            int p2 = p;
            if (p2 == 0) {
                return 0;
            }
            int j = 1;
            int u = n.get_mag$kt_math()[n.get_mag$kt_math().length - 1];
            if (p2 < 0) {
                p2 = -p2;
                n8 = u & 7;
                if (n8 == 3 || n8 == 7) {
                    j = -j;
                }
            }
            while ((p2 & 3) == 0) {
                p2 >>= 2;
            }
            if ((p2 & 1) == 0) {
                p2 >>= 1;
                if (((u ^ u >> 1) & 2) != 0) {
                    j = -j;
                }
            }
            if (p2 == 1) {
                return j;
            }
            if ((p2 & u & 2) != 0) {
                j = -j;
            }
            for (u = n.rem(this.of((long)p2)).toInt(); u != 0; u %= p2) {
                while ((u & 3) == 0) {
                    u >>= 2;
                }
                if ((u & 1) == 0) {
                    u >>= 1;
                    if (((p2 ^ p2 >> 1) & 2) != 0) {
                        j = -j;
                    }
                }
                if (u == 1) {
                    return j;
                }
                n8 = u < p2 ? 1 : 0;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (n8 == 0) {
                    boolean bl4 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                u = p2;
                int t = u;
                if ((u & (p2 = t) & 2) == 0) continue;
                j = -j;
            }
            return 0;
        }

        private final BigInteger lucasLehmerSequence(int z, BigInteger k, BigInteger n) {
            BigInteger d = this.of((long)z);
            BigInteger u = this.getONE();
            BigInteger u2 = null;
            BigInteger v = this.getONE();
            BigInteger v2 = null;
            int n2 = k.getBitLength() - 2;
            if (0 <= n2) {
                do {
                    int i = n2--;
                    u2 = u.times(v).rem(n);
                    v2 = v.square().plus(d.times(u.square())).rem(n);
                    if (v2.testBit(0)) {
                        v2 = v2.minus(n);
                    }
                    v2 = v2.shr(1);
                    u = u2;
                    v = v2;
                    if (!k.testBit(i)) continue;
                    u2 = u.plus(v).rem(n);
                    if (u2.testBit(0)) {
                        u2 = u2.minus(n);
                    }
                    u2 = u2.shr(1);
                    v2 = v.plus(d.times(u)).rem(n);
                    if (v2.testBit(0)) {
                        v2 = v2.minus(n);
                    }
                    v2 = v2.shr(1);
                    u = u2;
                    v = v2;
                } while (0 <= n2);
            }
            return u;
        }

        private final void reportOverflow() {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }

        @NotNull
        public final BigInteger of(long val) {
            if (val == 0L) {
                return this.getZERO();
            }
            boolean bl = 1L <= val ? val <= (long)MAX_CONSTANT : false;
            if (bl) {
                BigInteger bigInteger = posConst[(int)val];
                if (bigInteger == null) {
                    throw new IllegalStateException();
                }
                return bigInteger;
            }
            if (val < 0L && val >= (long)(-MAX_CONSTANT)) {
                BigInteger bigInteger = negConst[(int)(-val)];
                if (bigInteger == null) {
                    throw new IllegalStateException();
                }
                return bigInteger;
            }
            return new BigInteger(val, null);
        }

        @NotNull
        public final BigInteger of(int value) {
            return this.of((long)value);
        }

        private final Pair<Integer, String> getRadix(String $this$getRadix) {
            return StringsKt.contains((CharSequence)$this$getRadix, "0B", true) ? new Pair<Integer, String>(2, StringsKt.replaceFirst$default(StringsKt.replaceFirst$default($this$getRadix, "0B", "", false, 4, null), "0b", "", false, 4, null)) : (StringsKt.contains((CharSequence)$this$getRadix, "0O", true) ? new Pair<Integer, String>(8, StringsKt.replaceFirst$default(StringsKt.replaceFirst$default($this$getRadix, "0O", "", false, 4, null), "0o", "", false, 4, null)) : (StringsKt.contains((CharSequence)$this$getRadix, "0X", true) ? new Pair<Integer, String>(16, StringsKt.replaceFirst$default(StringsKt.replaceFirst$default($this$getRadix, "0X", "", false, 4, null), "0x", "", false, 4, null)) : new Pair<Integer, String>(10, $this$getRadix)));
        }

        @NotNull
        public final BigInteger of(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            Pair<Integer, String> radixed = this.getRadix(value);
            return new BigInteger(radixed.getSecond(), ((Number)radixed.getFirst()).intValue());
        }

        @NotNull
        public final BigInteger of(@NotNull String value, int radix) {
            Intrinsics.checkNotNullParameter(value, "value");
            return new BigInteger(value, radix);
        }

        private final BigInteger of(int[] val) {
            return val[0] > 0 ? new BigInteger(val, 1) : new BigInteger(val, null);
        }

        @NotNull
        public final BigInteger getZERO() {
            return ZERO;
        }

        @NotNull
        public final BigInteger getONE() {
            return ONE;
        }

        @NotNull
        public final BigInteger getTWO() {
            return TWO;
        }

        @NotNull
        public final BigInteger getTEN() {
            return TEN;
        }

        private final int[] sum(int[] x, long val) {
            boolean carry;
            long sum = 0L;
            int xIndex = x.length;
            int[] result2 = null;
            int highWord = (int)(val >>> 32);
            if (highWord == 0) {
                result2 = new int[xIndex];
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + val;
                result2[xIndex] = (int)sum;
            } else {
                if (xIndex == 1) {
                    result2 = new int[2];
                    sum = val + ((long)x[0] & 0xFFFFFFFFL);
                    result2[1] = (int)sum;
                    result2[0] = (int)(sum >>> 32);
                    return result2;
                }
                result2 = new int[xIndex];
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + (val & 0xFFFFFFFFL);
                result2[xIndex] = (int)sum;
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)highWord & 0xFFFFFFFFL) + (sum >>> 32);
                result2[xIndex] = (int)sum;
            }
            boolean bl = carry = sum >>> 32 != 0L;
            while (xIndex > 0 && carry) {
                result2[xIndex - 1] = x[xIndex] + 1;
                carry = result2[--xIndex] == 0;
            }
            while (xIndex > 0) {
                result2[--xIndex] = x[xIndex];
            }
            if (carry) {
                int[] bigger = new int[result2.length + 1];
                UtilsKt.arrayCopy(result2, 0, bigger, 1, result2.length);
                bigger[0] = 1;
                return bigger;
            }
            return result2;
        }

        private final int[] sum(int[] x, int[] y) {
            boolean carry;
            int[] x2 = x;
            int[] y2 = y;
            if (x2.length < y2.length) {
                int[] tmp = x2;
                x2 = y2;
                y2 = tmp;
            }
            int xIndex = x2.length;
            int yIndex = y2.length;
            int[] result2 = new int[xIndex];
            long sum = 0L;
            if (yIndex == 1) {
                int n = xIndex;
                xIndex = n + -1;
                sum = ((long)x2[xIndex] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL);
                result2[xIndex] = (int)sum;
            } else {
                while (yIndex > 0) {
                    sum = ((long)x2[--xIndex] & 0xFFFFFFFFL) + ((long)y2[--yIndex] & 0xFFFFFFFFL) + (sum >>> 32);
                    result2[xIndex] = (int)sum;
                }
            }
            boolean bl = carry = sum >>> 32 != 0L;
            while (xIndex > 0 && carry) {
                result2[--xIndex] = x2[xIndex] + 1;
                carry = result2[xIndex] == 0;
            }
            while (xIndex > 0) {
                result2[--xIndex] = x2[xIndex];
            }
            if (carry) {
                int[] bigger = new int[result2.length + 1];
                UtilsKt.arrayCopy(result2, 0, bigger, 1, result2.length);
                bigger[0] = 1;
                return bigger;
            }
            return result2;
        }

        private final int[] subtract(long val, int[] little) {
            int highWord = (int)(val >>> 32);
            if (highWord == 0) {
                int[] result2 = new int[]{(int)(val - ((long)little[0] & 0xFFFFFFFFL))};
                return result2;
            }
            int[] result3 = new int[2];
            if (little.length == 1) {
                long difference = ((long)((int)val) & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL);
                result3[1] = (int)difference;
                boolean borrow = difference >> 32 != 0L;
                result3[0] = borrow ? highWord - 1 : highWord;
                return result3;
            }
            long difference = ((long)((int)val) & 0xFFFFFFFFL) - ((long)little[1] & 0xFFFFFFFFL);
            result3[1] = (int)difference;
            difference = ((long)highWord & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL) + (difference >> 32);
            result3[0] = (int)difference;
            return result3;
        }

        private final int[] subtract(int[] big, long val) {
            boolean borrow;
            int highWord = (int)(val >>> 32);
            int bigIndex = big.length;
            int[] result2 = new int[bigIndex];
            long difference = 0L;
            if (highWord == 0) {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - val;
                result2[bigIndex] = (int)difference;
            } else {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - (val & 0xFFFFFFFFL);
                result2[bigIndex] = (int)difference;
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)highWord & 0xFFFFFFFFL) + (difference >> 32);
                result2[bigIndex] = (int)difference;
            }
            boolean bl = borrow = difference >> 32 != 0L;
            while (bigIndex > 0 && borrow) {
                result2[--bigIndex] = big[bigIndex] - 1;
                borrow = result2[bigIndex] == -1;
            }
            while (bigIndex > 0) {
                result2[--bigIndex] = big[bigIndex];
            }
            return result2;
        }

        private final int[] subtract(int[] big, int[] little) {
            boolean borrow;
            int bigIndex = big.length;
            int[] result2 = new int[bigIndex];
            int littleIndex = little.length;
            long difference = 0L;
            while (littleIndex > 0) {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
                result2[bigIndex] = (int)difference;
            }
            boolean bl = borrow = difference >> 32 != 0L;
            while (bigIndex > 0 && borrow) {
                result2[--bigIndex] = big[bigIndex] - 1;
                borrow = result2[bigIndex] == -1;
            }
            while (bigIndex > 0) {
                result2[--bigIndex] = big[bigIndex];
            }
            return result2;
        }

        private final BigInteger multiplyByInt(int[] x, int y, int sign) {
            if (UtilsKt.bitCount(y) == 1) {
                return new BigInteger(this.shl(x, UtilsKt.numberOfTrailingZeros(y)), sign);
            }
            int xlen = x.length;
            int[] rmag = new int[xlen + 1];
            long carry = 0L;
            long yl = (long)y & 0xFFFFFFFFL;
            int rstart = rmag.length - 1;
            int n = xlen - 1;
            if (0 <= n) {
                do {
                    int i = n--;
                    long product2 = ((long)x[i] & 0xFFFFFFFFL) * yl + carry;
                    int n2 = rstart;
                    rstart = n2 + -1;
                    rmag[n2] = (int)product2;
                    carry = product2 >>> 32;
                } while (0 <= n);
            }
            if (carry == 0L) {
                int[] nArray = rmag;
                int n3 = 1;
                int n4 = rmag.length;
                boolean bl = false;
                rmag = ArraysKt.copyOfRange(nArray, n3, n4);
            } else {
                rmag[rstart] = (int)carry;
            }
            return new BigInteger(rmag, sign);
        }

        private final int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
            this.multiplyToLenCheck(x, xlen);
            this.multiplyToLenCheck(y, ylen);
            return this.implMultiplyToLen(x, xlen, y, ylen, z);
        }

        private final int[] implMultiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
            int[] z2 = null;
            z2 = z;
            int xstart = xlen - 1;
            int ystart = ylen - 1;
            if (z2 == null || z2.length < xlen + ylen) {
                z2 = new int[xlen + ylen];
            }
            long carry = 0L;
            Companion companion = this;
            boolean bl = false;
            boolean bl2 = false;
            Companion $this$implMultiplyToLen_u24lambda_u2d0 = companion;
            boolean bl3 = false;
            int j = ystart;
            int k = ystart + 1 + xstart;
            while (j >= 0) {
                long product2 = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
                z2[k] = (int)product2;
                carry = product2 >>> 32;
                int n = j;
                j = n + -1;
                n = k;
                k = n + -1;
            }
            z2[xstart] = (int)carry;
            int n = xstart - 1;
            if (0 <= n) {
                do {
                    int i = n--;
                    carry = 0L;
                    int j2 = ystart;
                    int k2 = ystart + 1 + i;
                    while (j2 >= 0) {
                        long product3 = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z2[k2] & 0xFFFFFFFFL) + carry;
                        z2[k2] = (int)product3;
                        carry = product3 >>> 32;
                        int n2 = j2;
                        j2 = n2 + -1;
                        n2 = k2;
                        k2 = n2 + -1;
                    }
                    z2[i] = (int)carry;
                } while (0 <= n);
            }
            return z2;
        }

        private final void multiplyToLenCheck(int[] array, int length) {
            if (length <= 0) {
                return;
            }
            if (length > array.length) {
                throw new IndexOutOfBoundsException(String.valueOf(length - 1));
            }
        }

        private final BigInteger multiplyKaratsuba(BigInteger x, BigInteger y) {
            int xlen = x.get_mag$kt_math().length;
            int ylen = y.get_mag$kt_math().length;
            boolean bl = false;
            int half = (Math.max(xlen, ylen) + 1) / 2;
            BigInteger xl = x.getLower(half);
            BigInteger xh = x.getUpper(half);
            BigInteger yl = y.getLower(half);
            BigInteger yh = y.getUpper(half);
            BigInteger p1 = xh.times(yh);
            BigInteger p2 = xl.times(yl);
            BigInteger p3 = xh.plus(xl).times(yh.plus(yl));
            BigInteger result2 = p1.shl(32 * half).plus(p3.minus(p1).minus(p2)).shl(32 * half).plus(p2);
            return x.get_signum$kt_math() != y.get_signum$kt_math() ? result2.unaryMinus() : result2;
        }

        private final BigInteger multiplyToomCook3(BigInteger a, BigInteger b) {
            int alen = a.get_mag$kt_math().length;
            int blen = b.get_mag$kt_math().length;
            boolean bl = false;
            int largest = Math.max(alen, blen);
            int k = (largest + 2) / 3;
            int r = largest - 2 * k;
            BigInteger a0 = null;
            BigInteger a1 = null;
            BigInteger a2 = null;
            BigInteger b0 = null;
            BigInteger b1 = null;
            BigInteger b2 = null;
            a2 = a.getToomSlice(k, r, 0, largest);
            a1 = a.getToomSlice(k, r, 1, largest);
            a0 = a.getToomSlice(k, r, 2, largest);
            b2 = b.getToomSlice(k, r, 0, largest);
            b1 = b.getToomSlice(k, r, 1, largest);
            b0 = b.getToomSlice(k, r, 2, largest);
            BigInteger v0 = null;
            BigInteger v1 = null;
            BigInteger v2 = null;
            BigInteger vm1 = null;
            BigInteger vinf = null;
            BigInteger t1 = null;
            BigInteger t2 = null;
            BigInteger tm1 = null;
            BigInteger da1 = null;
            BigInteger db1 = null;
            v0 = a0.times(b0);
            da1 = a2.plus(a0);
            db1 = b2.plus(b0);
            vm1 = da1.minus(a1).times(db1.minus(b1));
            da1 = da1.plus(a1);
            db1 = db1.plus(b1);
            v1 = da1.times(db1);
            v2 = da1.plus(a2).shl(1).minus(a0).times(db1.plus(b2).shl(1).minus(b0));
            vinf = a2.times(b2);
            t2 = v2.minus(vm1).exactDivideBy3();
            tm1 = v1.minus(vm1).shr(1);
            t1 = v1.minus(v0);
            t2 = t2.minus(t1).shr(1);
            t1 = t1.minus(tm1).minus(vinf);
            t2 = t2.minus(vinf.shl(1));
            tm1 = tm1.minus(t2);
            int ss = k * 32;
            BigInteger result2 = vinf.shl(ss).plus(t2).shl(ss).plus(t1).shl(ss).plus(tm1).shl(ss).plus(v0);
            return a.get_signum$kt_math() != b.get_signum$kt_math() ? result2.unaryMinus() : result2;
        }

        private final int[] squareToLen(int[] x, int len, int[] z) {
            int[] z2 = z;
            int zlen = len << 1;
            if (z2 == null || z2.length < zlen) {
                z2 = new int[zlen];
            }
            this.implSquareToLenChecks(x, len, z2, zlen);
            return this.implSquareToLen(x, len, z2, zlen);
        }

        private final void implSquareToLenChecks(int[] x, int len, int[] z, int zlen) {
            if (len < 1) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("invalid input length: ", len));
            }
            if (len > x.length) {
                throw new IllegalArgumentException("input length out of bound: " + len + " > " + x.length);
            }
            if (len * 2 > z.length) {
                throw new IllegalArgumentException("input length out of bound: " + len * 2 + " > " + z.length);
            }
            if (zlen < 1) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("invalid input length: ", zlen));
            }
            if (zlen > z.length) {
                throw new IllegalArgumentException("input length out of bound: " + len + " > " + z.length);
            }
        }

        private final int[] implSquareToLen(int[] x, int len, int[] z, int zlen) {
            int lastProductLowWord = 0;
            Companion companion = this;
            boolean bl = false;
            boolean bl2 = false;
            Companion $this$implSquareToLen_u24lambda_u2d1 = companion;
            boolean bl3 = false;
            int j = 0;
            int i = 0;
            while (j < len) {
                long piece = (long)x[j] & 0xFFFFFFFFL;
                long product2 = piece * piece;
                int n = i;
                i = n + 1;
                z[n] = lastProductLowWord << 31 | (int)(product2 >>> 33);
                n = i;
                i = n + 1;
                z[n] = (int)(product2 >>> 1);
                lastProductLowWord = (int)product2;
                n = j;
                j = n + 1;
            }
            int i2 = len;
            int offset = 1;
            while (i2 > 0) {
                int t = x[i2 - 1];
                t = this.mulAdd$kt_math(z, x, offset, i2 - 1, t);
                this.addOne$kt_math(z, offset - 1, i2, t);
                int n = i2;
                i2 = n + -1;
                offset += 2;
            }
            this.primitiveLeftShift$kt_math(z, zlen, 1);
            z[zlen - 1] = z[zlen - 1] | x[len - 1] & 1;
            return z;
        }

        public final int bitLengthForInt$kt_math(int n) {
            return 32 - UtilsKt.numberOfLeadingZeros(n);
        }

        private final int[] leftShift(int[] a, int len, int n) {
            int nInts = n >>> 5;
            int nBits = n & 0x1F;
            int bitsInHighWord = this.bitLengthForInt$kt_math(a[0]);
            if (n <= 32 - bitsInHighWord) {
                this.primitiveLeftShift$kt_math(a, len, nBits);
                return a;
            }
            if (nBits <= 32 - bitsInHighWord) {
                int[] result2 = new int[nInts + len];
                UtilsKt.arrayCopy(a, 0, result2, 0, len);
                this.primitiveLeftShift$kt_math(result2, result2.length, nBits);
                return result2;
            }
            int[] result3 = new int[nInts + len + 1];
            UtilsKt.arrayCopy(a, 0, result3, 0, len);
            this.primitiveRightShift$kt_math(result3, result3.length, 32 - nBits);
            return result3;
        }

        public final void primitiveRightShift$kt_math(@NotNull int[] a, int len, int n) {
            Intrinsics.checkNotNullParameter(a, "a");
            int n2 = 32 - n;
            int i = len - 1;
            int c = a[i];
            while (i > 0) {
                int b = c;
                c = a[i - 1];
                a[i] = c << n2 | b >>> n;
                int n3 = i;
                i = n3 + -1;
            }
            a[0] = a[0] >>> n;
        }

        public final void primitiveLeftShift$kt_math(@NotNull int[] a, int len, int n) {
            Intrinsics.checkNotNullParameter(a, "a");
            if (len == 0 || n == 0) {
                return;
            }
            int n2 = 32 - n;
            int i = 0;
            int c = a[i];
            int m = i + len - 1;
            while (i < m) {
                int b = c;
                c = a[i + 1];
                a[i] = b << n | c >>> n2;
                int n3 = i;
                i = n3 + 1;
            }
            a[len - 1] = a[len - 1] << n;
        }

        private final int bitLength(int[] val, int len) {
            return len == 0 ? 0 : (len - 1 << 5) + this.bitLengthForInt$kt_math(val[0]);
        }

        private final int[] montgomeryMultiply(int[] a, int[] b, int[] n, int len, long inv, int[] product2) {
            int[] product3 = product2;
            this.implMontgomeryMultiplyChecks(a, b, n, len, product3);
            if (len > 512) {
                product3 = this.multiplyToLen(a, len, b, len, product3);
                return this.montReduce(product3, n, len, (int)inv);
            }
            return this.implMontgomeryMultiply(a, b, n, len, inv, this.materialize(product3, len));
        }

        private final int[] montgomerySquare(int[] a, int[] n, int len, long inv, int[] product2) {
            int[] product3 = product2;
            this.implMontgomeryMultiplyChecks(a, a, n, len, product3);
            if (len > 512) {
                product3 = this.squareToLen(a, len, product3);
                return this.montReduce(product3, n, len, (int)inv);
            }
            return this.implMontgomerySquare(a, n, len, inv, this.materialize(product3, len));
        }

        private final void implMontgomeryMultiplyChecks(int[] a, int[] b, int[] n, int len, int[] product2) {
            if (len % 2 != 0) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("input array length must be even: ", len));
            }
            if (len < 1) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("invalid input length: ", len));
            }
            if (len > a.length || len > b.length || len > n.length || product2 != null && len > product2.length) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("input array length out of bound: ", len));
            }
        }

        private final int[] materialize(int[] z, int len) {
            int[] z2 = z;
            if (z2 == null || z2.length < len) {
                z2 = new int[len];
            }
            return z2;
        }

        private final int[] implMontgomeryMultiply(int[] a, int[] b, int[] n, int len, long inv, int[] product2) {
            int[] product3 = product2;
            product3 = this.multiplyToLen(a, len, b, len, product3);
            return this.montReduce(product3, n, len, (int)inv);
        }

        private final int[] implMontgomerySquare(int[] a, int[] n, int len, long inv, int[] product2) {
            int[] product3 = product2;
            product3 = this.squareToLen(a, len, product3);
            return this.montReduce(product3, n, len, (int)inv);
        }

        @NotNull
        public final int[] getBnExpModThreshTable$kt_math() {
            return bnExpModThreshTable;
        }

        public final void setBnExpModThreshTable$kt_math(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter(nArray, "<set-?>");
            bnExpModThreshTable = nArray;
        }

        private final int[] montReduce(int[] n, int[] mod, int mlen, int inv) {
            int c = 0;
            int len = mlen;
            int offset = 0;
            do {
                int nEnd = n[n.length - 1 - offset];
                int carry = this.mulAdd$kt_math(n, mod, offset, mlen, inv * nEnd);
                c += this.addOne$kt_math(n, offset, mlen, carry);
                int n2 = offset;
                offset = n2 + 1;
            } while (--len > 0);
            while (c > 0) {
                c += this.subN(n, mod, mlen);
            }
            while (this.intArrayCmpToLen(n, mod, mlen) >= 0) {
                this.subN(n, mod, mlen);
            }
            return n;
        }

        private final int intArrayCmpToLen(int[] arg1, int[] arg2, int len) {
            int n = 0;
            if (n < len) {
                do {
                    long b2;
                    int i;
                    long b1;
                    if ((b1 = (long)arg1[i = n++] & 0xFFFFFFFFL) < (b2 = (long)arg2[i] & 0xFFFFFFFFL)) {
                        return -1;
                    }
                    if (b1 <= b2) continue;
                    return 1;
                } while (n < len);
            }
            return 0;
        }

        private final int subN(int[] a, int[] b, int len) {
            int len2 = len;
            long sum = 0L;
            while (--len2 >= 0) {
                sum = ((long)a[len2] & 0xFFFFFFFFL) - ((long)b[len2] & 0xFFFFFFFFL) + (sum >> 32);
                a[len2] = (int)sum;
            }
            return (int)(sum >> 32);
        }

        public final int mulAdd$kt_math(@NotNull int[] out2, @NotNull int[] in, int offset, int len, int k) {
            Intrinsics.checkNotNullParameter(out2, "out");
            Intrinsics.checkNotNullParameter(in, "in");
            this.implMulAddCheck(out2, in, offset, len, k);
            return this.implMulAdd(out2, in, offset, len, k);
        }

        private final void implMulAddCheck(int[] out2, int[] in, int offset, int len, int k) {
            if (len > in.length) {
                throw new IllegalArgumentException("input length is out of bound: " + len + " > " + in.length);
            }
            if (offset < 0) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("input offset is invalid: ", offset));
            }
            if (offset > out2.length - 1) {
                throw new IllegalArgumentException("input offset is out of bound: " + offset + " > " + (out2.length - 1));
            }
            if (len > out2.length - offset) {
                throw new IllegalArgumentException("input len is out of bound: " + len + " > " + (out2.length - offset));
            }
        }

        private final int implMulAdd(int[] out2, int[] in, int offset, int len, int k) {
            int offset2 = offset;
            long kLong = (long)k & 0xFFFFFFFFL;
            long carry = 0L;
            offset2 = out2.length - offset2 - 1;
            int n = len - 1;
            if (0 <= n) {
                do {
                    int j = n--;
                    long product2 = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out2[offset2] & 0xFFFFFFFFL) + carry;
                    int n2 = offset2;
                    offset2 = n2 + -1;
                    out2[n2] = (int)product2;
                    carry = product2 >>> 32;
                } while (0 <= n);
            }
            return (int)carry;
        }

        public final int addOne$kt_math(@NotNull int[] a, int offset, int mlen, int carry) {
            Intrinsics.checkNotNullParameter(a, "a");
            int offset2 = offset;
            int mlen2 = mlen;
            offset2 = a.length - 1 - mlen2 - offset2;
            long t = ((long)a[offset2] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
            a[offset2] = (int)t;
            if (t >>> 32 == 0L) {
                return 0;
            }
            while (--mlen2 >= 0) {
                if (--offset2 < 0) {
                    return 1;
                }
                int[] nArray = a;
                int n = offset2;
                int n2 = nArray[n];
                nArray[n] = n2 + 1;
                if (a[offset2] == 0) continue;
                return 0;
            }
            return 1;
        }

        private final int[] shl(int[] mag, int n) {
            int nInts = n >>> 5;
            int nBits = n & 0x1F;
            int magLen = mag.length;
            int[] newMag = null;
            if (nBits == 0) {
                newMag = new int[magLen + nInts];
                UtilsKt.arrayCopy(mag, 0, newMag, 0, magLen);
            } else {
                int i = 0;
                int nBits2 = 32 - nBits;
                int highBits = mag[0] >>> nBits2;
                if (highBits != 0) {
                    newMag = new int[magLen + nInts + 1];
                    int n2 = i;
                    i = n2 + 1;
                    newMag[n2] = highBits;
                } else {
                    newMag = new int[magLen + nInts];
                }
                int j = 0;
                while (j < magLen - 1) {
                    int n3 = i;
                    i = n3 + 1;
                    int n4 = n3;
                    n3 = j;
                    j = n3 + 1;
                    newMag[n4] = mag[n3] << nBits | mag[j] >>> nBits2;
                }
                newMag[i] = mag[j] << nBits;
            }
            return newMag;
        }

        private final void toString(BigInteger u, StringBuilder sb, int radix, int digits) {
            if (u.get_mag$kt_math().length <= 20) {
                int n;
                String s = u.smallToString(radix);
                if (s.length() < digits && sb.length() > 0 && (n = s.length()) < digits) {
                    do {
                        int i = n++;
                        sb.append('0');
                    } while (n < digits);
                }
                sb.append(s);
                return;
            }
            int b = 0;
            int n = 0;
            b = u.getBitLength();
            double i = (double)b * LOG_TWO / logCache[radix];
            boolean bl = false;
            i = Math.log(i) / LOG_TWO - 1.0;
            bl = false;
            n = (int)Math.rint(i);
            BigInteger v = this.getRadixConversionCache(radix, n);
            BigInteger[] results = null;
            results = u.divideAndRemainder(v);
            int expectedDigits = 1 << n;
            this.toString(results[0], sb, radix, digits - expectedDigits);
            this.toString(results[1], sb, radix, expectedDigits);
        }

        private final BigInteger getRadixConversionCache(int radix, int exponent) {
            BigInteger[] cacheLine = powerCache[radix];
            Intrinsics.checkNotNull(cacheLine);
            if (exponent < cacheLine.length) {
                return cacheLine[exponent];
            }
            int oldLength = cacheLine.length;
            BigInteger[] bigIntegerArray = cacheLine;
            int n = exponent + 1;
            boolean bl = false;
            BigInteger[] bigIntegerArray2 = Arrays.copyOf(bigIntegerArray, n);
            Intrinsics.checkNotNullExpressionValue(bigIntegerArray2, "java.util.Arrays.copyOf(this, newSize)");
            BigInteger[] cacheLine2 = bigIntegerArray2;
            int n2 = oldLength;
            if (n2 <= exponent) {
                int i;
                do {
                    i = n2++;
                    BigInteger bigInteger = cacheLine2[i - 1];
                    Intrinsics.checkNotNull(bigInteger);
                    cacheLine2[i] = bigInteger.pow(2);
                } while (i != exponent);
            }
            BigInteger[][] pc = powerCache;
            BigInteger[] i = pc[radix];
            Intrinsics.checkNotNull(i);
            if (exponent >= i.length) {
                Object[] $this$cloneArray$iv = (Object[])pc;
                boolean $i$f$cloneArray = false;
                int n3 = 0;
                int n4 = $this$cloneArray$iv.length;
                BigInteger[][] bigIntegerArrayArray = new BigInteger[n4][];
                while (n3 < n4) {
                    int n5 = n3++;
                    bigIntegerArrayArray[n5] = $this$cloneArray$iv[n5];
                }
                pc = bigIntegerArrayArray;
                pc[radix] = ArraysKt.requireNoNulls(cacheLine2);
                powerCache = pc;
            }
            BigInteger bigInteger = cacheLine2[exponent];
            Intrinsics.checkNotNull(bigInteger);
            return bigInteger;
        }

        private final int[] stripLeadingZeroInts(int[] val) {
            int vlen = val.length;
            int keep = 0;
            keep = 0;
            while (keep < vlen && val[keep] == 0) {
                int n = keep;
                keep = n + 1;
            }
            int[] nArray = val;
            boolean bl = false;
            return ArraysKt.copyOfRange(nArray, keep, vlen);
        }

        private final int[] trustedStripLeadingZeroInts(int[] val) {
            int[] nArray;
            int vlen = val.length;
            int keep = 0;
            keep = 0;
            while (keep < vlen && val[keep] == 0) {
                int n = keep;
                keep = n + 1;
            }
            if (keep == 0) {
                nArray = val;
            } else {
                int[] nArray2 = val;
                boolean bl = false;
                nArray = ArraysKt.copyOfRange(nArray2, keep, vlen);
            }
            return nArray;
        }

        private final int[] stripLeadingZeroBytes(byte[] a, int off, int len) {
            int indexBound = off + len;
            int keep = 0;
            keep = off;
            while (keep < indexBound && a[keep] == 0) {
                int n = keep;
                keep = n + 1;
            }
            int intLength = indexBound - keep + 3 >>> 2;
            int[] result2 = new int[intLength];
            int b = indexBound - 1;
            int n = intLength - 1;
            if (0 <= n) {
                do {
                    int i = n--;
                    int n2 = b;
                    b = n2 + -1;
                    result2[i] = a[n2] & 0xFF;
                    int bytesRemaining = b - keep + 1;
                    int n3 = 3;
                    int n4 = 0;
                    int bytesToTransfer = Math.min(n3, bytesRemaining);
                    for (int j = 8; j <= bytesToTransfer << 3; j += 8) {
                        n4 = b;
                        b = n4 + -1;
                        result2[i] = result2[i] | (a[n4] & 0xFF) << j;
                    }
                } while (0 <= n);
            }
            return result2;
        }

        private final int[] makePositive(byte[] a, int off, int len) {
            int i;
            int n;
            int keep = 0;
            int k = 0;
            int indexBound = off + len;
            keep = off;
            while (keep < indexBound && a[keep] == -1) {
                n = keep;
                keep = n + 1;
            }
            k = keep;
            while (k < indexBound && a[k] == 0) {
                n = k;
                k = n + 1;
            }
            int extraByte = k == indexBound ? 1 : 0;
            int intLength = indexBound - keep + extraByte + 3 >>> 2;
            int[] result2 = new int[intLength];
            int b = indexBound - 1;
            int n2 = intLength - 1;
            if (0 <= n2) {
                do {
                    i = n2--;
                    int n3 = b;
                    b = n3 + -1;
                    result2[i] = a[n3] & 0xFF;
                    int n4 = 3;
                    int n5 = b - keep + 1;
                    boolean bl = false;
                    int numBytesToTransfer = Math.min(n4, n5);
                    if (numBytesToTransfer < 0) {
                        numBytesToTransfer = 0;
                    }
                    for (int j = 8; j <= 8 * numBytesToTransfer; j += 8) {
                        n5 = b;
                        b = n5 + -1;
                        result2[i] = result2[i] | (a[n5] & 0xFF) << j;
                    }
                    int mask = -1 >>> 8 * (3 - numBytesToTransfer);
                    result2[i] = ~result2[i] & mask;
                } while (0 <= n2);
            }
            if (0 <= (n2 = result2.length + -1)) {
                do {
                    i = n2--;
                    result2[i] = (int)(((long)result2[i] & 0xFFFFFFFFL) + 1L);
                } while (result2[i] == 0 && 0 <= n2);
            }
            return result2;
        }

        private final int[] makePositive(int[] a) {
            int n;
            int keep = 0;
            int j = 0;
            keep = 0;
            while (keep < a.length && a[keep] == -1) {
                n = keep;
                keep = n + 1;
            }
            j = keep;
            while (j < a.length && a[j] == 0) {
                n = j;
                j = n + 1;
            }
            int extraInt = j == a.length ? 1 : 0;
            int[] result2 = new int[a.length - keep + extraInt];
            int n2 = keep;
            int n3 = a.length;
            if (n2 < n3) {
                do {
                    int i = n2++;
                    result2[i - keep + extraInt] = ~a[i];
                } while (n2 < n3);
            }
            int i = result2.length - 1;
            while (true) {
                int[] nArray = result2;
                int n4 = i;
                nArray[n4] = nArray[n4] + 1;
                if (nArray[n4] != 0) break;
                n3 = i;
                i = n3 + -1;
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

