/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.stdlib.function;

import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.function.BinaryMathFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gciatto.kt.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lit/unibo/tuprolog/solve/stdlib/function/Exponentiation;", "Lit/unibo/tuprolog/solve/function/BinaryMathFunction;", "()V", "mathFunction", "Lit/unibo/tuprolog/core/Numeric;", "integer1", "Lit/unibo/tuprolog/core/Integer;", "integer2", "context", "Lit/unibo/tuprolog/solve/ExecutionContext;", "integer", "real", "Lit/unibo/tuprolog/core/Real;", "real1", "real2", "returnOneOfBothZero", "numeric1", "numeric2", "solve"})
public final class Exponentiation
extends BinaryMathFunction {
    @NotNull
    public static final Exponentiation INSTANCE = new Exponentiation();

    private Exponentiation() {
        super("**");
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Integer integer1, @NotNull Integer integer2, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter(integer1, "integer1");
        Intrinsics.checkNotNullParameter(integer2, "integer2");
        Intrinsics.checkNotNullParameter(context, "context");
        Real real = this.returnOneOfBothZero(integer1, integer2);
        return real == null ? (Numeric)Real.Companion.of(integer1.getDecimalValue().pow(integer2.getValue().toInt())) : (Numeric)real;
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Real real, @NotNull Integer integer, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter(real, "real");
        Intrinsics.checkNotNullParameter(integer, "integer");
        Intrinsics.checkNotNullParameter(context, "context");
        Real real2 = this.returnOneOfBothZero(real, integer);
        return real2 == null ? (Numeric)Real.Companion.of(real.getValue().pow(integer.getValue().toInt())) : (Numeric)real2;
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Integer integer, @NotNull Real real, @NotNull ExecutionContext context) {
        Numeric numeric;
        Intrinsics.checkNotNullParameter(integer, "integer");
        Intrinsics.checkNotNullParameter(real, "real");
        Intrinsics.checkNotNullParameter(context, "context");
        Real real2 = this.returnOneOfBothZero(integer, real);
        if (real2 == null) {
            double d = integer.getValue().toDouble();
            double d2 = real.getValue().toDouble();
            boolean bl = false;
            numeric = Real.Companion.of(Math.pow(d, d2));
        } else {
            numeric = real2;
        }
        return numeric;
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Real real1, @NotNull Real real2, @NotNull ExecutionContext context) {
        Numeric numeric;
        Intrinsics.checkNotNullParameter(real1, "real1");
        Intrinsics.checkNotNullParameter(real2, "real2");
        Intrinsics.checkNotNullParameter(context, "context");
        Real real = this.returnOneOfBothZero(real1, real2);
        if (real == null) {
            double d = real1.getValue().toDouble();
            double d2 = real2.getValue().toDouble();
            boolean bl = false;
            numeric = Real.Companion.of(Math.pow(d, d2));
        } else {
            numeric = real;
        }
        return numeric;
    }

    private final Real returnOneOfBothZero(Numeric numeric1, Numeric numeric2) {
        return Intrinsics.areEqual(numeric1.getDecimalValue(), BigDecimal.Companion.getZERO()) && Intrinsics.areEqual(numeric2.getDecimalValue(), BigDecimal.Companion.getZERO()) ? Numeric.Companion.of(1.0) : null;
    }
}

