/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.List;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.impl.AbstractCons;
import it.unibo.tuprolog.core.impl.LazyConsWithImplicitLast;
import it.unibo.tuprolog.utils.CursorExtensions;
import it.unibo.tuprolog.utils.Taggable;
import it.unibo.tuprolog.utils.TaggableExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0012H\u0014J\u001c\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\""}, d2={"Lit/unibo/tuprolog/core/impl/ConsImpl;", "Lit/unibo/tuprolog/core/impl/AbstractCons;", "Lit/unibo/tuprolog/core/Cons;", "head", "Lit/unibo/tuprolog/core/Term;", "tail", "tags", "", "", "", "(Lit/unibo/tuprolog/core/Term;Lit/unibo/tuprolog/core/Term;Ljava/util/Map;)V", "estimatedLength", "", "getEstimatedLength", "()I", "getHead", "()Lit/unibo/tuprolog/core/Term;", "isGround", "", "()Z", "isWellFormed", "last", "getLast", "size", "getSize", "getTail", "applyNonEmptyUnifier", "unifier", "Lit/unibo/tuprolog/core/Substitution$Unifier;", "checkGroundness", "copyWithTags", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "core"})
public final class ConsImpl
extends AbstractCons
implements Cons {
    @NotNull
    private final Term head;
    @NotNull
    private final Term tail;
    private final boolean isGround;
    @NotNull
    private final Term last;
    private final int size;
    private final boolean isWellFormed;

    public ConsImpl(@NotNull Term head2, @NotNull Term tail2, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(head2, "head");
        Intrinsics.checkNotNullParameter(tail2, "tail");
        Intrinsics.checkNotNullParameter(tags, "tags");
        Term[] termArray = new Term[]{head2, tail2};
        super(CollectionsKt.listOf(termArray), tags);
        this.head = head2;
        this.tail = tail2;
        this.isGround = this.checkGroundness();
        this.last = this.getTail().isList() ? this.getTail().castToList().getLast() : this.getTail();
        this.size = this.getTail().isList() ? 1 + this.getTail().castToList().getSize() : 2;
        this.isWellFormed = this.getTail().isList() ? this.getTail().castToList().isWellFormed() : false;
    }

    public /* synthetic */ ConsImpl(Term term, Term term2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(term, term2, map);
    }

    @Override
    @NotNull
    public Term getHead() {
        return this.head;
    }

    @Override
    @NotNull
    public Term getTail() {
        return this.tail;
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    @Override
    @NotNull
    public Term getLast() {
        return this.last;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isWellFormed() {
        return this.isWellFormed;
    }

    @Override
    protected boolean checkGroundness() {
        return this.getHead().isGround() && this.getTail().isGround();
    }

    @Override
    public int getEstimatedLength() {
        return this.getSize();
    }

    @Override
    @NotNull
    protected Term applyNonEmptyUnifier(@NotNull Substitution.Unifier unifier) {
        Intrinsics.checkNotNullParameter(unifier, "unifier");
        return this.getEstimatedLength() >= 100 ? (Term)new LazyConsWithImplicitLast(CursorExtensions.cursor(this.getUnfoldedSequence()).map((Function1)new Function1<Term, Term>(unifier){
            final /* synthetic */ Substitution.Unifier $unifier;
            {
                this.$unifier = $unifier;
                super(1);
            }

            @NotNull
            public final Term invoke(@NotNull Term it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.apply(this.$unifier);
            }
        }), this.getTags()) : (Term)new ConsImpl(this.getHead().apply(unifier), this.getTail().apply(unifier), this.getTags());
    }

    @Override
    @NotNull
    protected ConsImpl copyWithTags(@NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        return this.getTags() == tags ? this : new ConsImpl(this.getHead(), this.getTail(), tags);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cons freshCopy(@NotNull Scope scope2) {
        Cons cons;
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (this.isGround()) {
            cons = this;
        } else if (this.isWellFormed()) {
            Collection<Term> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.toList();
            Scope scope3 = scope2;
            boolean $i$f$map = false;
            void var4_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Term term = (Term)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Term term2 = it.freshCopy(scope2);
                collection.add(term2);
            }
            collection = (java.util.List)destination$iv$iv;
            cons = ((List)TaggableExtensions.setTags((Taggable)scope3.listOf((Iterable<? extends Term>)collection), this.getTags())).castToCons();
        } else {
            Collection<Term> collection;
            Iterable $this$map$iv = this.getUnfoldedList();
            Scope scope4 = scope2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Term it = (Term)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Term term = it.freshCopy(scope2);
                collection.add(term);
            }
            collection = (java.util.List)destination$iv$iv;
            cons = ((List)TaggableExtensions.setTags((Taggable)Scope.DefaultImpls.listFrom$default(scope4, collection, null, 2, null), this.getTags())).castToCons();
        }
        return cons;
    }
}

