/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermVisitor;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.impl.AbstractStruct;
import it.unibo.tuprolog.utils.IterUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ!\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+H\u0016\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u0010/\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u00102\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0006H\u0016J\u001c\u00104\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH$J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001bH\u0002J\b\u00108\u001a\u00020\u0002H\u0016J\u0010\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u001bH\u0016J\u0018\u0010<\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J)\u0010?\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00062\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060A\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010BJ\u0016\u0010?\u001a\u00020\u00022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0016\u0010?\u001a\u00020\u00022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J!\u0010E\u001a\u00020\u00022\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060A\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010FJ\u0016\u0010E\u001a\u00020\u00022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0016\u0010E\u001a\u00020\u00022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J\u0010\u0010G\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010H\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b#\u0010%\u00a8\u0006I"}, d2={"Lit/unibo/tuprolog/core/impl/ClauseImpl;", "Lit/unibo/tuprolog/core/impl/AbstractStruct;", "Lit/unibo/tuprolog/core/Clause;", "head", "Lit/unibo/tuprolog/core/Struct;", "body", "Lit/unibo/tuprolog/core/Term;", "tags", "", "", "", "(Lit/unibo/tuprolog/core/Struct;Lit/unibo/tuprolog/core/Term;Ljava/util/Map;)V", "getBody", "()Lit/unibo/tuprolog/core/Term;", "bodyAsTuple", "Lit/unibo/tuprolog/core/Tuple;", "getBodyAsTuple", "()Lit/unibo/tuprolog/core/Tuple;", "bodyItems", "", "getBodyItems", "()Ljava/lang/Iterable;", "bodyItemsSequence", "Lkotlin/sequences/Sequence;", "getBodyItemsSequence", "()Lkotlin/sequences/Sequence;", "bodySize", "", "getBodySize", "()I", "functor", "getFunctor", "()Ljava/lang/String;", "getHead", "()Lit/unibo/tuprolog/core/Struct;", "isWellFormed", "", "()Z", "isWellFormed$delegate", "Lkotlin/Lazy;", "accept", "T", "visitor", "Lit/unibo/tuprolog/core/TermVisitor;", "(Lit/unibo/tuprolog/core/TermVisitor;)Ljava/lang/Object;", "addFirstBodyItem", "argument", "addFirstHeadArg", "addLastBodyItem", "addLastHeadArg", "appendBodyItem", "appendHeadArg", "copyWithTags", "ensureIndexIsInBodyRange", "", "index", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "getBodyItem", "insertBodyItem", "insertHeadArg", "setBody", "setBodyItems", "arguments", "", "(Lit/unibo/tuprolog/core/Term;[Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Clause;", "setHead", "Lit/unibo/tuprolog/core/Rule;", "setHeadArgs", "([Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Clause;", "setHeadFunctor", "toString", "core"})
public abstract class ClauseImpl
extends AbstractStruct
implements Clause {
    @Nullable
    private final Struct head;
    @NotNull
    private final Term body;
    @NotNull
    private final Lazy isWellFormed$delegate;
    @NotNull
    private final String functor;

    public ClauseImpl(@Nullable Struct head2, @NotNull Term body, @NotNull Map<String, ? extends Object> tags) {
        List<Term> list;
        Intrinsics.checkNotNullParameter(body, "body");
        Intrinsics.checkNotNullParameter(tags, "tags");
        if (head2 == null) {
            list = CollectionsKt.listOf(body);
        } else {
            Term[] termArray = new Term[]{head2, body};
            list = CollectionsKt.listOf(termArray);
        }
        super(":-", list, tags);
        this.head = head2;
        this.body = body;
        this.isWellFormed$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ClauseImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final boolean invoke() {
                return this.this$0.getBody().accept(Clause.Companion.getBodyWellFormedVisitor());
            }
        });
        this.functor = Clause.DefaultImpls.getFunctor(this);
    }

    @Override
    @Nullable
    public Struct getHead() {
        return this.head;
    }

    @Override
    @NotNull
    public Term getBody() {
        return this.body;
    }

    @Override
    public boolean isWellFormed() {
        Lazy lazy = this.isWellFormed$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public String getFunctor() {
        return this.functor;
    }

    @Override
    @NotNull
    public String toString() {
        Struct struct = this.getHead();
        return struct == null ? this.getFunctor() + ' ' + this.getBody() : this.getHead() + ' ' + this.getFunctor() + ' ' + this.getBody();
    }

    @Override
    @NotNull
    protected abstract Clause copyWithTags(@NotNull Map<String, ? extends Object> var1);

    @Override
    @NotNull
    public Clause freshCopy() {
        return super.freshCopy().castToClause();
    }

    @Override
    @NotNull
    public Clause freshCopy(@NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return super.freshCopy(scope2).castToClause();
    }

    private final Sequence<Term> getBodyItemsSequence() {
        Sequence<Term> sequence;
        Term term = this.getBody();
        boolean bl = false;
        boolean bl2 = false;
        Term it = term;
        boolean bl3 = false;
        if (it.isTuple()) {
            sequence = it.castToTuple().toSequence();
        } else {
            Term[] termArray = new Term[]{it};
            sequence = SequencesKt.sequenceOf(termArray);
        }
        return sequence;
    }

    @Override
    @NotNull
    public Iterable<Term> getBodyItems() {
        return SequencesKt.asIterable(this.getBodyItemsSequence());
    }

    @Override
    public int getBodySize() {
        Term term = this.getBody();
        boolean bl = false;
        boolean bl2 = false;
        Term it = term;
        boolean bl3 = false;
        return it.isTuple() ? it.castToTuple().getSize() : 1;
    }

    @Override
    @Nullable
    public Tuple getBodyAsTuple() {
        return this.getBody().asTuple();
    }

    private final void ensureIndexIsInBodyRange(int index) {
        int size = this.getBodySize();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Attempt to access body item " + index + " of a clause having " + size + " body items");
        }
    }

    @Override
    @NotNull
    public Term getBodyItem(int index) {
        this.ensureIndexIsInBodyRange(index);
        return SequencesKt.first(SequencesKt.drop(this.getBodyItemsSequence(), index));
    }

    @Override
    @NotNull
    public Rule setHead(@NotNull Struct head2) {
        Intrinsics.checkNotNullParameter(head2, "head");
        Term[] termArray = new Term[]{this.getBody()};
        return Rule.Companion.of(head2, termArray);
    }

    @Override
    @NotNull
    public Clause setBody(@NotNull Term body) {
        Intrinsics.checkNotNullParameter(body, "body");
        Term[] termArray = new Term[]{body};
        return Clause.Companion.of(this.getHead(), termArray);
    }

    @Override
    @NotNull
    public Clause setHeadFunctor(@NotNull String functor) {
        Intrinsics.checkNotNullParameter(functor, "functor");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.setFunctor(functor);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause setHeadArgs(Term ... arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.setArgs(Arrays.copyOf(arguments2, arguments2.length));
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause setHeadArgs(@NotNull Iterable<? extends Term> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.setArgs(arguments2);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause setHeadArgs(@NotNull Sequence<? extends Term> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.setArgs(arguments2);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause insertHeadArg(int index, @NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.insertAt(index, argument2);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause addFirstHeadArg(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.addFirst(argument2);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause addLastHeadArg(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Term[] termArray = this.getHead();
        Struct struct = termArray == null ? null : termArray.addLast(argument2);
        termArray = new Term[]{this.getBody()};
        return Clause.Companion.of(struct, termArray);
    }

    @Override
    @NotNull
    public Clause appendHeadArg(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        return this.addLastHeadArg(argument2);
    }

    @Override
    @NotNull
    public Clause setBodyItems(@NotNull Term argument2, Term ... arguments2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Struct struct = this.getHead();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(argument2);
        spreadBuilder.addSpread(arguments2);
        return Clause.Companion.of(struct, (Term[])spreadBuilder.toArray(new Term[spreadBuilder.size()]));
    }

    @Override
    @NotNull
    public Clause setBodyItems(@NotNull Iterable<? extends Term> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        return Clause.Companion.of(this.getHead(), arguments2);
    }

    @Override
    @NotNull
    public Clause setBodyItems(@NotNull Sequence<? extends Term> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        return Clause.Companion.of(this.getHead(), arguments2);
    }

    @Override
    @NotNull
    public Clause insertBodyItem(int index, @NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        this.ensureIndexIsInBodyRange(index);
        return Clause.Companion.of(this.getHead(), IterUtils.insertAt(this.getBodyItemsSequence(), index, argument2, new Term[0]));
    }

    @Override
    @NotNull
    public Clause addFirstBodyItem(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Term[] termArray = new Term[]{argument2};
        return Clause.Companion.of(this.getHead(), SequencesKt.plus(SequencesKt.sequenceOf(termArray), this.getBodyItemsSequence()));
    }

    @Override
    @NotNull
    public Clause addLastBodyItem(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Term[] termArray = new Term[]{argument2};
        return Clause.Companion.of(this.getHead(), SequencesKt.plus(this.getBodyItemsSequence(), SequencesKt.sequenceOf(termArray)));
    }

    @Override
    @NotNull
    public Clause appendBodyItem(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        return this.addLastBodyItem(argument2);
    }

    @Override
    public <T> T accept(@NotNull TermVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitClause(this);
    }

    @Override
    public int getArity() {
        return Clause.DefaultImpls.getArity(this);
    }

    @Override
    public boolean isClause() {
        return Clause.DefaultImpls.isClause(this);
    }

    @Override
    public boolean isDirective() {
        return Clause.DefaultImpls.isDirective(this);
    }

    @Override
    public boolean isFact() {
        return Clause.DefaultImpls.isFact(this);
    }

    @Override
    public boolean isRule() {
        return Clause.DefaultImpls.isRule(this);
    }

    @Override
    @NotNull
    public Clause asClause() {
        return Clause.DefaultImpls.asClause(this);
    }
}

