/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.EmptyBlock;
import it.unibo.tuprolog.core.EmptyList;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.List;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Recursive;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.impl.TruthImpl;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ\b\u0010\u0007\u001a\u00020\u0000H\u0016J\b\u0010\b\u001a\u00020\u0000H&J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\f"}, d2={"Lit/unibo/tuprolog/core/Truth;", "Lit/unibo/tuprolog/core/Atom;", "isFail", "", "()Z", "isTrue", "isTruth", "asTruth", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "Companion", "core"})
public interface Truth
extends Atom {
    @NotNull
    public static final Companion Companion = it.unibo.tuprolog.core.Truth$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final String TRUE_FUNCTOR = "true";
    @JvmField
    @NotNull
    public static final String FALSE_FUNCTOR = "false";
    @JvmField
    @NotNull
    public static final String FAIL_FUNCTOR = "fail";
    @JvmField
    @NotNull
    public static final Truth TRUE = new TruthImpl("true", true, null, 4, null);
    @JvmField
    @NotNull
    public static final Truth FAIL = new TruthImpl("fail", false, null, 4, null);
    @JvmField
    @NotNull
    public static final Truth FALSE = new TruthImpl("false", false, null, 4, null);

    @Override
    public boolean isTrue();

    @Override
    public boolean isFail();

    @Override
    public boolean isTruth();

    @Override
    @NotNull
    public Truth freshCopy();

    @Override
    @NotNull
    public Truth freshCopy(@NotNull Scope var1);

    @Override
    @NotNull
    public Truth asTruth();

    @JvmStatic
    @NotNull
    public static Truth of(boolean truth) {
        return Companion.of(truth);
    }

    @JvmStatic
    @NotNull
    public static Truth of(@NotNull String string2) {
        return Companion.of(string2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u0013\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\b\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\n\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u000f"}, d2={"Lit/unibo/tuprolog/core/Truth$Companion;", "", "()V", "FAIL", "Lit/unibo/tuprolog/core/Truth;", "FAIL_FUNCTOR", "", "FALSE", "FALSE_FUNCTOR", "TRUE", "TRUE_FUNCTOR", "of", "truth", "", "string", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Truth of(boolean truth) {
            return truth ? TRUE : FALSE;
        }

        @JvmStatic
        @NotNull
        public final Truth of(@NotNull String string2) {
            Truth truth;
            Intrinsics.checkNotNullParameter(string2, "string");
            switch (string2) {
                case "true": {
                    truth = TRUE;
                    break;
                }
                case "false": {
                    truth = FALSE;
                    break;
                }
                case "fail": {
                    truth = FAIL;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse " + string2 + " as a Truth value");
                }
            }
            return truth;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isFail(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return !this_.isTrue();
        }

        public static boolean isTruth(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return true;
        }

        @NotNull
        public static Truth asTruth(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_;
        }

        @Nullable
        public static <T extends Term> T as(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.as(this_);
        }

        @NotNull
        public static <T extends Term> T castTo(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castTo(this_);
        }

        @NotNull
        public static Struct append(@NotNull Truth this_, @NotNull Term argument2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(argument2, "argument");
            return Atom.DefaultImpls.append(this_, argument2);
        }

        @NotNull
        public static Term apply(@NotNull Truth this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Atom.DefaultImpls.apply(this_, substitution, substitutions);
        }

        @Nullable
        public static Block asBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asBlock(this_);
        }

        @Nullable
        public static Clause asClause(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asClause(this_);
        }

        @Nullable
        public static Cons asCons(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asCons(this_);
        }

        @Nullable
        public static Directive asDirective(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asDirective(this_);
        }

        @Nullable
        public static EmptyBlock asEmptyBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asEmptyBlock(this_);
        }

        @Nullable
        public static EmptyList asEmptyList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asEmptyList(this_);
        }

        @Nullable
        public static Fact asFact(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asFact(this_);
        }

        @Nullable
        public static Indicator asIndicator(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asIndicator(this_);
        }

        @Nullable
        public static Integer asInteger(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asInteger(this_);
        }

        @Nullable
        public static List asList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asList(this_);
        }

        @Nullable
        public static Numeric asNumeric(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asNumeric(this_);
        }

        @Nullable
        public static Real asReal(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asReal(this_);
        }

        @Nullable
        public static Recursive asRecursive(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asRecursive(this_);
        }

        @Nullable
        public static Rule asRule(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asRule(this_);
        }

        @NotNull
        public static Term asTerm(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asTerm(this_);
        }

        @Nullable
        public static Tuple asTuple(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asTuple(this_);
        }

        @Nullable
        public static Var asVar(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asVar(this_);
        }

        @NotNull
        public static Atom castToAtom(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToAtom(this_);
        }

        @NotNull
        public static Block castToBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToBlock(this_);
        }

        @NotNull
        public static Clause castToClause(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToClause(this_);
        }

        @NotNull
        public static Cons castToCons(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToCons(this_);
        }

        @NotNull
        public static Constant castToConstant(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToConstant(this_);
        }

        @NotNull
        public static Directive castToDirective(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToDirective(this_);
        }

        @NotNull
        public static EmptyBlock castToEmptyBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToEmptyBlock(this_);
        }

        @NotNull
        public static EmptyList castToEmptyList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToEmptyList(this_);
        }

        @NotNull
        public static Fact castToFact(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToFact(this_);
        }

        @NotNull
        public static Indicator castToIndicator(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToIndicator(this_);
        }

        @NotNull
        public static Integer castToInteger(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToInteger(this_);
        }

        @NotNull
        public static List castToList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToList(this_);
        }

        @NotNull
        public static Numeric castToNumeric(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToNumeric(this_);
        }

        @NotNull
        public static Real castToReal(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToReal(this_);
        }

        @NotNull
        public static Recursive castToRecursive(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToRecursive(this_);
        }

        @NotNull
        public static Rule castToRule(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToRule(this_);
        }

        @NotNull
        public static Struct castToStruct(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToStruct(this_);
        }

        @NotNull
        public static Term castToTerm(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToTerm(this_);
        }

        @NotNull
        public static Truth castToTruth(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToTruth(this_);
        }

        @NotNull
        public static Tuple castToTuple(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToTuple(this_);
        }

        @NotNull
        public static Var castToVar(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.castToVar(this_);
        }

        @NotNull
        public static Term get(@NotNull Truth this_, int index) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.get(this_, index);
        }

        @NotNull
        public static Term get(@NotNull Truth this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Atom.DefaultImpls.get(this_, substitution, substitutions);
        }

        @NotNull
        public static Term getArgAt(@NotNull Truth this_, int index) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getArgAt(this_, index);
        }

        @NotNull
        public static Sequence<Term> getArgsSequence(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getArgsSequence(this_);
        }

        @NotNull
        public static Indicator getIndicator(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getIndicator(this_);
        }

        public static boolean isConstant(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isConstant(this_);
        }

        public static boolean isGround(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isGround(this_);
        }

        public static boolean isInteger(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isInteger(this_);
        }

        public static boolean isNumber(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isNumber(this_);
        }

        public static boolean isReal(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isReal(this_);
        }

        public static boolean isRecursive(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isRecursive(this_);
        }

        public static boolean isVar(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isVar(this_);
        }

        @Nullable
        public static <T> T getTag(@NotNull Truth this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Atom.DefaultImpls.getTag(this_, name);
        }

        @NotNull
        public static Atom asAtom(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asAtom(this_);
        }

        @NotNull
        public static Constant asConstant(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asConstant(this_);
        }

        @NotNull
        public static Struct asStruct(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.asStruct(this_);
        }

        public static int compareTo(@NotNull Truth this_, @NotNull Term other) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(other, "other");
            return Atom.DefaultImpls.compareTo(this_, other);
        }

        public static boolean containsTag(@NotNull Truth this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Atom.DefaultImpls.containsTag(this_, name);
        }

        @NotNull
        public static java.util.List<Term> getArgs(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getArgs(this_);
        }

        public static int getArity(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getArity(this_);
        }

        public static boolean isAtom(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isAtom(this_);
        }

        public static boolean isBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isBlock(this_);
        }

        public static boolean isClause(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isClause(this_);
        }

        public static boolean isCons(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isCons(this_);
        }

        public static boolean isDirective(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isDirective(this_);
        }

        public static boolean isEmptyBlock(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isEmptyBlock(this_);
        }

        public static boolean isEmptyList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isEmptyList(this_);
        }

        public static boolean isFact(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isFact(this_);
        }

        public static boolean isIndicator(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isIndicator(this_);
        }

        public static boolean isList(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isList(this_);
        }

        public static boolean isRule(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isRule(this_);
        }

        public static boolean isStruct(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isStruct(this_);
        }

        public static boolean isTuple(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.isTuple(this_);
        }

        @NotNull
        public static String getValue(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getValue(this_);
        }

        @NotNull
        public static Sequence<Var> getVariables(@NotNull Truth this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Atom.DefaultImpls.getVariables(this_);
        }
    }
}

