/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.collections;

import it.unibo.tuprolog.collections.ClauseCollection;
import it.unibo.tuprolog.collections.RetrieveResult;
import it.unibo.tuprolog.collections.rete.custom.ReteTree;
import it.unibo.tuprolog.core.Clause;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b \u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0096\u0002J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eH\u0096\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000 2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0018\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000 2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lit/unibo/tuprolog/collections/AbstractClauseCollection;", "Self", "Lit/unibo/tuprolog/collections/ClauseCollection;", "rete", "Lit/unibo/tuprolog/collections/rete/custom/ReteTree;", "(Lit/unibo/tuprolog/collections/rete/custom/ReteTree;)V", "getRete", "()Lit/unibo/tuprolog/collections/rete/custom/ReteTree;", "self", "getSelf", "()Lit/unibo/tuprolog/collections/AbstractClauseCollection;", "size", "", "getSize", "()I", "add", "clause", "Lit/unibo/tuprolog/core/Clause;", "(Lit/unibo/tuprolog/core/Clause;)Lit/unibo/tuprolog/collections/AbstractClauseCollection;", "addAll", "clauses", "", "(Ljava/lang/Iterable;)Lit/unibo/tuprolog/collections/AbstractClauseCollection;", "contains", "", "element", "containsAll", "elements", "isEmpty", "iterator", "", "retrieve", "Lit/unibo/tuprolog/collections/RetrieveResult;", "retrieveAll", "toString", "", "theory"})
public abstract class AbstractClauseCollection<Self extends AbstractClauseCollection<Self>>
implements ClauseCollection {
    @NotNull
    private final ReteTree rete;

    protected AbstractClauseCollection(@NotNull ReteTree rete) {
        Intrinsics.checkNotNullParameter(rete, "rete");
        this.rete = rete;
    }

    @NotNull
    protected final ReteTree getRete() {
        return this.rete;
    }

    @NotNull
    protected abstract Self getSelf();

    @Override
    public int getSize() {
        return SequencesKt.count(this.rete.getClauses());
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean contains(@NotNull Clause element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return SequencesKt.any(this.rete.get(element));
    }

    @Override
    public boolean containsAll(@NotNull Iterable<? extends Clause> elements) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Sequence<? extends Clause> $this$all$iv = CollectionsKt.asSequence(elements);
            boolean $i$f$all = false;
            Iterator<? extends Clause> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                Clause element$iv;
                Clause it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (this.contains(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public abstract Self add(@NotNull Clause var1);

    @NotNull
    public abstract Self addAll(@NotNull Iterable<? extends Clause> var1);

    @NotNull
    public abstract RetrieveResult<? extends Self> retrieve(@NotNull Clause var1);

    @NotNull
    public abstract RetrieveResult<? extends Self> retrieveAll(@NotNull Clause var1);

    @Override
    @NotNull
    public Iterator<Clause> iterator() {
        return this.rete.getClauses().iterator();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + '(' + CollectionsKt.joinToString$default(this, ", ", null, null, 0, null, null, 62, null) + ')';
    }
}

