"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_appsync_1 = require("aws-cdk-lib/aws-appsync");
const caching_key_1 = require("./caching-key");
/**
 * An AppSync resolver
 */
class Resolver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Resolver);
            }
            throw error;
        }
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (props.cachingConfig?.ttl && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if (props.cachingConfig?.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !aws_cdk_lib_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        this.resolver = new aws_appsync_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
            maxBatchSize: props.maxBatchSize,
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: config.ttl?.toSeconds(),
        } : undefined;
    }
}
exports.Resolver = Resolver;
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.Resolver", version: "2.38.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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