"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Values = exports.AttributeValuesStep = exports.AttributeValues = exports.PartitionKey = exports.PrimaryKey = exports.SortKeyStep = exports.PartitionKeyStep = exports.Assign = exports.KeyCondition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
/**
 * Factory class for DynamoDB key conditions.
 */
class KeyCondition {
    constructor(cond) {
        this.cond = cond;
    }
    /**
     * Condition k = arg, true if the key attribute k is equal to the Query argument
     */
    static eq(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '=', arg));
    }
    /**
     * Condition k < arg, true if the key attribute k is less than the Query argument
     */
    static lt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<', arg));
    }
    /**
     * Condition k <= arg, true if the key attribute k is less than or equal to the Query argument
     */
    static le(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<=', arg));
    }
    /**
     * Condition k > arg, true if the key attribute k is greater than the the Query argument
     */
    static gt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>', arg));
    }
    /**
     * Condition k >= arg, true if the key attribute k is greater or equal to the Query argument
     */
    static ge(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>=', arg));
    }
    /**
     * Condition (k, arg). True if the key attribute k begins with the Query argument.
     */
    static beginsWith(keyName, arg) {
        return new KeyCondition(new private_1.BeginsWith(keyName, arg));
    }
    /**
     * Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     */
    static between(keyName, arg1, arg2) {
        return new KeyCondition(new private_1.Between(keyName, arg1, arg2));
    }
    /**
     * Conjunction between two conditions.
     */
    and(keyCond) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(keyCond);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.and);
            }
            throw error;
        }
        return new KeyCondition(this.cond.and(keyCond.cond));
    }
    /**
     * Renders the key condition to a VTL string.
     */
    renderTemplate() {
        return `"query" : {
              "expression" : "${this.cond.renderCondition()}",
              "expressionNames" : {
                ${this.cond.renderExpressionNames()}
              },
              "expressionValues" : {
                ${this.cond.renderExpressionValues()}
              }
            }`;
    }
}
exports.KeyCondition = KeyCondition;
_a = JSII_RTTI_SYMBOL_1;
KeyCondition[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.KeyCondition", version: "2.38.0-alpha.0" };
/**
 * Utility class representing the assigment of a value to an attribute.
 */
class Assign {
    constructor(attr, arg) {
        this.attr = attr;
        this.arg = arg;
    }
    /**
     * Renders the assignment as a VTL string.
     */
    renderAsAssignment() {
        return `"${this.attr}" : $util.dynamodb.toDynamoDBJson(${this.arg})`;
    }
    /**
     * Renders the assignment as a map element.
     */
    putInMap(map) {
        return `$util.qr($${map}.put("${this.attr}", ${this.arg}))`;
    }
}
exports.Assign = Assign;
_b = JSII_RTTI_SYMBOL_1;
Assign[_b] = { fqn: "@aws-cdk/aws-appsync-alpha.Assign", version: "2.38.0-alpha.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a partition key.
 */
class PartitionKeyStep {
    constructor(key) {
        this.key = key;
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    is(val) {
        return new PartitionKey(new Assign(this.key, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    auto() {
        return new PartitionKey(new Assign(this.key, '$util.autoId()'));
    }
}
exports.PartitionKeyStep = PartitionKeyStep;
_c = JSII_RTTI_SYMBOL_1;
PartitionKeyStep[_c] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKeyStep", version: "2.38.0-alpha.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a sort key.
 */
class SortKeyStep {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SortKeyStep);
            }
            throw error;
        }
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    is(val) {
        return new PrimaryKey(this.pkey, new Assign(this.skey, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    auto() {
        return new PrimaryKey(this.pkey, new Assign(this.skey, '$util.autoId()'));
    }
}
exports.SortKeyStep = SortKeyStep;
_d = JSII_RTTI_SYMBOL_1;
SortKeyStep[_d] = { fqn: "@aws-cdk/aws-appsync-alpha.SortKeyStep", version: "2.38.0-alpha.0" };
/**
 * Specifies the assignment to the primary key. It either
 * contains the full primary key or only the partition key.
 */
class PrimaryKey {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(skey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PrimaryKey);
            }
            throw error;
        }
    }
    /**
     * Allows assigning a value to the partition key.
     */
    static partition(key) {
        return new PartitionKeyStep(key);
    }
    /**
     * Renders the key assignment to a VTL string.
     */
    renderTemplate() {
        const assignments = [this.pkey.renderAsAssignment()];
        if (this.skey) {
            assignments.push(this.skey.renderAsAssignment());
        }
        return `"key" : {
      ${assignments.join(',')}
    }`;
    }
}
exports.PrimaryKey = PrimaryKey;
_e = JSII_RTTI_SYMBOL_1;
PrimaryKey[_e] = { fqn: "@aws-cdk/aws-appsync-alpha.PrimaryKey", version: "2.38.0-alpha.0" };
/**
 * Specifies the assignment to the partition key. It can be
 * enhanced with the assignment of the sort key.
 */
class PartitionKey extends PrimaryKey {
    constructor(pkey) {
        super(pkey);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PartitionKey);
            }
            throw error;
        }
    }
    /**
     * Allows assigning a value to the sort key.
     */
    sort(key) {
        return new SortKeyStep(this.pkey, key);
    }
}
exports.PartitionKey = PartitionKey;
_f = JSII_RTTI_SYMBOL_1;
PartitionKey[_f] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKey", version: "2.38.0-alpha.0" };
/**
 * Specifies the attribute value assignments.
 */
class AttributeValues {
    constructor(container, assignments = []) {
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    attribute(attr) {
        return new AttributeValuesStep(attr, this.container, this.assignments);
    }
    /**
     * Renders the variables required for `renderTemplate`.
     */
    renderVariables() {
        return `#set($input = ${this.container})
      ${this.assignments.map(a => a.putInMap('input')).join('\n')}`;
    }
    /**
     * Renders the attribute value assingments to a VTL string.
     */
    renderTemplate() {
        return '"attributeValues": $util.dynamodb.toMapValuesJson($input)';
    }
}
exports.AttributeValues = AttributeValues;
_g = JSII_RTTI_SYMBOL_1;
AttributeValues[_g] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValues", version: "2.38.0-alpha.0" };
/**
 * Utility class to allow assigning a value to an attribute.
 */
class AttributeValuesStep {
    constructor(attr, container, assignments) {
        this.attr = attr;
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Assign the value to the current attribute.
     */
    is(val) {
        this.assignments.push(new Assign(this.attr, val));
        return new AttributeValues(this.container, this.assignments);
    }
}
exports.AttributeValuesStep = AttributeValuesStep;
_h = JSII_RTTI_SYMBOL_1;
AttributeValuesStep[_h] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValuesStep", version: "2.38.0-alpha.0" };
/**
 * Factory class for attribute value assignments.
 */
class Values {
    /**
     * Treats the specified object as a map of assignments, where the property
     * names represent attribute names. It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     */
    static projecting(arg) {
        return new AttributeValues('$ctx.args' + (arg ? `.${arg}` : ''));
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    static attribute(attr) {
        return new AttributeValues('{}').attribute(attr);
    }
}
exports.Values = Values;
_j = JSII_RTTI_SYMBOL_1;
Values[_j] = { fqn: "@aws-cdk/aws-appsync-alpha.Values", version: "2.38.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsia2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHVDQUFtRjtBQUVuRjs7R0FFRztBQUNILE1BQWEsWUFBWTtJQW1EdkIsWUFBcUMsSUFBc0I7UUFBdEIsU0FBSSxHQUFKLElBQUksQ0FBa0I7S0FBSztJQWpEaEU7O09BRUc7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWUsRUFBRSxHQUFXO1FBQzNDLE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSx5QkFBZSxDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQztLQUNqRTtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7S0FDakU7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsT0FBZSxFQUFFLEdBQVc7UUFDM0MsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLHlCQUFlLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDO0tBQ2xFO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWUsRUFBRSxHQUFXO1FBQzNDLE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSx5QkFBZSxDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQztLQUNqRTtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7S0FDbEU7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxVQUFVLENBQUMsT0FBZSxFQUFFLEdBQVc7UUFDbkQsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLG9CQUFVLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7S0FDdkQ7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBZSxFQUFFLElBQVksRUFBRSxJQUFZO1FBQy9ELE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSxpQkFBTyxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztLQUMzRDtJQUlEOztPQUVHO0lBQ0ksR0FBRyxDQUFDLE9BQXFCOzs7Ozs7Ozs7O1FBQzlCLE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7S0FDdEQ7SUFFRDs7T0FFRztJQUNJLGNBQWM7UUFDbkIsT0FBTztnQ0FDcUIsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUU7O2tCQUV6QyxJQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixFQUFFOzs7a0JBR2pDLElBQUksQ0FBQyxJQUFJLENBQUMsc0JBQXNCLEVBQUU7O2NBRXRDLENBQUM7S0FDWjs7QUF6RUgsb0NBMEVDOzs7QUFFRDs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNqQixZQUE2QixJQUFZLEVBQW1CLEdBQVc7UUFBMUMsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixRQUFHLEdBQUgsR0FBRyxDQUFRO0tBQUs7SUFFNUU7O09BRUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLElBQUksQ0FBQyxJQUFJLHFDQUFxQyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUM7S0FDdEU7SUFFRDs7T0FFRztJQUNJLFFBQVEsQ0FBQyxHQUFXO1FBQ3pCLE9BQU8sYUFBYSxHQUFHLFNBQVMsSUFBSSxDQUFDLElBQUksTUFBTSxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUM7S0FDN0Q7O0FBZkgsd0JBZ0JDOzs7QUFFRDs7O0dBR0c7QUFDSCxNQUFhLGdCQUFnQjtJQUMzQixZQUE2QixHQUFXO1FBQVgsUUFBRyxHQUFILEdBQUcsQ0FBUTtLQUFLO0lBRTdDOztPQUVHO0lBQ0ksRUFBRSxDQUFDLEdBQVc7UUFDbkIsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGFBQWEsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDO0tBQ25FO0lBRUQ7O09BRUc7SUFDSSxJQUFJO1FBQ1QsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQztLQUNqRTs7QUFmSCw0Q0FnQkM7OztBQUVEOzs7R0FHRztBQUNILE1BQWEsV0FBVztJQUN0QixZQUE2QixJQUFZLEVBQW1CLElBQVk7UUFBM0MsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixTQUFJLEdBQUosSUFBSSxDQUFROzs7Ozs7K0NBRDdELFdBQVc7Ozs7S0FDdUQ7SUFFN0U7O09BRUc7SUFDSSxFQUFFLENBQUMsR0FBVztRQUNuQixPQUFPLElBQUksVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxhQUFhLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQztLQUM3RTtJQUVEOztPQUVHO0lBQ0ksSUFBSTtRQUNULE9BQU8sSUFBSSxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQztLQUMzRTs7QUFmSCxrQ0FnQkM7OztBQUVEOzs7R0FHRztBQUNILE1BQWEsVUFBVTtJQVFyQixZQUErQixJQUFZLEVBQW1CLElBQWE7UUFBNUMsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixTQUFJLEdBQUosSUFBSSxDQUFTOzs7Ozs7OytDQVJoRSxVQUFVOzs7O0tBUTJEO0lBUGhGOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFNBQVMsQ0FBQyxHQUFXO1FBQ2pDLE9BQU8sSUFBSSxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUNsQztJQUlEOztPQUVHO0lBQ0ksY0FBYztRQUNuQixNQUFNLFdBQVcsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQyxDQUFDO1FBQ3JELElBQUksSUFBSSxDQUFDLElBQUksRUFBRTtZQUNiLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLENBQUM7U0FDbEQ7UUFDRCxPQUFPO1FBQ0gsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7TUFDdkIsQ0FBQztLQUNKOztBQXJCSCxnQ0FzQkM7OztBQUVEOzs7R0FHRztBQUNILE1BQWEsWUFBYSxTQUFRLFVBQVU7SUFDMUMsWUFBWSxJQUFZO1FBQ3RCLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQzs7Ozs7OytDQUZILFlBQVk7Ozs7S0FHdEI7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxHQUFXO1FBQ3JCLE9BQU8sSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQztLQUN4Qzs7QUFWSCxvQ0FXQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGVBQWU7SUFDMUIsWUFBNkIsU0FBaUIsRUFBbUIsY0FBd0IsRUFBRTtRQUE5RCxjQUFTLEdBQVQsU0FBUyxDQUFRO1FBQW1CLGdCQUFXLEdBQVgsV0FBVyxDQUFlO0tBQUs7SUFFaEc7O09BRUc7SUFDSSxTQUFTLENBQUMsSUFBWTtRQUMzQixPQUFPLElBQUksbUJBQW1CLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0tBQ3hFO0lBRUQ7O09BRUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8saUJBQWlCLElBQUksQ0FBQyxTQUFTO1FBQ2xDLElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO0tBQ2pFO0lBRUQ7O09BRUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sMkRBQTJELENBQUM7S0FDcEU7O0FBdkJILDBDQXdCQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLG1CQUFtQjtJQUM5QixZQUE2QixJQUFZLEVBQW1CLFNBQWlCLEVBQW1CLFdBQXFCO1FBQXhGLFNBQUksR0FBSixJQUFJLENBQVE7UUFBbUIsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUFtQixnQkFBVyxHQUFYLFdBQVcsQ0FBVTtLQUFLO0lBRTFIOztPQUVHO0lBQ0ksRUFBRSxDQUFDLEdBQVc7UUFDbkIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQ2xELE9BQU8sSUFBSSxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDOUQ7O0FBVEgsa0RBVUM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxNQUFNO0lBQ2pCOzs7OztPQUtHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxHQUFZO1FBQ25DLE9BQU8sSUFBSSxlQUFlLENBQUMsV0FBVyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0tBQ2xFO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsU0FBUyxDQUFDLElBQVk7UUFDbEMsT0FBTyxJQUFJLGVBQWUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDbEQ7O0FBaEJILHdCQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJhc2VLZXlDb25kaXRpb24sIEJlZ2luc1dpdGgsIEJldHdlZW4sIEJpbmFyeUNvbmRpdGlvbiB9IGZyb20gJy4vcHJpdmF0ZSc7XG5cbi8qKlxuICogRmFjdG9yeSBjbGFzcyBmb3IgRHluYW1vREIga2V5IGNvbmRpdGlvbnMuXG4gKi9cbmV4cG9ydCBjbGFzcyBLZXlDb25kaXRpb24ge1xuXG4gIC8qKlxuICAgKiBDb25kaXRpb24gayA9IGFyZywgdHJ1ZSBpZiB0aGUga2V5IGF0dHJpYnV0ZSBrIGlzIGVxdWFsIHRvIHRoZSBRdWVyeSBhcmd1bWVudFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBlcShrZXlOYW1lOiBzdHJpbmcsIGFyZzogc3RyaW5nKTogS2V5Q29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IEtleUNvbmRpdGlvbihuZXcgQmluYXJ5Q29uZGl0aW9uKGtleU5hbWUsICc9JywgYXJnKSk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZGl0aW9uIGsgPCBhcmcsIHRydWUgaWYgdGhlIGtleSBhdHRyaWJ1dGUgayBpcyBsZXNzIHRoYW4gdGhlIFF1ZXJ5IGFyZ3VtZW50XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGx0KGtleU5hbWU6IHN0cmluZywgYXJnOiBzdHJpbmcpOiBLZXlDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgS2V5Q29uZGl0aW9uKG5ldyBCaW5hcnlDb25kaXRpb24oa2V5TmFtZSwgJzwnLCBhcmcpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25kaXRpb24gayA8PSBhcmcsIHRydWUgaWYgdGhlIGtleSBhdHRyaWJ1dGUgayBpcyBsZXNzIHRoYW4gb3IgZXF1YWwgdG8gdGhlIFF1ZXJ5IGFyZ3VtZW50XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGxlKGtleU5hbWU6IHN0cmluZywgYXJnOiBzdHJpbmcpOiBLZXlDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgS2V5Q29uZGl0aW9uKG5ldyBCaW5hcnlDb25kaXRpb24oa2V5TmFtZSwgJzw9JywgYXJnKSk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZGl0aW9uIGsgPiBhcmcsIHRydWUgaWYgdGhlIGtleSBhdHRyaWJ1dGUgayBpcyBncmVhdGVyIHRoYW4gdGhlIHRoZSBRdWVyeSBhcmd1bWVudFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBndChrZXlOYW1lOiBzdHJpbmcsIGFyZzogc3RyaW5nKTogS2V5Q29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IEtleUNvbmRpdGlvbihuZXcgQmluYXJ5Q29uZGl0aW9uKGtleU5hbWUsICc+JywgYXJnKSk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZGl0aW9uIGsgPj0gYXJnLCB0cnVlIGlmIHRoZSBrZXkgYXR0cmlidXRlIGsgaXMgZ3JlYXRlciBvciBlcXVhbCB0byB0aGUgUXVlcnkgYXJndW1lbnRcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2Uoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJpbmFyeUNvbmRpdGlvbihrZXlOYW1lLCAnPj0nLCBhcmcpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25kaXRpb24gKGssIGFyZykuIFRydWUgaWYgdGhlIGtleSBhdHRyaWJ1dGUgayBiZWdpbnMgd2l0aCB0aGUgUXVlcnkgYXJndW1lbnQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGJlZ2luc1dpdGgoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJlZ2luc1dpdGgoa2V5TmFtZSwgYXJnKSk7XG4gIH1cblxuICAvKipcbiAgICogQ29uZGl0aW9uIGsgQkVUV0VFTiBhcmcxIEFORCBhcmcyLCB0cnVlIGlmIGsgPj0gYXJnMSBhbmQgayA8PSBhcmcyLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBiZXR3ZWVuKGtleU5hbWU6IHN0cmluZywgYXJnMTogc3RyaW5nLCBhcmcyOiBzdHJpbmcpOiBLZXlDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgS2V5Q29uZGl0aW9uKG5ldyBCZXR3ZWVuKGtleU5hbWUsIGFyZzEsIGFyZzIpKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBjb25kOiBCYXNlS2V5Q29uZGl0aW9uKSB7IH1cblxuICAvKipcbiAgICogQ29uanVuY3Rpb24gYmV0d2VlbiB0d28gY29uZGl0aW9ucy5cbiAgICovXG4gIHB1YmxpYyBhbmQoa2V5Q29uZDogS2V5Q29uZGl0aW9uKTogS2V5Q29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IEtleUNvbmRpdGlvbih0aGlzLmNvbmQuYW5kKGtleUNvbmQuY29uZCkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbmRlcnMgdGhlIGtleSBjb25kaXRpb24gdG8gYSBWVEwgc3RyaW5nLlxuICAgKi9cbiAgcHVibGljIHJlbmRlclRlbXBsYXRlKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGBcInF1ZXJ5XCIgOiB7XG4gICAgICAgICAgICAgIFwiZXhwcmVzc2lvblwiIDogXCIke3RoaXMuY29uZC5yZW5kZXJDb25kaXRpb24oKX1cIixcbiAgICAgICAgICAgICAgXCJleHByZXNzaW9uTmFtZXNcIiA6IHtcbiAgICAgICAgICAgICAgICAke3RoaXMuY29uZC5yZW5kZXJFeHByZXNzaW9uTmFtZXMoKX1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXCJleHByZXNzaW9uVmFsdWVzXCIgOiB7XG4gICAgICAgICAgICAgICAgJHt0aGlzLmNvbmQucmVuZGVyRXhwcmVzc2lvblZhbHVlcygpfVxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9YDtcbiAgfVxufVxuXG4vKipcbiAqIFV0aWxpdHkgY2xhc3MgcmVwcmVzZW50aW5nIHRoZSBhc3NpZ21lbnQgb2YgYSB2YWx1ZSB0byBhbiBhdHRyaWJ1dGUuXG4gKi9cbmV4cG9ydCBjbGFzcyBBc3NpZ24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGF0dHI6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBhcmc6IHN0cmluZykgeyB9XG5cbiAgLyoqXG4gICAqIFJlbmRlcnMgdGhlIGFzc2lnbm1lbnQgYXMgYSBWVEwgc3RyaW5nLlxuICAgKi9cbiAgcHVibGljIHJlbmRlckFzQXNzaWdubWVudCgpOiBzdHJpbmcge1xuICAgIHJldHVybiBgXCIke3RoaXMuYXR0cn1cIiA6ICR1dGlsLmR5bmFtb2RiLnRvRHluYW1vREJKc29uKCR7dGhpcy5hcmd9KWA7XG4gIH1cblxuICAvKipcbiAgICogUmVuZGVycyB0aGUgYXNzaWdubWVudCBhcyBhIG1hcCBlbGVtZW50LlxuICAgKi9cbiAgcHVibGljIHB1dEluTWFwKG1hcDogc3RyaW5nKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYCR1dGlsLnFyKCQke21hcH0ucHV0KFwiJHt0aGlzLmF0dHJ9XCIsICR7dGhpcy5hcmd9KSlgO1xuICB9XG59XG5cbi8qKlxuICogVXRpbGl0eSBjbGFzcyB0byBhbGxvdyBhc3NpZ25pbmcgYSB2YWx1ZSBvciBhbiBhdXRvLWdlbmVyYXRlZCBpZFxuICogdG8gYSBwYXJ0aXRpb24ga2V5LlxuICovXG5leHBvcnQgY2xhc3MgUGFydGl0aW9uS2V5U3RlcCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkga2V5OiBzdHJpbmcpIHsgfVxuXG4gIC8qKlxuICAgKiBBc3NpZ24gYW4gYXV0by1nZW5lcmF0ZWQgdmFsdWUgdG8gdGhlIHBhcnRpdGlvbiBrZXkuXG4gICAqL1xuICBwdWJsaWMgaXModmFsOiBzdHJpbmcpOiBQYXJ0aXRpb25LZXkge1xuICAgIHJldHVybiBuZXcgUGFydGl0aW9uS2V5KG5ldyBBc3NpZ24odGhpcy5rZXksIGAkY3R4LmFyZ3MuJHt2YWx9YCkpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFzc2lnbiBhbiBhdXRvLWdlbmVyYXRlZCB2YWx1ZSB0byB0aGUgcGFydGl0aW9uIGtleS5cbiAgICovXG4gIHB1YmxpYyBhdXRvKCk6IFBhcnRpdGlvbktleSB7XG4gICAgcmV0dXJuIG5ldyBQYXJ0aXRpb25LZXkobmV3IEFzc2lnbih0aGlzLmtleSwgJyR1dGlsLmF1dG9JZCgpJykpO1xuICB9XG59XG5cbi8qKlxuICogVXRpbGl0eSBjbGFzcyB0byBhbGxvdyBhc3NpZ25pbmcgYSB2YWx1ZSBvciBhbiBhdXRvLWdlbmVyYXRlZCBpZFxuICogdG8gYSBzb3J0IGtleS5cbiAqL1xuZXhwb3J0IGNsYXNzIFNvcnRLZXlTdGVwIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwa2V5OiBBc3NpZ24sIHByaXZhdGUgcmVhZG9ubHkgc2tleTogc3RyaW5nKSB7IH1cblxuICAvKipcbiAgICogQXNzaWduIGFuIGF1dG8tZ2VuZXJhdGVkIHZhbHVlIHRvIHRoZSBzb3J0IGtleS5cbiAgICovXG4gIHB1YmxpYyBpcyh2YWw6IHN0cmluZyk6IFByaW1hcnlLZXkge1xuICAgIHJldHVybiBuZXcgUHJpbWFyeUtleSh0aGlzLnBrZXksIG5ldyBBc3NpZ24odGhpcy5za2V5LCBgJGN0eC5hcmdzLiR7dmFsfWApKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBc3NpZ24gYW4gYXV0by1nZW5lcmF0ZWQgdmFsdWUgdG8gdGhlIHNvcnQga2V5LlxuICAgKi9cbiAgcHVibGljIGF1dG8oKTogUHJpbWFyeUtleSB7XG4gICAgcmV0dXJuIG5ldyBQcmltYXJ5S2V5KHRoaXMucGtleSwgbmV3IEFzc2lnbih0aGlzLnNrZXksICckdXRpbC5hdXRvSWQoKScpKTtcbiAgfVxufVxuXG4vKipcbiAqIFNwZWNpZmllcyB0aGUgYXNzaWdubWVudCB0byB0aGUgcHJpbWFyeSBrZXkuIEl0IGVpdGhlclxuICogY29udGFpbnMgdGhlIGZ1bGwgcHJpbWFyeSBrZXkgb3Igb25seSB0aGUgcGFydGl0aW9uIGtleS5cbiAqL1xuZXhwb3J0IGNsYXNzIFByaW1hcnlLZXkge1xuICAvKipcbiAgICogQWxsb3dzIGFzc2lnbmluZyBhIHZhbHVlIHRvIHRoZSBwYXJ0aXRpb24ga2V5LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBwYXJ0aXRpb24oa2V5OiBzdHJpbmcpOiBQYXJ0aXRpb25LZXlTdGVwIHtcbiAgICByZXR1cm4gbmV3IFBhcnRpdGlvbktleVN0ZXAoa2V5KTtcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCByZWFkb25seSBwa2V5OiBBc3NpZ24sIHByaXZhdGUgcmVhZG9ubHkgc2tleT86IEFzc2lnbikgeyB9XG5cbiAgLyoqXG4gICAqIFJlbmRlcnMgdGhlIGtleSBhc3NpZ25tZW50IHRvIGEgVlRMIHN0cmluZy5cbiAgICovXG4gIHB1YmxpYyByZW5kZXJUZW1wbGF0ZSgpOiBzdHJpbmcge1xuICAgIGNvbnN0IGFzc2lnbm1lbnRzID0gW3RoaXMucGtleS5yZW5kZXJBc0Fzc2lnbm1lbnQoKV07XG4gICAgaWYgKHRoaXMuc2tleSkge1xuICAgICAgYXNzaWdubWVudHMucHVzaCh0aGlzLnNrZXkucmVuZGVyQXNBc3NpZ25tZW50KCkpO1xuICAgIH1cbiAgICByZXR1cm4gYFwia2V5XCIgOiB7XG4gICAgICAke2Fzc2lnbm1lbnRzLmpvaW4oJywnKX1cbiAgICB9YDtcbiAgfVxufVxuXG4vKipcbiAqIFNwZWNpZmllcyB0aGUgYXNzaWdubWVudCB0byB0aGUgcGFydGl0aW9uIGtleS4gSXQgY2FuIGJlXG4gKiBlbmhhbmNlZCB3aXRoIHRoZSBhc3NpZ25tZW50IG9mIHRoZSBzb3J0IGtleS5cbiAqL1xuZXhwb3J0IGNsYXNzIFBhcnRpdGlvbktleSBleHRlbmRzIFByaW1hcnlLZXkge1xuICBjb25zdHJ1Y3Rvcihwa2V5OiBBc3NpZ24pIHtcbiAgICBzdXBlcihwa2V5KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBbGxvd3MgYXNzaWduaW5nIGEgdmFsdWUgdG8gdGhlIHNvcnQga2V5LlxuICAgKi9cbiAgcHVibGljIHNvcnQoa2V5OiBzdHJpbmcpOiBTb3J0S2V5U3RlcCB7XG4gICAgcmV0dXJuIG5ldyBTb3J0S2V5U3RlcCh0aGlzLnBrZXksIGtleSk7XG4gIH1cbn1cblxuLyoqXG4gKiBTcGVjaWZpZXMgdGhlIGF0dHJpYnV0ZSB2YWx1ZSBhc3NpZ25tZW50cy5cbiAqL1xuZXhwb3J0IGNsYXNzIEF0dHJpYnV0ZVZhbHVlcyB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgY29udGFpbmVyOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgYXNzaWdubWVudHM6IEFzc2lnbltdID0gW10pIHsgfVxuXG4gIC8qKlxuICAgKiBBbGxvd3MgYXNzaWduaW5nIGEgdmFsdWUgdG8gdGhlIHNwZWNpZmllZCBhdHRyaWJ1dGUuXG4gICAqL1xuICBwdWJsaWMgYXR0cmlidXRlKGF0dHI6IHN0cmluZyk6IEF0dHJpYnV0ZVZhbHVlc1N0ZXAge1xuICAgIHJldHVybiBuZXcgQXR0cmlidXRlVmFsdWVzU3RlcChhdHRyLCB0aGlzLmNvbnRhaW5lciwgdGhpcy5hc3NpZ25tZW50cyk7XG4gIH1cblxuICAvKipcbiAgICogUmVuZGVycyB0aGUgdmFyaWFibGVzIHJlcXVpcmVkIGZvciBgcmVuZGVyVGVtcGxhdGVgLlxuICAgKi9cbiAgcHVibGljIHJlbmRlclZhcmlhYmxlcygpOiBzdHJpbmcge1xuICAgIHJldHVybiBgI3NldCgkaW5wdXQgPSAke3RoaXMuY29udGFpbmVyfSlcbiAgICAgICR7dGhpcy5hc3NpZ25tZW50cy5tYXAoYSA9PiBhLnB1dEluTWFwKCdpbnB1dCcpKS5qb2luKCdcXG4nKX1gO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbmRlcnMgdGhlIGF0dHJpYnV0ZSB2YWx1ZSBhc3NpbmdtZW50cyB0byBhIFZUTCBzdHJpbmcuXG4gICAqL1xuICBwdWJsaWMgcmVuZGVyVGVtcGxhdGUoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gJ1wiYXR0cmlidXRlVmFsdWVzXCI6ICR1dGlsLmR5bmFtb2RiLnRvTWFwVmFsdWVzSnNvbigkaW5wdXQpJztcbiAgfVxufVxuXG4vKipcbiAqIFV0aWxpdHkgY2xhc3MgdG8gYWxsb3cgYXNzaWduaW5nIGEgdmFsdWUgdG8gYW4gYXR0cmlidXRlLlxuICovXG5leHBvcnQgY2xhc3MgQXR0cmlidXRlVmFsdWVzU3RlcCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgYXR0cjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IGNvbnRhaW5lcjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IGFzc2lnbm1lbnRzOiBBc3NpZ25bXSkgeyB9XG5cbiAgLyoqXG4gICAqIEFzc2lnbiB0aGUgdmFsdWUgdG8gdGhlIGN1cnJlbnQgYXR0cmlidXRlLlxuICAgKi9cbiAgcHVibGljIGlzKHZhbDogc3RyaW5nKTogQXR0cmlidXRlVmFsdWVzIHtcbiAgICB0aGlzLmFzc2lnbm1lbnRzLnB1c2gobmV3IEFzc2lnbih0aGlzLmF0dHIsIHZhbCkpO1xuICAgIHJldHVybiBuZXcgQXR0cmlidXRlVmFsdWVzKHRoaXMuY29udGFpbmVyLCB0aGlzLmFzc2lnbm1lbnRzKTtcbiAgfVxufVxuXG4vKipcbiAqIEZhY3RvcnkgY2xhc3MgZm9yIGF0dHJpYnV0ZSB2YWx1ZSBhc3NpZ25tZW50cy5cbiAqL1xuZXhwb3J0IGNsYXNzIFZhbHVlcyB7XG4gIC8qKlxuICAgKiBUcmVhdHMgdGhlIHNwZWNpZmllZCBvYmplY3QgYXMgYSBtYXAgb2YgYXNzaWdubWVudHMsIHdoZXJlIHRoZSBwcm9wZXJ0eVxuICAgKiBuYW1lcyByZXByZXNlbnQgYXR0cmlidXRlIG5hbWVzLiBJdOKAmXMgb3BpbmlvbmF0ZWQgYWJvdXQgaG93IGl0IHJlcHJlc2VudHNcbiAgICogc29tZSBvZiB0aGUgbmVzdGVkIG9iamVjdHM6IGUuZy4sIGl0IHdpbGwgdXNlIGxpc3RzICjigJxM4oCdKSByYXRoZXIgdGhhbiBzZXRzXG4gICAqICjigJxTU+KAnSwg4oCcTlPigJ0sIOKAnEJT4oCdKS4gQnkgZGVmYXVsdCBpdCBwcm9qZWN0cyB0aGUgYXJndW1lbnQgY29udGFpbmVyIChcIiRjdHguYXJnc1wiKS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcHJvamVjdGluZyhhcmc/OiBzdHJpbmcpOiBBdHRyaWJ1dGVWYWx1ZXMge1xuICAgIHJldHVybiBuZXcgQXR0cmlidXRlVmFsdWVzKCckY3R4LmFyZ3MnICsgKGFyZyA/IGAuJHthcmd9YCA6ICcnKSk7XG4gIH1cblxuICAvKipcbiAgICogQWxsb3dzIGFzc2lnbmluZyBhIHZhbHVlIHRvIHRoZSBzcGVjaWZpZWQgYXR0cmlidXRlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhdHRyaWJ1dGUoYXR0cjogc3RyaW5nKTogQXR0cmlidXRlVmFsdWVzU3RlcCB7XG4gICAgcmV0dXJuIG5ldyBBdHRyaWJ1dGVWYWx1ZXMoJ3t9JykuYXR0cmlidXRlKGF0dHIpO1xuICB9XG59XG4iXX0=