# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['aceye']

package_data = \
{'': ['*'],
 'aceye': ['Aggregate Interfaces/CSV/*',
           'Aggregate Interfaces/HTML/*',
           'Aggregate Interfaces/JSON/*',
           'Aggregate Interfaces/Markdown/*',
           'Aggregate Interfaces/Mindmap/*',
           'Aggregate Interfaces/YAML/*',
           'Application Profiles/CSV/*',
           'Application Profiles/HTML/*',
           'Application Profiles/JSON/*',
           'Application Profiles/Markdown/*',
           'Application Profiles/Mindmap/*',
           'Application Profiles/YAML/*',
           'Attachable Access Entity Profiles/CSV/*',
           'Attachable Access Entity Profiles/HTML/*',
           'Attachable Access Entity Profiles/JSON/*',
           'Attachable Access Entity Profiles/Markdown/*',
           'Attachable Access Entity Profiles/Mindmap/*',
           'Attachable Access Entity Profiles/YAML/*',
           'Audit Log/CSV/*',
           'Audit Log/HTML/*',
           'Audit Log/JSON/*',
           'Audit Log/Markdown/*',
           'Audit Log/Mindmap/*',
           'Audit Log/YAML/*',
           'BGP Route Reflectors/CSV/*',
           'BGP Route Reflectors/HTML/*',
           'BGP Route Reflectors/JSON/*',
           'BGP Route Reflectors/Markdown/*',
           'BGP Route Reflectors/Mindmap/*',
           'BGP Route Reflectors/YAML/*',
           'Bridge Domains/CSV/*',
           'Bridge Domains/HTML/*',
           'Bridge Domains/JSON/*',
           'Bridge Domains/Markdown/*',
           'Bridge Domains/Mindmap/*',
           'Bridge Domains/YAML/*',
           'Cluster Health/CSV/*',
           'Cluster Health/HTML/*',
           'Cluster Health/JSON/*',
           'Cluster Health/Markdown/*',
           'Cluster Health/Mindmap/*',
           'Cluster Health/YAML/*',
           'Contexts/CSV/*',
           'Contexts/HTML/*',
           'Contexts/JSON/*',
           'Contexts/Markdown/*',
           'Contexts/Mindmap/*',
           'Contexts/YAML/*',
           'Contract Subjects/CSV/*',
           'Contract Subjects/HTML/*',
           'Contract Subjects/JSON/*',
           'Contract Subjects/Markdown/*',
           'Contract Subjects/Mindmap/*',
           'Contract Subjects/YAML/*',
           'Contracts/CSV/*',
           'Contracts/HTML/*',
           'Contracts/JSON/*',
           'Contracts/Markdown/*',
           'Contracts/Mindmap/*',
           'Contracts/YAML/*',
           'Device Packages/CSV/*',
           'Device Packages/HTML/*',
           'Device Packages/JSON/*',
           'Device Packages/Markdown/*',
           'Device Packages/Mindmap/*',
           'Device Packages/YAML/*',
           'EPG/CSV/*',
           'EPG/HTML/*',
           'EPG/JSON/*',
           'EPG/Markdown/*',
           'EPG/Mindmap/*',
           'EPG/YAML/*',
           'Endpoints/CSV/*',
           'Endpoints/HTML/*',
           'Endpoints/JSON/*',
           'Endpoints/Markdown/*',
           'Endpoints/Mindmap/*',
           'Endpoints/YAML/*',
           'Events/CSV/*',
           'Events/HTML/*',
           'Events/JSON/*',
           'Events/Markdown/*',
           'Events/Mindmap/*',
           'Events/YAML/*',
           'Fabric Membership/CSV/*',
           'Fabric Membership/HTML/*',
           'Fabric Membership/JSON/*',
           'Fabric Membership/Markdown/*',
           'Fabric Membership/Mindmap/*',
           'Fabric Membership/YAML/*',
           'Fabric Node SSL Certificates/CSV/*',
           'Fabric Node SSL Certificates/HTML/*',
           'Fabric Node SSL Certificates/JSON/*',
           'Fabric Node SSL Certificates/Markdown/*',
           'Fabric Node SSL Certificates/Mindmap/*',
           'Fabric Node SSL Certificates/YAML/*',
           'Fabric Nodes/CSV/*',
           'Fabric Nodes/HTML/*',
           'Fabric Nodes/JSON/*',
           'Fabric Nodes/Markdown/*',
           'Fabric Nodes/Mindmap/*',
           'Fabric Nodes/YAML/*',
           'Fabric Paths/CSV/*',
           'Fabric Paths/HTML/*',
           'Fabric Paths/JSON/*',
           'Fabric Paths/Markdown/*',
           'Fabric Paths/Mindmap/*',
           'Fabric Paths/YAML/*',
           'Fabric Pods/CSV/*',
           'Fabric Pods/HTML/*',
           'Fabric Pods/JSON/*',
           'Fabric Pods/Markdown/*',
           'Fabric Pods/Mindmap/*',
           'Fabric Pods/YAML/*',
           'Fault Summary/CSV/*',
           'Fault Summary/HTML/*',
           'Fault Summary/JSON/*',
           'Fault Summary/Markdown/*',
           'Fault Summary/Mindmap/*',
           'Fault Summary/YAML/*',
           'Filters/CSV/*',
           'Filters/HTML/*',
           'Filters/JSON/*',
           'Filters/Markdown/*',
           'Filters/Mindmap/*',
           'Filters/YAML/*',
           'Health/CSV/*',
           'Health/HTML/*',
           'Health/JSON/*',
           'Health/Markdown/*',
           'Health/Mindmap/*',
           'Health/YAML/*',
           'IP Addresses/CSV/*',
           'IP Addresses/HTML/*',
           'IP Addresses/JSON/*',
           'IP Addresses/Markdown/*',
           'IP Addresses/Mindmap/*',
           'IP Addresses/YAML/*',
           'Interface Policies/CSV/*',
           'Interface Policies/HTML/*',
           'Interface Policies/JSON/*',
           'Interface Policies/Markdown/*',
           'Interface Policies/Mindmap/*',
           'Interface Policies/YAML/*',
           'Interface Profiles/CSV/*',
           'Interface Profiles/HTML/*',
           'Interface Profiles/JSON/*',
           'Interface Profiles/Markdown/*',
           'Interface Profiles/Mindmap/*',
           'Interface Profiles/YAML/*',
           'L2Outs/CSV/*',
           'L2Outs/HTML/*',
           'L2Outs/JSON/*',
           'L2Outs/Markdown/*',
           'L2Outs/Mindmap/*',
           'L2Outs/YAML/*',
           'L3 Domains/CSV/*',
           'L3 Domains/HTML/*',
           'L3 Domains/JSON/*',
           'L3 Domains/Markdown/*',
           'L3 Domains/Mindmap/*',
           'L3 Domains/YAML/*',
           'L3 Interfaces/CSV/*',
           'L3 Interfaces/HTML/*',
           'L3 Interfaces/JSON/*',
           'L3 Interfaces/Markdown/*',
           'L3 Interfaces/Mindmap/*',
           'L3 Interfaces/YAML/*',
           'L3Outs/CSV/*',
           'L3Outs/HTML/*',
           'L3Outs/JSON/*',
           'L3Outs/Markdown/*',
           'L3Outs/Mindmap/*',
           'L3Outs/YAML/*',
           'Leaf Interface Profiles/CSV/*',
           'Leaf Interface Profiles/HTML/*',
           'Leaf Interface Profiles/JSON/*',
           'Leaf Interface Profiles/Markdown/*',
           'Leaf Interface Profiles/Mindmap/*',
           'Leaf Interface Profiles/YAML/*',
           'Leaf Switch Profiles/CSV/*',
           'Leaf Switch Profiles/HTML/*',
           'Leaf Switch Profiles/JSON/*',
           'Leaf Switch Profiles/Markdown/*',
           'Leaf Switch Profiles/Mindmap/*',
           'Leaf Switch Profiles/YAML/*',
           'License Entitlements/CSV/*',
           'License Entitlements/HTML/*',
           'License Entitlements/JSON/*',
           'License Entitlements/Markdown/*',
           'License Entitlements/Mindmap/*',
           'License Entitlements/YAML/*',
           'Physical Domains/CSV/*',
           'Physical Domains/HTML/*',
           'Physical Domains/JSON/*',
           'Physical Domains/Markdown/*',
           'Physical Domains/Mindmap/*',
           'Physical Domains/YAML/*',
           'Physical Interfaces/CSV/*',
           'Physical Interfaces/HTML/*',
           'Physical Interfaces/JSON/*',
           'Physical Interfaces/Markdown/*',
           'Physical Interfaces/Mindmap/*',
           'Physical Interfaces/YAML/*',
           'Prefix List Detailed/CSV/*',
           'Prefix List Detailed/HTML/*',
           'Prefix List Detailed/JSON/*',
           'Prefix List Detailed/Markdown/*',
           'Prefix List Detailed/Mindmap/*',
           'Prefix List Detailed/YAML/*',
           'Prefix List/CSV/*',
           'Prefix List/HTML/*',
           'Prefix List/JSON/*',
           'Prefix List/Markdown/*',
           'Prefix List/Mindmap/*',
           'Prefix List/YAML/*',
           'QOS Classes/CSV/*',
           'QOS Classes/HTML/*',
           'QOS Classes/JSON/*',
           'QOS Classes/Markdown/*',
           'QOS Classes/Mindmap/*',
           'QOS Classes/YAML/*',
           'Security Domains/CSV/*',
           'Security Domains/HTML/*',
           'Security Domains/JSON/*',
           'Security Domains/Markdown/*',
           'Security Domains/Mindmap/*',
           'Security Domains/YAML/*',
           'Spine Interface Profiles/CSV/*',
           'Spine Interface Profiles/HTML/*',
           'Spine Interface Profiles/JSON/*',
           'Spine Interface Profiles/Markdown/*',
           'Spine Interface Profiles/Mindmap/*',
           'Spine Interface Profiles/YAML/*',
           'Spine Switch Profiles/CSV/*',
           'Spine Switch Profiles/HTML/*',
           'Spine Switch Profiles/JSON/*',
           'Spine Switch Profiles/Markdown/*',
           'Spine Switch Profiles/Mindmap/*',
           'Spine Switch Profiles/YAML/*',
           'Subnets/CSV/*',
           'Subnets/HTML/*',
           'Subnets/JSON/*',
           'Subnets/Markdown/*',
           'Subnets/Mindmap/*',
           'Subnets/YAML/*',
           'Tenant Health/CSV/*',
           'Tenant Health/HTML/*',
           'Tenant Health/JSON/*',
           'Tenant Health/Markdown/*',
           'Tenant Health/Mindmap/*',
           'Tenant Health/YAML/*',
           'Tenant/CSV/*',
           'Tenant/HTML/*',
           'Tenant/JSON/*',
           'Tenant/Markdown/*',
           'Tenant/Mindmap/*',
           'Tenant/YAML/*',
           'Top System/CSV/*',
           'Top System/HTML/*',
           'Top System/JSON/*',
           'Top System/Markdown/*',
           'Top System/Mindmap/*',
           'Top System/YAML/*',
           'Users/CSV/*',
           'Users/HTML/*',
           'Users/JSON/*',
           'Users/Markdown/*',
           'Users/Mindmap/*',
           'Users/YAML/*',
           'VLAN Pools/CSV/*',
           'VLAN Pools/HTML/*',
           'VLAN Pools/JSON/*',
           'VLAN Pools/Markdown/*',
           'VLAN Pools/Mindmap/*',
           'VLAN Pools/YAML/*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'rich-click>=1.5.1,<2.0.0']

entry_points = \
{'console_scripts': ['aceye = aceye.script:run']}

setup_kwargs = {
    'name': 'aceye',
    'version': '1.1.31',
    'description': 'Business ready documents from Cisco ACI',
    'long_description': '[![published](https://static.production.devnetcloud.com/codeexchange/assets/images/devnet-published.svg)](https://developer.cisco.com/codeexchange/github/repo/automateyournetwork/ACEye)\n\n# ACEye\n\nBusiness Ready Documents for Cisco ACI\n\n## Current API Coverage\n\nAggregate Interfaces\n\nApplication Profiles\n\nAttachable Access Entity Profiles\n\n*Audit Log\n\nBGP Route Reflectors\n\nBridge Domains\n\nCluster Health\n\nContexts (VRFs)\n\nContracts\n\nContract Subjects\n\nDevice Packages\n\nEndpoints (All Connected Fabric Endpoints)\n\nEPG (Endpoint Groups)\n\n*Events\n\nFabric Membership\n\nFabric Node SSL Certifcates\n\nFabric Nodes\n\nFabric Paths\n\nFabric Pods\n\nFault Summary\n\nFilters\n\nHealth\n\nInterface Policies\n\nInterface Profiles\n\nIP Addresses\n\nLicense Entitlements\n\nL2Outs\n\nL3 Domains\n\nL3 Interfaces\n\nL3Outs\n\nLeaf Interface Profiles\n\nLeaf Switch Profiles\n\nPhysical Domains\n\nPhysical Interfaces\n\nPrefix List\n\nPrefix List Detailed\n\nQOS Classes\n\nSecurity Domains\n\nSpine Interface Profiles\n\nSpine Switch Profiles\n\nSubnets\n\nTenant\n\nTenant Health\n\nTop System\n\nUsers\n\nVLAN Pools\n\n* Both Audit Log and Events are commented out of the base package due to the potentially huge number of records; should you want the Audit Log / Events please uncomment out lines 72-73 (Audit Log) and 76-77 (Events)\n\n\n## Installation\n\n```console\n$ python3 -m venv ACI\n$ source ACI/bin/activate\n(ACI) $ pip install aceye\n```\n\n## Usage - Help\n\n```console\n(ACI) $ aceye --help\n```\n\n![ACEye Help](/images/help.png)\n\n## Usage - In-line\n\n```console\n(ACI) $ aceye --url <url to APIC> --username <APIC username> --password <APIC password>\n```\n\n## Usage - Interactive\n\n```console\n(ACI) $ aceye\nAPIC URL: <URL to APIC>\nAPIC Username: <APIC Username>\nAPIC Password: <APIC Password>\n```\n\n## Usage - Environment Variables\n\n```console\n(ACI) $ export URL=<URL to APIC>\n(ACI) $ export USERNAME=<APIC Username>\n(ACI) $ export PASSWORD=<APIC Password>\n```\n\n## Recommended VS Code Extensions\n\nExcel Viewer - CSV Files\n\nMarkdown Preview - Markdown Files\n\nMarkmap - Mindmap Files\n\nOpen in Default Browser - HTML Files\n\n## Contact\n\nPlease contact John Capobianco if you need any assistance\n',
    'author': 'John Capobianco',
    'author_email': 'ptcapo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
