"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        "can be created by specifying only minHealthyHostCount"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(1),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "HOST_COUNT",
                    "Value": 1,
                },
            }));
            test.done();
        },
        "can be created by specifying only minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.percentage(75),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "FLEET_PERCENT",
                    "Value": 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(stack, 'MyDC', 'MyDC');
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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