"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightTheme = exports.LightPalette = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const palette_1 = require("./palette");
/** Light theme color palette */
var LightPalette;
(function (LightPalette) {
    LightPalette["PUBLIC"] = "#E9F3E6";
    LightPalette["PRIVATE"] = "#E6F2F8";
    LightPalette["GENERIC"] = "#5A6B861A";
    LightPalette["PRIMARY"] = "#232F3E";
    LightPalette["SECONDARY"] = "#5B9BD5";
    LightPalette["TERTIARY"] = "#5A6B86";
})(LightPalette = exports.LightPalette || (exports.LightPalette = {}));
/** Light theme definition */
exports.LightTheme = {
    id: "light",
    backgrounds: {
        base: palette_1.BasePalette.WHITE,
        private: LightPalette.PRIVATE,
        public: LightPalette.PUBLIC,
        generic: LightPalette.GENERIC,
    },
    text: {
        default: palette_1.BasePalette.BLACK,
        primary: LightPalette.PRIMARY,
        secondary: LightPalette.SECONDARY,
        tertiary: LightPalette.TERTIARY,
    },
    groups: {
        cloud: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#DF3312",
            bgcolor: false,
            borderColor: "#DF3312",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#CD2264",
            bgcolor: false,
            borderColor: "#CD2264",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#5A6B86",
            bgcolor: false,
            borderColor: "#5A6B86",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#000000CC",
            bgcolor: "#5A6B861A",
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: LightPalette.GENERIC,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: LightPalette.SECONDARY,
            tail: "normal",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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