"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SNS dead letter queue destination configuration for a Lambda event source.
 *
 * @stability stable
 */
class SnsDlq {
    /**
     * @stability stable
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ.
     *
     * @stability stable
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
_a = JSII_RTTI_SYMBOL_1;
SnsDlq[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SnsDlq", version: "1.113.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEsTUFBTTs7OztJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7Ozs7OztJQUdNLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRXZDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDOztBQVhILHdCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGxxRGVzdGluYXRpb25Db25maWcsIElFdmVudFNvdXJjZURscSwgSUV2ZW50U291cmNlTWFwcGluZywgSUZ1bmN0aW9uIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNuc0RscSBpbXBsZW1lbnRzIElFdmVudFNvdXJjZURscSB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMpIHtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICB0aGlzLnRvcGljLmdyYW50UHVibGlzaCh0YXJnZXRIYW5kbGVyKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogdGhpcy50b3BpYy50b3BpY0FybixcbiAgICB9O1xuICB9XG59XG4iXX0=