"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lambda Function as the destination for a log subscription.
 *
 * @stability stable
 */
class LambdaDestination {
    /**
     * LambdaDestinationOptions.
     *
     * @stability stable
     */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        if (this.options.addPermissions !== false) {
            this.fn.addPermission('CanInvokeLambda', {
                principal: new iam.ServicePrincipal('logs.amazonaws.com'),
                sourceArn: arn,
                // Using SubScription Filter as scope is okay, since every Subscription Filter has only
                // one destination.
                scope,
            });
        }
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.LambdaDestination", version: "1.112.0" };
//# sourceMappingURL=data:application/json;base64,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