import * as lambda from '@aws-cdk/aws-lambda';
import * as logs from '@aws-cdk/aws-logs';
import { Construct } from '@aws-cdk/core';
/**
 * Options that may be provided to LambdaDestination.
 *
 * @stability stable
 */
export interface LambdaDestinationOptions {
    /**
     * Whether or not to add Lambda Permissions.
     *
     * @default true
     * @stability stable
     */
    readonly addPermissions?: boolean;
}
/**
 * Use a Lambda Function as the destination for a log subscription.
 *
 * @stability stable
 */
export declare class LambdaDestination implements logs.ILogSubscriptionDestination {
    private readonly fn;
    private readonly options;
    /**
     * LambdaDestinationOptions.
     *
     * @stability stable
     */
    constructor(fn: lambda.IFunction, options?: LambdaDestinationOptions);
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope: Construct, logGroup: logs.ILogGroup): logs.LogSubscriptionDestinationConfig;
}
