"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription.
 *
 * @stability stable
 */
class KinesisDestination {
    /**
     * @stability stable
     */
    constructor(stream) {
        this.stream = stream;
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
_a = JSII_RTTI_SYMBOL_1;
KinesisDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.KinesisDestination", version: "1.112.0" };
//# sourceMappingURL=data:application/json;base64,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