# coding: utf-8

"""
    Argo Server API

    You can get examples of requests and responses by using the CLI with `--gloglevel=9`, e.g. `argo list --gloglevel=9`  # noqa: E501

    The version of the OpenAPI document: v2.11.8
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from argo.workflows.client.configuration import Configuration


class V1alpha1MutexHolding(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'holder': 'str',
        'mutex': 'str'
    }

    attribute_map = {
        'holder': 'holder',
        'mutex': 'mutex'
    }

    def __init__(self, holder=None, mutex=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1MutexHolding - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._holder = None
        self._mutex = None
        self.discriminator = None

        if holder is not None:
            self.holder = holder
        if mutex is not None:
            self.mutex = mutex

    @property
    def holder(self):
        """Gets the holder of this V1alpha1MutexHolding.  # noqa: E501

        Holder is a reference to the object which holds the Mutex. Holding Scenario:   1. Current workflow's NodeID which is holding the lock.      e.g: ${NodeID} Waiting Scenario:   1. Current workflow or other workflow NodeID which is holding the lock.      e.g: ${WorkflowName}/${NodeID}  # noqa: E501

        :return: The holder of this V1alpha1MutexHolding.  # noqa: E501
        :rtype: str
        """
        return self._holder

    @holder.setter
    def holder(self, holder):
        """Sets the holder of this V1alpha1MutexHolding.

        Holder is a reference to the object which holds the Mutex. Holding Scenario:   1. Current workflow's NodeID which is holding the lock.      e.g: ${NodeID} Waiting Scenario:   1. Current workflow or other workflow NodeID which is holding the lock.      e.g: ${WorkflowName}/${NodeID}  # noqa: E501

        :param holder: The holder of this V1alpha1MutexHolding.  # noqa: E501
        :type: str
        """

        self._holder = holder

    @property
    def mutex(self):
        """Gets the mutex of this V1alpha1MutexHolding.  # noqa: E501

        Reference for the mutex e.g: ${namespace}/mutex/${mutexName}  # noqa: E501

        :return: The mutex of this V1alpha1MutexHolding.  # noqa: E501
        :rtype: str
        """
        return self._mutex

    @mutex.setter
    def mutex(self, mutex):
        """Sets the mutex of this V1alpha1MutexHolding.

        Reference for the mutex e.g: ${namespace}/mutex/${mutexName}  # noqa: E501

        :param mutex: The mutex of this V1alpha1MutexHolding.  # noqa: E501
        :type: str
        """

        self._mutex = mutex

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1MutexHolding):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1MutexHolding):
            return True

        return self.to_dict() != other.to_dict()
