"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * An IP address that is a target for load balancing.
 *
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 */
class IpTarget {
    /**
     * Create a new IPAddress target
     *
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     *
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     *
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     *
     * Default is automatic.
     *
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     * @param availabilityZone Availability zone to send traffic from
     */
    constructor(ipAddress, port, availabilityZone) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.availabilityZone = availabilityZone;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.IP,
            targetJson: { id: this.ipAddress, port: this.port, availabilityZone: this.availabilityZone },
        };
    }
}
exports.IpTarget = IpTarget;
_a = JSII_RTTI_SYMBOL_1;
IpTarget[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.IpTarget", version: "1.184.1" };
//# sourceMappingURL=data:application/json;base64,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