# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.attach_decorator import AttachDecorator
from aries_cloudcontroller.model.v20_cred_format import V20CredFormat
from aries_cloudcontroller.model.v20_cred_preview import V20CredPreview


class V20CredProposal(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    V20CredProposal - a model defined in OpenAPI
        filtersattach: Credential filter per acceptable format on corresponding identifier.
        formats: Attachment formats.
        id: Message identifier [Optional].
        type: Message type [Optional].
        comment: Human-readable comment [Optional].
        credential_preview: Credential preview [Optional].
    """

    filtersattach: List[AttachDecorator] = Field(..., alias="filters~attach")
    formats: List[V20CredFormat]
    id: Optional[str] = Field(None, alias="@id")
    type: Optional[str] = Field(None, alias="@type")
    comment: Optional[str] = None
    credential_preview: Optional[V20CredPreview] = None

    def __init__(
        self,
        *,
        filtersattach: List[AttachDecorator] = None,
        formats: List[V20CredFormat] = None,
        id: Optional[str] = None,
        type: Optional[str] = None,
        comment: Optional[str] = None,
        credential_preview: Optional[V20CredPreview] = None,
        **kwargs,
    ):
        super().__init__(
            id=id,
            type=type,
            comment=comment,
            credential_preview=credential_preview,
            filtersattach=filtersattach,
            formats=formats,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


V20CredProposal.update_forward_refs()
