# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_proof_request import IndyProofRequest


class V10PresentationSendRequestRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    V10PresentationSendRequestRequest - a model defined in OpenAPI
        connection_id: Connection identifier.
        proof_request: The proof_request of this V10PresentationSendRequestRequest.
        comment: The comment of this V10PresentationSendRequestRequest [Optional].
        trace: Whether to trace event (default false) [Optional].
    """

    connection_id: str
    proof_request: IndyProofRequest
    comment: Optional[str] = None
    trace: Optional[bool] = None

    def __init__(
        self,
        *,
        connection_id: str = None,
        proof_request: IndyProofRequest = None,
        comment: Optional[str] = None,
        trace: Optional[bool] = None,
        **kwargs,
    ):
        super().__init__(
            comment=comment,
            connection_id=connection_id,
            proof_request=proof_request,
            trace=trace,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


V10PresentationSendRequestRequest.update_forward_refs()
